/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.diagnostics.zos.tdump;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.kernel.zos.NativeMethodManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.zos.core.command.processing.CommandHandler;
import com.ibm.ws.zos.core.command.processing.ModifyResults;
import java.util.ArrayList;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TdumpCommandHandler
implements CommandHandler {
    static final String NAME = "TDUMP Command Handler";
    public final String DUMP_ERROR = "InitiateSystemDump returned return code ";
    public final String INTERNAL_ERROR = "Internal error occurred. Error code is ";
    static final List<String> HELP_TEXT;
    protected NativeMethodManager nativeMethodManager = null;
    static final long serialVersionUID = 8701789141998162784L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void activate() {
        this.nativeMethodManager.registerNatives(TdumpCommandHandler.class);
    }

    protected void deactivate() {
    }

    protected void setNativeMethodManager(NativeMethodManager nativeMethodManager) {
        this.nativeMethodManager = nativeMethodManager;
    }

    protected void unsetNativeMethodManager(NativeMethodManager nativeMethodManager) {
        if (this.nativeMethodManager == nativeMethodManager) {
            this.nativeMethodManager = null;
        }
    }

    public List<String> getHelp() {
        return HELP_TEXT;
    }

    public String getName() {
        return NAME;
    }

    public void handleModify(String command, ModifyResults results) {
        ArrayList<String> responses = new ArrayList<String>();
        if (command != null && command.equalsIgnoreCase("tdump")) {
            int dumpReturnCode = this.ntv_takeTDump();
            if (dumpReturnCode != 0) {
                if (dumpReturnCode > 0) {
                    responses.add("Internal error occurred. Error code is " + String.valueOf(dumpReturnCode));
                } else {
                    responses.add("InitiateSystemDump returned return code " + String.valueOf(dumpReturnCode));
                }
                results.setCompletionStatus(3);
            } else {
                results.setCompletionStatus(1);
            }
        } else {
            results.setCompletionStatus(2);
        }
        results.setResponsesContainMSGIDs(false);
        results.setResponses(responses);
    }

    private static List<String> buildHelpText() {
        ArrayList<String> responses = new ArrayList<String>();
        responses.add("Issue \"MODIFY <jobname.>identifier,tdump\"");
        responses.add("  to request the JVM to initiate a transaction dump");
        return responses;
    }

    protected native int ntv_takeTDump();

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(TdumpCommandHandler.class);
        HELP_TEXT = TdumpCommandHandler.buildHelpText();
    }
}

