/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.CustomLogProperties;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FileLogProperties;
import com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog;
import com.ibm.ws.recoverylog.spi.InvalidLogPropertiesException;
import com.ibm.ws.recoverylog.spi.LogProperties;
import com.ibm.ws.recoverylog.spi.MultiScopeLog;
import com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.spi.RecoveryLog;
import com.ibm.ws.recoverylog.spi.RecoveryLogFactory;
import com.ibm.ws.recoverylog.spi.RecoveryLogImpl;
import com.ibm.ws.recoverylog.spi.RecoveryLogManager;
import com.ibm.ws.recoverylog.spi.SharedServerLeaseLog;
import com.ibm.ws.recoverylog.spi.StreamLogProperties;
import java.lang.reflect.Constructor;
import java.util.HashMap;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RecoveryLogManagerImpl
implements RecoveryLogManager {
    private static final TraceComponent tc;
    private String _clientName = null;
    private int _clientIdentity = 0;
    private int _clientVersion = 0;
    private static String _fileSeparator;
    private RecoveryAgent _recoveryAgent = null;
    private HashMap _recoveryLogs = null;
    private HashMap _multiScopeRecoveryLogs = null;
    private final HashMap<String, RecoveryLogFactory> _customLogFactories;
    private String _traceId;
    static final long serialVersionUID = -6066225899555339807L;
    private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

    RecoveryLogManagerImpl(RecoveryAgent recoveryAgent, HashMap<String, RecoveryLogFactory> customLogFactories) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"RecoveryLogManagerImpl", (Object)new Object[]{recoveryAgent, customLogFactories});
        }
        this._recoveryAgent = recoveryAgent;
        this._customLogFactories = customLogFactories;
        this._clientName = this._recoveryAgent.clientName();
        this._clientVersion = this._recoveryAgent.clientVersion();
        this._clientIdentity = this._recoveryAgent.clientIdentifier();
        this._recoveryLogs = new HashMap();
        this._multiScopeRecoveryLogs = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"RecoveryLogManagerImpl", (Object)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized RecoveryLog getRecoveryLog(FailureScope failureScope, LogProperties logProperties) throws InvalidLogPropertiesException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRecoveryLog", (Object)new Object[]{failureScope, logProperties, this});
        }
        if (logProperties instanceof StreamLogProperties) {
            if (!Configuration.isZOS()) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Unable to create stream based recovery log on non-ZOS platform");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getRecoveryLog");
                }
                throw new InvalidLogPropertiesException();
            }
        } else if (!(logProperties instanceof FileLogProperties) && !(logProperties instanceof CustomLogProperties)) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unable to create non-file based or non-Custom recovery log");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRecoveryLog");
            }
            throw new InvalidLogPropertiesException();
        }
        Integer logIdentifier = new Integer(logProperties.logIdentifier());
        RecoveryLog recoveryLog = null;
        HashMap<FailureScope, RecoveryLog> logsByFailureScope = (HashMap<FailureScope, RecoveryLog>)this._recoveryLogs.get(logIdentifier);
        if (logsByFailureScope != null) {
            recoveryLog = (RecoveryLog)logsByFailureScope.get(failureScope);
        } else {
            logsByFailureScope = new HashMap<FailureScope, RecoveryLog>();
            this._recoveryLogs.put(logIdentifier, logsByFailureScope);
        }
        if (recoveryLog == null) {
            if (logProperties instanceof FileLogProperties) {
                MultiScopeLog multiScopeRecoveryLog = null;
                HashMap<String, MultiScopeRecoveryLog> multiScopeLogsByServerName = null;
                String serverName = failureScope.serverName();
                FileLogProperties fileLogProperties = (FileLogProperties)logProperties;
                int logType = fileLogProperties.logType();
                if (logType == 0) {
                    multiScopeLogsByServerName = (HashMap<String, MultiScopeRecoveryLog>)this._multiScopeRecoveryLogs.get(logIdentifier);
                    if (multiScopeLogsByServerName != null) {
                        multiScopeRecoveryLog = (MultiScopeLog)multiScopeLogsByServerName.get(serverName);
                    } else {
                        multiScopeLogsByServerName = new HashMap<String, MultiScopeRecoveryLog>();
                        this._multiScopeRecoveryLogs.put(logIdentifier, multiScopeLogsByServerName);
                    }
                }
                if (multiScopeRecoveryLog == null) {
                    multiScopeRecoveryLog = new MultiScopeRecoveryLog(fileLogProperties, this._recoveryAgent, failureScope);
                    if (logType == 0) {
                        multiScopeLogsByServerName.put(serverName, (MultiScopeRecoveryLog)multiScopeRecoveryLog);
                    }
                }
                recoveryLog = new RecoveryLogImpl(multiScopeRecoveryLog, failureScope);
            } else if (logProperties instanceof CustomLogProperties) {
                MultiScopeLog multiScopeRecoveryLog = null;
                HashMap<String, MultiScopeLog> multiScopeLogsByServerName = null;
                String serverName = failureScope.serverName();
                CustomLogProperties customLogProperties = (CustomLogProperties)logProperties;
                int logType = customLogProperties.logType();
                if (logType == 0) {
                    multiScopeLogsByServerName = (HashMap<String, MultiScopeLog>)this._multiScopeRecoveryLogs.get(logIdentifier);
                    if (multiScopeLogsByServerName != null) {
                        multiScopeRecoveryLog = (MultiScopeLog)multiScopeLogsByServerName.get(serverName);
                    } else {
                        multiScopeLogsByServerName = new HashMap<String, MultiScopeLog>();
                        this._multiScopeRecoveryLogs.put(logIdentifier, multiScopeLogsByServerName);
                    }
                }
                if (multiScopeRecoveryLog == null) {
                    String customLogId = customLogProperties.pluginId();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Look in properties with customLogId, " + customLogId));
                    }
                    RecoveryLogFactory factory = this._customLogFactories.get(customLogId);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Retrieved factory, " + factory));
                    }
                    if (factory == null) {
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Custom recovery log factory NOT FOUND for ", (Object)customLogId);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"getRecoveryLog");
                        }
                        throw new InvalidLogPropertiesException();
                    }
                    recoveryLog = factory.createRecoveryLog(customLogProperties, this._recoveryAgent, Configuration.getRecoveryLogComponent(), failureScope);
                    if (recoveryLog == null) {
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Custom recovery log factory returned NULL recovery log", (Object)customLogId);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"getRecoveryLog");
                        }
                        throw new InvalidLogPropertiesException();
                    }
                    if (logType == 0 && recoveryLog instanceof MultiScopeLog) {
                        multiScopeRecoveryLog = (MultiScopeLog)recoveryLog;
                        multiScopeLogsByServerName.put(serverName, multiScopeRecoveryLog);
                        recoveryLog = new RecoveryLogImpl(multiScopeRecoveryLog, failureScope);
                    }
                } else {
                    recoveryLog = new RecoveryLogImpl(multiScopeRecoveryLog, failureScope);
                }
            } else {
                try {
                    Constructor<?> ixgLogConstructor = Class.forName("com.ibm.ws390.recoverylog.spi.IXGRecoveryLogImpl").getConstructor(FailureScope.class, StreamLogProperties.class, RecoveryAgent.class);
                    recoveryLog = (RecoveryLog)ixgLogConstructor.newInstance(failureScope, (StreamLogProperties)logProperties, this._recoveryAgent);
                }
                catch (Exception ixgLogConstructor) {
                    void e;
                    FFDCFilter.processException((Throwable)ixgLogConstructor, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogManagerImpl", (String)"440", (Object)this, (Object[])new Object[]{failureScope, logProperties});
                    com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogManagerImpl.getRecoveryLog", (String)"278", (Object)this);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Exception caught initializing stream-based log", (Object)e);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getRecoveryLog", (Object)"InvalidLogPropertiesException");
                    }
                    throw new InvalidLogPropertiesException((Throwable)e);
                }
            }
            logsByFailureScope.put(failureScope, recoveryLog);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRecoveryLog", (Object)recoveryLog);
        }
        return recoveryLog;
    }

    @Override
    public SharedServerLeaseLog getLeaseLog(String localRecoveryIdentity, String recoveryGroup, LogProperties logProperties) throws InvalidLogPropertiesException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLeaseLog", (Object)new Object[]{localRecoveryIdentity, recoveryGroup, logProperties, this});
        }
        SharedServerLeaseLog leaseLog = null;
        CustomLogProperties customLogProperties = null;
        if (logProperties instanceof CustomLogProperties) {
            customLogProperties = (CustomLogProperties)logProperties;
            String customLogId = customLogProperties.pluginId();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Look in properties with customLogId, " + customLogId));
            }
            RecoveryLogFactory factory = this._customLogFactories.get(customLogId);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Retrieved factory, " + factory));
            }
            if (factory == null) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Custom recovery log factory NOT FOUND for ", (Object)customLogId);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getLeaseLog");
                }
                throw new InvalidLogPropertiesException();
            }
            leaseLog = factory.createLeaseLog(customLogProperties);
            if (leaseLog == null) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Custom recovery log factory returned NULL lease log", (Object)customLogId);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getLeaseLog");
                }
                throw new InvalidLogPropertiesException();
            }
        } else if (logProperties instanceof FileLogProperties) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Found FileLogProperties");
            }
            Object multiScopeRecoveryLog = null;
            FileLogProperties fileLogProperties = (FileLogProperties)logProperties;
            String logDirStem = fileLogProperties.logDirectoryStem();
            leaseLog = FileSharedServerLeaseLog.getFileSharedServerLeaseLog(logDirStem, localRecoveryIdentity, recoveryGroup);
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getLeaseLog");
            }
            throw new InvalidLogPropertiesException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLeaseLog", (Object)leaseLog);
        }
        return leaseLog;
    }

    public String toString() {
        if (this._traceId == null) {
            this._traceId = "RecoveryLogManagerImpl:clientName=" + this._clientName + ":" + "clientVersion=" + this._clientVersion + ":" + "clientIdentity=" + this._clientIdentity + " @" + System.identityHashCode(this);
        }
        return this._traceId;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register(RecoveryLogManagerImpl.class);
        tc = Tr.register(RecoveryLogManagerImpl.class, (String)"Transaction", null);
        _fileSeparator = null;
    }
}

