/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.FailureScopeFactory;
import com.ibm.ws.recoverylog.spi.FailureScopeManager;
import com.ibm.ws.recoverylog.spi.FileFailureScope;
import com.ibm.ws.recoverylog.spi.FileFailureScopeFactory;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.LibertyRecoveryDirectorImpl;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorFactory;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl;
import com.ibm.ws.recoverylog.spi.RecoveryFailedException;
import com.ibm.ws.recoverylog.spi.RecoveryLogAccessControllerImpl;
import com.ibm.ws.recoverylog.spi.RecoveryLogComponentImpl;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RecLogServiceImpl {
    private static TraceComponent tc;
    private String _recoveryGroup = null;
    private boolean _isPeerRecoverySupported = false;
    static final long serialVersionUID = -7574279952587800385L;
    private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

    public void initialize(Object config) {
        String theServerName;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize", (Object)config);
        }
        String cellName = "Cell";
        String clusterName = "Cluster";
        String nodeName = "Node";
        String serverName = "Server";
        if (config != null && config instanceof String && !(theServerName = (String)config).isEmpty()) {
            serverName = theServerName;
        }
        String installDirectory = "dir";
        Configuration.cellName(cellName);
        Configuration.clusterName(clusterName);
        Configuration.nodeName(nodeName);
        Configuration.serverName(serverName);
        Configuration.serverShortName(serverName);
        Configuration.WASInstallDirectory(installDirectory);
        Configuration.localFailureScope(new FileFailureScope());
        Configuration.isZOS(false);
        Configuration.setRecoveryLogComponent(new RecoveryLogComponentImpl());
        Configuration.setAccessController(new RecoveryLogAccessControllerImpl());
        FailureScopeManager.registerFailureScopeFactory(FailureScopeFactory.FILE_FAILURE_SCOPE_ID, FileFailureScope.class, new FileFailureScopeFactory());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void start() {
        block11: {
            RecoveryDirector director;
            block10: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"start");
                }
                director = null;
                try {
                    director = RecoveryDirectorFactory.recoveryDirector();
                    ((RecoveryDirectorImpl)director).driveLocalRecovery();
                }
                catch (RecoveryFailedException recoveryFailedException) {
                    void exc;
                    FFDCFilter.processException((Throwable)recoveryFailedException, (String)"com.ibm.ws.recoverylog.spi.RecLogServiceImpl", (String)"126", (Object)this, (Object[])new Object[0]);
                    com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecLogServiceImpl.start", (String)"421", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Local recovery failed.");
                    }
                }
                catch (InternalLogException exc) {
                    void ile;
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecLogServiceImpl", (String)"133", (Object)this, (Object[])new Object[0]);
                    com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)ile, (String)"com.ibm.ws.recoverylog.spi.RecLogServiceImpl.start", (String)"478", (Object)this);
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug((TraceComponent)tc, (String)"Local recovery not attempted.", (Object)ile);
                }
            }
            if (director != null && this._isPeerRecoverySupported && !this.doNotCheckPeersAtStartup()) {
                try {
                    if (director instanceof LibertyRecoveryDirectorImpl) {
                        ((LibertyRecoveryDirectorImpl)director).drivePeerRecovery();
                    }
                }
                catch (RecoveryFailedException ile) {
                    void exc;
                    FFDCFilter.processException((Throwable)ile, (String)"com.ibm.ws.recoverylog.spi.RecLogServiceImpl", (String)"152", (Object)this, (Object[])new Object[0]);
                    com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecLogServiceImpl.start", (String)"421", (Object)this);
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug((TraceComponent)tc, (String)"Local peer failed.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop() {
    }

    public void destroy() {
    }

    public void setPeerRecoverySupported(boolean isPeerRecoverySupported) {
        this._isPeerRecoverySupported = isPeerRecoverySupported;
    }

    public void setRecoveryGroup(String recoveryGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setRecoveryGroup", (Object)new Object[]{recoveryGroup});
        }
        this._recoveryGroup = recoveryGroup;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setRecoveryGroup");
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean doNotCheckPeersAtStartup() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doNotCheckPeersAtStartup");
        }
        boolean doCheck = true;
        Boolean doNotPeerCheckAtStartup = null;
        try {
            doNotPeerCheckAtStartup = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){
                static final long serialVersionUID = -7575411395322914251L;
                private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    Boolean theResult = Boolean.getBoolean("com.ibm.ws.recoverylog.spi.DoNotCheckPeersAtStartup");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Have retrieved jvm property with result, " + theResult));
                    }
                    return theResult;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = com.ibm.websphere.ras.Tr.register(1.class);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.recoverylog.spi.RecLogServiceImpl", (String)"235", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"Exception setting Peer Lease-Check Interval", (Object)e);
            }
            doNotPeerCheckAtStartup = null;
        }
        if (doNotPeerCheckAtStartup == null) {
            doNotPeerCheckAtStartup = Boolean.TRUE;
        }
        doCheck = doNotPeerCheckAtStartup;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doNotCheckPeersAtStartup", (Object)doCheck);
        }
        return doCheck;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register(RecLogServiceImpl.class);
        tc = Tr.register(RecLogServiceImpl.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    }
}

