/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.zos.logging.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.kernel.zos.NativeMethodManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.zos.jni.NativeMethodUtils;
import com.ibm.ws.zos.logging.internal.LoggingWtoLogHandler;
import com.ibm.ws.zos.logging.internal.MsgLogLogHandler;
import com.ibm.ws.zos.logging.internal.NativeMethodManagerServiceTracker;
import com.ibm.ws.zos.logging.internal.ZosLoggingConfigListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Dictionary;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ZosLoggingBundleActivator
implements BundleActivator {
    private volatile NativeMethodManagerServiceTracker nativeMethodManagerServiceTracker = new NativeMethodManagerServiceTracker(this);
    private volatile NativeMethodManager nativeMethodManager;
    private final LoggingWtoLogHandler wtoLogHandler = new LoggingWtoLogHandler(this);
    private final MsgLogLogHandler msgLogLogHandler = new MsgLogLogHandler(this);
    private final ZosLoggingConfigListener configListener = new ZosLoggingConfigListener(this);
    private volatile boolean isWTORequired = false;
    private volatile boolean isMsgLogDDDefined = false;
    private volatile boolean enableLogToMVS = false;
    private volatile boolean stopped = false;
    private BundleContext bContext;
    static final long serialVersionUID = -7857912078411837505L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void start(BundleContext bundleContext) {
        this.bContext = bundleContext;
        this.configListener.register(bundleContext);
        this.nativeMethodManagerServiceTracker.open(bundleContext);
    }

    public void stop(BundleContext ctx) {
        this.stopped = true;
        this.nativeMethodManagerServiceTracker.close();
        this.toggleRegistration();
        this.isWTORequired = false;
        this.enableLogToMVS = false;
        this.isMsgLogDDDefined = false;
    }

    protected void configUpdated(Dictionary config) {
        this.enableLogToMVS = (Boolean)config.get("enableLogToMVS");
        this.toggleRegistration();
    }

    protected void setNativeMethodManager(NativeMethodManager nativeMethodManager) {
        this.nativeMethodManager = nativeMethodManager;
        nativeMethodManager.registerNatives(ZosLoggingBundleActivator.class);
        this.isWTORequired = !this.isLaunchContextShell();
        this.isMsgLogDDDefined = this.isMsgLogDDDefined();
        this.toggleRegistration();
    }

    protected void unsetNativeMethodManager(NativeMethodManager nativeMethodManager) {
        if (this.nativeMethodManager == nativeMethodManager) {
            this.nativeMethodManager = null;
        }
    }

    private synchronized void toggleRegistration() {
        if (this.stopped || this.nativeMethodManager == null) {
            this.wtoLogHandler.unregister();
            this.msgLogLogHandler.unregister();
            return;
        }
        if (this.isWTORequired) {
            this.wtoLogHandler.register(this.bContext);
        } else if (this.enableLogToMVS) {
            this.wtoLogHandler.register(this.bContext);
        } else {
            this.wtoLogHandler.unregister();
        }
        if (this.isMsgLogDDDefined) {
            this.msgLogLogHandler.register(this.bContext);
        } else {
            this.msgLogLogHandler.unregister();
        }
    }

    private boolean isLaunchContextShell() {
        return this.ntv_isLaunchContextShell();
    }

    private boolean isMsgLogDDDefined() {
        return this.ntv_isMsgLogDDDefined();
    }

    protected long openFile(String fileName) throws IOException {
        ByteBuffer errorCodes = ByteBuffer.allocate(8);
        long retMe = this.ntv_openFile(NativeMethodUtils.convertToEBCDIC((String)fileName), errorCodes.array());
        if (retMe == 0L) {
            throw new IOException("The server could not open file " + fileName + "." + " errno: " + errorCodes.asIntBuffer().get(0) + " errno2: " + errorCodes.asIntBuffer().get(1));
        }
        return retMe;
    }

    protected void writeFile(long filePtr, String msg) throws IOException {
        ByteBuffer errorCodes = ByteBuffer.allocate(8);
        int rc = this.ntv_writeFile(filePtr, NativeMethodUtils.convertToEBCDIC((String)msg), errorCodes.array());
        if (rc != 0) {
            throw new IOException("The server could not write to FILE ptr x" + Long.toHexString(filePtr) + "." + " rc: " + rc + " errno: " + errorCodes.asIntBuffer().get(0) + " errno2: " + errorCodes.asIntBuffer().get(1) + " msg: " + msg);
        }
    }

    protected void closeFile(long filePtr) throws IOException {
        ByteBuffer errorCodes = ByteBuffer.allocate(8);
        int rc = this.ntv_closeFile(filePtr, errorCodes.array());
        if (rc != 0) {
            throw new IOException("The server could not close FILE ptr x" + Long.toHexString(filePtr) + " rc: " + rc + " errno: " + errorCodes.asIntBuffer().get(0) + " errno2: " + errorCodes.asIntBuffer().get(1));
        }
    }

    protected native int ntv_WriteToOperatorConsole(byte[] var1);

    protected native boolean ntv_isLaunchContextShell();

    protected native boolean ntv_isMsgLogDDDefined();

    protected native long ntv_openFile(byte[] var1, byte[] var2);

    protected native int ntv_writeFile(long var1, byte[] var3, byte[] var4);

    protected native int ntv_closeFile(long var1, byte[] var3);

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ZosLoggingBundleActivator.class);
    }
}

