/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.server.component;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.module.internal.ModuleClassLoaderFactory;
import com.ibm.ws.app.manager.module.internal.WebModuleInfoImpl;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ApplicationInfoFactory;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ModuleRuntimeContainer;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.container.service.metadata.MetaDataService;
import com.ibm.ws.container.service.state.ModuleStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.container.service.state.StateChangeService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.web.WebApp;
import com.ibm.ws.jaxrs20.metadata.JaxRsModuleInfo;
import com.ibm.ws.jaxrs20.metadata.JaxRsModuleMetaData;
import com.ibm.ws.jaxrs20.server.JaxRsRouterWebApp;
import com.ibm.ws.jaxrs20.server.internal.FileUtils;
import com.ibm.ws.jaxrs20.support.JaxRsMetaDataManager;
import com.ibm.ws.jaxrs20.support.JaxRsWebContainerManager;
import com.ibm.ws.kernel.feature.FeatureProvisioner;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.AdaptableModuleFactory;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.jaxrs20.server.jaxRsWebContainerManager", service={JaxRsWebContainerManager.class, ModuleStateListener.class}, property={"service.vendor=IBM"})
public class JaxRsWebContainerManagerImpl
implements JaxRsWebContainerManager,
ModuleStateListener {
    private static final TraceComponent tc = Tr.register(JaxRsWebContainerManagerImpl.class);
    private final AtomicServiceReference<ModuleRuntimeContainer> webAppContainerRef = new AtomicServiceReference("webAppContainer");
    private final AtomicServiceReference<ApplicationInfoFactory> applicationInfoFactorySRRef = new AtomicServiceReference("applicationInfoFactory");
    private final AtomicServiceReference<ArtifactContainerFactory> artifactContainerFactoryRef = new AtomicServiceReference("artifactContainerFactory");
    private final AtomicServiceReference<AdaptableModuleFactory> adaptableModuleFactoryRef = new AtomicServiceReference("adaptableModuleFactory");
    private final AtomicServiceReference<WsLocationAdmin> locationAdminRef = new AtomicServiceReference("wsLocationAdmin");
    private final AtomicServiceReference<MetaDataService> metaDataServiceSR = new AtomicServiceReference("metaDataService");
    private final AtomicServiceReference<StateChangeService> stateChangeSRRef = new AtomicServiceReference("stateChangeService");
    private final Map<J2EEName, ModuleRuntimeData> j2EENameModuleRuntimeDataMap = new ConcurrentHashMap<J2EEName, ModuleRuntimeData>();
    private final Map<J2EEName, WebModuleInfo> attachedWebModuleInfoMap = new ConcurrentHashMap<J2EEName, WebModuleInfo>();
    private final AtomicServiceReference<FeatureProvisioner> _featureProvisioner = new AtomicServiceReference("featureProvisioner");
    private File cacheBaseDirectory;
    static final long serialVersionUID = -2610661592751831342L;

    protected void activate(ComponentContext cc) {
        this._featureProvisioner.activate(cc);
        this.webAppContainerRef.activate(cc);
        this.applicationInfoFactorySRRef.activate(cc);
        this.artifactContainerFactoryRef.activate(cc);
        this.adaptableModuleFactoryRef.activate(cc);
        this.locationAdminRef.activate(cc);
        this.metaDataServiceSR.activate(cc);
        this.stateChangeSRRef.activate(cc);
        this.cacheBaseDirectory = ((WsLocationAdmin)this.locationAdminRef.getServiceWithException()).getBundleFile((Object)this, "rs20routermodules");
        if (!FileUtils.ensureDirExists(this.cacheBaseDirectory) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Could not create directory at {0}.", (Object[])new Object[]{this.cacheBaseDirectory.getAbsolutePath()});
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void deactivate(ComponentContext cc) {
        for (Map.Entry<J2EEName, ModuleRuntimeData> entry : this.j2EENameModuleRuntimeDataMap.entrySet()) {
            ModuleRuntimeData moduleRuntimeData = entry.getValue();
            if (moduleRuntimeData.started) {
                try {
                    this.stopWebModuleInfo(moduleRuntimeData.webModuleInfo);
                }
                catch (StateChangeException stateChangeException) {
                    void e;
                    FFDCFilter.processException((Throwable)stateChangeException, (String)"com.ibm.ws.jaxrs20.server.component.JaxRsWebContainerManagerImpl", (String)"122", (Object)this, (Object[])new Object[]{cc});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Unable to stop web module " + entry.getKey() + " due to " + e.getMessage()), (Object[])new Object[0]);
                }
                continue;
            }
            this.cleanUp(moduleRuntimeData);
        }
        this.j2EENameModuleRuntimeDataMap.clear();
        this.attachedWebModuleInfoMap.clear();
        this.webAppContainerRef.deactivate(cc);
        this.applicationInfoFactorySRRef.deactivate(cc);
        this.artifactContainerFactoryRef.deactivate(cc);
        this.adaptableModuleFactoryRef.deactivate(cc);
        this.locationAdminRef.deactivate(cc);
        this.metaDataServiceSR.deactivate(cc);
        this.stateChangeSRRef.deactivate(cc);
        this._featureProvisioner.deactivate(cc);
    }

    @Reference(name="featureProvisioner", service=FeatureProvisioner.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setFeatureProvisioner(ServiceReference<FeatureProvisioner> ref) {
        this._featureProvisioner.setReference(ref);
    }

    protected void unsetFeatureProvisioner(ServiceReference<FeatureProvisioner> ref) {
        this._featureProvisioner.unsetReference(ref);
    }

    @Reference(name="applicationInfoFactory", service=ApplicationInfoFactory.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setApplicationInfoFactory(ServiceReference<ApplicationInfoFactory> ref) {
        this.applicationInfoFactorySRRef.setReference(ref);
    }

    protected void unsetApplicationInfoFactory(ServiceReference<ApplicationInfoFactory> ref) {
        this.applicationInfoFactorySRRef.unsetReference(ref);
    }

    @Reference(name="webAppContainer", service=ModuleRuntimeContainer.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, target="(type=web)")
    protected void setWebAppContainer(ServiceReference<ModuleRuntimeContainer> ref) {
        this.webAppContainerRef.setReference(ref);
    }

    protected void unsetWebAppContainer(ServiceReference<ModuleRuntimeContainer> ref) {
        this.webAppContainerRef.setReference(null);
    }

    @Reference(name="artifactContainerFactory", service=ArtifactContainerFactory.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setArtifactContainerFactory(ServiceReference<ArtifactContainerFactory> ref) {
        this.artifactContainerFactoryRef.setReference(ref);
    }

    protected void unsetArtifactContainerFactory(ServiceReference<ArtifactContainerFactory> ref) {
        this.artifactContainerFactoryRef.unsetReference(ref);
    }

    @Reference(name="adaptableModuleFactory", service=AdaptableModuleFactory.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setAdaptableModuleFactory(ServiceReference<AdaptableModuleFactory> ref) {
        this.adaptableModuleFactoryRef.setReference(ref);
    }

    protected void unsetAdaptableModuleFactory(ServiceReference<AdaptableModuleFactory> ref) {
        this.adaptableModuleFactoryRef.unsetReference(ref);
    }

    @Reference(name="wsLocationAdmin", service=WsLocationAdmin.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setWsLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.setReference(ref);
    }

    protected void unsetWsLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.unsetReference(ref);
    }

    @Reference(name="stateChangeService", service=StateChangeService.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setStateChangeService(ServiceReference<StateChangeService> ref) {
        this.stateChangeSRRef.setReference(ref);
    }

    protected void unsetStateChangeService(ServiceReference<StateChangeService> ref) {
        this.stateChangeSRRef.unsetReference(ref);
    }

    @Reference(name="metaDataService", service=MetaDataService.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setMetaDataService(ServiceReference<MetaDataService> ref) {
        this.metaDataServiceSR.setReference(ref);
    }

    protected void unsetMetaDataService(ServiceReference<MetaDataService> ref) {
        this.metaDataServiceSR.unsetReference(ref);
    }

    /*
     * WARNING - void declaration
     */
    public WebModuleInfo createWebModuleInfo(ModuleInfo moduleInfo) throws UnableToAdaptException {
        try {
            ArtifactContainer artifactContainer;
            File dummyWebApplicationDirectory;
            File cacheOverlayDirectory;
            File cacheAdaptDirectory;
            File cacheDirectory;
            File moduleCacheBaseDirectory;
            if (this._featureProvisioner.getService() == null) {
                throw new RuntimeException("service " + FeatureProvisioner.class.getName() + " is not available");
            }
            boolean isJAXWSEnabled = false;
            Set features = ((FeatureProvisioner)this._featureProvisioner.getService()).getInstalledFeatures();
            for (String feature : features) {
                if (!feature.equals("jaxws-2.2")) continue;
                isJAXWSEnabled = true;
                break;
            }
            if (!FileUtils.ensureDirExists(moduleCacheBaseDirectory = new File(this.cacheBaseDirectory, UUID.randomUUID().toString())) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not create directory at {0}.", (Object[])new Object[]{moduleCacheBaseDirectory.getAbsolutePath()});
            }
            if (!FileUtils.ensureDirExists(cacheDirectory = new File(moduleCacheBaseDirectory, "cache")) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not create directory at {0}.", (Object[])new Object[]{cacheDirectory.getAbsolutePath()});
            }
            if (!FileUtils.ensureDirExists(cacheAdaptDirectory = new File(moduleCacheBaseDirectory, "cacheAdapt")) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not create directory at {0}.", (Object[])new Object[]{cacheAdaptDirectory.getAbsolutePath()});
            }
            if (!FileUtils.ensureDirExists(cacheOverlayDirectory = new File(moduleCacheBaseDirectory, "cacheOverlay")) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not create directory at {0}.", (Object[])new Object[]{cacheOverlayDirectory.getAbsolutePath()});
            }
            if (!FileUtils.ensureDirExists(dummyWebApplicationDirectory = new File(moduleCacheBaseDirectory, "router.war")) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not create directory at {0}.", (Object[])new Object[]{dummyWebApplicationDirectory.getAbsolutePath()});
            }
            if ((artifactContainer = ((ArtifactContainerFactory)this.artifactContainerFactoryRef.getServiceWithException()).getContainer(cacheDirectory, (Object)dummyWebApplicationDirectory)) == null) {
                throw new IllegalStateException("");
            }
            Container moduleContainer = ((AdaptableModuleFactory)this.adaptableModuleFactoryRef.getServiceWithException()).getContainer(cacheAdaptDirectory, cacheOverlayDirectory, artifactContainer);
            JaxRsModuleMetaData jaxRsModuleMetaData = JaxRsMetaDataManager.getJaxRsModuleMetaData((ModuleMetaData)((ExtendedModuleInfo)moduleInfo).getMetaData());
            if (jaxRsModuleMetaData == null) {
                return null;
            }
            NonPersistentCache overlayCache = (NonPersistentCache)moduleContainer.adapt(NonPersistentCache.class);
            overlayCache.addToCache(JaxRsModuleMetaData.class, (Object)jaxRsModuleMetaData);
            overlayCache.addToCache(WebApp.class, (Object)new JaxRsRouterWebApp(jaxRsModuleMetaData.getJ2EEName().toString() + "-Router-WebModule"));
            JaxRsModuleInfo jaxrsModuleInfo = (JaxRsModuleInfo)moduleInfo.getContainer().adapt(JaxRsModuleInfo.class);
            overlayCache.addToCache(JaxRsModuleInfo.class, (Object)jaxrsModuleInfo);
            ApplicationInfo appInfo = moduleInfo.getApplicationInfo();
            String ejbModuleName = moduleInfo.getName();
            String webModuleName = ejbModuleName + "-RSRouter";
            String defaultContextRoot = jaxrsModuleInfo.isShareEJBJarWithJAXWS() && isJAXWSEnabled ? "/" + ejbModuleName + ".jaxrs" : "/" + ejbModuleName;
            final ClassLoader moduleClassLoader = moduleInfo.getClassLoader();
            ModuleClassLoaderFactory classPathFactory = new ModuleClassLoaderFactory(){
                static final long serialVersionUID = 2518301082168096581L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public ClassLoader createModuleClassLoader(ModuleInfo moduleInfo, List<ContainerInfo> moduleClassesContainers) {
                    return moduleClassLoader;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            };
            WebModuleInfoImpl webModuleInfo = new WebModuleInfoImpl(appInfo, webModuleName, webModuleName, defaultContextRoot, moduleContainer, null, null, classPathFactory);
            ModuleMetaData webModuleMetaData = ((ModuleRuntimeContainer)this.webAppContainerRef.getServiceWithException()).createModuleMetaData((ModuleInfo)webModuleInfo);
            JaxRsMetaDataManager.setJaxRsModuleMetaData((ModuleMetaData)webModuleMetaData, (JaxRsModuleMetaData)jaxRsModuleMetaData);
            MetaDataService metaDataService = (MetaDataService)this.metaDataServiceSR.getServiceWithException();
            webModuleInfo.setMetaData(webModuleMetaData);
            try {
                metaDataService.fireModuleMetaDataCreated(webModuleMetaData, moduleContainer);
            }
            catch (Throwable throwable) {
                void t;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.jaxrs20.server.component.JaxRsWebContainerManagerImpl", (String)"318", (Object)this, (Object[])new Object[]{moduleInfo});
                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireModuleMetaDataCreated");
            }
            ModuleRuntimeData moduleRuntimeData = new ModuleRuntimeData();
            moduleRuntimeData.moduleCacheBaseDirectory = moduleCacheBaseDirectory;
            moduleRuntimeData.webModuleInfo = webModuleInfo;
            this.j2EENameModuleRuntimeDataMap.put(webModuleMetaData.getJ2EEName(), moduleRuntimeData);
            return webModuleInfo;
        }
        catch (MetaDataException isJAXWSEnabled) {
            void e;
            FFDCFilter.processException((Throwable)isJAXWSEnabled, (String)"com.ibm.ws.jaxrs20.server.component.JaxRsWebContainerManagerImpl", (String)"329", (Object)this, (Object[])new Object[]{moduleInfo});
            throw new IllegalStateException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void startWebModuleInfo(WebModuleInfo webModuleInfoInfo) throws StateChangeException {
        J2EEName j2EEName = ((ExtendedModuleInfo)webModuleInfoInfo).getMetaData().getJ2EEName();
        ModuleRuntimeData moduleRuntimeData = this.j2EENameModuleRuntimeDataMap.get(j2EEName);
        if (moduleRuntimeData != null && !moduleRuntimeData.started) {
            StateChangeService stateChangeService = (StateChangeService)this.stateChangeSRRef.getService();
            if (stateChangeService != null) {
                try {
                    stateChangeService.fireModuleStarting((ModuleInfo)webModuleInfoInfo);
                }
                catch (Throwable throwable) {
                    void t;
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.jaxrs20.server.component.JaxRsWebContainerManagerImpl", (String)"343", (Object)this, (Object[])new Object[]{webModuleInfoInfo});
                    FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireModuleStarting");
                }
            }
            ((ModuleRuntimeContainer)this.webAppContainerRef.getServiceWithException()).startModule((ModuleInfo)webModuleInfoInfo);
            moduleRuntimeData.started = true;
            if (stateChangeService != null) {
                try {
                    stateChangeService.fireModuleStarted((ModuleInfo)webModuleInfoInfo);
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.jaxrs20.server.component.JaxRsWebContainerManagerImpl", (String)"352", (Object)this, (Object[])new Object[]{webModuleInfoInfo});
                    FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireModuleStarted");
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Unable to find the ModuleRuntimeData for the module " + j2EEName + ", startWebModuleInfo will not be invoked"), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stopWebModuleInfo(WebModuleInfo webModuleInfo) throws StateChangeException {
        J2EEName j2EEName = ((ExtendedModuleInfo)webModuleInfo).getMetaData().getJ2EEName();
        ModuleRuntimeData moduleRuntimeData = this.j2EENameModuleRuntimeDataMap.remove(j2EEName);
        if (moduleRuntimeData != null) {
            StateChangeService stateChangeService = (StateChangeService)this.stateChangeSRRef.getService();
            try {
                MetaDataService metaDataService;
                ModuleRuntimeContainer moduleRuntimeContainer;
                if (stateChangeService != null) {
                    try {
                        stateChangeService.fireModuleStopping((ModuleInfo)webModuleInfo);
                    }
                    catch (Throwable throwable) {
                        void t;
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.jaxrs20.server.component.JaxRsWebContainerManagerImpl", (String)"375", (Object)this, (Object[])new Object[]{webModuleInfo});
                        FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireModuleStopping");
                    }
                }
                if ((moduleRuntimeContainer = (ModuleRuntimeContainer)this.webAppContainerRef.getService()) != null) {
                    moduleRuntimeContainer.stopModule((ModuleInfo)webModuleInfo);
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unable to get webAppContainer, stop action for module {0} is skipped", (Object[])new Object[]{webModuleInfo.getName()});
                }
                if (stateChangeService != null) {
                    try {
                        stateChangeService.fireModuleStopped((ModuleInfo)webModuleInfo);
                    }
                    catch (Throwable throwable) {
                        void t;
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.jaxrs20.server.component.JaxRsWebContainerManagerImpl", (String)"390", (Object)this, (Object[])new Object[]{webModuleInfo});
                        FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireModuleStopped");
                    }
                }
                if ((metaDataService = (MetaDataService)this.metaDataServiceSR.getService()) == null) return;
                try {
                    metaDataService.fireModuleMetaDataDestroyed(((ExtendedModuleInfo)webModuleInfo).getMetaData());
                    return;
                }
                catch (Throwable throwable) {
                    void t;
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.jaxrs20.server.component.JaxRsWebContainerManagerImpl", (String)"400", (Object)this, (Object[])new Object[]{webModuleInfo});
                    FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireModuleMetaDataDestroyed");
                }
                return;
            }
            finally {
                this.cleanUp(moduleRuntimeData);
            }
        }
        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return;
        Tr.debug((TraceComponent)tc, (String)("Unable to find the ModuleRuntimeData for the module " + j2EEName + ", stopWebModuleInfo will not be invoked"), (Object[])new Object[0]);
    }

    public void moduleStarting(ModuleInfo moduleInfo) throws StateChangeException {
    }

    public void moduleStarted(ModuleInfo moduleInfo) throws StateChangeException {
        WebModuleInfo webModuleInfo = this.attachedWebModuleInfoMap.get(((ExtendedModuleInfo)moduleInfo).getMetaData().getJ2EEName());
        if (webModuleInfo != null) {
            this.startWebModuleInfo(webModuleInfo);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void moduleStopping(ModuleInfo moduleInfo) {
        WebModuleInfo webModuleInfo = this.attachedWebModuleInfoMap.remove(((ExtendedModuleInfo)moduleInfo).getMetaData().getJ2EEName());
        if (webModuleInfo == null) {
            return;
        }
        try {
            this.stopWebModuleInfo(webModuleInfo);
        }
        catch (StateChangeException stateChangeException) {
            void e;
            FFDCFilter.processException((Throwable)stateChangeException, (String)"com.ibm.ws.jaxrs20.server.component.JaxRsWebContainerManagerImpl", (String)"435", (Object)this, (Object[])new Object[]{moduleInfo});
            throw new IllegalStateException((Throwable)e);
        }
    }

    public void moduleStopped(ModuleInfo moduleInfo) {
    }

    public void attachWebModuleInfo(ModuleInfo moduleInfo, WebModuleInfo webModuleInfo) throws UnableToAdaptException {
        if (!this.j2EENameModuleRuntimeDataMap.containsKey(((ExtendedModuleInfo)webModuleInfo).getMetaData().getJ2EEName())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The webmoduleInfo " + ((ExtendedModuleInfo)webModuleInfo).getMetaData().getJ2EEName() + "was not created by the JaxWsWebContainerManager, unable to attach its lifecycle to the target module " + ((ExtendedModuleInfo)moduleInfo).getMetaData().getJ2EEName()), (Object[])new Object[0]);
            }
            return;
        }
        this.attachedWebModuleInfoMap.put(((ExtendedModuleInfo)moduleInfo).getMetaData().getJ2EEName(), webModuleInfo);
    }

    protected void cleanUp(ModuleRuntimeData moduleRuntimeData) {
        FileUtils.recursiveDelete(moduleRuntimeData.moduleCacheBaseDirectory);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class ModuleRuntimeData {
        public volatile boolean started = false;
        public File moduleCacheBaseDirectory;
        public WebModuleInfo webModuleInfo;
        static final long serialVersionUID = -468775227267749472L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ModuleRuntimeData() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ModuleRuntimeData.class);
        }
    }
}

