/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ws.ffdc.FFDCFilter;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Random;

public class UUID
implements Cloneable,
Comparable {
    private static final TraceComponent tc = Tr.register(UUID.class, null, null);
    private static final String SCCSID = "@(#) 1.9 ws/code/utils/src/com/ibm/ws/util/UUID.java, WAS.utils, ASV 3/5/04 11:40:54 [9/7/12 10:20:04]";
    private static final Object _LOCK = new Object();
    private static final long _CLASS_LOAD_SYSTEM_TIME = System.currentTimeMillis();
    private static final long _CLASS_LOAD_NANO_TIME = System.nanoTime();
    private static final long NANOS_IN_A_MILLISECOND = 1000000L;
    private static long _lastTime = 0L;
    private static int _clockSeq = 0;
    private static final int _PID = UUID.getPID();
    private static final long _IP_ADDRESS = UUID.getIPAddress();
    private static final long _OLD_VERSION_ID = 0x2000000000000000L;
    private static final long _CURRENT_VERSION_ID = 0x4000000000000000L;
    private static final long _VERSION_MASK = -1152921504606846976L;
    private static final char[] _NIBBLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private long _uuidHigh;
    private long _uuidLow;
    private transient String _cachedString = null;
    private transient byte[] _cachedBytes = null;
    private boolean _unexpectedFormat = false;
    private boolean _hashed = false;
    private int _hashCode = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID() {
        int ourSeq;
        long time;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"UUID");
        }
        Object object = _LOCK;
        synchronized (object) {
            time = UUID.getTime();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("time = " + time));
            }
            if (_lastTime == time) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Times match, incrementing and using clockSeq");
                }
                if (++_clockSeq == 8192) {
                    _clockSeq = 0;
                    time = UUID.getTime();
                    while (_lastTime == time) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.util.UUID.<init>", (String)"166");
                        }
                        time = UUID.getTime();
                    }
                    _lastTime = time;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Times do no match");
                }
                _clockSeq = 0;
                _lastTime = time;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("_lastTime = " + _lastTime));
                }
            }
            ourSeq = _clockSeq;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ourSeq = " + ourSeq));
        }
        this._uuidHigh = 0x4000000000000000L + (time & 0xFFFFFFFFFFFFFFFL);
        this._uuidLow = 0xE000000000000000L | ((long)ourSeq & 0x1FFFL) << 48 | (long)_PID << 32;
        this._uuidLow |= _IP_ADDRESS;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"UUID", (Object)this);
        }
    }

    public UUID(byte[] bytes) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"UUID", (Object)Util.toHexString(bytes));
        }
        if (bytes == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"UUID", (Object)"NullPointerException");
            }
            throw new NullPointerException();
        }
        if (bytes.length != 16) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unexpected format byte[] length != 16");
            }
            this._cachedBytes = new byte[bytes.length];
            System.arraycopy(bytes, 0, this._cachedBytes, 0, this._cachedBytes.length);
            this._cachedString = Util.toHexString(bytes);
            this._unexpectedFormat = true;
        } else {
            byte[] cloned = new byte[16];
            System.arraycopy(bytes, 0, cloned, 0, 16);
            this.fillFromBytes(cloned);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"UUID", (Object)this);
        }
    }

    public UUID(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"UUID", (Object)string);
        }
        byte[] bytes = new byte[]{(byte)Integer.parseInt(string.substring(14, 16), 16), (byte)Integer.parseInt(string.substring(16, 18), 16), (byte)Integer.parseInt(string.substring(9, 11), 16), (byte)Integer.parseInt(string.substring(11, 13), 16), (byte)Integer.parseInt(string.substring(0, 2), 16), (byte)Integer.parseInt(string.substring(2, 4), 16), (byte)Integer.parseInt(string.substring(4, 6), 16), (byte)Integer.parseInt(string.substring(6, 8), 16), (byte)Integer.parseInt(string.substring(19, 21), 16), (byte)Integer.parseInt(string.substring(21, 23), 16), (byte)Integer.parseInt(string.substring(24, 26), 16), (byte)Integer.parseInt(string.substring(26, 28), 16), (byte)Integer.parseInt(string.substring(28, 30), 16), (byte)Integer.parseInt(string.substring(30, 32), 16), (byte)Integer.parseInt(string.substring(32, 34), 16), (byte)Integer.parseInt(string.substring(34, 36), 16)};
        this.fillFromBytes(bytes);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"UUID", (Object)this);
        }
    }

    protected void fillFromBytes(byte[] bytes) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fillFromBytes", (Object)Util.toHexString(bytes));
        }
        this._uuidHigh = ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | ((long)bytes[7] & 0xFFL) << 0;
        this._uuidLow = ((long)bytes[8] & 0xFFL) << 56 | ((long)bytes[9] & 0xFFL) << 48 | ((long)bytes[10] & 0xFFL) << 40 | ((long)bytes[11] & 0xFFL) << 32 | ((long)bytes[12] & 0xFFL) << 24 | ((long)bytes[13] & 0xFFL) << 16 | ((long)bytes[14] & 0xFFL) << 8 | ((long)bytes[15] & 0xFFL) << 0;
        this._cachedBytes = bytes;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"fillFromBytes");
        }
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"toString");
        }
        if (this._cachedString == null) {
            char[] string = new char[]{_NIBBLE[(int)((this._uuidHigh & 0xF0000000L) >>> 28)], _NIBBLE[(int)((this._uuidHigh & 0xF000000L) >>> 24)], _NIBBLE[(int)((this._uuidHigh & 0xF00000L) >>> 20)], _NIBBLE[(int)((this._uuidHigh & 0xF0000L) >>> 16)], _NIBBLE[(int)((this._uuidHigh & 0xF000L) >>> 12)], _NIBBLE[(int)((this._uuidHigh & 0xF00L) >>> 8)], _NIBBLE[(int)((this._uuidHigh & 0xF0L) >>> 4)], _NIBBLE[(int)((this._uuidHigh & 0xFL) >>> 0)], '-', _NIBBLE[(int)((this._uuidHigh & 0xF00000000000L) >>> 44)], _NIBBLE[(int)((this._uuidHigh & 0xF0000000000L) >>> 40)], _NIBBLE[(int)((this._uuidHigh & 0xF000000000L) >>> 36)], _NIBBLE[(int)((this._uuidHigh & 0xF00000000L) >>> 32)], '-', _NIBBLE[(int)((this._uuidHigh & 0xF000000000000000L) >>> 60)], _NIBBLE[(int)((this._uuidHigh & 0xF00000000000000L) >>> 56)], _NIBBLE[(int)((this._uuidHigh & 0xF0000000000000L) >>> 52)], _NIBBLE[(int)((this._uuidHigh & 0xF000000000000L) >>> 48)], '-', _NIBBLE[(int)((this._uuidLow & 0xF000000000000000L) >>> 60)], _NIBBLE[(int)((this._uuidLow & 0xF00000000000000L) >>> 56)], _NIBBLE[(int)((this._uuidLow & 0xF0000000000000L) >>> 52)], _NIBBLE[(int)((this._uuidLow & 0xF000000000000L) >>> 48)], '-', _NIBBLE[(int)((this._uuidLow & 0xF00000000000L) >>> 44)], _NIBBLE[(int)((this._uuidLow & 0xF0000000000L) >>> 40)], _NIBBLE[(int)((this._uuidLow & 0xF000000000L) >>> 36)], _NIBBLE[(int)((this._uuidLow & 0xF00000000L) >>> 32)], _NIBBLE[(int)((this._uuidLow & 0xF0000000L) >>> 28)], _NIBBLE[(int)((this._uuidLow & 0xF000000L) >>> 24)], _NIBBLE[(int)((this._uuidLow & 0xF00000L) >>> 20)], _NIBBLE[(int)((this._uuidLow & 0xF0000L) >>> 16)], _NIBBLE[(int)((this._uuidLow & 0xF000L) >>> 12)], _NIBBLE[(int)((this._uuidLow & 0xF00L) >>> 8)], _NIBBLE[(int)((this._uuidLow & 0xF0L) >>> 4)], _NIBBLE[(int)((this._uuidLow & 0xFL) >>> 0)]};
            this._cachedString = new String(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"toString", (Object)this._cachedString);
        }
        return this._cachedString;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        UUID other = (UUID)object;
        if (this._unexpectedFormat) {
            return Arrays.equals(this._cachedBytes, other.toByteArray());
        }
        if (this._uuidHigh != other._uuidHigh) {
            return false;
        }
        return this._uuidLow == other._uuidLow;
    }

    public int hashCode() {
        if (this._unexpectedFormat) {
            if (!this._hashed) {
                for (int i = 0; i < this._cachedBytes.length; ++i) {
                    this._hashCode += this._cachedBytes[i];
                }
                this._hashed = true;
            }
            return this._hashCode;
        }
        return (int)this._uuidHigh;
    }

    public byte[] toByteArray() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"toByteArray");
        }
        if (this._cachedBytes == null) {
            this._cachedBytes = new byte[16];
            this._cachedBytes[0] = (byte)((this._uuidHigh & 0xFF00000000000000L) >>> 56);
            this._cachedBytes[1] = (byte)((this._uuidHigh & 0xFF000000000000L) >>> 48);
            this._cachedBytes[2] = (byte)((this._uuidHigh & 0xFF0000000000L) >>> 40);
            this._cachedBytes[3] = (byte)((this._uuidHigh & 0xFF00000000L) >>> 32);
            this._cachedBytes[4] = (byte)((this._uuidHigh & 0xFF000000L) >>> 24);
            this._cachedBytes[5] = (byte)((this._uuidHigh & 0xFF0000L) >>> 16);
            this._cachedBytes[6] = (byte)((this._uuidHigh & 0xFF00L) >>> 8);
            this._cachedBytes[7] = (byte)((this._uuidHigh & 0xFFL) >>> 0);
            this._cachedBytes[8] = (byte)((this._uuidLow & 0xFF00000000000000L) >>> 56);
            this._cachedBytes[9] = (byte)((this._uuidLow & 0xFF000000000000L) >>> 48);
            this._cachedBytes[10] = (byte)((this._uuidLow & 0xFF0000000000L) >>> 40);
            this._cachedBytes[11] = (byte)((this._uuidLow & 0xFF00000000L) >>> 32);
            this._cachedBytes[12] = (byte)((this._uuidLow & 0xFF000000L) >>> 24);
            this._cachedBytes[13] = (byte)((this._uuidLow & 0xFF0000L) >>> 16);
            this._cachedBytes[14] = (byte)((this._uuidLow & 0xFF00L) >>> 8);
            this._cachedBytes[15] = (byte)((this._uuidLow & 0xFFL) >>> 0);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"toByteArray", (Object)Util.toHexString(this._cachedBytes));
        }
        return this._cachedBytes;
    }

    public int compareTo(Object obj) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"compareTo", (Object)obj);
        }
        UUID other = (UUID)obj;
        int result = 0;
        if (this.equals(other)) {
            result = 0;
        } else if (this._unexpectedFormat) {
            result = Integer.valueOf(this.hashCode()).compareTo(other.hashCode());
        } else {
            result = Long.valueOf(this._uuidHigh).compareTo(other._uuidHigh);
            if (result == 0) {
                result = Long.valueOf(this._uuidLow).compareTo(other._uuidLow);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"compareTo", (Object)result);
        }
        return result;
    }

    public Object clone() {
        return this;
    }

    public boolean isCurrentVersion() {
        if (this._unexpectedFormat) {
            return false;
        }
        return (this._uuidHigh & 0xF000000000000000L) == 0x4000000000000000L;
    }

    public boolean isOldVersion() {
        if (this._unexpectedFormat) {
            return false;
        }
        long version = this._uuidHigh & 0xF000000000000000L;
        return version >= 0x2000000000000000L && version < 0x4000000000000000L;
    }

    private static int getPID() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPID");
        }
        short spid = 0;
        int ipid = 0;
        try {
            spid = Short.parseShort(RasHelper.getProcessId());
        }
        catch (Throwable t) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Caught throwable parsing PID", (Object)t);
            }
            spid = (short)(new Random().nextInt() & 0xFFFF);
        }
        ipid = spid & 0xFFFF;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPID", (Object)ipid);
        }
        return ipid;
    }

    private static long getIPAddress() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getIPAddress");
        }
        int lower32Bits = 0;
        try {
            byte[] address = InetAddress.getLocalHost().getAddress();
            lower32Bits = (address[0] & 0xFF) << 24 | (address[1] & 0xFF) << 16 | (address[2] & 0xFF) << 8 | (address[3] & 0xFF) << 0;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.util.UUID.getIPAddress", (String)"661");
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Exception caught getting host address.", (Object)e);
            }
            lower32Bits = new Random().nextInt();
        }
        long ipAddress = (long)lower32Bits & 0xFFFFFFFFL;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getIPAddress", (Object)ipAddress);
        }
        return ipAddress;
    }

    private static long getTime() {
        return _CLASS_LOAD_SYSTEM_TIME + (System.nanoTime() - _CLASS_LOAD_NANO_TIME) / 1000000L;
    }
}

