/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container.service.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.xml.internal.nester.Nester;
import com.ibm.ws.container.service.app.deploy.NestedConfigHelper;
import com.ibm.ws.container.service.security.SecurityRoles;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.appbnd.ApplicationBnd;
import com.ibm.ws.javaee.dd.appbnd.Group;
import com.ibm.ws.javaee.dd.appbnd.RunAs;
import com.ibm.ws.javaee.dd.appbnd.SecurityRole;
import com.ibm.ws.javaee.dd.appbnd.SpecialSubject;
import com.ibm.ws.javaee.dd.appbnd.User;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class SecurityRolesImpl
implements SecurityRoles {
    private static final TraceComponent tc = Tr.register(SecurityRolesImpl.class);
    private final Container appContainer;
    private final NestedConfigHelper configHelper;
    private final AtomicServiceReference<ConfigurationAdmin> configAdminSRRef;
    private List<SecurityRole> securityRolesList = null;
    private static final String PASSWORD = "password";
    private static final String USERID2 = "userid";
    private static final String TYPE = "type";
    private static final String ACCESS_ID = "access-id";
    private static final String RUN_AS = "run-as";
    private static final String SPECIAL_SUBJECT = "special-subject";
    private static final String GROUP = "group";
    private static final String USER = "user";
    private static final String NAME = "name";
    private static final String SECURITY_ROLE = "security-role";
    static final long serialVersionUID = -3984063688463983667L;

    SecurityRolesImpl(Container appContainer, NestedConfigHelper configHelper, AtomicServiceReference<ConfigurationAdmin> configAdminSRRef) throws UnableToAdaptException {
        this.appContainer = appContainer;
        this.configHelper = configHelper;
        this.configAdminSRRef = configAdminSRRef;
        this.securityRolesList = this.getSecurityRolesList();
    }

    /*
     * WARNING - void declaration
     */
    private List<SecurityRole> getSecurityRoles(Source source) throws UnableToAdaptException {
        if (source == Source.EarApplicationBnd) {
            ApplicationBnd appBnd = (ApplicationBnd)this.appContainer.adapt(ApplicationBnd.class);
            if (appBnd != null) {
                List roles = appBnd.getSecurityRoles();
                return roles;
            }
            return null;
        }
        if (source == Source.ServerXMLConfig) {
            if (this.configHelper == null) {
                return null;
            }
            String parentPid = (String)this.configHelper.get("service.pid");
            String sourcePid = (String)this.configHelper.get("ibm.extends.source.pid");
            if (sourcePid != null) {
                parentPid = sourcePid;
            }
            ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminSRRef.getService();
            try {
                return SecurityRolesImpl.createSecurityRoles(parentPid, configAdmin);
            }
            catch (IOException iOException) {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.container.service.security.internal.SecurityRolesImpl", (String)"85", (Object)this, (Object[])new Object[]{source});
                throw new UnableToAdaptException((Throwable)e);
            }
        }
        return null;
    }

    @Override
    public List<SecurityRole> getSecurityRoles() {
        return this.securityRolesList;
    }

    private List<SecurityRole> getSecurityRolesList() throws UnableToAdaptException {
        ArrayList<SecurityRole> secRoles;
        block9: {
            List<SecurityRole> secRolesFromBindFile;
            List<SecurityRole> secRolesFromServerXml;
            block8: {
                secRolesFromServerXml = this.getSecurityRoles(Source.ServerXMLConfig);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The security roles from server.xml are: " + secRolesFromServerXml), (Object[])new Object[0]);
                }
                secRolesFromBindFile = this.getSecurityRoles(Source.EarApplicationBnd);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The security roles from the application bind file are: " + secRolesFromBindFile), (Object[])new Object[0]);
                }
                secRoles = new ArrayList<SecurityRole>();
                if (secRolesFromBindFile != null && !secRolesFromBindFile.isEmpty()) break block8;
                if (secRolesFromServerXml == null) break block9;
                for (SecurityRole serverXmlRole : secRolesFromServerXml) {
                    secRoles.add(serverXmlRole);
                }
                break block9;
            }
            for (SecurityRole bndFileRole : secRolesFromBindFile) {
                secRoles.add(bndFileRole);
            }
            if (secRolesFromServerXml != null) {
                ArrayList<SecurityRole> serverXMLRolestoAdd = new ArrayList<SecurityRole>();
                for (SecurityRole serverXmlRole : secRolesFromServerXml) {
                    boolean roleInBindFile = false;
                    for (int i = 0; i < secRoles.size(); ++i) {
                        SecurityRole bndFileRole = (SecurityRole)secRoles.get(i);
                        if (!serverXmlRole.getName().equals(bndFileRole.getName())) continue;
                        secRoles.set(i, serverXmlRole);
                        roleInBindFile = true;
                        break;
                    }
                    if (roleInBindFile) continue;
                    serverXMLRolestoAdd.add(serverXmlRole);
                }
                for (SecurityRole roleToAdd : serverXMLRolestoAdd) {
                    secRoles.add(roleToAdd);
                }
            }
        }
        return secRoles;
    }

    /*
     * WARNING - void declaration
     */
    private static synchronized List<SecurityRole> createSecurityRoles(String parentPid, ConfigurationAdmin configAdmin) throws IOException {
        StringBuilder filter = new StringBuilder(200);
        filter.append("(&");
        filter.append(FilterUtils.createPropertyFilter((String)"service.factoryPid", (String)"com.ibm.ws.javaee.dd.appbnd"));
        filter.append(FilterUtils.createPropertyFilter((String)"config.parentPID", (String)parentPid));
        filter.append(')');
        Configuration config = null;
        try {
            Configuration[] configs = configAdmin.listConfigurations(filter.toString());
            if (configs == null || configs.length != 1) {
                return Collections.emptyList();
            }
            config = configs[0];
        }
        catch (InvalidSyntaxException configs) {
            void e;
            FFDCFilter.processException((Throwable)configs, (String)"com.ibm.ws.container.service.security.internal.SecurityRolesImpl", (String)"178", null, (Object[])new Object[]{parentPid, configAdmin});
            e.getCause();
        }
        if (config == null || config.getProperties() == null) {
            return Collections.emptyList();
        }
        ArrayList<SecurityRole> securityRoles = new ArrayList<SecurityRole>();
        List<Map<String, Object>> roleConfigs = Nester.nest(SECURITY_ROLE, config.getProperties());
        for (Map<String, Object> roleConfig : roleConfigs) {
            @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
            @InjectedFFDC
            class SecurityRoleRunAs
            implements RunAs {
                private final String userid;
                private final String password;
                static final long serialVersionUID = -1340697577086842657L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public SecurityRoleRunAs(String userid, @Sensitive String password) {
                    this.userid = userid;
                    this.password = password;
                }

                public String getUserid() {
                    return this.userid;
                }

                @Sensitive
                public String getPassword() {
                    return this.password;
                }

                public String toString() {
                    return this.userid;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(SecurityRoleRunAs.class);
                }
            }
            SecurityRoleRunAs runas;
            final String rolename = (String)roleConfig.get(NAME);
            if (rolename == null) continue;
            Map<String, List<Map<String, Object>>> maps = Nester.nest(roleConfig, USER, GROUP, SPECIAL_SUBJECT, RUN_AS);
            final ArrayList<1> users = new ArrayList<1>();
            for (Map<String, Object> userConfig : maps.get(USER)) {
                final String username = (String)userConfig.get(NAME);
                final String accessId = (String)userConfig.get(ACCESS_ID);
                if (username == null || username.trim().isEmpty()) continue;
                users.add(new User(){
                    static final long serialVersionUID = -4985322486248561898L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    public String getName() {
                        return username;
                    }

                    public String getAccessId() {
                        return accessId;
                    }

                    public String toString() {
                        return username + "(" + accessId + ")";
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class);
                    }
                });
            }
            final ArrayList<2> groups = new ArrayList<2>();
            for (Map<String, Object> groupConfig : maps.get(GROUP)) {
                final String groupname = (String)groupConfig.get(NAME);
                final String accessId = (String)groupConfig.get(ACCESS_ID);
                if (groupname == null || groupname.trim().isEmpty()) continue;
                groups.add(new Group(){
                    static final long serialVersionUID = -5901164018887936278L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    public String getName() {
                        return groupname;
                    }

                    public String getAccessId() {
                        return accessId;
                    }

                    public String toString() {
                        return groupname + "(" + accessId + ")";
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(2.class);
                    }
                });
            }
            final ArrayList<3> specialSubjects = new ArrayList<3>();
            for (Map<String, Object> ssConfig : maps.get(SPECIAL_SUBJECT)) {
                final String typeString = (String)ssConfig.get(TYPE);
                if (typeString == null || typeString.trim().isEmpty()) continue;
                final SpecialSubject.Type type = SpecialSubject.Type.valueOf((String)typeString.trim());
                specialSubjects.add(new SpecialSubject(){
                    static final long serialVersionUID = 5792894843512960675L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    public SpecialSubject.Type getType() {
                        return type;
                    }

                    public String toString() {
                        return typeString;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(3.class);
                    }
                });
            }
            List<Map<String, Object>> runAsConfigList = maps.get(RUN_AS);
            if (!runAsConfigList.isEmpty()) {
                Map<String, Object> runasConfig = runAsConfigList.get(0);
                String userid = (String)runasConfig.get(USERID2);
                Object o = runasConfig.get(PASSWORD);
                String password = o != null ? (o instanceof SerializableProtectedString ? new String(((SerializableProtectedString)o).getChars()) : (String)o) : null;
                runas = new SecurityRoleRunAs(userid, password);
            } else {
                runas = null;
            }
            securityRoles.add(new SecurityRole(){
                static final long serialVersionUID = 4685332436146105129L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public String getName() {
                    return rolename;
                }

                public List<User> getUsers() {
                    return users;
                }

                public List<Group> getGroups() {
                    return groups;
                }

                public List<SpecialSubject> getSpecialSubjects() {
                    return specialSubjects;
                }

                public RunAs getRunAs() {
                    return runas;
                }

                public String toString() {
                    return "Role=" + rolename + "(users=" + users + " groups=" + groups + " specialSubjects=" + specialSubjects + " runAs=" + runas + ")";
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(4.class);
                }
            });
        }
        return securityRoles;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class Source
    extends Enum<Source> {
        public static final /* enum */ Source EarApplicationBnd;
        public static final /* enum */ Source ServerXMLConfig;
        private static final /* synthetic */ Source[] $VALUES;
        static final long serialVersionUID = 4604390229837791526L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static Source[] values() {
            return (Source[])$VALUES.clone();
        }

        public static Source valueOf(String name) {
            return Enum.valueOf(Source.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(Source.class);
            EarApplicationBnd = new Source();
            ServerXMLConfig = new Source();
            $VALUES = new Source[]{EarApplicationBnd, ServerXMLConfig};
        }
    }
}

