/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util;

import com.ibm.ejs.util.Bucket;
import com.ibm.ejs.util.Element;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class FastHashtable<K, V>
extends Dictionary<K, V> {
    protected final Bucket<K, V>[] buckets;
    protected int size = 0;

    public FastHashtable(int expectedEntries) {
        Bucket[] uncheckedBuckets = new Bucket[expectedEntries];
        this.buckets = uncheckedBuckets;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object getLock(K key) {
        return this.getBucketForKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(K key) {
        Bucket<K, V> bucket;
        Bucket<K, V> bucket2 = bucket = this.getBucketForKey(key);
        synchronized (bucket2) {
            Element<K, V> element = bucket.findByKey(key);
            return element != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        Bucket<Object, V> bucket;
        Object k = key;
        Bucket<Object, V> bucket2 = bucket = this.getBucketForKey(k);
        synchronized (bucket2) {
            Element<Object, V> element = bucket.findByKey(k);
            return element != null ? (V)element.ivObject : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        Object k = key;
        Bucket<Object, V> bucket = this.getBucketForKey(k);
        Element<Object, V> element = null;
        Object object = bucket;
        synchronized (object) {
            element = bucket.removeByKey(k);
        }
        if (element != null) {
            object = this;
            synchronized (object) {
                --this.size;
            }
            return element.ivObject;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V object) {
        Bucket<K, V> bucket;
        FastHashtable fastHashtable = this;
        synchronized (fastHashtable) {
            ++this.size;
        }
        Bucket<K, V> bucket2 = bucket = this.getBucketForKey(key);
        synchronized (bucket2) {
            Element<K, V> e = bucket.replaceByKey(key, object);
            return e != null ? (V)e.ivObject : null;
        }
    }

    @Override
    public final Enumeration<V> elements() {
        return new ObjectEnumerator();
    }

    @Override
    public final Enumeration<K> keys() {
        return new KeyEnumerator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        this.size = 0;
        for (Bucket<K, V> bucket : this.buckets) {
            if (bucket == null) continue;
            Bucket<K, V> bucket2 = bucket;
            synchronized (bucket2) {
                bucket.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Bucket<K, V> getBucketForKey(K key) {
        int bucket_index = (key.hashCode() & Integer.MAX_VALUE) % this.buckets.length;
        Bucket<K, V> thebucket = this.buckets[bucket_index];
        if (thebucket == null) {
            FastHashtable fastHashtable = this;
            synchronized (fastHashtable) {
                thebucket = this.buckets[bucket_index];
                if (thebucket == null) {
                    this.buckets[bucket_index] = thebucket = new Bucket();
                }
            }
        }
        return thebucket;
    }

    class KeyEnumerator
    extends ElementEnumerator<K> {
        KeyEnumerator() {
        }

        @Override
        public K nextElement() {
            return this.nextBucketElement().ivKey;
        }
    }

    class ObjectEnumerator
    extends ElementEnumerator<V> {
        ObjectEnumerator() {
        }

        @Override
        public V nextElement() {
            return this.nextBucketElement().ivObject;
        }
    }

    abstract class ElementEnumerator<T>
    implements Enumeration<T> {
        private int bucketIndex;
        private Element<K, V> ivCurrentBucketElement;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ElementEnumerator() {
            FastHashtable fastHashtable2 = FastHashtable.this;
            synchronized (fastHashtable2) {
                if (FastHashtable.this.size == 0) {
                    this.bucketIndex = FastHashtable.this.buckets.length;
                }
            }
        }

        @Override
        public boolean hasMoreElements() {
            if (this.ivCurrentBucketElement != null) {
                return true;
            }
            return this.findNextBucket();
        }

        public Element<K, V> nextBucketElement() {
            if (this.ivCurrentBucketElement == null && !this.findNextBucket()) {
                throw new NoSuchElementException();
            }
            Element nextElement = this.ivCurrentBucketElement;
            this.ivCurrentBucketElement = this.ivCurrentBucketElement.ivNext;
            return nextElement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean findNextBucket() {
            this.ivCurrentBucketElement = null;
            while (this.bucketIndex < FastHashtable.this.buckets.length) {
                Bucket bucket;
                if ((bucket = FastHashtable.this.buckets[this.bucketIndex++]) == null) continue;
                Bucket bucket2 = bucket;
                synchronized (bucket2) {
                    if (bucket.size() > 0) {
                        this.ivCurrentBucketElement = bucket.ivHead;
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

