/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.util.felix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.aries.subsystem.obr.internal.NamespaceTranslator;
import org.apache.aries.subsystem.util.felix.FelixProperty;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Property;

public class OsgiCapabilityAdapter
implements Capability {
    private final org.osgi.resource.Capability capability;

    public OsgiCapabilityAdapter(org.osgi.resource.Capability capability) {
        if (capability == null) {
            throw new NullPointerException("Missing required parameter: capability");
        }
        this.capability = capability;
    }

    public boolean equals(Object o) {
        return this.capability.equals(o);
    }

    public String getName() {
        return NamespaceTranslator.translate(this.capability.getNamespace());
    }

    public Property[] getProperties() {
        Map attributes = this.capability.getAttributes();
        ArrayList<FelixProperty> result = new ArrayList<FelixProperty>(attributes.size());
        for (Map.Entry<String, Object> entry : this.capability.getAttributes().entrySet()) {
            if (((String)entry.getKey()).equals(this.capability.getNamespace())) {
                result.add(new FelixProperty(this.getName(), entry.getValue()));
                continue;
            }
            result.add(new FelixProperty(entry));
        }
        return result.toArray(new Property[result.size()]);
    }

    public Map getPropertiesAsMap() {
        HashMap result = new HashMap(this.capability.getAttributes());
        result.put(this.getName(), result.get(this.capability.getNamespace()));
        return result;
    }

    public int hashCode() {
        return this.capability.hashCode();
    }
}

