/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.util.felix;

import java.util.Collections;
import java.util.Map;
import org.apache.aries.subsystem.obr.internal.AbstractCapability;
import org.apache.aries.subsystem.obr.internal.NamespaceTranslator;
import org.apache.felix.bundlerepository.Capability;
import org.osgi.resource.Resource;

public class FelixCapabilityAdapter
extends AbstractCapability {
    private final Capability capability;
    private final Resource resource;

    public FelixCapabilityAdapter(Capability capability, Resource resource) {
        if (capability == null) {
            throw new NullPointerException("Missing required parameter: capability");
        }
        this.capability = capability;
        this.resource = resource;
    }

    public Map<String, Object> getAttributes() {
        Map result = this.capability.getPropertiesAsMap();
        String namespace = this.getNamespace();
        if ("osgi.service".equals(namespace)) {
            result.put("objectClass", result.get("objectClass".toLowerCase()));
        } else if ("osgi.wiring.bundle".equals(namespace)) {
            result.put("osgi.wiring.bundle", result.get("symbolicname"));
        } else {
            result.put(namespace, result.get(this.capability.getName()));
        }
        return result;
    }

    public Map<String, String> getDirectives() {
        return Collections.emptyMap();
    }

    public String getNamespace() {
        return NamespaceTranslator.translate(this.capability.getName());
    }

    public Resource getResource() {
        return this.resource;
    }
}

