/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.osgi;

import com.ibm.ws.logging.RoutedMessage;
import com.ibm.ws.logging.WsTraceHandler;
import com.ibm.ws.logging.WsTraceRouter;
import com.ibm.ws.logging.internal.osgi.RecursionCounter;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class WsTraceRouterImpl
implements WsTraceRouter {
    private final ConcurrentMap<String, WsTraceHandler> wsTraceHandlerServices = new ConcurrentHashMap<String, WsTraceHandler>();
    static RecursionCounter counter = new RecursionCounter();
    private Queue<RoutedMessage> earlierMessages;

    protected WsTraceRouterImpl() {
    }

    public void setEarlierMessages(Queue<RoutedMessage> earlierMessages) {
        this.earlierMessages = earlierMessages;
    }

    protected void sendEarlierMessagesToNewwsTraceHandler(String wsTraceHandlerId) {
        if (this.earlierMessages == null) {
            return;
        }
        for (RoutedMessage earlierMessage : this.earlierMessages.toArray(new RoutedMessage[this.earlierMessages.size()])) {
            this.routeTo(earlierMessage, wsTraceHandlerId);
        }
    }

    public void setWsTraceHandler(String id, WsTraceHandler ref) {
        if (id != null && ref != null) {
            this.wsTraceHandlerServices.put(id, ref);
        }
    }

    public void unsetWsTraceHandler(String id, WsTraceHandler ref) {
        if (id != null) {
            if (ref == null) {
                this.wsTraceHandlerServices.remove(id);
            } else {
                this.wsTraceHandlerServices.remove(id, ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean route(RoutedMessage routedMessage) {
        boolean logNormally = true;
        try {
            if (counter.incrementCount() <= 1) {
                if (this.earlierMessages != null) {
                    this.earlierMessages.add(routedMessage);
                }
                Set<String> routeAllMsgsToTheseLogHandlers = this.wsTraceHandlerServices.keySet();
                logNormally = this.routeToAll(routedMessage, routeAllMsgsToTheseLogHandlers);
            }
        }
        finally {
            counter.decrementCount();
        }
        return logNormally;
    }

    protected boolean routeToAll(RoutedMessage routedMessage, Set<String> logHandlerIds) {
        for (String logHandlerId : logHandlerIds) {
            this.routeTo(routedMessage, logHandlerId);
        }
        return true;
    }

    protected void routeTo(RoutedMessage routedMessage, String logHandlerId) {
        WsTraceHandler wsTraceHandler = (WsTraceHandler)this.wsTraceHandlerServices.get(logHandlerId);
        if (wsTraceHandler != null) {
            wsTraceHandler.publish(routedMessage);
        }
    }
}

