/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.osgi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCConfigurator;
import com.ibm.ws.logging.internal.osgi.TrLogServiceImpl;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class LoggingConfigurationService
implements ManagedService {
    private static final TraceComponent tc = Tr.register(LoggingConfigurationService.class);
    public static final String RAS_TR_CFG_PID = "com.ibm.ws.logging";
    private ServiceRegistration<ManagedService> configRef = null;
    protected BundleContext context;
    private final boolean instrumentation;

    public LoggingConfigurationService(BundleContext context, boolean instrumentationActive) {
        this.context = context;
        this.instrumentation = instrumentationActive;
        this.configRef = context.registerService(ManagedService.class, (Object)this, LoggingConfigurationService.defaultProperties());
        TrConfigurator.setInstrumentation((boolean)this.instrumentation);
    }

    public void stop() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Stopping the Logging managed service", (Object[])new Object[0]);
        }
        this.configRef.unregister();
        this.configRef = null;
    }

    public synchronized void updated(Dictionary properties) throws ConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("properties updated " + properties), (Object[])new Object[0]);
        }
        if (properties == null) {
            return;
        }
        String eventConfig = (String)properties.get("publishOsgiEvents");
        TrLogServiceImpl.updatePublishEventConfig(eventConfig);
        HashMap newMap = null;
        if (properties instanceof Map) {
            newMap = (HashMap)((Object)properties);
        } else {
            newMap = new HashMap();
            Enumeration keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                newMap.put(key, properties.get(key));
            }
        }
        TrConfigurator.update(newMap);
        FFDCConfigurator.update(newMap);
    }

    protected static Hashtable<String, String> defaultProperties() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("service.pid", RAS_TR_CFG_PID);
        return ht;
    }
}

