/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.ssl.internal;

import com.ibm.websphere.channelfw.FlowType;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.channel.ssl.internal.SSLConnectionLink;
import com.ibm.ws.channel.ssl.internal.SSLHandshakeCompletedCallback;
import com.ibm.ws.channel.ssl.internal.SSLHandshakeIOCallback;
import com.ibm.ws.channel.ssl.internal.SSLLinkConfig;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferUtils;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.LinkedList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class SSLUtils {
    private static final TraceComponent tc = Tr.register(SSLUtils.class, (String)"SSLChannel", (String)"com.ibm.ws.channel.ssl.internal.resources.SSLChannelMessages");
    private static final String CLASS_NAME = SSLUtils.class.getCanonicalName();
    private static ByteBuffer emptyBuffer = ByteBuffer.allocate(1);

    public static void shutDownSSLEngine(SSLConnectionLink connLink, boolean isServer, boolean isConnected) {
        SSLEngine engine;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("shutDownSSLEngine: isServer: " + isServer + " isConnected: " + isConnected + " " + (Object)((Object)connLink)), (Object[])new Object[0]);
        }
        if ((engine = connLink.getSSLEngine()) != null) {
            if (isServer) {
                if (!engine.isInboundDone()) {
                    if (isConnected) {
                        engine.closeOutbound();
                        WsByteBuffer buffer = SSLUtils.allocateByteBuffer(engine.getSession().getPacketBufferSize(), false);
                        SSLUtils.flushCloseDown(engine, buffer, connLink);
                        buffer.release();
                    }
                    try {
                        engine.closeInbound();
                    }
                    catch (SSLException se) {}
                }
            } else {
                if (!engine.isOutboundDone()) {
                    engine.closeOutbound();
                }
                if (isConnected) {
                    WsByteBuffer buffer = SSLUtils.allocateByteBuffer(engine.getSession().getPacketBufferSize(), false);
                    SSLUtils.flushCloseDown(engine, buffer, connLink);
                    buffer.release();
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SSLEngine is null, must be shutdown already.", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"shutDownSSLEngine");
        }
    }

    private static void flushCloseDown(SSLEngine engine, WsByteBuffer outputBuffer, SSLConnectionLink xConnLink) {
        block20: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"flushCloseDown", (Object[])new Object[0]);
            }
            TCPWriteRequestContext deviceWriteInterface = xConnLink.getDeviceWriteInterface();
            int amountToYield = xConnLink.getChannel().getTimeoutValueInSSLClosingHandshake() * 10;
            int loopCounter = 0;
            try {
                SSLEngineResult.Status status = null;
                do {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("before wrap: \r\n\tbuf: " + SSLUtils.getBufferTraceInfo(outputBuffer)), (Object[])new Object[0]);
                    }
                    SSLEngineResult result = engine.wrap(emptyBuffer, outputBuffer.getWrappedByteBuffer());
                    int amountToWrite = result.bytesProduced();
                    long amountWritten = 0L;
                    if (0 < amountToWrite) {
                        outputBuffer.flip();
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("after wrap: \r\n\tbuf: " + SSLUtils.getBufferTraceInfo(outputBuffer) + "\r\n\tstatus=" + (Object)((Object)result.getStatus()) + " consumed=" + result.bytesConsumed() + " produced=" + result.bytesProduced()), (Object[])new Object[0]);
                    }
                    if (0 < amountToWrite) {
                        deviceWriteInterface.setBuffer(outputBuffer);
                        while (amountWritten < (long)amountToWrite) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)("want to write bytes: " + amountToWrite), (Object[])new Object[0]);
                            }
                            amountWritten = deviceWriteInterface.write(0L, 0);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)("bytes written: " + amountWritten), (Object[])new Object[0]);
                            }
                            if (xConnLink.getChannel().getstop0Called() || amountToYield > -1 && amountToYield <= loopCounter) break;
                            if (amountToYield > -1 && amountWritten == 0L) {
                                ++loopCounter;
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Did not write anything, sleeping thread before trying again.", (Object[])new Object[0]);
                                }
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException e) {}
                                continue;
                            }
                            if (amountWritten != 0L) continue;
                            Thread.yield();
                        }
                        outputBuffer.clear();
                    }
                    if (SSLEngineResult.Status.OK == (status = result.getStatus()) && 0 == amountToWrite || xConnLink.getChannel().getstop0Called()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Did not produce anything, quit now", (Object[])new Object[0]);
                            Tr.debug((TraceComponent)tc, (String)("status: " + (Object)((Object)status) + " amountToWrite: " + amountToWrite + " amountWritten: " + amountWritten + " stop0Called: " + xConnLink.getChannel().getstop0Called()), (Object[])new Object[0]);
                        }
                    } else {
                        if (amountToYield <= -1 || amountToYield > loopCounter) continue;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Closing handshake write timeout amount in SSL Channel met. Slept " + loopCounter + " times. Quit now."), (Object[])new Object[0]);
                        }
                    }
                    break;
                } while (status != SSLEngineResult.Status.CLOSED);
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block20;
                Tr.debug((TraceComponent)tc, (String)("Exception caught closing down, " + e), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"flushCloseDown");
        }
    }

    public static ByteBuffer[] getWrappedByteBuffers(WsByteBuffer[] wsbuffers) {
        ByteBuffer[] buffers = new ByteBuffer[wsbuffers.length];
        boolean foundNullBuffer = false;
        int i = 0;
        for (i = 0; i < wsbuffers.length; ++i) {
            if (wsbuffers[i] == null) {
                foundNullBuffer = true;
                break;
            }
            buffers[i] = wsbuffers[i].getWrappedByteBuffer();
        }
        if (foundNullBuffer) {
            ByteBuffer[] tempBuffers = buffers;
            buffers = new ByteBuffer[i];
            for (int j = 0; j < i; ++j) {
                buffers[j] = tempBuffers[j];
            }
        }
        return buffers;
    }

    public static void limitToCapacity(WsByteBuffer[] buffers) {
        if (buffers != null) {
            for (int i = 0; i < buffers.length; ++i) {
                if (buffers[i] == null) continue;
                buffers[i].limit(buffers[i].capacity());
            }
        }
    }

    public static void positionToLimit(WsByteBuffer[] buffers) {
        if (buffers != null) {
            for (int i = 0; i < buffers.length; ++i) {
                if (buffers[i] == null) continue;
                buffers[i].position(buffers[i].limit());
            }
        }
    }

    public static void flipBuffersToMark(WsByteBuffer[] buffers, int mark, int markBufferIndex) {
        WsByteBuffer buffer = null;
        if (buffers != null) {
            for (int i = 0; i < buffers.length; ++i) {
                buffer = buffers[i];
                if (buffer == null) continue;
                if (i == markBufferIndex && mark != 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("mark is " + mark), (Object[])new Object[0]);
                    }
                    buffer.limit(buffer.position());
                    buffer.position(mark);
                    continue;
                }
                buffer.flip();
            }
        }
    }

    public static void flipBuffers(WsByteBuffer[] buffers, int totalSize) {
        int size = 0;
        boolean overLimit = false;
        for (int i = 0; i < buffers.length && null != buffers[i]; ++i) {
            if (overLimit) {
                buffers[i].limit(buffers[i].position());
                continue;
            }
            buffers[i].flip();
            overLimit = (size += buffers[i].remaining()) >= totalSize;
        }
    }

    public static void copyBuffer(WsByteBuffer src, WsByteBuffer dst) {
        SSLUtils.copyBuffer(src, dst, src.remaining());
    }

    public static void copyBuffer(WsByteBuffer src, WsByteBuffer dst, int length) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("copyBuffer: length=" + length + "\r\n\tsrc: " + SSLUtils.getBufferTraceInfo(src) + "\r\n\tdst: " + SSLUtils.getBufferTraceInfo(dst)), (Object[])new Object[0]);
        }
        if (dst.remaining() < length || src.remaining() < length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"copyBuffer: Not enough space", (Object[])new Object[0]);
            }
            RuntimeException e = new RuntimeException("Attempt to copy source buffer to inadequate destination buffer");
            FFDCFilter.processException((Throwable)e, (String)CLASS_NAME, (String)"762", (Object)src);
            throw e;
        }
        if (src.hasArray()) {
            int newSrcPosition = src.position() + length;
            dst.put(src.array(), src.arrayOffset() + src.position(), length);
            src.position(newSrcPosition);
        } else {
            byte[] srcByteArray = new byte[length];
            src.get(srcByteArray, 0, length);
            dst.put(srcByteArray);
        }
    }

    public static WsByteBuffer allocateByteBuffer(int size, boolean allocateDirect) {
        WsByteBuffer newBuffer = null;
        newBuffer = allocateDirect ? ChannelFrameworkFactory.getBufferManager().allocateDirect(size) : ChannelFrameworkFactory.getBufferManager().allocate(size);
        newBuffer.limit(newBuffer.capacity());
        return newBuffer;
    }

    public static String getBufferTraceInfo(WsByteBuffer[] buffers) {
        if (null == buffers) {
            return "Null buffer array";
        }
        StringBuilder sb = new StringBuilder(32 + 64 * buffers.length);
        for (int i = 0; i < buffers.length; ++i) {
            sb.append("\r\n\t  Buffer [");
            sb.append(i);
            sb.append("]: ");
            SSLUtils.getBufferTraceInfo(sb, buffers[i]);
        }
        return sb.toString();
    }

    public static StringBuilder getBufferTraceInfo(StringBuilder src, WsByteBuffer buffer) {
        StringBuilder sb;
        StringBuilder stringBuilder = sb = null == src ? new StringBuilder(64) : src;
        if (null == buffer) {
            return sb.append("null");
        }
        sb.append("hc=").append(buffer.hashCode());
        sb.append(" pos=").append(buffer.position());
        sb.append(" lim=").append(buffer.limit());
        sb.append(" cap=").append(buffer.capacity());
        return sb;
    }

    public static String getBufferTraceInfo(WsByteBuffer buffer) {
        if (null == buffer) {
            return "null";
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append("hc=").append(buffer.hashCode());
        sb.append(" pos=").append(buffer.position());
        sb.append(" lim=").append(buffer.limit());
        sb.append(" cap=").append(buffer.capacity());
        return sb.toString();
    }

    public static String showBufferContents(WsByteBuffer[] buffers) {
        if (null == buffers || 0 == buffers.length) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < buffers.length; ++i) {
            sb.append("Buffer [");
            sb.append(i);
            if (null == buffers[i]) {
                sb.append("]: null\r\n");
                continue;
            }
            sb.append("]: ");
            sb.append(WsByteBufferUtils.asString((WsByteBuffer)buffers[i]));
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public static WsByteBuffer[] allocateByteBuffers(int requestedBufferSize, long totalDataSize, boolean allocateDirect, boolean enforceRequestedSize) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"allocateByteBuffers", (Object[])new Object[0]);
        }
        WsByteBuffer firstBuffer = SSLUtils.allocateByteBuffer(requestedBufferSize, allocateDirect);
        if (enforceRequestedSize) {
            firstBuffer.limit(requestedBufferSize);
        }
        int actualBufferSize = firstBuffer.limit();
        boolean enforce = enforceRequestedSize;
        if (enforce && actualBufferSize == requestedBufferSize) {
            enforce = false;
        }
        int numBuffersToAllocate = (int)(totalDataSize / (long)actualBufferSize);
        if (totalDataSize % (long)actualBufferSize > 0L) {
            ++numBuffersToAllocate;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("allocate: requestSize=" + requestedBufferSize + ", actualSize=" + actualBufferSize + ", totSize=" + totalDataSize + ", numBufs=" + numBuffersToAllocate), (Object[])new Object[0]);
        }
        WsByteBuffer[] newBuffers = new WsByteBuffer[numBuffersToAllocate];
        newBuffers[0] = firstBuffer;
        for (int i = 1; i < newBuffers.length; ++i) {
            newBuffers[i] = SSLUtils.allocateByteBuffer(requestedBufferSize, allocateDirect);
            if (!enforce) continue;
            newBuffers[i].limit(requestedBufferSize);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"allocateByteBuffers");
        }
        return newBuffers;
    }

    public static boolean anyPositionsNonZero(WsByteBuffer[] buffers) {
        if (buffers != null) {
            for (int i = 0; i < buffers.length; ++i) {
                if (buffers[i] == null || buffers[i].position() == 0) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isHandshaking(SSLEngine engine) {
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING != engine.getHandshakeStatus();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SSLEngineResult handleHandshake(SSLConnectionLink connLink, WsByteBuffer netBuffer, WsByteBuffer decryptedNetBuffer, WsByteBuffer encryptedAppBuffer, SSLEngineResult inResult, SSLHandshakeCompletedCallback handshakeCallback, boolean fromCallback) throws IOException, ReadOnlyBufferException {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        if (bTrace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("handleHandshake, engine=" + connLink.getSSLEngine().hashCode()), (Object[])new Object[0]);
        }
        SSLEngineResult result = inResult;
        SSLEngine engine = connLink.getSSLEngine();
        TCPReadRequestContext deviceReadContext = connLink.getDeviceReadInterface();
        TCPWriteRequestContext deviceWriteContext = connLink.getDeviceWriteInterface();
        JSSEHelper jsseHelper = connLink.getChannel().getJsseHelper();
        int amountToWrite = 0;
        boolean firstPass = true;
        SSLEngineResult.HandshakeStatus hsstatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
        SSLEngineResult.Status status = SSLEngineResult.Status.OK;
        if (null != result) {
            hsstatus = result.getHandshakeStatus();
            status = result.getStatus();
        }
        SSLEngineResult.Status initialStatus = status;
        if (fromCallback && status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"From callback, former status BUFFER_UNDERFLOW.", (Object[])new Object[0]);
            }
            netBuffer.limit(netBuffer.position());
            netBuffer.reset();
            hsstatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            status = SSLEngineResult.Status.OK;
        }
        while (true) {
            block51: {
                block55: {
                    long bytesIn;
                    block56: {
                        block45: {
                            block52: {
                                block53: {
                                    block54: {
                                        SSLHandshakeIOCallback readCallback;
                                        VirtualConnection vc;
                                        block47: {
                                            block48: {
                                                block49: {
                                                    block50: {
                                                        block46: {
                                                            if (!SSLUtils.isHandshaking(engine) && SSLEngineResult.Status.OK == status) break block45;
                                                            if (bTrace && tc.isDebugEnabled()) {
                                                                Tr.debug((TraceComponent)tc, (String)("status=" + (Object)((Object)status) + " HSstatus=" + (Object)((Object)hsstatus)), (Object[])new Object[0]);
                                                            }
                                                            if (hsstatus != SSLEngineResult.HandshakeStatus.FINISHED) break block46;
                                                            if (connLink.getChannel().isZOS) {
                                                                jsseHelper.setSSLPropertiesOnThread(null);
                                                            }
                                                            break block45;
                                                        }
                                                        if (hsstatus != SSLEngineResult.HandshakeStatus.NEED_WRAP) break block47;
                                                        if (bTrace && tc.isEventEnabled()) {
                                                            Tr.event((TraceComponent)tc, (String)("before wrap: \r\n\tencBuf: " + SSLUtils.getBufferTraceInfo(encryptedAppBuffer)), (Object[])new Object[0]);
                                                        }
                                                        if (0 < (amountToWrite = (result = engine.wrap(emptyBuffer, encryptedAppBuffer.getWrappedByteBuffer())).bytesProduced())) {
                                                            encryptedAppBuffer.flip();
                                                        }
                                                        hsstatus = result.getHandshakeStatus();
                                                        status = result.getStatus();
                                                        if (bTrace && tc.isEventEnabled()) {
                                                            Tr.event((TraceComponent)tc, (String)("after wrap: \r\n\tencBuf: " + SSLUtils.getBufferTraceInfo(encryptedAppBuffer) + "\r\n\tstatus=" + (Object)((Object)status) + " HSstatus=" + (Object)((Object)hsstatus) + " consumed=" + result.bytesConsumed() + " produced=" + result.bytesProduced()), (Object[])new Object[0]);
                                                        }
                                                        if (0 >= amountToWrite) break block48;
                                                        if (bTrace && tc.isEventEnabled()) {
                                                            Tr.event((TraceComponent)tc, (String)("Write bytes: " + amountToWrite), (Object[])new Object[0]);
                                                        }
                                                        deviceWriteContext.setBuffer(encryptedAppBuffer);
                                                        if (handshakeCallback == null) break block49;
                                                        SSLHandshakeIOCallback writeCallback = new SSLHandshakeIOCallback(connLink, netBuffer, decryptedNetBuffer, encryptedAppBuffer, result, handshakeCallback);
                                                        vc = deviceWriteContext.write((long)amountToWrite, (TCPWriteCompletedCallback)writeCallback, false, 0);
                                                        if (vc == null) break block50;
                                                        encryptedAppBuffer.clear();
                                                        break block47;
                                                    }
                                                    if (bTrace && tc.isDebugEnabled()) {
                                                        Tr.debug((TraceComponent)tc, (String)"Write is not done.  Callback will be used.", (Object[])new Object[0]);
                                                    }
                                                    result = null;
                                                    break block45;
                                                }
                                                deviceWriteContext.write((long)amountToWrite, 0);
                                                encryptedAppBuffer.clear();
                                                break block47;
                                            }
                                            encryptedAppBuffer.clear();
                                        }
                                        while (hsstatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                                            Runnable task = engine.getDelegatedTask();
                                            if (task != null) {
                                                task.run();
                                                hsstatus = engine.getHandshakeStatus();
                                                if (bTrace && tc.isDebugEnabled()) {
                                                    Tr.debug((TraceComponent)tc, (String)("After task, hsstatus=" + (Object)((Object)hsstatus)), (Object[])new Object[0]);
                                                }
                                            } else {
                                                if (bTrace && tc.isDebugEnabled()) {
                                                    Tr.debug((TraceComponent)tc, (String)"No task, setting status to HS_NEED_WRAP", (Object[])new Object[0]);
                                                }
                                                hsstatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                                            }
                                            result = new SSLEngineResult(status, hsstatus, 0, 0);
                                        }
                                        if (hsstatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP && status != SSLEngineResult.Status.BUFFER_UNDERFLOW) break block51;
                                        if (bTrace && tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)("Get ready to decrypt data, netBuf: " + SSLUtils.getBufferTraceInfo(netBuffer)), (Object[])new Object[0]);
                                        }
                                        if (netBuffer.limit() == netBuffer.capacity() && status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                                            int size = netBuffer.capacity() + engine.getSession().getPacketBufferSize();
                                            WsByteBuffer tempBuffer = SSLUtils.allocateByteBuffer(size, false);
                                            SSLUtils.copyBuffer(netBuffer, tempBuffer, netBuffer.remaining());
                                            tempBuffer.flip();
                                            netBuffer.release();
                                            netBuffer = tempBuffer;
                                            if (bTrace && tc.isDebugEnabled()) {
                                                Tr.debug((TraceComponent)tc, (String)("Had to grow the netBuf: " + SSLUtils.getBufferTraceInfo(netBuffer)), (Object[])new Object[0]);
                                            }
                                        }
                                        if (SSLEngineResult.Status.BUFFER_UNDERFLOW != status && (netBuffer.hasRemaining() || firstPass) && (netBuffer.remaining() != netBuffer.capacity() || firstPass && SSLEngineResult.Status.BUFFER_UNDERFLOW == initialStatus)) break block52;
                                        deviceReadContext.setBuffer(netBuffer);
                                        if (!netBuffer.hasRemaining() || netBuffer.remaining() == netBuffer.capacity()) {
                                            netBuffer.clear();
                                            netBuffer.mark();
                                            if (bTrace && tc.isDebugEnabled()) {
                                                Tr.debug((TraceComponent)tc, (String)"Nothing was in the buffer", (Object[])new Object[0]);
                                            }
                                        } else {
                                            netBuffer.mark();
                                            netBuffer.position(netBuffer.limit());
                                            netBuffer.limit(netBuffer.capacity());
                                            if (bTrace && tc.isDebugEnabled()) {
                                                Tr.debug((TraceComponent)tc, (String)("Existing data in netBuf: " + SSLUtils.getBufferTraceInfo(netBuffer)), (Object[])new Object[0]);
                                            }
                                        }
                                        if (handshakeCallback == null) break block53;
                                        if (bTrace && tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"Do async read", (Object[])new Object[0]);
                                        }
                                        if ((vc = deviceReadContext.read(1L, (TCPReadCompletedCallback)(readCallback = new SSLHandshakeIOCallback(connLink, netBuffer, decryptedNetBuffer, encryptedAppBuffer, result, handshakeCallback)), false, 0)) == null) break block54;
                                        if (bTrace && tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"Read already done.  No callback necessary.", (Object[])new Object[0]);
                                        }
                                        netBuffer.limit(netBuffer.position());
                                        netBuffer.reset();
                                        break block55;
                                    }
                                    if (bTrace && tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"Read is not done.  Callback will be used.", (Object[])new Object[0]);
                                    }
                                    result = null;
                                    break block45;
                                }
                                if (bTrace && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Do sync read", (Object[])new Object[0]);
                                }
                                bytesIn = 0L;
                                break block56;
                            }
                            if (!netBuffer.hasRemaining() && firstPass) {
                                if (bTrace && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Callback came back with data that needs to be flipped.", (Object[])new Object[0]);
                                }
                                netBuffer.flip();
                            }
                            if (bTrace && tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)("Data already in netBuf: " + SSLUtils.getBufferTraceInfo(netBuffer)), (Object[])new Object[0]);
                            }
                            break block55;
                        }
                        if (bTrace && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("after handshake loop, status=" + (Object)((Object)status) + " HSstatus=" + (Object)((Object)hsstatus) + ", fromCallback=" + fromCallback + ", engine=" + engine.hashCode() + "\r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(netBuffer) + "\r\n\tdecBuf: " + SSLUtils.getBufferTraceInfo(decryptedNetBuffer)), (Object[])new Object[0]);
                        }
                        if (fromCallback && null != result && null != handshakeCallback) {
                            handshakeCallback.complete(result);
                            result = null;
                        }
                        if (bTrace && tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"handleHandshake");
                        }
                        return result;
                    }
                    while (bytesIn == 0L) {
                        try {
                            bytesIn = deviceReadContext.read(1L, 0);
                            if (!bTrace || !tc.isEventEnabled()) continue;
                            Tr.event((TraceComponent)tc, (String)("Read bytes: " + bytesIn), (Object[])new Object[0]);
                        }
                        catch (IOException x) {
                            String s = "IOException receiving data during SSL Handshake. One possible cause is that authentication may not be configured correctly";
                            Exception nx = new Exception(s, x);
                            FFDCFilter.processException((Throwable)nx, (String)CLASS_NAME, (String)"882");
                            throw x;
                        }
                    }
                    netBuffer.limit(netBuffer.position());
                    netBuffer.reset();
                }
                if (0 != netBuffer.position() && netBuffer.limit() == netBuffer.capacity() && firstPass && SSLEngineResult.Status.BUFFER_UNDERFLOW != initialStatus) {
                    netBuffer.limit(netBuffer.position());
                    netBuffer.reset();
                }
                if (bTrace && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("before unwrap: \r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(netBuffer) + "\r\n\tdecBuf: " + SSLUtils.getBufferTraceInfo(decryptedNetBuffer)), (Object[])new Object[0]);
                }
                result = engine.unwrap(netBuffer.getWrappedByteBuffer(), decryptedNetBuffer.getWrappedByteBuffer());
                hsstatus = result.getHandshakeStatus();
                status = result.getStatus();
                if (bTrace && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("after unwrap: \r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(netBuffer) + "\r\n\tdecBuf: " + SSLUtils.getBufferTraceInfo(decryptedNetBuffer) + "\r\n\tstatus=" + (Object)((Object)status) + " HSstatus=" + (Object)((Object)hsstatus) + " consumed=" + result.bytesConsumed() + " produced=" + result.bytesProduced()), (Object[])new Object[0]);
                }
                if (netBuffer.remaining() == 0) {
                    netBuffer.clear();
                }
            }
            if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("BUFFER_OVERFLOW occured during handshake: " + (Object)((Object)hsstatus)), (Object[])new Object[0]);
                }
                throw new SSLException("BUFFER_OVERFLOW occured during handshake: " + (Object)((Object)hsstatus));
            }
            if (status == SSLEngineResult.Status.CLOSED) {
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Handshake terminated SSL engine: " + (Object)((Object)hsstatus)), (Object[])new Object[0]);
                }
                throw new SSLException("Handshake terminated SSL engine: " + (Object)((Object)hsstatus));
            }
            firstPass = false;
        }
    }

    public static void handleHandshake(SSLEngine clientEngine, SSLEngine serverEngine) throws SSLException {
        WsByteBuffer encryptedAppBuffer1;
        WsByteBuffer decryptedNetBuffer1;
        WsByteBuffer netBuffer1;
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        if (bTrace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleHandshake", (Object[])new Object[0]);
        }
        if (clientEngine == null || serverEngine == null) {
            throw new SSLException("Null engine found: engine1=" + clientEngine + ", engine2=" + serverEngine);
        }
        SSLEngine currentEngine = clientEngine;
        SSLEngine otherEngine = serverEngine;
        if (bTrace && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Parameters: engine1=" + currentEngine.hashCode() + ", engine2=" + otherEngine.hashCode()), (Object[])new Object[0]);
        }
        WsByteBuffer netBuffer = netBuffer1 = SSLUtils.allocateByteBuffer(currentEngine.getSession().getPacketBufferSize(), false);
        WsByteBuffer decryptedNetBuffer = decryptedNetBuffer1 = SSLUtils.allocateByteBuffer(currentEngine.getSession().getApplicationBufferSize(), false);
        WsByteBuffer encryptedAppBuffer = encryptedAppBuffer1 = SSLUtils.allocateByteBuffer(currentEngine.getSession().getPacketBufferSize(), false);
        Runnable task = null;
        SSLEngine tempEngine = null;
        SSLEngineResult.HandshakeStatus tempStatus = null;
        SSLEngineResult.HandshakeStatus currentStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
        SSLEngineResult.HandshakeStatus otherStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        if (bTrace && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("current engine= " + currentEngine.hashCode() + ", status=" + (Object)((Object)currentStatus)), (Object[])new Object[0]);
        }
        while (SSLUtils.isHandshaking(currentEngine) || SSLUtils.isHandshaking(otherEngine) || currentStatus != SSLEngineResult.HandshakeStatus.FINISHED || otherStatus != SSLEngineResult.HandshakeStatus.FINISHED) {
            SSLEngineResult result;
            if (currentStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && encryptedAppBuffer.limit() == encryptedAppBuffer.capacity()) {
                if (bTrace && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("before wrap: encBuf: " + SSLUtils.getBufferTraceInfo(encryptedAppBuffer)), (Object[])new Object[0]);
                }
                if (0 < (result = currentEngine.wrap(emptyBuffer, encryptedAppBuffer.getWrappedByteBuffer())).bytesProduced()) {
                    encryptedAppBuffer.flip();
                }
                currentStatus = result.getHandshakeStatus();
                if (bTrace && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("after wrap: encBuf: " + SSLUtils.getBufferTraceInfo(encryptedAppBuffer) + "\r\n\tstatus=" + (Object)((Object)result.getStatus()) + " HSstatus=" + (Object)((Object)currentStatus) + " consumed=" + result.bytesConsumed() + " produced=" + result.bytesProduced()), (Object[])new Object[0]);
                }
            } else if ((currentStatus == SSLEngineResult.HandshakeStatus.FINISHED || currentStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) && netBuffer.limit() != netBuffer.capacity()) {
                if (bTrace && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("before unwrap: \r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(netBuffer) + "\r\n\tdecBuf: " + SSLUtils.getBufferTraceInfo(decryptedNetBuffer)), (Object[])new Object[0]);
                }
                result = currentEngine.unwrap(netBuffer.getWrappedByteBuffer(), decryptedNetBuffer.getWrappedByteBuffer());
                currentStatus = result.getHandshakeStatus();
                if (bTrace && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("after unwrap: \r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(netBuffer) + "\r\n\tdecBuf: " + SSLUtils.getBufferTraceInfo(decryptedNetBuffer) + "\r\n\tstatus=" + (Object)((Object)result.getStatus()) + " HSstatus=" + (Object)((Object)currentStatus) + " consumed=" + result.bytesConsumed() + " produced=" + result.bytesProduced()), (Object[])new Object[0]);
                }
                if (netBuffer.remaining() == 0) {
                    netBuffer.clear();
                }
            }
            if (currentStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                while (currentStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    task = currentEngine.getDelegatedTask();
                    if (task != null) {
                        if (bTrace && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Run task", (Object[])new Object[0]);
                        }
                        task.run();
                        currentStatus = currentEngine.getHandshakeStatus();
                        if (!bTrace || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("After task, handshake status=" + (Object)((Object)currentStatus)), (Object[])new Object[0]);
                        continue;
                    }
                    if (bTrace && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"No task, setting status to HS_NEED_WRAP", (Object[])new Object[0]);
                    }
                    currentStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                }
                if (currentStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) continue;
            }
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Switching engines", (Object[])new Object[0]);
            }
            netBuffer = encryptedAppBuffer;
            tempEngine = currentEngine;
            currentEngine = otherEngine;
            otherEngine = tempEngine;
            tempStatus = currentStatus;
            currentStatus = otherStatus;
            otherStatus = tempStatus;
            if (!bTrace || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("current engine= " + currentEngine.hashCode() + ", status=" + (Object)((Object)currentStatus)), (Object[])new Object[0]);
        }
        if (bTrace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleHandshake");
        }
    }

    public static SSLEngine getOutboundSSLEngine(SSLContext context, SSLLinkConfig config, String host, int port) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getOutboundSSLEngine, host=" + host + ", port=" + port), (Object[])new Object[0]);
        }
        SSLEngine engine = context.createSSLEngine(host, port);
        SSLUtils.configureEngine(engine, FlowType.OUTBOUND, config);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getOutboundSSLEngine, hc=" + engine.hashCode()));
        }
        return engine;
    }

    public static SSLEngine getSSLEngine(SSLContext context, FlowType type, SSLLinkConfig config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLEngine", (Object[])new Object[0]);
        }
        SSLEngine engine = context.createSSLEngine();
        SSLUtils.configureEngine(engine, type, config);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSSLEngine, hc=" + engine.hashCode()));
        }
        return engine;
    }

    private static void configureEngine(SSLEngine engine, FlowType type, SSLLinkConfig config) {
        block8: {
            engine.setEnabledCipherSuites(config.getEnabledCipherSuites(engine));
            if (type == FlowType.INBOUND) {
                engine.setUseClientMode(false);
                boolean flag = config.getBooleanProperty("com.ibm.ssl.clientAuthentication");
                engine.setNeedClientAuth(flag);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Client auth needed is " + engine.getNeedClientAuth()), (Object[])new Object[0]);
                }
                if (!flag) {
                    flag = config.getBooleanProperty("com.ibm.ssl.clientAuthenticationSupported");
                    engine.setWantClientAuth(flag);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Client auth supported is " + engine.getWantClientAuth()), (Object[])new Object[0]);
                    }
                }
            } else {
                engine.setUseClientMode(true);
            }
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Calling beginHandshake on engine", (Object[])new Object[0]);
                }
                engine.beginHandshake();
            }
            catch (SSLException se) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block8;
                Tr.event((TraceComponent)tc, (String)("Error while starting handshake; " + se), (Object[])new Object[0]);
            }
        }
    }

    public static int[] adjustBuffersForJSSE(WsByteBuffer[] buffers, int maxBufferSize) {
        int[] limitInfo = null;
        int dataAmount = 0;
        for (int i = 0; i < buffers.length && null != buffers[i]; ++i) {
            if ((dataAmount += buffers[i].remaining()) > maxBufferSize) {
                int savedLimit = buffers[i].limit();
                limitInfo = new int[]{i, savedLimit};
                int overFlow = dataAmount - maxBufferSize;
                buffers[i].limit(savedLimit - overFlow);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("adjustBuffersForJSSE: buffer [" + i + "] from " + savedLimit + " to " + buffers[i].limit()), (Object[])new Object[0]);
                break;
            }
            if (dataAmount == maxBufferSize) break;
        }
        return limitInfo;
    }

    public static int adjustBufferForJSSE(WsByteBuffer buffer, int maxBufferSize) {
        int size;
        int limit = -1;
        if (null != buffer && maxBufferSize < (size = buffer.remaining())) {
            limit = buffer.limit();
            int overFlow = size - maxBufferSize;
            buffer.limit(limit - overFlow);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("adjustBufferForJSSE: from " + limit + " to " + buffer.limit()), (Object[])new Object[0]);
            }
        }
        return limit;
    }

    public static void resetBuffersAfterJSSE(WsByteBuffer[] buffers, int[] limitInfo) {
        WsByteBuffer buffer;
        if (limitInfo == null) {
            return;
        }
        int bufferIndex = limitInfo[0];
        int bufferLimit = limitInfo[1];
        if (buffers.length > bufferIndex && (buffer = buffers[bufferIndex]) != null && buffer.capacity() >= bufferLimit) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("resetBuffersAfterJSSE: buffer [" + bufferIndex + "] from " + buffer.limit() + " to " + bufferLimit), (Object[])new Object[0]);
            }
            buffer.limit(bufferLimit);
        }
    }

    public static void getBufferLimits(WsByteBuffer[] buffers, int[] limits) {
        if (buffers != null && limits != null) {
            for (int i = 0; i < buffers.length && i < limits.length; ++i) {
                if (buffers[i] != null) {
                    limits[i] = buffers[i].limit();
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("getBufferLimits: buffer[" + i + "] limit of " + limits[i]), (Object[])new Object[0]);
                    continue;
                }
                limits[i] = 0;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("getBufferLimits: null buffer[" + i + "] limit of " + limits[i]), (Object[])new Object[0]);
            }
        }
    }

    public static void setBufferLimits(WsByteBuffer[] buffers, int[] limits) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setBufferLimits", (Object[])new Object[0]);
        }
        if (buffers != null && limits != null) {
            int bufferCapacity = 0;
            int limit = 0;
            for (int i = 0; i < buffers.length && i < limits.length; ++i) {
                if (buffers[i] == null) continue;
                bufferCapacity = buffers[i].capacity();
                limit = limits[i];
                if (buffers[i].limit() == limit) continue;
                if (bufferCapacity >= limit) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Buffer [" + i + "] being updated from " + buffers[i].limit() + " to " + limit), (Object[])new Object[0]);
                    }
                    buffers[i].limit(limit);
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Buffer [" + i + "] has capacity " + bufferCapacity + " less than passed in limit " + limit), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setBufferLimits");
        }
    }

    public static int lengthOf(WsByteBuffer[] src, int startIndex) {
        int length = 0;
        if (null != src) {
            for (int i = startIndex; i < src.length && null != src[i]; ++i) {
                length += src[i].remaining();
            }
        }
        return length;
    }

    public static WsByteBuffer[] compressBuffers(WsByteBuffer[] src, boolean releaseEmpty) {
        LinkedList<WsByteBuffer> output = new LinkedList<WsByteBuffer>();
        boolean first = true;
        int size = 0;
        for (int i = 0; i < src.length; ++i) {
            if (null == src[i]) continue;
            if (0 < src[i].remaining()) {
                if (first) {
                    output.add(src[i].slice());
                    src[i].release();
                    first = false;
                } else {
                    output.add(src[i]);
                }
                ++size;
                continue;
            }
            if (!releaseEmpty) continue;
            src[i].release();
        }
        if (0 == size) {
            return null;
        }
        WsByteBuffer[] data = new WsByteBuffer[size];
        output.toArray(data);
        return data;
    }

    static {
        emptyBuffer.limit(0);
    }
}

