/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.config;

import com.ibm.tx.config.ConfigurationProvider;
import com.ibm.tx.util.alarm.AlarmManager;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ConfigurationProviderManager {
    private static ConfigurationProvider _provider;

    public static void stop(boolean immediate) {
        if (_provider != null) {
            AlarmManager am = _provider.getAlarmManager();
            if (immediate) {
                am.shutdownNow();
            } else {
                am.shutdown();
            }
            _provider = null;
        }
    }

    public static synchronized void start() {
        Class<?> configProviderClass;
        String property = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("com.ibm.tx.config.ConfigurationProviderClassName");
            }
        });
        if (_provider == null && property != null) {
            try {
                configProviderClass = Class.forName(property);
                _provider = (ConfigurationProvider)configProviderClass.newInstance();
            }
            catch (Throwable t) {
                _provider = null;
                t.printStackTrace();
            }
        }
        if (_provider == null) {
            try {
                configProviderClass = Class.forName("com.ibm.tx.jta.config.DefaultConfigurationProvider");
                _provider = (ConfigurationProvider)configProviderClass.newInstance();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static ConfigurationProvider getConfigurationProvider() {
        return _provider;
    }

    public static void setConfigurationProvider(ConfigurationProvider p) {
        _provider = p;
    }

    static {
        ConfigurationProviderManager.start();
    }
}

