/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.classsource.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.anno.classsource.internal.ClassSourceImpl;
import com.ibm.ws.anno.classsource.internal.ClassSourceImpl_Factory;
import com.ibm.ws.anno.util.internal.UtilImpl_FileUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.classsource.ClassSource;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.classsource.ClassSource_Exception;
import com.ibm.wsspi.anno.classsource.ClassSource_MappedJar;
import com.ibm.wsspi.anno.classsource.ClassSource_ScanCounts;
import com.ibm.wsspi.anno.classsource.ClassSource_Streamer;
import com.ibm.wsspi.anno.util.Util_InternMap;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClassSourceImpl_MappedJar
extends ClassSourceImpl
implements ClassSource,
ClassSource_MappedJar {
    public static final String CLASS_NAME = ClassSourceImpl_MappedJar.class.getName();
    private static final TraceComponent tc = Tr.register(ClassSourceImpl_MappedJar.class);
    protected int opens;
    protected final String jarPath;
    protected JarFile jarFile;
    static final long serialVersionUID = -7193021702749564993L;

    public ClassSourceImpl_MappedJar(ClassSourceImpl_Factory factory, Util_InternMap internMap, String name, String jarPath) throws ClassSource_Exception {
        super(factory, internMap, name, jarPath);
        this.jarPath = jarPath;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)this.hashText, (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public void open() throws ClassSource_Exception {
        String methodName = "open";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{MessageFormat.format("[ {0} ] State [ {1} ]", this.getHashText(), this.opens)});
        }
        if (this.opens < 0 || this.opens == 0 && this.jarFile != null || this.opens > 0 && this.jarFile == null) {
            Tr.warning((TraceComponent)tc, (String)"ANNO_CLASSSOURCE_JAR_STATE_BAD", (Object[])new Object[]{this.getHashText(), this.getJarPath(), this.opens});
            String eMsg = "[ " + this.getHashText() + " ]" + " Failed to open [ " + this.getJarPath() + " ]" + " Count of opens [ " + this.opens + " ]" + " Jar state [ " + this.jarFile + " ]";
            throw this.getFactory().newClassSourceException(eMsg);
        }
        ++this.opens;
        if (this.jarFile == null) {
            try {
                this.jarFile = UtilImpl_FileUtils.createJarFile(this.jarPath);
            }
            catch (IOException eMsg) {
                void e;
                FFDCFilter.processException((Throwable)eMsg, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedJar", (String)"95", (Object)this, (Object[])new Object[0]);
                Tr.warning((TraceComponent)tc, (String)"ANNO_CLASSSOURCE_OPEN4_EXCEPTION", (Object[])new Object[]{this.getHashText(), this.jarPath});
                String eMsg2 = "[ " + this.getHashText() + " ] Failed to open [ " + this.jarPath + " ]";
                throw this.getFactory().wrapIntoClassSourceException(CLASS_NAME, methodName, eMsg2, (Throwable)e);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)MessageFormat.format("[ {0} ] RETURN (new open)", this.getHashText()));
            }
        } else if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)MessageFormat.format("[ {0} ] RETURN (already open)", this.getHashText()));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Trivial
    @ManualTrace
    public void close() throws ClassSource_Exception {
        String methodName = "close";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{this.getHashText()});
        }
        JarFile useJarFile = this.getJarFile();
        if (this.opens < 0 || this.opens == 0 && useJarFile != null || this.opens > 0 && useJarFile == null) {
            Tr.warning((TraceComponent)tc, (String)"ANNO_CLASSSOURCE_JAR_STATE_BAD", (Object[])new Object[]{this.getHashText(), this.getJarPath(), this.opens});
            this.opens = 0;
            useJarFile = this.clearJarFile();
            if (useJarFile != null) {
                try {
                    useJarFile.close();
                }
                catch (IOException iOException) {
                    void e;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedJar", (String)"136", (Object)this, (Object[])new Object[0]);
                    String eMsg = "[ " + this.getHashText() + " ] Failed to close [ " + this.getJarPath() + " ]";
                    throw this.getFactory().wrapIntoClassSourceException(CLASS_NAME, methodName, eMsg, (Throwable)e);
                }
            }
            String eMsg = "[ " + this.getHashText() + " ] Close with open count [ " + this.opens + " ]";
            throw this.getFactory().newClassSourceException(eMsg);
        }
        if (--this.opens == 0) {
            useJarFile = this.clearJarFile();
            try {
                useJarFile.close();
            }
            catch (IOException eMsg) {
                void e;
                FFDCFilter.processException((Throwable)eMsg, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedJar", (String)"156", (Object)this, (Object[])new Object[0]);
                String eMsg2 = "[ " + this.getHashText() + " ] Failed to close [ " + this.getJarPath() + " ]";
                throw this.getFactory().wrapIntoClassSourceException(CLASS_NAME, methodName, eMsg2, (Throwable)e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)this.getHashText());
        }
    }

    @Override
    public String getJarPath() {
        return this.jarPath;
    }

    public JarFile getJarFile() {
        return this.jarFile;
    }

    protected JarFile clearJarFile() {
        JarFile useJarFile = this.jarFile;
        this.jarFile = null;
        return useJarFile;
    }

    @Override
    public int getResult(ClassSource_ScanCounts.ResultField resultField) {
        return this.scanCounts.getResult(resultField);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void scanClasses(ClassSource_Streamer streamer, Set<String> i_seedClassNames, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] ENTER", this.getHashText()), (Object[])new Object[0]);
        }
        int initialClasses = i_seedClassNames.size();
        JarFile useJarFile = this.getJarFile();
        Enumeration<JarEntry> jarEntries = useJarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry nextEntry = jarEntries.nextElement();
            String nextEntryName = nextEntry.getName();
            if (this.isDirectoryResource(nextEntryName)) {
                this.incrementResourceExclusionCount();
                this.markResult(ClassSource_ScanCounts.ResultField.CONTAINER);
                this.markResult(ClassSource_ScanCounts.ResultField.NON_ROOT_CONTAINER);
            } else {
                if (!this.isClassResource(nextEntryName)) {
                    this.incrementResourceExclusionCount();
                    this.markResult(ClassSource_ScanCounts.ResultField.NON_CLASS);
                } else {
                    String nextClassName = this.getClassNameFromResourceName(nextEntryName);
                    String i_nextClassName = this.internClassName(nextClassName);
                    boolean didAdd = this.i_maybeAdd(i_nextClassName, i_seedClassNames);
                    if (!didAdd) {
                        this.incrementClassExclusionCount();
                        this.markResult(ClassSource_ScanCounts.ResultField.DUPLICATE_CLASS);
                    } else {
                        boolean didProcess;
                        this.incrementClassInclusionCount();
                        try {
                            didProcess = this.process(streamer, nextClassName, nextEntryName, scanPolicy);
                        }
                        catch (ClassSource_Exception classSource_Exception) {
                            void e;
                            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedJar", (String)"261", (Object)this, (Object[])new Object[]{streamer, i_seedClassNames, scanPolicy});
                            didProcess = false;
                            Tr.warning((TraceComponent)tc, (String)"ANNO_TARGETS_SCAN_EXCEPTION", (Object[])new Object[]{e});
                        }
                        if (didProcess) {
                            this.markResult(ClassSource_ScanCounts.ResultField.PROCESSED_CLASS);
                        } else {
                            this.markResult(ClassSource_ScanCounts.ResultField.UNPROCESSED_CLASS);
                        }
                    }
                    this.markResult(ClassSource_ScanCounts.ResultField.CLASS);
                }
                this.markResult(ClassSource_ScanCounts.ResultField.NON_CONTAINER);
            }
            this.markResult(ClassSource_ScanCounts.ResultField.ENTRY);
        }
        int finalClasses = i_seedClassNames.size();
        if (tc.isDebugEnabled()) {
            Object[] logParms = new Object[]{this.getHashText(), null, null};
            logParms[1] = finalClasses - initialClasses;
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] RETURN [ {1} ] Added classes", logParms), (Object[])new Object[0]);
            for (ClassSource_ScanCounts.ResultField resultField : ClassSource_ScanCounts.ResultField.values()) {
                int nextResult = this.getResult(resultField);
                String nextResultTag = resultField.getTag();
                logParms[1] = nextResult;
                logParms[2] = nextResultTag;
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ]  [ {1} ] {2}", logParms), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean process(ClassSource_Streamer streamer, String className, String resourceName, ClassSource_Aggregate.ScanPolicy scanPolicy) throws ClassSource_Exception {
        if (streamer == null) {
            return true;
        }
        if (!streamer.doProcess(className, scanPolicy)) {
            return false;
        }
        InputStream inputStream = this.openResourceStream(className, resourceName);
        try {
            streamer.process(this.getCanonicalName(), className, inputStream, scanPolicy);
        }
        finally {
            this.closeResourceStream(className, resourceName, inputStream);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InputStream openResourceStream(String className, String resourceName) throws ClassSource_Exception {
        InputStream result;
        String methodName = "openResourceStream";
        JarFile useJarFile = this.getJarFile();
        JarEntry jarEntry = useJarFile.getJarEntry(resourceName);
        if (jarEntry == null) {
            return null;
        }
        try {
            result = useJarFile.getInputStream(jarEntry);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedJar", (String)"355", (Object)this, (Object[])new Object[]{className, resourceName});
            String eMsg = "[ " + this.getHashText() + " ]" + " Failed to open [ " + resourceName + " ]" + " for class [ " + className + " ]" + " in [ " + this.getJarPath() + " ]";
            throw this.getFactory().wrapIntoClassSourceException(CLASS_NAME, methodName, eMsg, (Throwable)e);
        }
        return result;
    }

    @Override
    public void closeResourceStream(String className, String resourceName, InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedJar", (String)"374", (Object)this, (Object[])new Object[]{className, resourceName, inputStream});
            Tr.warning((TraceComponent)tc, (String)"ANNO_CLASSSOURCE_CLOSE6_EXCEPTION", (Object[])new Object[]{this.getHashText(), resourceName, className, this.getJarPath()});
        }
    }

    @Override
    public void log(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("Class Source [ {0} ]", this.getHashText()), (Object[])new Object[0]);
        this.logCounts(logger);
    }
}

