/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.transport.model;

import com.ibm.ws.repository.common.enums.LicenseType;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.common.enums.State;
import com.ibm.ws.repository.transport.client.JSONIgnore;
import com.ibm.ws.repository.transport.model.AbstractJSON;
import com.ibm.ws.repository.transport.model.AssetInformation;
import com.ibm.ws.repository.transport.model.Attachment;
import com.ibm.ws.repository.transport.model.Feedback;
import com.ibm.ws.repository.transport.model.JSONIncludeForFile;
import com.ibm.ws.repository.transport.model.Provider;
import com.ibm.ws.repository.transport.model.PublishedInformation;
import com.ibm.ws.repository.transport.model.Reviewed;
import com.ibm.ws.repository.transport.model.User;
import com.ibm.ws.repository.transport.model.WlpInformation;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class Asset
extends AbstractJSON {
    private String _id = null;
    @JSONIncludeForFile
    private String name = null;
    @JSONIncludeForFile
    private String description = null;
    @JSONIncludeForFile
    private String shortDescription = null;
    @JSONIncludeForFile
    private ResourceType type = null;
    private Calendar createdOn = null;
    private User createdBy = null;
    private Calendar lastUpdatedOn = null;
    private List<Attachment> attachments = null;
    @JSONIncludeForFile
    private Provider provider = null;
    private Featured featured = null;
    private State state = null;
    private Feedback feedback = null;
    private AssetInformation information = null;
    @JSONIncludeForFile
    private LicenseType licenseType = null;
    private String marketplaceId = null;
    private String marketplaceName = null;
    private String inMyStore = null;
    private PublishedInformation published = null;
    private Privacy privacy;
    @JSONIncludeForFile
    private String version = null;
    @JSONIncludeForFile
    private WlpInformation wlpInformation;
    private Reviewed reviewed;
    @JSONIncludeForFile
    private String licenseId;

    public String get_id() {
        return this._id;
    }

    public void set_id(String _id) {
        this._id = _id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public ResourceType getType() {
        return this.type;
    }

    public void setType(ResourceType type) {
        this.type = type;
    }

    public Calendar getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Calendar createdOn) {
        this.createdOn = createdOn;
    }

    public User getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public Calendar getLastUpdatedOn() {
        return this.lastUpdatedOn;
    }

    public void setLastUpdatedOn(Calendar lastUpdatedOn) {
        this.lastUpdatedOn = lastUpdatedOn;
    }

    @JSONIgnore
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void addAttachement(Attachment attachment) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
        this.attachments.add(attachment);
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = null;
        if (attachments != null) {
            for (Attachment attachment : attachments) {
                this.addAttachement(attachment);
            }
        }
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public Featured getFeatured() {
        return this.featured;
    }

    public void setFeatured(Featured featured) {
        this.featured = featured;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Feedback getFeedback() {
        return this.feedback;
    }

    public void setFeedback(Feedback feedback) {
        this.feedback = feedback;
    }

    public AssetInformation getInformation() {
        return this.information;
    }

    public void setInformation(AssetInformation information) {
        this.information = information;
    }

    public void setLicenseType(LicenseType lt) {
        this.licenseType = lt;
    }

    public LicenseType getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseId(String s) {
        this.licenseId = s;
    }

    public String getLicenseId() {
        return this.licenseId;
    }

    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public String getMarketplaceName() {
        return this.marketplaceName;
    }

    public void setMarketplaceName(String marketplaceName) {
        this.marketplaceName = marketplaceName;
    }

    public String getInMyStore() {
        return this.inMyStore;
    }

    public void setInMyStore(String inMyStore) {
        this.inMyStore = inMyStore;
    }

    public PublishedInformation getPublished() {
        return this.published;
    }

    public void setPublished(PublishedInformation published) {
        this.published = published;
    }

    public Privacy getPrivacy() {
        return this.privacy;
    }

    public void setPrivacy(Privacy privacy) {
        this.privacy = privacy;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setWlpInformation(WlpInformation wlpInformation) {
        this.wlpInformation = wlpInformation;
    }

    public WlpInformation getWlpInformation() {
        return this.wlpInformation;
    }

    public Reviewed getReviewed() {
        return this.reviewed;
    }

    public void setReviewed(Reviewed reviewed) {
        this.reviewed = reviewed;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.licenseType == null ? 0 : this.licenseType.hashCode());
        result = 31 * result + (this.provider == null ? 0 : this.provider.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.wlpInformation == null ? 0 : this.wlpInformation.hashCode());
        if (this.type != null && this.type != ResourceType.FEATURE) {
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!this.equivalent(obj)) {
            return false;
        }
        Asset other = (Asset)obj;
        if (this._id == null ? other._id != null : !this._id.equals(other._id)) {
            return false;
        }
        if (this.createdBy == null ? other.createdBy != null : !this.createdBy.equals(other.createdBy)) {
            return false;
        }
        if (this.createdOn == null ? other.createdOn != null : !this.createdOn.equals(other.createdOn)) {
            return false;
        }
        if (this.lastUpdatedOn == null ? other.lastUpdatedOn != null : !this.lastUpdatedOn.equals(other.lastUpdatedOn)) {
            return false;
        }
        if (this.marketplaceId == null ? other.marketplaceId != null : !this.marketplaceId.equals(other.marketplaceId)) {
            return false;
        }
        if (this.marketplaceName == null ? other.marketplaceName != null : !this.marketplaceName.equals(other.marketplaceName)) {
            return false;
        }
        if (this.published == null ? other.published != null : !this.published.equals(other.published)) {
            return false;
        }
        if (this.inMyStore == null ? other.inMyStore != null : !this.inMyStore.equals(other.inMyStore)) {
            return false;
        }
        if (this.state == null ? other.state != null : !this.state.equals((Object)other.state)) {
            return false;
        }
        if (this.featured == null ? other.featured != null : !this.featured.equals((Object)other.featured)) {
            return false;
        }
        return !(this.attachments == null ? other.attachments != null : !this.attachments.equals(other.attachments));
    }

    public boolean equivalentWithoutAttachments(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Asset other = (Asset)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.shortDescription == null ? other.shortDescription != null : !this.shortDescription.equals(other.shortDescription)) {
            return false;
        }
        if (this.feedback == null ? other.feedback != null : !this.feedback.equals(other.feedback)) {
            return false;
        }
        if (this.information == null ? other.information != null : !this.information.equals(other.information)) {
            return false;
        }
        if (this.licenseType == null ? other.licenseType != null : !this.licenseType.equals((Object)other.licenseType)) {
            return false;
        }
        if (this.licenseId == null ? other.licenseId != null : !this.licenseId.equals(other.licenseId)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.privacy == null ? other.privacy != null : !this.privacy.equals((Object)other.privacy)) {
            return false;
        }
        if (this.provider == null ? other.provider != null : !this.provider.equals(other.provider)) {
            return false;
        }
        if (this.reviewed == null ? other.reviewed != null : !this.reviewed.equals(other.reviewed)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals((Object)other.type)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        return !(this.wlpInformation == null ? other.wlpInformation != null : !this.wlpInformation.equivalent(other.wlpInformation));
    }

    public boolean equivalent(Object obj) {
        if (!this.equivalentWithoutAttachments(obj)) {
            return false;
        }
        Asset other = (Asset)obj;
        if (this.attachments == null) {
            if (other.attachments != null) {
                return false;
            }
        } else {
            if (other.attachments == null) {
                return false;
            }
            if (other.attachments.size() != this.attachments.size()) {
                return false;
            }
            block0: for (Attachment at : this.attachments) {
                for (Attachment otherAt : other.attachments) {
                    if (!at.equivalent(otherAt)) continue;
                    continue block0;
                }
                return false;
            }
        }
        return true;
    }

    public Asset createMinimalAssetForJSON() throws IllegalArgumentException, IllegalAccessException {
        Asset ass = new Asset();
        for (Field f : Asset.class.getDeclaredFields()) {
            if (!f.isAnnotationPresent(JSONIncludeForFile.class)) continue;
            f.set(ass, f.get(this));
        }
        return ass;
    }

    public void dumpMinimalAsset(OutputStream stream) throws IllegalArgumentException, IllegalAccessException {
        this.createMinimalAssetForJSON().dump(stream);
    }

    public static enum Featured {
        YES("yes"),
        NO("no");

        private final String featured;

        private Featured(String featured) {
            this.featured = featured;
        }

        public String getValue() {
            return this.featured;
        }

        public static Featured forValue(String value) {
            for (Featured featured : Featured.values()) {
                if (!featured.getValue().equals(value)) continue;
                return featured;
            }
            return null;
        }
    }

    public static enum Privacy {
        PUBLIC,
        PRIVATE;

    }
}

