/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.blueprint.aries.impl;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.PassThroughMetadata;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableRefMetadata;
import org.apache.aries.blueprint.mutable.MutableReferenceMetadata;
import org.apache.aries.jpa.container.context.PersistenceContextProvider;
import org.apache.aries.util.nls.MessageUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.MapEntry;
import org.osgi.service.blueprint.reflect.MapMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.Target;
import org.osgi.service.blueprint.reflect.ValueMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NSHandler
implements NamespaceHandler {
    private static final String ATTR_INDEX = "index";
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.jpa.blueprint.aries");
    private static final MessageUtil MESSAGES = MessageUtil.createMessageUtil(NSHandler.class, (String)"org.apache.aries.jpa.blueprint.aries.nls.ariesBlueprintJpaMessages");
    public static final String NS_URI_100 = "http://aries.apache.org/xmlns/jpa/v1.0.0";
    public static final String NS_URI_110 = "http://aries.apache.org/xmlns/jpa/v1.1.0";
    private static final String BLUEPRINT_NS = "http://www.osgi.org/xmlns/blueprint/v1.0.0";
    private static final String TAG_UNIT = "unit";
    private static final String TAG_CONTEXT = "context";
    private static final String TAG_MAP = "map";
    private static final String ATTR_PROPERTY = "property";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_UNIT_NAME = "unitname";
    private static final String DEFAULT_UNIT_NAME = "";
    public static final String EMPTY_UNIT_NAME_FILTER = "(org.apache.aries.jpa.default.unit.name=true)";
    private static final String ACTIVATION_EAGER = "EAGER";
    private static final Collection<Class<?>> IFACES = Arrays.asList(EntityManager.class);
    private PersistenceContextProvider manager;
    private final AtomicBoolean contextsAvailable = new AtomicBoolean();

    public void setManager(PersistenceContextProvider manager) {
        this.manager = manager;
        boolean log = this.contextsAvailable.compareAndSet(false, true);
        if (log && _logger.isDebugEnabled()) {
            _logger.debug("Managed persistence context support is now available for use with the Aries Blueprint container");
        }
    }

    public void unsetManager(PersistenceContextProvider manager) {
        this.contextsAvailable.set(false);
        _logger.warn(MESSAGES.getMessage("jpa.support.gone", new Object[0]));
    }

    public ComponentMetadata decorate(Node node, ComponentMetadata component, ParserContext context) {
        if (node.getNodeType() != 1) {
            _logger.error(MESSAGES.getMessage("unexpected.node", new Object[]{node}));
            throw new IllegalArgumentException(node.toString());
        }
        Element element = (Element)node;
        if (!(component instanceof BeanMetadata)) {
            _logger.error(MESSAGES.getMessage("incorrect.component.type", new Object[]{component}));
            throw new IllegalArgumentException(component.toString());
        }
        if (!(component instanceof MutableBeanMetadata)) {
            _logger.error(MESSAGES.getMessage("non.mutable.bean", new Object[]{component}));
            throw new IllegalArgumentException(component.toString());
        }
        MutableBeanMetadata bean = (MutableBeanMetadata)component;
        if (!NS_URI_100.equals(element.getNamespaceURI()) && !NS_URI_110.equals(element.getNamespaceURI())) {
            String message = MESSAGES.getMessage("unexpected.namespace", new Object[]{element.getNamespaceURI()});
            _logger.error(message);
            throw new IllegalArgumentException(message);
        }
        if (!TAG_UNIT.equals(element.getLocalName()) && !TAG_CONTEXT.equals(element.getLocalName())) {
            String message = MESSAGES.getMessage("unexpected.element", new Object[]{element.getLocalName()});
            _logger.error(message);
            throw new IllegalArgumentException(message);
        }
        String property = element.getAttribute(ATTR_PROPERTY);
        property = property.isEmpty() ? null : property;
        String index = element.getAttribute(ATTR_INDEX);
        index = index.isEmpty() ? null : index;
        String unitName = this.parseUnitName(element);
        boolean isPersistenceUnit = TAG_UNIT.equals(element.getLocalName());
        if (property != null && index != null) {
            _logger.error(MESSAGES.getMessage("invalid.property.and.index", new Object[0]));
        } else if (property != null) {
            if (_logger.isDebugEnabled()) {
                if (isPersistenceUnit) {
                    _logger.debug("Creating blueprint injection metadata to inject the unit {} into bean property {}", new Object[]{unitName, property});
                } else {
                    _logger.debug("Creating blueprint injection metadata to inject the context {} into bean property {}", new Object[]{unitName, property});
                }
            }
            bean.addProperty(property, (Metadata)this.createTargetMetadata(isPersistenceUnit, context, unitName));
        } else {
            int i;
            if (_logger.isDebugEnabled()) {
                if (isPersistenceUnit) {
                    if (index == null) {
                        _logger.debug("Creating blueprint injection metadata to inject the unit {} as a constructor argument", new Object[]{unitName});
                    } else {
                        _logger.debug("Creating blueprint injection metadata to inject the unit {} as a constructor argument with index {}", new Object[]{unitName, index});
                    }
                } else if (index == null) {
                    _logger.debug("Creating blueprint injection metadata to inject the context {} as a constructor argument", new Object[]{unitName});
                } else {
                    _logger.debug("Creating blueprint injection metadata to inject the context {} as a constructor argument with index {}", new Object[]{unitName, index});
                }
            }
            if (index == null) {
                i = -1;
            } else {
                try {
                    i = Integer.parseInt(index);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException(MESSAGES.getMessage("index.not.a.number", new Object[]{index}), nfe);
                }
            }
            bean.addArgument((Metadata)this.createTargetMetadata(isPersistenceUnit, context, unitName), isPersistenceUnit ? EntityManagerFactory.class.getName() : EntityManager.class.getName(), i);
        }
        if (TAG_CONTEXT.equals(element.getLocalName())) {
            Bundle client = this.getBlueprintBundle(context);
            if (client != null) {
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("org.apache.aries.jpa.context.type", this.parseType(element));
                properties.putAll(this.parseJPAProperties(element, context));
                if (this.contextsAvailable.get()) {
                    this.manager.registerContext(unitName, client, properties);
                } else {
                    _logger.warn(MESSAGES.getMessage("no.persistence.context.provider", new Object[]{client.getSymbolicName() + '/' + client.getVersion(), unitName, properties}));
                }
            } else {
                _logger.debug("No bundle: this must be a dry, parse only run.");
            }
        }
        return bean;
    }

    public Set<Class> getManagedClasses() {
        return null;
    }

    public URL getSchemaLocation(String namespace) {
        if (NS_URI_100.equals(namespace)) {
            return this.getClass().getResource("/org/apache/aries/jpa/blueprint/namespace/jpa.xsd");
        }
        if (NS_URI_110.equals(namespace)) {
            return this.getClass().getResource("/org/apache/aries/jpa/blueprint/namespace/jpa_110.xsd");
        }
        return null;
    }

    public Metadata parse(Element element, ParserContext context) {
        _logger.error(MESSAGES.getMessage("unexpected.top.level.element", new Object[0]));
        throw new UnsupportedOperationException();
    }

    public void contextAvailable(ServiceReference ref) {
        boolean log = this.contextsAvailable.compareAndSet(false, true);
        if (log && _logger.isDebugEnabled()) {
            _logger.debug("Managed persistence context support is now available for use with the Aries Blueprint container");
        }
    }

    public void contextUnavailable(ServiceReference ref) {
        this.contextsAvailable.set(false);
        _logger.warn(MESSAGES.getMessage("jpa.support.gone", new Object[0]));
    }

    private ComponentMetadata createTargetMetadata(boolean isPersistenceUnit, ParserContext ctx, String unitName) {
        MutableReferenceMetadata refMetadata = (MutableReferenceMetadata)ctx.createMetadata(MutableReferenceMetadata.class);
        refMetadata.setActivation(ACTIVATION_EAGER.equalsIgnoreCase(ctx.getDefaultActivation()) ? 1 : 2);
        refMetadata.setAvailability(1);
        refMetadata.setInterface(EntityManagerFactory.class.getName());
        StringBuilder filter = new StringBuilder("(&");
        if (isPersistenceUnit) {
            filter.append("(!(").append("org.apache.aries.jpa.proxy.factory").append("=*))");
        } else {
            filter.append("(").append("org.apache.aries.jpa.proxy.factory").append("=true)");
        }
        if (!DEFAULT_UNIT_NAME.equals(unitName)) {
            filter.append("(osgi.unit.name=" + unitName + ")");
        } else {
            filter.append(EMPTY_UNIT_NAME_FILTER);
        }
        filter.append(")");
        refMetadata.setFilter(filter.toString());
        refMetadata.setTimeout((long)Integer.parseInt(ctx.getDefaultTimeout()));
        refMetadata.setDependsOn(Collections.EMPTY_LIST);
        refMetadata.setId(ctx.generateId());
        MutableReferenceMetadata target = isPersistenceUnit ? refMetadata : this.createInjectionBeanMetedata(ctx, refMetadata);
        return target;
    }

    private ComponentMetadata createInjectionBeanMetedata(ParserContext ctx, MutableReferenceMetadata factory) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Creating a managed persistence context definition for injection");
        }
        factory.setProxyChildBeanClasses(IFACES);
        ctx.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)factory);
        MutableBeanMetadata meta = (MutableBeanMetadata)ctx.createMetadata(MutableBeanMetadata.class);
        MutableRefMetadata ref = (MutableRefMetadata)ctx.createMetadata(MutableRefMetadata.class);
        ref.setComponentId(factory.getId());
        meta.setFactoryComponent((Target)ref);
        meta.setActivation(factory.getActivation());
        meta.setFactoryMethod("createEntityManager");
        meta.setScope("prototype");
        meta.setDestroyMethod("internalClose");
        return meta;
    }

    private Bundle getBlueprintBundle(ParserContext context) {
        PassThroughMetadata metadata = (PassThroughMetadata)context.getComponentDefinitionRegistry().getComponentDefinition("blueprintBundle");
        Bundle result = null;
        if (metadata != null) {
            result = (Bundle)metadata.getObject();
        }
        return result;
    }

    private PersistenceContextType parseType(Element element) {
        if (element.hasAttribute(ATTR_TYPE)) {
            return PersistenceContextType.valueOf((String)element.getAttribute(ATTR_TYPE));
        }
        return PersistenceContextType.TRANSACTION;
    }

    private String parseUnitName(Element element) {
        return element.hasAttribute(ATTR_UNIT_NAME) ? element.getAttribute(ATTR_UNIT_NAME) : DEFAULT_UNIT_NAME;
    }

    private Map<String, Object> parseJPAProperties(Element element, ParserContext context) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        NodeList ns = element.getElementsByTagNameNS(BLUEPRINT_NS, TAG_MAP);
        for (int i = 0; i < ns.getLength(); ++i) {
            MapMetadata metadata = (MapMetadata)context.parseElement(MapMetadata.class, null, (Element)ns.item(i));
            for (MapEntry entry : metadata.getEntries()) {
                if (entry.getKey() instanceof ValueMetadata && entry.getValue() instanceof ValueMetadata) {
                    ValueMetadata key = (ValueMetadata)entry.getKey();
                    ValueMetadata value = (ValueMetadata)entry.getValue();
                    result.put(key.getStringValue(), value.getStringValue());
                    continue;
                }
                _logger.error(MESSAGES.getMessage("map.not.well.formed", new Object[0]));
                throw new UnsupportedOperationException();
            }
        }
        return result;
    }
}

