/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.tx;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.eba.tx.TxComponentMetaDataHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.blueprint.reflect.ComponentMetadata;

public class TxComponentMetaDataHelperImpl
implements TxComponentMetaDataHelper {
    private final Map<ComponentMetadata, TranData> data = Collections.synchronizedMap(new WeakHashMap());

    @Override
    public synchronized void setComponentTransactionData(ComponentMetadata component, String value, String method) {
        TranData td = this.data.get(component);
        if (td == null) {
            td = new TranData();
            this.data.put(component, td);
        }
        String[] names = method.split("[, \t]");
        for (int i = 0; i < names.length; ++i) {
            Pattern pattern = Pattern.compile(names[i].replaceAll("\\*", ".*"));
            td.add(pattern, value);
        }
    }

    @Override
    public String getComponentMethodTxStrategy(ComponentMetadata component, String methodName) {
        TranData td = this.data.get(component);
        String result = null;
        if (td != null) {
            result = td.getStrategy(methodName);
        }
        return result;
    }

    private static class TranData {
        private static final TraceNLS TRACE_NLS = TraceNLS.getTraceNLS((String)"com.ibm.ws.eba.tx.nls.txMessages");
        private static final Pattern WILDCARD = Pattern.compile("\\Q.*\\E");
        private final Map<Pattern, String> map = new ConcurrentHashMap<Pattern, String>();
        private final Map<String, String> cache = new ConcurrentHashMap<String, String>();

        public void add(Pattern pattern, String strategy) {
            this.map.put(pattern, strategy);
        }

        public String getStrategy(String name) {
            String strategy = this.cache.get(name);
            if (strategy == null) {
                List<Pattern> matches = this.findMatches(name);
                int size = matches.size();
                if (size == 0) {
                    strategy = "Required";
                } else if (size == 1) {
                    strategy = this.map.get(matches.get(0));
                } else {
                    size = (matches = this.selectPatternsWithFewestWildcards(matches)).size();
                    if (size == 1) {
                        strategy = this.map.get(matches.get(0));
                    } else {
                        size = (matches = this.selectLongestPatterns(matches)).size();
                        if (size == 1) {
                            strategy = this.map.get(matches.get(0));
                        } else {
                            throw new IllegalStateException(TRACE_NLS.getFormattedMessage("CWSAB1002E", new Object[]{matches, name}, "CWSAB1002E: Unable to select a transaction strategy due to ambiguous component metadata. Unable to choose between " + matches + " for component " + name + "."));
                        }
                    }
                }
                this.cache.put(name, strategy);
            }
            return strategy;
        }

        private List<Pattern> findMatches(String name) {
            ArrayList<Pattern> matches = new ArrayList<Pattern>();
            for (Pattern p : this.map.keySet()) {
                if (!p.matcher(name).matches()) continue;
                matches.add(p);
            }
            return matches;
        }

        private List<Pattern> selectPatternsWithFewestWildcards(List<Pattern> matches) {
            ArrayList<Pattern> remainingMatches = new ArrayList<Pattern>();
            int minWildcards = Integer.MAX_VALUE;
            for (Pattern p : matches) {
                String pattern = p.pattern();
                Matcher m = WILDCARD.matcher(pattern);
                int count = 0;
                while (m.find()) {
                    ++count;
                }
                if (count < minWildcards) {
                    remainingMatches.clear();
                    remainingMatches.add(p);
                    minWildcards = count;
                    continue;
                }
                if (count != minWildcards) continue;
                remainingMatches.add(p);
            }
            return remainingMatches;
        }

        private List<Pattern> selectLongestPatterns(List<Pattern> matches) {
            ArrayList<Pattern> remainingMatches = new ArrayList<Pattern>();
            int longestLength = 0;
            for (Pattern p : matches) {
                String pattern = p.pattern();
                int length = pattern.length();
                if (length > longestLength) {
                    remainingMatches.clear();
                    remainingMatches.add(p);
                    longestLength = length;
                    continue;
                }
                if (length != longestLength) continue;
                remainingMatches.add(p);
            }
            return remainingMatches;
        }
    }
}

