/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.client.rest.internal;

import com.ibm.ws.jmx.connector.client.rest.internal.resources.RESTClientMessagesUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

class NotificationListenerEntry {
    public final NotificationListener listener;
    public final NotificationFilter filter;
    public final Object handback;
    private static final Logger logger = Logger.getLogger(NotificationListenerEntry.class.getName());

    NotificationListenerEntry(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.listener = listener;
        this.filter = filter;
        this.handback = handback;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "NotificationListenerEntry", "[" + RESTClientMessagesUtil.getObjID(this) + "] | listener: " + listener + " | filter: " + filter + " | handback: " + handback);
        }
    }

    void handleNotification(Notification notification) {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "handleNotification", "[" + RESTClientMessagesUtil.getObjID(this) + "] | Notification: " + notification);
        }
        if (this.filter == null || this.filter.isNotificationEnabled(notification)) {
            this.listener.handleNotification(notification, this.handback);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof NotificationListenerEntry)) {
            return false;
        }
        NotificationListenerEntry other = (NotificationListenerEntry)o;
        return this.listener.equals(other.listener) && this.filter == other.filter && this.handback == other.handback;
    }

    public int hashCode() {
        return this.listener.hashCode() + (this.filter != null ? this.filter.hashCode() : 0) + (this.handback != null ? this.handback.hashCode() : 0);
    }
}

