/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.hpel;

import com.ibm.websphere.logging.WsLevel;
import com.ibm.ws.kernel.boot.logging.LoggerHandlerManager;
import com.ibm.ws.logging.internal.hpel.HpelTraceServiceConfig;
import com.ibm.ws.logging.internal.hpel.HpelTraceServiceWriter;
import com.ibm.ws.logging.internal.impl.BaseTraceService;
import com.ibm.ws.logging.internal.impl.LogProviderConfigImpl;
import com.ibm.wsspi.logging.MessageRouter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class HpelBaseTraceService
extends BaseTraceService {
    private final HpelTraceServiceWriter trWriter = new HpelTraceServiceWriter(this);

    public void echo(BaseTraceService.SystemLogHolder holder, LogRecord logRecord) {
        if (this.copySystemStreams) {
            this.writeFilteredStreamOutput(holder, logRecord);
        }
        this.trWriter.repositoryPublish(logRecord);
    }

    boolean notifyConsole(LogRecord logRecord) {
        int levelValue = logRecord.getLevel().intValue();
        if (levelValue >= Level.INFO.intValue()) {
            boolean logNormally;
            String txt = this.formatter.formatMessage(logRecord);
            MessageRouter router = (MessageRouter)this.externalMessageRouter.get();
            if (router != null && !(logNormally = router.route(txt, logRecord))) {
                return false;
            }
            if (levelValue >= this.consoleLogLevel.intValue()) {
                if (levelValue == WsLevel.ERROR.intValue() || levelValue == WsLevel.FATAL.intValue()) {
                    this.writeStreamOutput(this.systemErr, this.formatter.consoleLogFormat(logRecord, txt), false);
                } else {
                    this.writeStreamOutput(this.systemOut, this.formatter.consoleLogFormat(logRecord, txt), false);
                }
            }
        }
        return true;
    }

    public void publishLogRecord(LogRecord logRecord) {
        this.trWriter.repositoryPublish(logRecord);
    }

    protected void publishTraceLogRecord(BaseTraceService.TraceWriter detailLog, LogRecord logRecord, Object id, String formattedMsg, String formattedVerboseMsg) {
        this.trWriter.repositoryPublish(logRecord);
    }

    protected void initializeWriters(LogProviderConfigImpl config) {
        this.trWriter.configure((HpelTraceServiceConfig)config);
    }

    protected void registerLoggerHandlerSingleton() {
        LoggerHandlerManager.setSingleton((Handler)this.trWriter.getHandler());
    }

    protected void unregisterLoggerHandlerSingleton() {
        LoggerHandlerManager.unsetSingleton();
        this.trWriter.stop();
    }
}

