/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.impl;

import com.ibm.ws.logging.hpel.impl.AccessHelper;
import com.ibm.ws.logging.hpel.impl.LogRepositoryManagerImpl;
import java.io.File;
import java.io.FileFilter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogRepositoryManagerTextImpl
extends LogRepositoryManagerImpl {
    private static final String TEXTLOGPREF = "TextLog_";
    private static final String TEXTLOGEXT = ".log";
    private static final SimpleDateFormat DATEFORMAT = new SimpleDateFormat("yy.MM.dd_HH.mm.ss");

    public LogRepositoryManagerTextImpl(File directory, String pid, String label, boolean useDirTree) {
        super(directory, pid, label, useDirTree);
    }

    @Override
    protected File getLogFile(File parentLocation, long timestamp) {
        StringBuilder sb = new StringBuilder();
        sb.append(TEXTLOGPREF);
        sb.append(DATEFORMAT.format(new Date(timestamp)));
        sb.append(TEXTLOGEXT);
        return new File(parentLocation, sb.toString());
    }

    @Override
    public long getLogFileTimestamp(File file) {
        String name = file.getName();
        if (name == null || name.length() == 0 || !name.startsWith(TEXTLOGPREF) || !name.endsWith(TEXTLOGEXT)) {
            return -1L;
        }
        long result = -1L;
        try {
            Date date = DATEFORMAT.parse(name.substring(TEXTLOGPREF.length(), name.length() - TEXTLOGEXT.length()));
            result = date.getTime();
        }
        catch (ParseException ex) {
            // empty catch block
        }
        return result;
    }

    @Override
    protected File[] listRepositoryFiles() {
        FileFilter textLogFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().startsWith(LogRepositoryManagerTextImpl.TEXTLOGPREF) && pathname.getName().endsWith(LogRepositoryManagerTextImpl.TEXTLOGEXT);
            }
        };
        return AccessHelper.listFiles(this.repositoryLocation, textLogFilter);
    }
}

