/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.stat.StatsConfigHelper;
import com.ibm.ws.xml.ParserFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public class ModuleConfigParser
extends DefaultHandler
implements PmiConstants {
    public static final String STATS_DTD = "/com/ibm/websphere/pmi/xml/stats.dtd";
    public static final String VALIDATE_DESCRIPTOR_PROPERTY = "com.ibm.websphere.pmi.validateDescriptors";
    private PmiModuleConfig oneModule = null;
    private PmiDataInfo currentData;
    private PmiDataInfo submoduleData;
    private String currentChars = null;
    private final TraceComponent tc = Tr.register(ModuleConfigParser.class);
    private String submoduleName = null;
    private boolean isModule = true;
    private String _fileName = null;
    private boolean _validate = false;
    private boolean bExtension = false;
    private Bundle loadXMLUsingBundle = null;
    private Locator locator = null;
    private static String PERF_MODULE;
    private static String STATS;
    private static String PERF_LONG;
    private static String COUNT_STAT;
    private static String PERF_DOUBLE;
    private static String DOUBLE_STAT;
    private static String PERF_LOAD;
    private static String BOUNDED_RANGE_STAT;
    private static String PERF_STAT;
    private static String TIME_STAT;
    private static String AVG_STAT;
    private static String RANGE_STAT;
    private static String PERF_SUBMODULE;
    private static String UID;
    private static String DESCRIPTION;
    private static String NAME;
    private static String LEVEL;
    private static String STATISTICSET;
    private static String PLATFORM;
    private static String UNIT;
    private static String RESETTABLE;
    private static String AGGREGATABLE;
    private static String ZOS_AGGREGATABLE;
    private static String ON_REQUEST;
    private static String CATEGORY;
    private static String COMMENT;
    private static String DEPENDENCY;
    private static String MBEAN_TYPE;
    private static String STATS_NLS_FILE;
    private static String TYPE;
    private static String EXTENSION_TAG;
    private static AttributesImpl attrList;
    static final long serialVersionUID = -2953362401810150844L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Bundle getLoadXMLUsingBundle() {
        return this.loadXMLUsingBundle;
    }

    public void setLoadXMLUsingBundle(Bundle b) {
        this.loadXMLUsingBundle = b;
    }

    public PmiModuleConfig parse(String fileName) throws Exception {
        return this.loadDescriptor(fileName, false);
    }

    public synchronized PmiModuleConfig parse(String fileName, boolean validate) throws Exception {
        return this.loadDescriptor(fileName, validate);
    }

    public PmiModuleConfig loadDescriptor(String fileName, boolean validate) throws Exception {
        return this.loadDescriptor(fileName, validate, true);
    }

    @ManualTrace
    public PmiModuleConfig loadDescriptor(String fileName, boolean validate, boolean loadFromClassPathOnly) throws Exception {
        String[] tokens;
        loadFromClassPathOnly = false;
        if (this.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)this.tc, (String)("loadDescriptor: parsing stats xml " + fileName + "; dtd validation: " + validate), (Object[])new Object[0]);
        }
        this.oneModule = null;
        this.currentData = null;
        this.submoduleName = null;
        this.submoduleData = null;
        this._fileName = fileName;
        this._validate = validate;
        InputStream istream = null;
        boolean usingCC = false;
        if (fileName.indexOf(61) != -1 && (tokens = fileName.split("=")).length > 1 && tokens[0].equalsIgnoreCase(EXTENSION_TAG)) {
            this.bExtension = true;
            this._fileName = tokens[1];
            try {
                this.parseFromExtension(this._fileName);
            }
            catch (Exception ex) {
                if (this.tc.isDebugEnabled()) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.pmi.server.ModuleConfigParser.loadDescriptor", (String)"97", (Object)this);
                }
                throw ex;
            }
            if (this.tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)this.tc, (String)"loadDescriptor");
            }
            return this.oneModule;
        }
        this.bExtension = false;
        if (istream == null) {
            istream = this.getResourcefromBundle(fileName);
            if (istream == null) {
                istream = this.getClass().getResourceAsStream(fileName);
            }
            usingCC = false;
            if (istream == null) {
                istream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
                usingCC = true;
            }
            if (istream == null) {
                istream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName.substring(1));
                usingCC = true;
            }
            if (istream == null) {
                Tr.error((TraceComponent)this.tc, (String)"PMI0010W", (Object[])new Object[]{fileName});
                return null;
            }
        }
        try {
            XMLReader parser = ParserFactory.createXMLReader();
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://xml.org/sax/features/validation", validate);
            parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", validate);
            parser.setEntityResolver(this);
            parser.setContentHandler(this);
            parser.setErrorHandler(this);
            parser.parse(new InputSource(istream));
        }
        catch (Exception ex) {
            if (this.tc.isDebugEnabled()) {
                ex.printStackTrace();
            }
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.pmi.server.ModuleConfigParser.loadDescriptor", (String)"97", (Object)this);
            throw ex;
        }
        finally {
            istream.close();
        }
        String uid = PerfModules.getModuleUID(fileName);
        StatsConfigHelper.translateAndCache(this.oneModule, null);
        if (this.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)this.tc, (String)"loadDescriptor");
        }
        return this.oneModule;
    }

    private InputStream getResourcefromBundle(String path) {
        URL u;
        if (this.loadXMLUsingBundle != null && (u = this.loadXMLUsingBundle.getEntry(path)) != null) {
            try {
                return u.openStream();
            }
            catch (IOException e) {
                if (this.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)this.tc, (String)"IO Exception was thrown. Please check FFDC Files.", (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.pmi.server.ModuleConfigParser.getResourcefromBundle", (String)"257", (Object)this);
            }
        }
        return null;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    @ManualTrace
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (this.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)this.tc, (String)"resolveEntity", (Object[])new Object[]{systemId});
        }
        InputSource inputSource = null;
        try {
            if (systemId.endsWith("stats.dtd")) {
                InputStream in = this.getClass().getResourceAsStream(STATS_DTD);
                inputSource = new InputSource(in);
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.pmi.server.ModuleConfigParser.resolveEntity", (String)"126", (Object)this);
            Tr.error((TraceComponent)this.tc, (String)"PMI0010W", (Object[])new Object[]{systemId});
            if (this.tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)this.tc, (String)"resolveEntity");
            }
            return null;
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)this.tc, (String)"resolveEntity");
        }
        return inputSource;
    }

    @Override
    @ManualTrace
    public void error(SAXParseException exception) throws SAXException {
        if (this.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)this.tc, (String)"error", (Object[])new Object[]{exception});
        }
        throw new SAXException(exception);
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localpart, String rawname, Attributes attributes) throws SAXException {
        if (rawname.equals(PERF_MODULE)) {
            this.isModule = true;
            String uid = PerfModules.getModuleUID(this._fileName);
            int index = uid.lastIndexOf(".");
            String newUID = uid.substring(index + 1);
            this.oneModule = new PmiModuleConfig(newUID);
            return;
        }
        if (rawname.equals(STATS)) {
            String moduleUID;
            this.isModule = true;
            String type = attributes.getValue(TYPE);
            if (this._validate && !(moduleUID = this.bExtension ? this._fileName : PerfModules.getModuleUID(this._fileName)).equals(type)) {
                throw new SAXException("Stats template name does not match with stat type: template = " + this._fileName + "; stats type = " + type);
            }
            this.oneModule = new PmiModuleConfig(type);
            return;
        }
        if (!rawname.equals(DESCRIPTION) && !rawname.equals(STATS_NLS_FILE)) {
            if (rawname.equals(COUNT_STAT) || rawname.equals(TIME_STAT) || rawname.equals(RANGE_STAT) || rawname.equals(BOUNDED_RANGE_STAT) || rawname.equals(AVG_STAT) || rawname.equals(DOUBLE_STAT) || rawname.equals(PERF_LONG) || rawname.equals(PERF_LOAD) || rawname.equals(PERF_STAT) || rawname.equals(PERF_DOUBLE) || rawname.equals(PERF_SUBMODULE)) {
                this.isModule = false;
                int dataId = Integer.parseInt(attributes.getValue("ID"));
                this.currentData = new PmiDataInfo(dataId);
                this.currentData.setName(attributes.getValue(NAME));
                this.currentData.setSubmoduleName(this.submoduleName);
                if (rawname.equals(COUNT_STAT) || rawname.equals(PERF_LONG)) {
                    this.currentData.setType(2);
                } else if (rawname.equals(BOUNDED_RANGE_STAT) || rawname.equals(PERF_LOAD)) {
                    this.currentData.setType(5);
                } else if (rawname.equals(RANGE_STAT)) {
                    this.currentData.setType(7);
                } else if (rawname.equals(PERF_STAT) || rawname.equals(TIME_STAT)) {
                    this.currentData.setType(4);
                } else if (rawname.equals(PERF_DOUBLE) || rawname.equals(DOUBLE_STAT)) {
                    this.currentData.setType(3);
                } else if (rawname.equals(AVG_STAT)) {
                    this.currentData.setType(6);
                } else if (rawname.equals(PERF_SUBMODULE)) {
                    this.currentData.setType(15);
                    this.submoduleName = this.currentData.getName();
                }
                this.oneModule.addData(this.currentData);
            } else if (rawname.equals(LEVEL) || rawname.equals(CATEGORY) || rawname.equals(UNIT) || rawname.equals(AGGREGATABLE) || rawname.equals(ZOS_AGGREGATABLE) || rawname.equals(RESETTABLE) || rawname.equals(COMMENT)) {
                // empty if block
            }
        }
        this.currentChars = null;
    }

    @Override
    public void endElement(String uri, String localpart, String rawname) throws SAXException {
        if (!rawname.equals(PERF_MODULE) && !rawname.equals(STATS)) {
            if (rawname.equals(DESCRIPTION)) {
                if (this.isModule) {
                    this.oneModule.setDescription(this.currentChars);
                } else {
                    this.currentData.setDescription(this.currentChars);
                }
            } else if (rawname.equals(STATS_NLS_FILE)) {
                if (this.isModule) {
                    this.oneModule.setResourceBundle(this.currentChars);
                }
            } else if (!(rawname.equals(PERF_LONG) || rawname.equals(PERF_LOAD) || rawname.equals(PERF_STAT) || rawname.equals(PERF_DOUBLE) || rawname.equals(COUNT_STAT) || rawname.equals(BOUNDED_RANGE_STAT) || rawname.equals(RANGE_STAT) || rawname.equals(AVG_STAT) || rawname.equals(TIME_STAT) || rawname.equals(DOUBLE_STAT))) {
                if (rawname.equals(PERF_SUBMODULE)) {
                    this.submoduleName = null;
                } else if (rawname.equals(LEVEL)) {
                    if (this.currentChars.equals("low")) {
                        this.currentData.setLevel(1);
                    } else if (this.currentChars.equals("medium")) {
                        this.currentData.setLevel(3);
                    } else if (this.currentChars.equals("high")) {
                        this.currentData.setLevel(7);
                    } else if (this.currentChars.equals("maximum")) {
                        this.currentData.setLevel(15);
                    } else {
                        this.currentData.setLevel(1000);
                    }
                } else if (rawname.equals(CATEGORY)) {
                    this.currentData.setCategory(this.currentChars);
                } else if (rawname.equals(UNIT)) {
                    this.currentData.setUnit(this.currentChars);
                } else if (rawname.equals(STATISTICSET)) {
                    this.currentData.setStatisticSet(this.currentChars);
                } else if (rawname.equals(PLATFORM)) {
                    this.currentData.setPlatform(this.currentChars);
                } else if (rawname.equals(RESETTABLE)) {
                    if (this.currentChars.equals("false")) {
                        this.currentData.setResettable(false);
                    }
                } else if (rawname.equals(AGGREGATABLE)) {
                    if (this.currentChars.equals("false")) {
                        this.currentData.setAggregatable(false);
                    }
                } else if (rawname.equals(ZOS_AGGREGATABLE)) {
                    if (this.currentChars.equals("false")) {
                        this.currentData.setZosAggregatable(false);
                    }
                } else if (rawname.equals(COMMENT)) {
                    this.currentData.setComment(this.currentChars);
                } else if (rawname.equals(ON_REQUEST)) {
                    if (this.currentChars.equals("true")) {
                        this.currentData.setOnRequest(true);
                    }
                } else if (rawname.equals(DEPENDENCY)) {
                    try {
                        int dataId = Integer.parseInt(this.currentChars);
                        this.currentData.addDependency(dataId);
                    }
                    catch (Exception e) {}
                } else if (rawname.equals(MBEAN_TYPE)) {
                    this.oneModule.setMbeanType(this.currentChars);
                }
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String tmpStr = new String(ch, start, length);
        this.currentChars = this.currentChars == null ? tmpStr : this.currentChars + tmpStr;
    }

    private String getXmlFileName(String moduleID) {
        String fileName = "/" + moduleID.replace('.', '/') + ".xml";
        return fileName;
    }

    private void parseFromExtension(String strExtension) {
    }

    public static void main(String[] args) throws Exception {
        ModuleConfigParser mParser = new ModuleConfigParser();
        mParser.parse("/com/ibm/websphere/pmi/custom/test/PmiServletModule1.xml", true);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ModuleConfigParser.class);
        PERF_MODULE = "PerfModule";
        STATS = "Stats";
        PERF_LONG = "PerfLong";
        COUNT_STAT = "CountStatistic";
        PERF_DOUBLE = "PerfDouble";
        DOUBLE_STAT = "DoubleStatistic";
        PERF_LOAD = "PerfLoad";
        BOUNDED_RANGE_STAT = "BoundedRangeStatistic";
        PERF_STAT = "PerfStat";
        TIME_STAT = "TimeStatistic";
        AVG_STAT = "AverageStatistic";
        RANGE_STAT = "RangeStatistic";
        PERF_SUBMODULE = "PerfSubModule";
        UID = "UID";
        DESCRIPTION = "description";
        NAME = "name";
        LEVEL = "level";
        STATISTICSET = "statisticSet";
        PLATFORM = "platform";
        UNIT = "unit";
        RESETTABLE = "resettable";
        AGGREGATABLE = "aggregatable";
        ZOS_AGGREGATABLE = "zosAggregatable";
        ON_REQUEST = "updateOnRequest";
        CATEGORY = "category";
        COMMENT = "comment";
        DEPENDENCY = "dependency";
        MBEAN_TYPE = "mBeanType";
        STATS_NLS_FILE = "resourceBundle";
        TYPE = "type";
        EXTENSION_TAG = "EXTENSION";
    }
}

