/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.monitors.helper;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public class JvmMonitorHelper {
    private final MemoryMXBean mmx = ManagementFactory.getMemoryMXBean();
    private final List<GarbageCollectorMXBean> gmx = ManagementFactory.getGarbageCollectorMXBeans();
    private final GarbageCollectorMXBean firstGCMBean = this.gmx.get(0);
    private final RuntimeMXBean rmx = ManagementFactory.getRuntimeMXBean();
    private final OperatingSystemMXBean osmx;
    private final Method met_getProcessCpuTime;
    private static final String PROCESSCPU_METHOD_NAME = "getProcessCpuTime";
    private long currElapsedCPUTime = 0L;
    private long currElapsedRealTime = 0L;
    private long lastElapsedRealTime = 0L;
    private long lastElapsedCPUTime = 0L;
    private int cpuNSFactor = 1;
    static final long serialVersionUID = -4144840510964359270L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public JvmMonitorHelper() {
        if (this.rmx.getVmVendor().equalsIgnoreCase("IBM Corporation")) {
            this.cpuNSFactor = 100;
        }
        this.osmx = ManagementFactory.getOperatingSystemMXBean();
        this.met_getProcessCpuTime = this.getProcessCpuTimeMethod(this.osmx.getClass());
    }

    @FFDCIgnore(value={NoSuchMethodException.class})
    private Method getProcessCpuTimeMethod(Class<?> osmxClass) {
        try {
            return osmxClass.getMethod(PROCESSCPU_METHOD_NAME, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public long getCommitedHeapMemoryUsage() {
        MemoryUsage mu = this.mmx.getHeapMemoryUsage();
        return mu.getCommitted();
    }

    public long getInitHeapMemorySettings() {
        MemoryUsage mu = this.mmx.getHeapMemoryUsage();
        return mu.getInit();
    }

    public long getMaxHeapMemorySettings() {
        MemoryUsage mu = this.mmx.getHeapMemoryUsage();
        return mu.getMax();
    }

    public long getUsedHeapMemoryUsage() {
        MemoryUsage mu = this.mmx.getHeapMemoryUsage();
        return mu.getUsed();
    }

    public long getGCCollectionCount() {
        return this.firstGCMBean.getCollectionCount();
    }

    public long getGCCollectionTime() {
        return this.firstGCMBean.getCollectionTime();
    }

    public long getUptime() {
        return this.rmx.getUptime();
    }

    public double getCPU() {
        double cpuUsage = 0.0;
        if (this.met_getProcessCpuTime != null && !this.met_getProcessCpuTime.isAccessible()) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){
                static final long serialVersionUID = -4883835181439721553L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void run() {
                    JvmMonitorHelper.this.met_getProcessCpuTime.setAccessible(true);
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }
        if (this.met_getProcessCpuTime != null && Modifier.isPublic(this.met_getProcessCpuTime.getModifiers())) {
            try {
                this.currElapsedCPUTime = (Long)this.met_getProcessCpuTime.invoke((Object)this.osmx, new Object[0]);
                this.currElapsedRealTime = System.nanoTime();
                long d1 = this.currElapsedRealTime - this.lastElapsedRealTime;
                long d2 = this.currElapsedCPUTime - this.lastElapsedCPUTime;
                cpuUsage = (double)d2 / (double)d1;
                int processors = this.osmx.getAvailableProcessors();
                cpuUsage = cpuUsage / (double)processors * (double)this.cpuNSFactor * 100.0;
            }
            catch (IllegalArgumentException e) {
                cpuUsage = -1.0;
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getCPU");
            }
            catch (IllegalAccessException e) {
                cpuUsage = -1.0;
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getCPU");
            }
            catch (InvocationTargetException e) {
                cpuUsage = -1.0;
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getCPU");
            }
            this.lastElapsedRealTime = this.currElapsedRealTime;
            this.lastElapsedCPUTime = this.currElapsedCPUTime;
        } else {
            cpuUsage = -1.0;
        }
        return cpuUsage;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JvmMonitorHelper.class);
    }
}

