/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.provisioning;

import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.provisioning.ProductExtensionInfo;
import com.ibm.ws.kernel.provisioning.ServiceFingerprint;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ProductExtension {
    public static final String PRODUCT_EXTENSION_DIR = "etc/extensions";
    public static final String PRODUCT_EXTENSIONS_FILE_EXTENSION = ".properties";
    public static final String PRODUCT_EXTENSIONS_INSTALL = "com.ibm.websphere.productInstall";
    public static final String PRODUCT_EXTENSIONS_ID = "com.ibm.websphere.productId";
    private static FileFilter PROPERTIESFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(ProductExtension.PRODUCT_EXTENSIONS_FILE_EXTENSION);
        }
    };

    private static File getExtensionDir(File installDir) {
        return new File(installDir, PRODUCT_EXTENSION_DIR);
    }

    public static List<ProductExtensionInfo> getProductExtensions() {
        return ProductExtension.getProductExtensions(Utils.getInstallDir());
    }

    public static List<ProductExtensionInfo> getProductExtensions(File installDir) {
        File productExtensionsDir;
        ArrayList<ProductExtensionInfo> productList = new ArrayList<ProductExtensionInfo>();
        HashMap<String, Properties> extraProductExtensions = ProductExtension.getExtraProductExtensions();
        if (extraProductExtensions != null) {
            for (Map.Entry<String, Properties> entry : extraProductExtensions.entrySet()) {
                String name = entry.getKey();
                Properties featureProperties = entry.getValue();
                String installLocation = featureProperties.getProperty(PRODUCT_EXTENSIONS_INSTALL);
                String productId = featureProperties.getProperty(PRODUCT_EXTENSIONS_ID);
                ProductExtensionInfoImpl prodInfo = new ProductExtensionInfoImpl(name, productId, installLocation);
                productList.add(prodInfo);
            }
        }
        if ((productExtensionsDir = ProductExtension.getExtensionDir(installDir)).exists()) {
            File[] productPropertiesFiles;
            for (File file : productPropertiesFiles = productExtensionsDir.listFiles(PROPERTIESFilter)) {
                String fileName = file.getName();
                String productName = fileName.substring(0, fileName.indexOf(PRODUCT_EXTENSIONS_FILE_EXTENSION));
                if (0 == productName.length() || "usr".equalsIgnoreCase(productName) || extraProductExtensions != null && extraProductExtensions.containsKey(productName)) continue;
                try {
                    ProductExtensionInfo prodInfo = ProductExtension.loadExtensionInfo(productName, file);
                    if (prodInfo == null) continue;
                    productList.add(prodInfo);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return productList;
    }

    private static HashMap<String, Properties> getExtraProductExtensions() {
        HashMap<String, Properties> extraProductExtensions = null;
        String embededData = System.getProperty("PRODUCT_EXTENSIONS_ADDED_BY_EMBEDDER");
        if (embededData != null) {
            String[] extensions = embededData.split("\n");
            for (int i = 0; i < extensions.length && i + 3 <= extensions.length; i += 3) {
                Properties props = new Properties();
                props.setProperty(PRODUCT_EXTENSIONS_ID, extensions[i + 1]);
                props.setProperty(PRODUCT_EXTENSIONS_INSTALL, extensions[i + 2]);
                if (extraProductExtensions == null) {
                    extraProductExtensions = new HashMap<String, Properties>();
                }
                extraProductExtensions.put(extensions[i], props);
            }
        }
        return extraProductExtensions;
    }

    public static ProductExtensionInfo getProductExtension(String extensionName) throws IOException {
        Properties featureProperties;
        ProductExtensionInfo productExtensionInfo = null;
        HashMap<String, Properties> extraProductExtensions = ProductExtension.getExtraProductExtensions();
        if (extraProductExtensions != null && (featureProperties = extraProductExtensions.get(extensionName)) != null) {
            String installLocation = featureProperties.getProperty(PRODUCT_EXTENSIONS_INSTALL);
            String productId = featureProperties.getProperty(PRODUCT_EXTENSIONS_ID);
            productExtensionInfo = new ProductExtensionInfoImpl(extensionName, productId, installLocation);
        }
        if (productExtensionInfo == null) {
            File extensionFile = new File(ProductExtension.getExtensionDir(Utils.getInstallDir()), extensionName + PRODUCT_EXTENSIONS_FILE_EXTENSION);
            productExtensionInfo = ProductExtension.loadExtensionInfo(extensionName, extensionFile);
        }
        return productExtensionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProductExtensionInfo loadExtensionInfo(String productName, File extensionFile) throws IOException {
        if (extensionFile.isFile()) {
            ProductExtensionInfoImpl productExtensionInfoImpl;
            Properties featureProperties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(extensionFile);
                featureProperties.load(fileInputStream);
                String installLocation = featureProperties.getProperty(PRODUCT_EXTENSIONS_INSTALL);
                String productId = featureProperties.getProperty(PRODUCT_EXTENSIONS_ID);
                ServiceFingerprint.put(extensionFile);
                productExtensionInfoImpl = new ProductExtensionInfoImpl(productName, productId, installLocation);
            }
            catch (Throwable throwable) {
                Utils.tryToClose(fileInputStream);
                throw throwable;
            }
            Utils.tryToClose(fileInputStream);
            return productExtensionInfoImpl;
        }
        return null;
    }

    public static class ProductExtensionInfoImpl
    implements ProductExtensionInfo {
        final String productName;
        final String location;
        final String productId;

        public ProductExtensionInfoImpl(String productName, String productId, String location) {
            this.productName = productName;
            this.productId = productId;
            this.location = location;
        }

        @Override
        public String getName() {
            return this.productName;
        }

        @Override
        public String getLocation() {
            return this.location;
        }

        @Override
        public String getProductID() {
            return this.productId;
        }
    }
}

