/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal.commands;

import com.ibm.ws.kernel.boot.BootstrapConfig;
import com.ibm.ws.kernel.boot.Debug;
import com.ibm.ws.kernel.boot.LaunchArguments;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.boot.internal.FileShareLockProcessStatusImpl;
import com.ibm.ws.kernel.boot.internal.PSProcessStatusImpl;
import com.ibm.ws.kernel.boot.internal.ProcessStatus;
import com.ibm.ws.kernel.boot.internal.ServerLock;
import com.ibm.ws.kernel.boot.internal.commands.JavaDumpAction;
import com.ibm.ws.kernel.boot.internal.commands.ServerCommandClient;
import com.ibm.ws.kernel.boot.internal.commands.ServerDumpPackager;
import com.ibm.ws.kernel.boot.internal.commands.ServerDumpUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ProcessControlHelper {
    public static final String INTERNAL_PID = "pid";
    public static final String INTERNAL_PID_FILE = "pid-file";
    final String serverName;
    final String serverConfigDir;
    final String serverOutputDir;
    final File consoleLogFile;
    final BootstrapConfig bootProps;
    final LaunchArguments launchArgs;

    public ProcessControlHelper(BootstrapConfig bootProps, LaunchArguments launchArgs) {
        this.serverName = bootProps.getProcessName();
        this.bootProps = bootProps;
        this.launchArgs = launchArgs;
        this.serverConfigDir = bootProps.get("server.config.dir");
        this.serverOutputDir = bootProps.get("server.output.dir");
        this.consoleLogFile = bootProps.getConsoleLogFile();
    }

    private String getPID() {
        String pid = this.launchArgs.getOption(INTERNAL_PID);
        return "".equals(pid) ? null : pid;
    }

    public ReturnCode stop() {
        String pid;
        ServerCommandClient scc;
        System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverStopping"), this.serverName));
        ServerLock serverLock = ServerLock.createTestLock(this.bootProps);
        ReturnCode stopRc = ReturnCode.STOP_ACTION;
        boolean lockExists = serverLock.lockFileExists();
        stopRc = lockExists ? (serverLock.testServerRunning() ? ((scc = new ServerCommandClient(this.bootProps)).isValid() ? scc.stopServer(this.launchArgs.getOption("force") != null) : ReturnCode.ERROR_SERVER_STOP) : ReturnCode.REDUNDANT_ACTION_STATUS) : ReturnCode.REDUNDANT_ACTION_STATUS;
        if (stopRc == ReturnCode.OK && lockExists) {
            stopRc = serverLock.waitForStop();
        }
        if (stopRc == ReturnCode.OK && (pid = this.getPID()) != null) {
            stopRc = this.waitForProcessStop(pid);
        }
        if (stopRc == ReturnCode.OK) {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverStopped"), this.serverName));
        } else if (stopRc == ReturnCode.REDUNDANT_ACTION_STATUS) {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverNotRunning"), this.serverName));
        } else if (stopRc == ReturnCode.SERVER_COMMAND_PORT_DISABLED_STATUS) {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("error.serverStopCommandPortDisabled"), this.serverName));
        } else {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverStopException"), this.serverName));
        }
        return stopRc;
    }

    private ReturnCode waitForProcessStop(String pid) {
        PSProcessStatusImpl ps = new PSProcessStatusImpl(pid);
        for (int i = 0; i < 60; ++i) {
            try {
                if (!ps.isPossiblyRunning()) {
                    return ReturnCode.OK;
                }
                Thread.sleep(500L);
                continue;
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
                break;
            }
        }
        return ReturnCode.ERROR_SERVER_STOP;
    }

    public ReturnCode status(boolean starting) {
        ServerLock serverLock = ServerLock.createTestLock(this.bootProps);
        ReturnCode rc = ReturnCode.OK;
        boolean lockExists = serverLock.lockFileExists();
        rc = lockExists ? (serverLock.testServerRunning() ? ReturnCode.OK : ReturnCode.REDUNDANT_ACTION_STATUS) : ReturnCode.REDUNDANT_ACTION_STATUS;
        if (rc == ReturnCode.OK) {
            String pid = this.getPID();
            if (pid == null) {
                if (starting) {
                    System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverIsAlreadyRunning"), this.serverName));
                } else {
                    System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverIsRunning"), this.serverName));
                }
            } else if (starting) {
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverIsAlreadyRunningWithPID"), this.serverName, pid));
            } else {
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverIsRunningWithPID"), this.serverName, pid));
            }
        } else if (rc == ReturnCode.REDUNDANT_ACTION_STATUS) {
            if (!starting) {
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverNotRunning"), this.serverName));
            }
        } else if (rc == ReturnCode.SERVER_NOT_EXIST_STATUS) {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverNotExist"), this.serverName));
        } else if (!starting) {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverStatusException"), this.serverName));
        } else if (rc == ReturnCode.SERVER_UNKNOWN_STATUS) {
            String pid = this.getPID();
            String pidFile = this.launchArgs.getOption(INTERNAL_PID_FILE);
            if (pid == null || pidFile == null) {
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverStartException"), this.serverName));
            } else {
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverStartUnreachable"), this.serverName, pidFile, pid));
            }
        } else {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverStartException"), this.serverName));
        }
        return rc;
    }

    public ReturnCode startStatus() {
        System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverStarting"), this.serverName));
        ServerLock serverLock = ServerLock.createTestLock(this.bootProps);
        ReturnCode rc = ReturnCode.OK;
        String pid = this.getPID();
        if (serverLock.lockFileExists()) {
            ProcessStatus ps = pid == null ? new FileShareLockProcessStatusImpl(this.consoleLogFile) : new PSProcessStatusImpl(pid);
            rc = serverLock.waitForStart(ps);
            if (rc == ReturnCode.OK) {
                ServerCommandClient scc = new ServerCommandClient(this.bootProps);
                rc = scc.startStatus(serverLock);
            }
        } else {
            rc = ReturnCode.ERROR_SERVER_START;
        }
        if (rc == ReturnCode.OK) {
            if (pid == null) {
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverStarted"), this.serverName));
            } else {
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverStartedWithPID"), this.serverName, pid));
            }
        } else if (rc == ReturnCode.SERVER_COMMAND_PORT_DISABLED_STATUS) {
            if (pid == null) {
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("warning.serverStartedCommandPortDisabled"), this.serverName));
            } else {
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("warning.serverStartedWithPIDCommandPortDisabled"), this.serverName, pid));
            }
            rc = ReturnCode.SERVER_UNKNOWN_STATUS;
        } else {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverStartException"), this.serverName));
        }
        return rc;
    }

    private void parseJavaDumpInclude(Set<JavaDumpAction> javaDumpActions) {
        String includeValue = this.launchArgs.getOption("include");
        if (includeValue != null) {
            for (String include : includeValue.split("\\s*,\\s*")) {
                JavaDumpAction action = JavaDumpAction.forDisplayName(include);
                if (action == null) continue;
                javaDumpActions.add(action);
            }
        }
    }

    public ReturnCode dump() {
        File dumpedFlag;
        boolean serverCommandPortDisabledFlag;
        System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverDumping"), this.serverName));
        LinkedHashSet<JavaDumpAction> javaDumpActions = new LinkedHashSet<JavaDumpAction>();
        this.parseJavaDumpInclude(javaDumpActions);
        ServerDumpPackager sdp = new ServerDumpPackager(this.bootProps, this.launchArgs.getOption("archive"));
        sdp.initializeDumpDirectory();
        ReturnCode dumpRc = this.createDumps(javaDumpActions, true, sdp.getDumpTimestamp());
        boolean serverInactiveStatusFlag = dumpRc == ReturnCode.SERVER_INACTIVE_STATUS;
        boolean serverUnknownStatusFlag = dumpRc == ReturnCode.SERVER_UNKNOWN_STATUS;
        boolean bl = serverCommandPortDisabledFlag = dumpRc == ReturnCode.SERVER_COMMAND_PORT_DISABLED_STATUS;
        if (dumpRc == ReturnCode.OK && !(dumpedFlag = new File(sdp.getDumpDir(), ".dumped")).exists()) {
            dumpRc = ReturnCode.ERROR_SERVER_DUMP;
        }
        if (dumpRc == ReturnCode.OK || dumpRc == ReturnCode.SERVER_INACTIVE_STATUS || dumpRc == ReturnCode.SERVER_UNKNOWN_STATUS || dumpRc == ReturnCode.SERVER_COMMAND_PORT_DISABLED_STATUS) {
            dumpRc = javaDumpActions != null && !javaDumpActions.isEmpty() ? sdp.packageDump(true) : sdp.packageDump(false);
        }
        sdp.cleanupDumpDirectory();
        if (dumpRc == ReturnCode.OK) {
            if (serverInactiveStatusFlag) {
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverNotRunning"), this.serverName));
            }
            if (serverUnknownStatusFlag) {
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverStatusException"), this.serverName));
                dumpRc = ReturnCode.SERVER_UNKNOWN_STATUS;
            }
            if (serverCommandPortDisabledFlag) {
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("warning.serverDumpCompleteCommandPortDisabled"), this.serverName, sdp.getDumpFile().getAbsolutePath()));
            } else {
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverDumpComplete"), this.serverName, sdp.getDumpFile().getAbsolutePath()));
            }
        } else {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverDumpException"), this.serverName));
        }
        return dumpRc;
    }

    public ReturnCode dumpJava() {
        System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverDumping"), this.serverName));
        LinkedHashSet<JavaDumpAction> javaDumpActions = new LinkedHashSet<JavaDumpAction>();
        javaDumpActions.add(JavaDumpAction.THREAD);
        this.parseJavaDumpInclude(javaDumpActions);
        File outputDir = this.bootProps.getOutputFile(null);
        File dumpedFlag = new File(outputDir, ".dumped");
        ReturnCode dumpRc = ReturnCode.JAVADUMP_ACTION;
        Map<JavaDumpAction, Object> files = new EnumMap(JavaDumpAction.class);
        if (!dumpedFlag.delete() && dumpedFlag.exists()) {
            dumpRc = ReturnCode.ERROR_SERVER_DUMP;
        } else {
            dumpRc = this.createDumps(javaDumpActions, false, null);
            if (dumpRc == ReturnCode.OK && (files = ProcessControlHelper.readJavaDumpLocations(dumpedFlag)) == null) {
                dumpRc = ReturnCode.ERROR_SERVER_DUMP;
            }
        }
        boolean isZos = ServerDumpUtil.isZos();
        if (dumpRc == ReturnCode.OK) {
            for (JavaDumpAction javaDumpAction : javaDumpActions) {
                boolean zosJavaDumpSystem;
                String fileName = (String)files.get((Object)javaDumpAction);
                boolean bl = zosJavaDumpSystem = isZos && JavaDumpAction.SYSTEM == javaDumpAction;
                if (fileName.isEmpty() && !zosJavaDumpSystem) {
                    System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverDumpOptionUnsupported"), this.serverName, javaDumpAction.displayName()));
                    dumpRc = ReturnCode.maxRc(dumpRc, ReturnCode.REDUNDANT_ACTION_STATUS);
                    continue;
                }
                if (fileName.startsWith("ERROR")) {
                    System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverDumpException"), this.serverName));
                    dumpRc = ReturnCode.maxRc(dumpRc, ReturnCode.ERROR_SERVER_DUMP);
                    continue;
                }
                if (fileName.isEmpty() && zosJavaDumpSystem) {
                    System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverDumpCompleteZos"), this.serverName));
                    continue;
                }
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverDumpComplete"), this.serverName, fileName));
            }
        } else if (dumpRc == ReturnCode.SERVER_INACTIVE_STATUS) {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverNotRunning"), this.serverName));
        } else if (dumpRc == ReturnCode.SERVER_COMMAND_PORT_DISABLED_STATUS) {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("error.serverJavaDumpCommandPortDisabled"), this.serverName));
        } else {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverDumpException"), this.serverName));
        }
        return dumpRc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<JavaDumpAction, String> readJavaDumpLocations(File javaDumpLocationFile) {
        EnumMap<JavaDumpAction, String> fileLocations = new EnumMap<JavaDumpAction, String>(JavaDumpAction.class);
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(javaDumpLocationFile), "UTF-8"));
            while ((line = reader.readLine()) != null) {
                int index = line.indexOf(61);
                String actionName = line.substring(0, index);
                String fileName = line.substring(index + 1).trim();
                fileLocations.put(JavaDumpAction.valueOf(actionName), fileName);
            }
            Utils.tryToClose(reader);
        }
        catch (IOException ex) {
            Map<JavaDumpAction, String> map = null;
            return map;
        }
        finally {
            Utils.tryToClose(reader);
        }
        return fileLocations;
    }

    private ReturnCode createDumps(Set<JavaDumpAction> javaDumpActions, boolean introspect, String dumpTimestamp) {
        ServerCommandClient scc;
        ServerLock serverLock = ServerLock.createTestLock(this.bootProps);
        ReturnCode dumpRc = ReturnCode.OK;
        boolean lockExists = serverLock.lockFileExists();
        dumpRc = lockExists ? (serverLock.testServerRunning() ? ((scc = new ServerCommandClient(this.bootProps)).isValid() ? (introspect ? scc.introspectServer(dumpTimestamp, javaDumpActions) : scc.javaDump(javaDumpActions)) : ReturnCode.SERVER_UNKNOWN_STATUS) : ReturnCode.SERVER_INACTIVE_STATUS) : ReturnCode.SERVER_INACTIVE_STATUS;
        return dumpRc;
    }
}

