/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal.commands;

import com.ibm.ws.kernel.boot.BootstrapConfig;
import com.ibm.ws.kernel.boot.Debug;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.archive.Archive;
import com.ibm.ws.kernel.boot.archive.ArchiveEntryConfig;
import com.ibm.ws.kernel.boot.archive.ArchiveFactory;
import com.ibm.ws.kernel.boot.archive.DirEntryConfig;
import com.ibm.ws.kernel.boot.archive.DirPattern;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.boot.internal.FileUtils;
import com.ibm.ws.kernel.boot.internal.commands.ArchiveProcessor;
import com.ibm.ws.kernel.boot.internal.commands.ProcessorUtils;
import com.ibm.ws.kernel.provisioning.ProductExtension;
import com.ibm.ws.kernel.provisioning.ProductExtensionInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;

public class PackageProcessor
implements ArchiveProcessor {
    private final String processName;
    private final File packageFile;
    private final BootstrapConfig bootProps;
    private final List<ArchiveProcessor.Pair<PackageOption, String>> options;
    public static final String PACKAGE_ARCHIVE_ENTRY_PREFIX = "wlp/";
    protected static final String DEFAULT_CONFIG_LOCATION_KEY = "configLocation";
    private final File wlpUserDir;
    private final File processConfigDir;
    private final File workAreaTmpDir;
    private final Set<File> looseFiles = new HashSet<File>();
    private final Set<String> processContent;

    public PackageProcessor(String processName, File packageFile, BootstrapConfig bootProps, List<ArchiveProcessor.Pair<PackageOption, String>> options, Set<String> processContent) {
        this.processName = processName;
        this.packageFile = packageFile;
        this.bootProps = bootProps;
        this.options = options;
        this.wlpUserDir = bootProps.getUserRoot();
        this.processConfigDir = bootProps.getConfigFile(null);
        this.processContent = processContent;
        this.workAreaTmpDir = new File(bootProps.get("server.tmp.dir"));
        this.workAreaTmpDir.mkdirs();
    }

    private boolean isIncludeOptionEqualToUsr() {
        if (this.options == null) {
            return false;
        }
        for (ArchiveProcessor.Pair<PackageOption, String> option : this.options) {
            if (!PackageOption.INCLUDE.equals((Object)option.getPairKey()) || !IncludeOption.USR.getValue().equals(option.getPairValue())) continue;
            return true;
        }
        return false;
    }

    protected File buildManifestForIncludeEqualsUsr(File installationManifest) throws IOException {
        Manifest mf = new Manifest();
        mf.read(new FileInputStream(installationManifest));
        mf.getMainAttributes().remove(new Attributes.Name("License-Agreement"));
        mf.getMainAttributes().remove(new Attributes.Name("License-Information"));
        mf.getMainAttributes().remove(new Attributes.Name("Applies-To"));
        mf.getMainAttributes().remove(new Attributes.Name("Extract-Installer"));
        mf.getMainAttributes().putValue("Applies-To", "com.ibm.websphere.appserver");
        mf.getMainAttributes().putValue("Extract-Installer", "false");
        File newMani = new File(this.workAreaTmpDir, "MANIFEST.usrinclude.tmp");
        mf.write(new FileOutputStream(newMani));
        return newMani;
    }

    private boolean doesIncludeOptionHaveRunnable() {
        if (this.options == null) {
            return false;
        }
        for (ArchiveProcessor.Pair<PackageOption, String> option : this.options) {
            if (!PackageOption.INCLUDE.equals((Object)option.getPairKey()) || !IncludeOption.RUNNABLE.getValue().equals(option.getPairValue()) && !IncludeOption.ALLRUNNABLE.getValue().equals(option.getPairValue()) && !IncludeOption.MINIFYRUNNABLE.getValue().equals(option.getPairValue())) continue;
            return true;
        }
        return false;
    }

    protected File buildManifestForIncludeHasRunnable(File installationManifest) throws IOException {
        Manifest mf = new Manifest();
        mf.read(new FileInputStream(installationManifest));
        mf.getMainAttributes().remove(new Attributes.Name("License-Agreement"));
        mf.getMainAttributes().remove(new Attributes.Name("License-Information"));
        mf.getMainAttributes().putValue("Main-Class", "wlp.lib.extract.SelfExtractRun");
        mf.getMainAttributes().putValue("Server-Name", this.processName);
        File newMani = new File(this.workAreaTmpDir, "MANIFEST.usrinclude.tmp");
        mf.write(new FileOutputStream(newMani));
        return newMani;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnCode execute(boolean runtimeOnly) {
        Archive archive = null;
        try {
            archive = ArchiveFactory.create(this.packageFile);
            if (this.packageFile.getName().endsWith(".jar")) {
                File manifest = new File(this.bootProps.getInstallRoot(), "lib/extract/META-INF/MANIFEST.MF");
                if (!manifest.exists()) {
                    manifest = new File(this.bootProps.getInstallRoot().getParentFile(), "META-INF/MANIFEST.MF");
                }
                if (!manifest.exists()) {
                    System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("error.minify.missing.manifest"), this.processName));
                    ReturnCode returnCode = ReturnCode.ERROR_SERVER_PACKAGE;
                    return returnCode;
                }
                if (this.isIncludeOptionEqualToUsr()) {
                    archive.addFileEntry("META-INF/MANIFEST.MF", this.buildManifestForIncludeEqualsUsr(manifest));
                } else if (this.doesIncludeOptionHaveRunnable()) {
                    archive.addFileEntry("META-INF/MANIFEST.MF", this.buildManifestForIncludeHasRunnable(manifest));
                } else {
                    archive.addFileEntry("META-INF/MANIFEST.MF", manifest);
                }
                archive.addEntryConfigs(this.createSelfExtractEntryConfigs());
            }
            if (null == this.options || this.options.isEmpty()) {
                archive.addEntryConfigs(this.createAllConfigs(this.processName, runtimeOnly));
            } else {
                for (ArchiveProcessor.Pair<PackageOption, String> option : this.options) {
                    if (!PackageOption.INCLUDE.equals((Object)option.getPairKey())) continue;
                    String val = option.getPairValue();
                    if (this.includeAllorRunnable(val)) {
                        archive.addEntryConfigs(this.createAllConfigs(this.processName, runtimeOnly));
                        continue;
                    }
                    if (this.includeUsr(val)) {
                        archive.addEntryConfigs(this.createUsrConfigs(this.processName, true));
                        continue;
                    }
                    if (this.bootProps.getProcessType() != "client" && this.includeMinifyorMinifyRunnable(val)) {
                        archive.addEntryConfigs(this.createMinifyConfigs(this.processName));
                        continue;
                    }
                    System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("warn.packageServer.include.unknownOption"), val));
                    archive.addEntryConfigs(this.createAllConfigs(this.processName, runtimeOnly));
                }
            }
            archive.create();
        }
        catch (IOException e) {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("error.unableZipDir"), e));
            Debug.printStackTrace(e);
            ReturnCode returnCode = ReturnCode.ERROR_SERVER_PACKAGE;
            return returnCode;
        }
        finally {
            Utils.tryToClose(archive);
            FileUtils.recursiveClean(this.workAreaTmpDir);
        }
        return ReturnCode.OK;
    }

    private boolean includeAllorRunnable(String val) {
        if (IncludeOption.ALL.getValue().equals(val)) {
            return true;
        }
        if (IncludeOption.RUNNABLE.getValue().equals(val)) {
            return true;
        }
        return IncludeOption.ALLRUNNABLE.getValue().equals(val);
    }

    private boolean includeMinifyorMinifyRunnable(String val) {
        if (IncludeOption.MINIFY.getValue().equals(val)) {
            return true;
        }
        return IncludeOption.MINIFYRUNNABLE.getValue().equals(val);
    }

    private boolean includeUsr(String val) {
        return IncludeOption.USR.getValue().equals(val);
    }

    private List<ArchiveEntryConfig> createSelfExtractEntryConfigs() throws IOException {
        ArrayList<ArchiveEntryConfig> entryConfigs = new ArrayList<ArchiveEntryConfig>();
        File metaInf = new File(this.bootProps.getInstallRoot(), "lib/extract/META-INF");
        if (!metaInf.exists()) {
            File aboveRoot = this.bootProps.getInstallRoot().getParentFile();
            metaInf = new File(aboveRoot, "META-INF");
        }
        DirEntryConfig metaInfDirConfig = new DirEntryConfig("META-INF/", metaInf, false, DirPattern.PatternStrategy.IncludePreference);
        metaInfDirConfig.exclude(Pattern.compile(Pattern.quote(new File(metaInf, "MANIFEST.MF").getAbsolutePath())));
        entryConfigs.add(metaInfDirConfig);
        this.addLibExtractDir(entryConfigs);
        return entryConfigs;
    }

    private List<ArchiveEntryConfig> createMinifyConfigs(String processName) throws IOException {
        ArrayList<ArchiveEntryConfig> entryConfigs = new ArrayList<ArchiveEntryConfig>();
        Set<String> featureResourcePaths = this.processContent;
        DirEntryConfig rootDirConfig = new DirEntryConfig(PACKAGE_ARCHIVE_ENTRY_PREFIX, this.bootProps.getInstallRoot(), false, DirPattern.PatternStrategy.ExcludePreference);
        entryConfigs.add(rootDirConfig);
        ArrayList<DirEntryConfig> extensionDirConfigs = new ArrayList<DirEntryConfig>();
        for (ProductExtensionInfo info : ProductExtension.getProductExtensions()) {
            File extensionDir = new File(info.getLocation());
            if (!extensionDir.isAbsolute()) {
                File parentDir = this.bootProps.getInstallRoot().getParentFile();
                extensionDir = ProcessorUtils.getFileFromDirectory(parentDir, info.getLocation());
            }
            DirEntryConfig looseExtensionDirConfig = new DirEntryConfig(info.getLocation(), extensionDir, false, DirPattern.PatternStrategy.ExcludePreference);
            extensionDirConfigs.add(looseExtensionDirConfig);
        }
        for (String s : featureResourcePaths) {
            String match = Pattern.quote(s);
            Pattern featurePattern = Pattern.compile(match);
            rootDirConfig.include(featurePattern);
            for (DirEntryConfig extensionDirConfig : extensionDirConfigs) {
                extensionDirConfig.include(featurePattern);
                entryConfigs.add(extensionDirConfig);
            }
        }
        boolean isJarPackage = this.packageFile.getName().endsWith(".jar");
        File lafilesDir = new File(this.bootProps.getInstallRoot(), "lafiles");
        if (lafilesDir.exists()) {
            DirEntryConfig lafilesDirConfig = new DirEntryConfig("wlp/lafiles", lafilesDir, true, DirPattern.PatternStrategy.IncludePreference);
            entryConfigs.add(lafilesDirConfig);
        } else if (isJarPackage) {
            throw new FileNotFoundException(lafilesDir.toString());
        }
        File templatesDir = new File(this.bootProps.getInstallRoot(), "templates");
        DirEntryConfig templatesDirConfig = new DirEntryConfig("wlp/templates", templatesDir, true, DirPattern.PatternStrategy.IncludePreference);
        entryConfigs.add(templatesDirConfig);
        if (!isJarPackage) {
            this.addLibExtractDir(entryConfigs);
        }
        entryConfigs.addAll(this.createUsrConfigs(processName, false));
        entryConfigs.addAll(this.createPkgInfoConfigs(processName));
        return entryConfigs;
    }

    private void addLibExtractDir(List<ArchiveEntryConfig> entryConfigs) throws IOException {
        try {
            File libExtractDir = new File(this.bootProps.getInstallRoot(), "lib/extract");
            DirEntryConfig libExtractDirConfig = new DirEntryConfig("wlp/lib/extract", libExtractDir, true, DirPattern.PatternStrategy.IncludePreference);
            entryConfigs.add(libExtractDirConfig);
        }
        catch (FileNotFoundException ex) {
            System.out.println(BootstrapConstants.messages.getString("error.package.missingLibExtractDir"));
            throw ex;
        }
    }

    private List<ArchiveEntryConfig> createAllConfigs(String processName, boolean runtimeOnly) throws IOException {
        ArrayList<ArchiveEntryConfig> entryConfigs = new ArrayList<ArchiveEntryConfig>();
        String regexInstallRootName = Pattern.quote(this.bootProps.getInstallRoot().getName());
        DirEntryConfig rootDirConfig = new DirEntryConfig(PACKAGE_ARCHIVE_ENTRY_PREFIX, this.bootProps.getInstallRoot(), true, DirPattern.PatternStrategy.IncludePreference);
        entryConfigs.add(rootDirConfig);
        rootDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexInstallRootName + REGEX_SEPARATOR + "usr"));
        if (this.packageFile.getName().endsWith(".jar")) {
            File libExtract = new File(this.bootProps.getInstallRoot(), "lib/extract");
            rootDirConfig.exclude(Pattern.compile(Pattern.quote(libExtract.getAbsolutePath())));
        }
        String installRootAbsPath = this.bootProps.getInstallRoot().getAbsolutePath();
        String userRootAbsPath = this.bootProps.getUserRoot().getAbsolutePath();
        String processOutputAbsPath = this.bootProps.getOutputFile(null).getAbsolutePath();
        if (userRootAbsPath.contains(installRootAbsPath)) {
            rootDirConfig.exclude(Pattern.compile(Pattern.quote(userRootAbsPath)));
        }
        if (processOutputAbsPath.contains(installRootAbsPath)) {
            rootDirConfig.exclude(Pattern.compile(Pattern.quote(processOutputAbsPath)));
        }
        if (!runtimeOnly) {
            entryConfigs.addAll(this.createUsrConfigs(processName, true));
        }
        entryConfigs.addAll(this.createPkgInfoConfigs(processName));
        File prodExtDir = ProcessorUtils.getFileFromDirectory(this.wlpUserDir.getParentFile(), "/etc/extensions");
        if (prodExtDir.exists()) {
            DirEntryConfig prodExtDirConfig = new DirEntryConfig("wlp/etc/extensions", prodExtDir, true, DirPattern.PatternStrategy.IncludePreference);
            entryConfigs.add(prodExtDirConfig);
        }
        for (ProductExtensionInfo info : ProductExtension.getProductExtensions()) {
            File extensionDir = new File(info.getLocation());
            if (!extensionDir.isAbsolute()) {
                File parentDir = this.bootProps.getInstallRoot().getParentFile();
                extensionDir = ProcessorUtils.getFileFromDirectory(parentDir, info.getLocation());
            }
            DirEntryConfig looseExtensionDirConfig = new DirEntryConfig(info.getLocation(), extensionDir, true, DirPattern.PatternStrategy.IncludePreference);
            entryConfigs.add(looseExtensionDirConfig);
        }
        return entryConfigs;
    }

    private List<ArchiveEntryConfig> createUsrConfigs(String processName, boolean addUsrExtension) throws IOException {
        File extensionDir;
        ArrayList<ArchiveEntryConfig> entryConfigs = new ArrayList<ArchiveEntryConfig>();
        this.getReferencedResources(entryConfigs);
        String locAreaName = "servers";
        if (this.bootProps.getProcessType() == "client") {
            locAreaName = "clients";
        }
        DirEntryConfig processConfigDirConfig = new DirEntryConfig("wlp/usr/" + locAreaName + "/" + processName + "/", this.processConfigDir, true, DirPattern.PatternStrategy.IncludePreference);
        entryConfigs.add(processConfigDirConfig);
        String regexProcessName = Pattern.quote(processName);
        processConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexProcessName + REGEX_SEPARATOR + "workarea"));
        processConfigDirConfig.include(Pattern.compile(REGEX_SEPARATOR + regexProcessName + REGEX_SEPARATOR + "workarea" + REGEX_SEPARATOR + "\\.sLock$"));
        processConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexProcessName + REGEX_SEPARATOR + "logs"));
        processConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexProcessName + REGEX_SEPARATOR + "dump_" + "\\d\\d\\.\\d\\d\\.\\d\\d_\\d\\d\\.\\d\\d\\.\\d\\d"));
        processConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexProcessName + REGEX_SEPARATOR + "core\\.[^\\\\/]+\\.dmp"));
        processConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexProcessName + REGEX_SEPARATOR + "heapdump\\.[^\\\\/]+\\.phd"));
        processConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexProcessName + REGEX_SEPARATOR + "java\\.[^\\\\/]+\\.hprof"));
        processConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexProcessName + REGEX_SEPARATOR + "javacore\\.[^\\\\/]+\\.txt"));
        processConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexProcessName + REGEX_SEPARATOR + "javadump\\.[^\\\\/]+\\.txt"));
        processConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexProcessName + "\\.(zip|pax|jar)$"));
        processConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexProcessName + "\\.dump-" + "\\d\\d\\.\\d\\d\\.\\d\\d_\\d\\d\\.\\d\\d\\.\\d\\d" + "\\.(zip|pax)$"));
        processConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexProcessName + REGEX_SEPARATOR + "package_" + "\\d\\d\\.\\d\\d\\.\\d\\d_\\d\\d\\.\\d\\d\\.\\d\\d" + "\\.txt"));
        for (File app : this.looseFiles) {
            String appName = "." + app.getName().replace(".", "\\.");
            processConfigDirConfig.exclude(Pattern.compile(appName));
        }
        File sharedDir = ProcessorUtils.getFileFromDirectory(this.wlpUserDir, "shared");
        if (sharedDir.exists()) {
            DirEntryConfig serverSharedDirConfig = new DirEntryConfig("wlp/usr/shared/", sharedDir, true, DirPattern.PatternStrategy.IncludePreference);
            entryConfigs.add(serverSharedDirConfig);
            serverSharedDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + "resources" + REGEX_SEPARATOR + "security" + REGEX_SEPARATOR + "key.jks"));
            for (File app : this.looseFiles) {
                String appName = "." + app.getName().replace(".", "\\.");
                if (!FileUtils.isUnderDirectory(app, sharedDir)) continue;
                serverSharedDirConfig.exclude(Pattern.compile(appName));
            }
        }
        if (addUsrExtension && (extensionDir = ProcessorUtils.getFileFromDirectory(this.wlpUserDir, "extension")).exists()) {
            DirEntryConfig serverExtensionDirConfig = new DirEntryConfig("wlp/usr/extension/", extensionDir, true, DirPattern.PatternStrategy.IncludePreference);
            entryConfigs.add(serverExtensionDirConfig);
        }
        return entryConfigs;
    }

    private List<ArchiveEntryConfig> createPkgInfoConfigs(String processName) throws IOException {
        ArrayList<ArchiveEntryConfig> entryConfigs = new ArrayList<ArchiveEntryConfig>();
        String regexProcessName = Pattern.quote(processName);
        DirEntryConfig processPkgInfoConfig = new DirEntryConfig("wlp/lib/versions/", this.bootProps.getOutputFile(null), false, DirPattern.PatternStrategy.IncludePreference);
        entryConfigs.add(processPkgInfoConfig);
        processPkgInfoConfig.include(Pattern.compile(REGEX_SEPARATOR + regexProcessName + REGEX_SEPARATOR + "package_" + "\\d\\d\\.\\d\\d\\.\\d\\d_\\d\\d\\.\\d\\d\\.\\d\\d" + "\\.txt"));
        return entryConfigs;
    }

    private void getReferencedResources(List<ArchiveEntryConfig> entryConfigs) throws IOException {
        this.getLooseApplications(entryConfigs);
    }

    private void getLooseApplications(List<ArchiveEntryConfig> entryConfigs) throws IOException {
        this.looseFiles.addAll(ProcessorUtils.getLooseConfigFiles(this.bootProps));
        Iterator<File> it = this.looseFiles.iterator();
        while (it.hasNext()) {
            File lf = it.next();
            ProcessorUtils.LooseConfig looseConfig = null;
            try {
                looseConfig = ProcessorUtils.convertToLooseConfig(lf);
                if (looseConfig != null) {
                    try {
                        ArchiveEntryConfig looseArchiveEntryConfig = ProcessorUtils.createLooseArchiveEntryConfig(looseConfig, lf, this.bootProps);
                        entryConfigs.add(looseArchiveEntryConfig);
                    }
                    catch (FileNotFoundException e) {
                        System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("warning.unableToPackageLooseConfigFileMissingPath"), lf));
                        Debug.printStackTrace(e);
                        it.remove();
                    }
                    continue;
                }
                it.remove();
            }
            catch (Exception e) {
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("warn.package.invalid.looseFile"), lf));
                Debug.printStackTrace(e);
                it.remove();
            }
        }
    }

    public static enum IncludeOption {
        ALL("all"),
        USR("usr"),
        MINIFY("minify"),
        WLP("wlp"),
        RUNNABLE("runnable"),
        ALLRUNNABLE("all,runnable"),
        MINIFYRUNNABLE("minify,runnable");

        private final String value;

        private IncludeOption(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum PackageOption {
        INCLUDE;

    }
}

