/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal.commands;

import com.ibm.ws.kernel.boot.internal.commands.JavaDumpAction;
import com.ibm.ws.kernel.boot.internal.commands.JavaDumper;
import java.io.File;
import java.lang.reflect.Method;

class IBMJavaDumperImpl
extends JavaDumper {
    private final Method javaDumpToFileMethod;
    private final Method heapDumpToFileMethod;
    private final Method systemDumpToFileMethod;

    IBMJavaDumperImpl(Method javaDumpToFileMethod, Method heapDumpToFileMethod, Method systemDumpToFileMethod) {
        this.javaDumpToFileMethod = javaDumpToFileMethod;
        this.heapDumpToFileMethod = heapDumpToFileMethod;
        this.systemDumpToFileMethod = systemDumpToFileMethod;
    }

    @Override
    public File dump(JavaDumpAction action, File outputDir) {
        String resultPath;
        Method method;
        switch (action) {
            case HEAP: {
                method = this.heapDumpToFileMethod;
                break;
            }
            case SYSTEM: {
                method = this.systemDumpToFileMethod;
                break;
            }
            case THREAD: {
                method = this.javaDumpToFileMethod;
                break;
            }
            default: {
                return null;
            }
        }
        try {
            Object fileNamePattern = null;
            resultPath = (String)method.invoke(null, fileNamePattern);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new File(resultPath);
    }
}

