/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal.commands;

import com.ibm.ws.kernel.boot.BootstrapConfig;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.archive.Archive;
import com.ibm.ws.kernel.boot.archive.ArchiveEntryConfig;
import com.ibm.ws.kernel.boot.archive.ArchiveFactory;
import com.ibm.ws.kernel.boot.archive.DirEntryConfig;
import com.ibm.ws.kernel.boot.archive.DirPattern;
import com.ibm.ws.kernel.boot.archive.FileEntryConfig;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.boot.internal.commands.ArchiveProcessor;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class DumpProcessor
implements ArchiveProcessor {
    private final String serverName;
    private final File dumpFile;
    private final BootstrapConfig bootProps;
    private final List<String> javaDumps;

    public DumpProcessor(String serverName, File dumpFile, BootstrapConfig bootProps, List<String> javaDumps) {
        this.serverName = serverName;
        this.dumpFile = dumpFile;
        this.bootProps = bootProps;
        this.javaDumps = javaDumps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnCode execute() {
        Archive archive = null;
        try {
            archive = ArchiveFactory.create(this.dumpFile);
            archive.addEntryConfigs(this.createDumpConfigs(this.serverName));
            archive.create();
        }
        catch (IOException e) {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("error.unableZipDir"), e));
            ReturnCode returnCode = ReturnCode.ERROR_SERVER_DUMP;
            return returnCode;
        }
        finally {
            Utils.tryToClose(archive);
        }
        return ReturnCode.OK;
    }

    private List<ArchiveEntryConfig> createDumpConfigs(String serverName) throws IOException {
        ArrayList<ArchiveEntryConfig> entryConfigs = new ArrayList<ArchiveEntryConfig>();
        String regexServerName = Pattern.quote(serverName);
        File serverConfigDir = new File(this.bootProps.getUserRoot(), "servers/" + serverName);
        DirEntryConfig serverConfigDirConfig = new DirEntryConfig("", serverConfigDir, true, DirPattern.PatternStrategy.ExcludePreference);
        entryConfigs.add(serverConfigDirConfig);
        serverConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexServerName + REGEX_SEPARATOR + "dropins"));
        serverConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexServerName + REGEX_SEPARATOR + "apps"));
        serverConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + "resources" + REGEX_SEPARATOR + "security"));
        serverConfigDirConfig.exclude(Pattern.compile("\\.jks$"));
        serverConfigDirConfig.exclude(Pattern.compile("\\.p12$"));
        serverConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexServerName + REGEX_SEPARATOR + "dump_" + "\\d\\d\\.\\d\\d\\.\\d\\d_\\d\\d\\.\\d\\d\\.\\d\\d"));
        serverConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexServerName + REGEX_SEPARATOR + "autopd"));
        serverConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexServerName + REGEX_SEPARATOR + "logs"));
        serverConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexServerName + REGEX_SEPARATOR + "workarea"));
        serverConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexServerName + "\\.(zip|pax)$"));
        serverConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexServerName + "\\.dump-" + "\\d\\d\\.\\d\\d\\.\\d\\d_\\d\\d\\.\\d\\d\\.\\d\\d" + "\\.(zip|pax)$"));
        serverConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexServerName + REGEX_SEPARATOR + "core\\.[^\\\\/]+\\.dmp"));
        serverConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexServerName + REGEX_SEPARATOR + "heapdump\\.[^\\\\/]+\\.phd"));
        serverConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexServerName + REGEX_SEPARATOR + "java\\.[^\\\\/]+\\.hprof"));
        serverConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexServerName + REGEX_SEPARATOR + "javacore\\.[^\\\\/]+\\.txt"));
        serverConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexServerName + REGEX_SEPARATOR + "javadump\\.[^\\\\/]+\\.txt"));
        File serverOutputDir = this.bootProps.getOutputFile(null);
        DirEntryConfig serverOutputDirConfig = new DirEntryConfig("", serverOutputDir, false, DirPattern.PatternStrategy.ExcludePreference);
        entryConfigs.add(serverOutputDirConfig);
        serverOutputDirConfig.include(Pattern.compile(REGEX_SEPARATOR + regexServerName + REGEX_SEPARATOR + "dump_" + "\\d\\d\\.\\d\\d\\.\\d\\d_\\d\\d\\.\\d\\d\\.\\d\\d"));
        serverOutputDirConfig.include(Pattern.compile(REGEX_SEPARATOR + regexServerName + REGEX_SEPARATOR + "autopd"));
        serverOutputDirConfig.include(Pattern.compile(REGEX_SEPARATOR + regexServerName + REGEX_SEPARATOR + "logs"));
        serverOutputDirConfig.include(Pattern.compile(REGEX_SEPARATOR + regexServerName + REGEX_SEPARATOR + "workarea"));
        serverOutputDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexServerName + REGEX_SEPARATOR + "workarea" + REGEX_SEPARATOR + "\\.sLock$"));
        serverOutputDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexServerName + REGEX_SEPARATOR + "workarea" + REGEX_SEPARATOR + "\\.sCommand$"));
        serverOutputDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexServerName + REGEX_SEPARATOR + "workarea" + REGEX_SEPARATOR + ".*" + "org\\.eclipse\\.osgi" + REGEX_SEPARATOR + "\\.manager"));
        serverOutputDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexServerName + REGEX_SEPARATOR + "workarea" + REGEX_SEPARATOR + "org\\.eclipse\\.osgi" + REGEX_SEPARATOR + "bundles" + REGEX_SEPARATOR + "\\d+" + REGEX_SEPARATOR + "data" + REGEX_SEPARATOR + ".*com\\.ibm\\.ws\\.app\\.manager_gen"));
        if (!this.javaDumps.isEmpty()) {
            for (String javaDump : this.javaDumps) {
                File f = new File(javaDump);
                if (f.exists()) {
                    FileEntryConfig feg = new FileEntryConfig("", f);
                    entryConfigs.add(feg);
                    continue;
                }
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("error.missingDumpFile"), javaDump));
            }
        }
        return entryConfigs;
    }
}

