/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.delegated.zos;

import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.boot.internal.KernelUtils;
import java.io.File;
import java.text.MessageFormat;

public final class NativeMethodHelper {
    private static final String DLL_NAME = "zNativeServices";
    private static Throwable loadFailure = null;
    static String libraryName = null;
    private static final boolean initialized = NativeMethodHelper.loadAndInitialize();

    public static long registerNatives(Class<?> clazz, String nativeDescriptorName, Object[] extraInfo) {
        if (!initialized) {
            if (loadFailure != null) {
                UnsatisfiedLinkError e = new UnsatisfiedLinkError();
                e.initCause(loadFailure);
                throw e;
            }
            return 0L;
        }
        return NativeMethodHelper.ntv_registerNatives(clazz, nativeDescriptorName, extraInfo);
    }

    public static long deregisterNatives(long dllHandle, Class<?> clazz, String nativeDescriptorName, Object[] extraInfo) {
        if (!initialized) {
            if (loadFailure != null) {
                UnsatisfiedLinkError e = new UnsatisfiedLinkError();
                e.initCause(loadFailure);
                throw e;
            }
            return 0L;
        }
        return NativeMethodHelper.ntv_deregisterNatives(dllHandle, clazz, nativeDescriptorName, extraInfo);
    }

    private static final boolean loadAndInitialize() {
        try {
            libraryName = System.mapLibraryName(DLL_NAME);
            System.loadLibrary(DLL_NAME);
            return true;
        }
        catch (Throwable t) {
            try {
                String wasLibPath = KernelUtils.getBootstrapLibDir().getAbsolutePath();
                String wasLibrary = wasLibPath + "/native/zos/s390x/" + System.mapLibraryName(DLL_NAME);
                if (new File(wasLibrary).exists()) {
                    libraryName = wasLibrary;
                    System.load(wasLibrary);
                    return true;
                }
            }
            catch (Throwable t2) {
                loadFailure = t2;
                System.err.println(MessageFormat.format(BootstrapConstants.messages.getString("error.loadNativeLibrary"), libraryName));
            }
            libraryName = null;
            return false;
        }
    }

    private static final native long ntv_registerNatives(Class<?> var0, String var1, Object[] var2);

    private static final native long ntv_deregisterNatives(long var0, Class<?> var2, String var3, Object[] var4);
}

