/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.cmdline;

import com.ibm.ws.kernel.boot.cmdline.ExtensionUtils;
import com.ibm.ws.kernel.boot.cmdline.LaunchManifest;
import com.ibm.ws.kernel.boot.cmdline.PackageDelegateClassLoader;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.provisioning.AbstractResourceRepository;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.kernel.provisioning.NameBasedLocalBundleRepository;
import com.ibm.ws.kernel.provisioning.VersionUtility;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class UtilityMain {
    private static final String DEFAULT_BUNDLE_VERSION = "0.0.0";

    public static void main(String[] args) {
        try {
            UtilityMain.internal_main(args);
        }
        catch (InvocationTargetException e) {
            Throwable ite = e.getTargetException();
            if (ite != null) {
                ite.printStackTrace();
            } else {
                e.printStackTrace();
            }
            System.exit(32);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(32);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void internal_main(String[] args) throws IOException, ClassNotFoundException, SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String jarName = System.getProperty("java.class.path");
        JarFile jarFile = new JarFile(new File(jarName));
        Attributes a = jarFile.getManifest().getMainAttributes();
        jarFile.close();
        String commandClass = a.getValue("Command-Class");
        String requiredBundles = a.getValue("Require-Bundle");
        String parentCL = a.getValue("Parent-ClassLoader");
        String parentLastPackages = a.getValue("Parent-Last-Package");
        String requireCompiler = a.getValue("Require-Compiler");
        boolean bootstrapCLParent = false;
        boolean compilerTools = false;
        if ("bootstrap".equals(parentCL)) {
            bootstrapCLParent = true;
        }
        if ("true".equals(requireCompiler)) {
            compilerTools = true;
        }
        List<LaunchManifest.RequiredBundle> rbs = LaunchManifest.parseRequireBundle(requiredBundles);
        BundleRepositoryRegistry.initializeDefaults(null, false);
        List<AbstractResourceRepository> repos = UtilityMain.getAllRepositories();
        List<URL> urls = new ArrayList<URL>();
        urls = UtilityMain.selectResources(repos, rbs, urls);
        String extensions = a.getValue("IBM-RequiredExtensions");
        if (extensions != null && !extensions.isEmpty()) {
            for (String extension : extensions.split(",")) {
                List<LaunchManifest.RequiredBundle> rbsExt = ExtensionUtils.findExtensionBundles(extension.trim());
                if (rbsExt == null || rbsExt.isEmpty()) continue;
                urls = UtilityMain.selectResources(repos, rbsExt, urls);
            }
        }
        if (compilerTools) {
            File toolsFile = Utils.getJavaTools();
            if (toolsFile != null) {
                urls.add(toolsFile.toURI().toURL());
            } else if (!Utils.hasToolsByDefault()) {
                UtilityMain.error("error.sdkRequired", System.getProperty("java.home"));
                System.exit(30);
                return;
            }
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader originalContextLoader = currentThread.getContextClassLoader();
        URL[] urlArray = urls.toArray(new URL[urls.size()]);
        List<String> parentLastPackageList = LaunchManifest.parseHeaderList(parentLastPackages);
        ClassLoader parentLoader = bootstrapCLParent ? null : UtilityMain.class.getClassLoader();
        PackageDelegateClassLoader cl = new PackageDelegateClassLoader(urlArray, parentLoader, parentLastPackageList);
        currentThread.setContextClassLoader(cl);
        try {
            Class<?> clazz = cl.loadClass(commandClass);
            Method m = clazz.getMethod("main", args.getClass());
            m.invoke(null, new Object[]{args});
        }
        finally {
            currentThread.setContextClassLoader(originalContextLoader);
        }
    }

    private static String format(String key, Object ... args) {
        String string = Utils.getResourceBundleString(key);
        return args == null || args.length == 0 ? string : MessageFormat.format(string, args);
    }

    private static void error(String key, Object ... args) {
        System.err.println(UtilityMain.format(key, args));
    }

    private static boolean isValidJavaSpecVersion(LaunchManifest.RequiredBundle rb) {
        String vrString = rb.getAttribute("java.specification.version");
        if (vrString == null) {
            return true;
        }
        VersionRange vr = new VersionRange(vrString);
        Version v = new Version(System.getProperty("java.specification.version"));
        return vr.includes(v);
    }

    private static List<URL> selectResources(List<AbstractResourceRepository> repos, List<LaunchManifest.RequiredBundle> rbs, List<URL> urls) throws MalformedURLException {
        for (LaunchManifest.RequiredBundle rb : rbs) {
            URL url;
            AbstractResourceRepository repo;
            String bundleVersion = rb.getAttribute("version");
            String string = bundleVersion = null != bundleVersion ? bundleVersion : DEFAULT_BUNDLE_VERSION;
            if (!UtilityMain.isValidJavaSpecVersion(rb)) continue;
            File f = null;
            Iterator<AbstractResourceRepository> i$ = repos.iterator();
            while (i$.hasNext() && (f = (repo = i$.next()).selectResource(rb.getAttribute("location"), rb.getSymbolicName(), VersionUtility.stringToVersionRange(bundleVersion))) == null) {
            }
            if (f == null || urls.contains(url = f.toURI().toURL())) continue;
            urls.add(url);
        }
        return urls;
    }

    private static List<AbstractResourceRepository> getAllRepositories() {
        ArrayList<AbstractResourceRepository> repos = new ArrayList<AbstractResourceRepository>();
        repos.add(new NameBasedLocalBundleRepository(Utils.getInstallDir()));
        List<File> extDirs = ExtensionUtils.listProductExtensionDirectories();
        for (File extDir : extDirs) {
            repos.add(new NameBasedLocalBundleRepository(extDir));
        }
        return repos;
    }
}

