/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.http.internal.VirtualHostMap;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class HostAlias {
    final String hostName;
    final String portString;
    int port;
    final boolean isValid;
    static final Pattern validPort;
    static final long serialVersionUID = -2490102146263714390L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    HostAlias(String host, int port) {
        this.port = port;
        this.hostName = host;
        this.portString = Integer.toString(port);
        this.isValid = true;
    }

    @FFDCIgnore(value={URISyntaxException.class})
    HostAlias(String alias, String virtualHostName) {
        String port = "80";
        String host = "";
        boolean valid = true;
        try {
            int pos = alias.lastIndexOf(58);
            if (pos < 0 || alias.endsWith("]")) {
                host = alias;
            } else {
                Matcher portMatch = validPort.matcher(alias);
                if (portMatch.matches()) {
                    host = portMatch.group(1);
                    port = portMatch.group(2);
                } else {
                    throw new URISyntaxException(alias, Tr.formatMessage((TraceComponent)VirtualHostMap.tc, (String)"badHostPortReason", (Object[])new Object[0]));
                }
            }
            if (host.contains("*")) {
                if (host.length() > 1) {
                    throw new URISyntaxException(alias, Tr.formatMessage((TraceComponent)VirtualHostMap.tc, (String)"wildcardReason", (Object[])new Object[0]));
                }
            } else {
                URI uri = new URI("http://" + host);
                host = uri.getHost();
                if (host == null) {
                    throw new URISyntaxException(alias, Tr.formatMessage((TraceComponent)VirtualHostMap.tc, (String)"badHostPortReason", (Object[])new Object[0]));
                }
            }
        }
        catch (URISyntaxException ex) {
            Tr.warning((TraceComponent)VirtualHostMap.tc, (String)"invalidAlias", (Object[])new Object[]{virtualHostName, ex.getMessage()});
            valid = false;
        }
        this.hostName = host == null ? "" : host.toLowerCase(Locale.ENGLISH);
        this.portString = port;
        this.port = Integer.valueOf(port);
        this.isValid = valid;
    }

    public String toString() {
        return this.hostName + ':' + this.portString;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hostName == null ? 0 : this.hostName.hashCode());
        result = 31 * result + (this.portString == null ? 0 : this.portString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostAlias other = (HostAlias)obj;
        if (this.hostName == null ? other.hostName != null : !this.hostName.equals(other.hostName)) {
            return false;
        }
        return !(this.portString == null ? other.portString != null : !this.portString.equals(other.portString));
    }

    public static List<String> toStringList(Collection<HostAlias> haList) {
        if (haList == null) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(haList.size());
        for (HostAlias ha : haList) {
            list.add(ha.toString());
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(HostAlias.class);
        validPort = Pattern.compile("(.*):(\\d+)");
    }
}

