/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.inbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.http.HttpInputStream;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.io.IOException;

public class HttpInputStreamImpl
extends HttpInputStream {
    private static final TraceComponent tc = Tr.register(HttpInputStreamImpl.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    protected HttpInboundServiceContext isc = null;
    protected WsByteBuffer buffer = null;
    private IOException error = null;
    private boolean closed = false;
    protected long bytesRead = 0L;
    private long bytesToCaller = 0L;

    public HttpInputStreamImpl(HttpInboundServiceContext context) {
        this.isc = context;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.getClass().getSimpleName());
        sb.append('@').append(Integer.toHexString(this.hashCode()));
        sb.append(" closed=").append(this.closed);
        sb.append(" error=").append(this.error);
        sb.append(" received=").append(this.bytesRead);
        sb.append(" given=").append(this.bytesToCaller);
        sb.append(" buffer=").append(this.buffer);
        return sb.toString();
    }

    protected void validate() throws IOException {
        if (this.isClosed()) {
            throw new IOException("Stream is closed");
        }
        if (null != this.error) {
            throw this.error;
        }
    }

    protected boolean checkBuffer() throws IOException {
        if (null != this.buffer) {
            if (this.buffer.hasRemaining()) {
                return true;
            }
            this.buffer.release();
            this.buffer = null;
        }
        try {
            this.buffer = this.isc.getRequestBodyBuffer();
            if (null != this.buffer) {
                this.bytesRead += (long)this.buffer.remaining();
                return true;
            }
            return false;
        }
        catch (IOException e) {
            this.error = e;
            throw e;
        }
    }

    @Override
    public int available() throws IOException {
        int rc;
        this.validate();
        int n = rc = null == this.buffer ? 0 : this.buffer.remaining();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("available: " + rc), (Object[])new Object[0]);
        }
        return rc;
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Closing stream: " + this), (Object[])new Object[0]);
        }
        if (null != this.buffer) {
            this.buffer.release();
            this.buffer = null;
        }
        this.validate();
        this.closed = true;
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Ignoring call to mark()", (Object[])new Object[0]);
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        this.validate();
        int rc = -1;
        if (this.checkBuffer()) {
            rc = this.buffer.get() & 0xFF;
            ++this.bytesToCaller;
        }
        return rc;
    }

    @Override
    public int read(byte[] output, int offset, int length) throws IOException {
        this.validate();
        if (0 == length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"read(byte[],int,int), target length was 0", (Object[])new Object[0]);
            }
            return 0;
        }
        if (!this.checkBuffer()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"read(byte[],int,int), EOF", (Object[])new Object[0]);
            }
            return -1;
        }
        int avail = this.buffer.remaining();
        int amount = length > avail ? avail : length;
        this.buffer.get(output, offset, amount);
        this.bytesToCaller += (long)amount;
        return amount;
    }

    @Override
    public int read(byte[] output) throws IOException {
        return this.read(output, 0, output.length);
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("Mark not supported");
    }

    @Override
    public long skip(long target) throws IOException {
        this.validate();
        if (!this.checkBuffer()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("skip(" + target + "), EOF"), (Object[])new Object[0]);
            }
            return -1L;
        }
        long total = 0L;
        long remaining = target;
        while (total < target && this.checkBuffer()) {
            int avail = this.buffer.remaining();
            if ((long)avail > remaining) {
                this.buffer.position(this.buffer.position() + (int)remaining);
                total += remaining;
                continue;
            }
            this.buffer.release();
            this.buffer = null;
            total += (long)avail;
            remaining -= (long)avail;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("skip(" + target + ") rc=" + total), (Object[])new Object[0]);
        }
        this.bytesToCaller += total;
        return total;
    }
}

