/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.websphere.rsadapter.GenericDataStoreHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.jca.adapter.WSConnectionManager;
import com.ibm.ws.jca.adapter.WSManagedConnectionFactory;
import com.ibm.ws.jca.cm.ConnectorService;
import com.ibm.ws.jdbc.osgi.JDBCRuntimeVersion;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfig;
import com.ibm.ws.rsadapter.DSConfigHelper;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.jdbc.WSJdbcDataSource;
import com.ibm.ws.rsadapter.jdbc.WSJdbcTracer;
import com.ibm.ws.rsadapter.spi.ConnectionResults;
import com.ibm.ws.rsadapter.spi.InternalDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSConnectionRequestInfoImpl;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.resource.spi.security.GenericCredential;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XADataSource;
import org.ietf.jgss.GSSCredential;
import org.osgi.framework.Version;

public class WSManagedConnectionFactoryImpl
extends WSManagedConnectionFactory
implements ValidatingManagedConnectionFactory,
FFDCSelfIntrospectable {
    private static final long serialVersionUID = -56589160441993572L;
    boolean perfEnhancementEnabledNotSet = true;
    boolean perfEnhancementEnabled = false;
    public final ConnectorService connectorSvc;
    public final JDBCRuntimeVersion jdbcRuntime;
    public int jdbcVersion;
    Properties defaultClientInfo = new Properties();
    private transient CommonDataSource dataSource;
    transient Class<?> dataSourceImplClass;
    transient DataStoreHelper dataStoreHelper;
    transient InternalDataStoreHelper internalHelper;
    transient PrintWriter logWriter;
    public boolean detectedMultithreadedAccess;
    private static TraceComponent tc = Tr.register(WSManagedConnectionFactoryImpl.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    boolean loggingEnabled;
    protected WSConnectionManager connMgr = null;
    final AtomicLong fatalErrorCount = new AtomicLong();
    long oracleRACXARetryDelay;
    final AtomicLong oracleRACLastStale = new AtomicLong();
    boolean warnedAboutValidationByTimeout;
    boolean warnedAboutNonTransactionalDataSource;
    protected boolean loggedDbUowMessage = false;
    protected boolean loggedImmplicitTransactionFound = false;
    public boolean doArrayCleanup = true;
    public boolean doBlobCleanup = true;
    public boolean doClobCleanup = true;
    public boolean doXMLCleanup = true;
    public final AtomicReference<DSConfig> dsConfig;
    public final transient Set<Method> vendorMethods = Collections.newSetFromMap(new ConcurrentHashMap());
    private boolean wasUsedToGetAConnection;

    public WSManagedConnectionFactoryImpl(AtomicReference<DSConfig> dsConfigRef, CommonDataSource ds, JDBCRuntimeVersion jdbcRuntime, ClassLoader classloader, String dataStoreHelperClass, Properties propsWithStringValues) throws ResourceException {
        com.ibm.ejs.ras.TraceComponent tracer;
        this.dsConfig = dsConfigRef;
        DSConfig config = this.dsConfig.get();
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"<init>", (Object[])new Object[]{config, jdbcRuntime, dataStoreHelperClass});
        }
        this.connectorSvc = config.connectorSvc;
        this.jdbcRuntime = jdbcRuntime;
        this.dataSourceImplClass = ds.getClass();
        this.dataStoreHelper = DSConfigHelper.createDataStoreHelper(this, dataStoreHelperClass, propsWithStringValues, ((Object)((Object)this)).getClass().getClassLoader());
        this.internalHelper = DSConfigHelper.createInternalDataStoreHelper(dataStoreHelperClass, this.dataStoreHelper, ds.getClass().getName(), classloader);
        this.internalHelper.setExternalHelper(this.dataStoreHelper);
        this.internalHelper.setProperties(propsWithStringValues);
        this.internalHelper.setManagedConnectionFactory(this);
        if (this.internalHelper.shouldTraceBeEnabled(this)) {
            this.internalHelper.enableJdbcLogging(this);
        }
        ((GenericDataStoreHelper)this.dataStoreHelper).init();
        if ((config.supplementalJDBCTrace == null || config.supplementalJDBCTrace.booleanValue()) && (tracer = this.internalHelper.getTracer()) != null && tracer.isDebugEnabled()) {
            try {
                ds = (CommonDataSource)this.getTraceableDataSource(ds);
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"supplemental tracing set for data source", (Object[])new Object[]{"Data source: " + ds, "Tracer: " + tracer});
            }
            catch (ResourceException e) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"error setting supplemental trace on data source", (Object[])new Object[]{"Data source: " + ds, e});
            }
        }
        this.dataSource = ds;
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"<init>");
        }
    }

    public final Object createConnectionFactory(ConnectionManager connMgr) throws ResourceException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"createConnectionFactory", (Object[])new Object[]{connMgr});
        }
        this.connMgr = (WSConnectionManager)connMgr;
        WSJdbcDataSource connFactory = new WSJdbcDataSource(this, this.connMgr);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"createConnectionFactory", (Object)connFactory);
        }
        return connFactory;
    }

    public boolean atLeastJDBCVersion(Version ver) {
        return this.jdbcRuntime.getVersion().compareTo(ver) >= 0;
    }

    public final boolean beforeJDBCVersion(Version ver) {
        return this.jdbcRuntime.getVersion().compareTo(ver) < 0;
    }

    public final Object createConnectionFactory() throws ResourceException {
        throw new NotSupportedException();
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        String password;
        String userName;
        WSConnectionRequestInfoImpl cri;
        boolean isAnyTraceOn;
        Object credential;
        boolean useKerb;
        block20: {
            block21: {
                block19: {
                    useKerb = false;
                    credential = null;
                    isAnyTraceOn = TraceComponent.isAnyTracingEnabled();
                    if (isAnyTraceOn && tc.isEntryEnabled()) {
                        Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"createManagedConnection", (Object[])new Object[]{subject == null ? null : "subject", AdapterUtil.toString(cxRequestInfo)});
                    }
                    cri = cxRequestInfo == null ? new WSConnectionRequestInfoImpl() : (WSConnectionRequestInfoImpl)cxRequestInfo;
                    userName = null;
                    password = null;
                    if (subject != null) break block19;
                    password = cri.getPassword();
                    userName = cri.getUserName();
                    if (!isAnyTraceOn || !tc.isEventEnabled()) break block20;
                    if (userName == null) {
                        Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"Using DataSource default user/password for authentication", (Object[])new Object[0]);
                    } else {
                        Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"Using ConnectionRequestInfo for authentication", (Object[])new Object[0]);
                    }
                    break block20;
                }
                if (isAnyTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Subject found.  Will try to use either PasswordCredentials or GenericCredentials ", (Object[])new Object[0]);
                }
                userName = null;
                password = null;
                String threadIdentitySupport = this.getThreadIdentitySupport();
                boolean subjectHasUtokenCred = false;
                if (threadIdentitySupport.equals("ALLOWED") || threadIdentitySupport.equals("REQUIRED")) {
                    if (isAnyTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"The JDBC Provider supports the use of Thread Identity for authentication.", (Object[])new Object[0]);
                    }
                    final Subject subj = subject;
                    Set<GenericCredential> privateGenericCredentials = null;
                    privateGenericCredentials = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<Set<GenericCredential>>(){

                        @Override
                        public Set<GenericCredential> run() {
                            return subj.getPrivateCredentials(GenericCredential.class);
                        }
                    }) : subj.getPrivateCredentials(GenericCredential.class);
                    final Iterator<GenericCredential> iterator = privateGenericCredentials.iterator();
                    PrivilegedAction<GenericCredential> iterationAction = new PrivilegedAction<GenericCredential>(){

                        @Override
                        public GenericCredential run() {
                            return (GenericCredential)iterator.next();
                        }
                    };
                    GenericCredential genericCredential = null;
                    while (iterator.hasNext()) {
                        genericCredential = System.getSecurityManager() != null ? AccessController.doPrivileged(iterationAction) : iterator.next();
                        if (!genericCredential.getMechType().equals("oid:1.3.18.0.2.30.1")) continue;
                        subjectHasUtokenCred = true;
                        break;
                    }
                    if (!subjectHasUtokenCred && threadIdentitySupport.equals("REQUIRED")) {
                        String message = "createManagedConnection() error: Jdbc Provider requires ThreadIdentitySupport, but no UTOKEN generic credential was found.";
                        DataStoreAdapterException resX = AdapterUtil.createDataStoreAdapterException("WS_INTERNAL_ERROR", message, null, ((Object)((Object)this)).getClass());
                        throw resX;
                    }
                }
                if (!subjectHasUtokenCred) break block21;
                if (cri.trustedConnectionMappingIsUsed) {
                    throw AdapterUtil.createDataStoreAdapterException("IDENTITY_PROPAGATION_CONFLICT2_ERROR", null, null, ((Object)((Object)this)).getClass());
                }
                userName = null;
                password = null;
                if (!isAnyTraceOn || !tc.isEventEnabled()) break block20;
                Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"Using thread identity for authentication by the JDBC Provider's DataSource.", (Object[])new Object[0]);
                break block20;
            }
            final Iterator<Object> iter = subject.getPrivateCredentials().iterator();
            PrivilegedAction<Object> iterationAction = new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return iter.next();
                }
            };
            while (iter.hasNext()) {
                credential = System.getSecurityManager() != null ? AccessController.doPrivileged(iterationAction) : iter.next();
                if (credential instanceof PasswordCredential) {
                    PasswordCredential pwcred = (PasswordCredential)credential;
                    if (!pwcred.getManagedConnectionFactory().equals((Object)this)) continue;
                    if (isAnyTraceOn && tc.isEventEnabled()) {
                        Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"Using PasswordCredentials for authentication", (Object[])new Object[0]);
                    }
                    userName = pwcred.getUserName();
                    char[] pwdChars = pwcred.getPassword();
                    password = pwdChars == null ? null : new String(pwdChars);
                    break;
                }
                if (!(credential instanceof GSSCredential)) continue;
                useKerb = true;
                if (!isAnyTraceOn || !tc.isEventEnabled()) break;
                Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"Using GenericCredentials for authentication", (Object[])new Object[0]);
                break;
            }
        }
        WSRdbManagedConnectionImpl mc = null;
        ConnectionResults results = null;
        try {
            results = this.getConnection(userName, password, subject, cri, useKerb, credential);
            mc = new WSRdbManagedConnectionImpl(this, results.pooledConnection, results.connection, subject, cri, results.cookie);
            if (results.cookie != null) {
                mc.setTrustedConnection();
            } else if (useKerb) {
                mc.setKerberosConnection();
            }
            if (isAnyTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"createManagedConnection", (Object)mc);
            }
            return mc;
        }
        catch (ResourceException resX) {
            if (isAnyTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"createManagedConnection", (Object)((Object)resX));
            }
            throw resX;
        }
    }

    private Connection getConnection(PooledConnection pconn, byte[] cookie, WSConnectionRequestInfoImpl cri, String userName) throws ResourceException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getConnection", (Object[])new Object[]{AdapterUtil.toString(pconn)});
        }
        Connection conn = null;
        boolean isConnectionSetupComplete = false;
        try {
            if (cri.trustedConnectionMappingIsUsed && cri.trustedContextIdentityAttributesAreSet) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Trusted  context attributes are set.  Getting a trusted connection from :", (Object[])new Object[]{pconn});
                }
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Trusted without authentication is used.", (Object[])new Object[0]);
                }
                conn = this.internalHelper.getTrustedConnection(pconn, cri.tc_originalUser, cri.tc_name, null, cri.tc_realm, cri.tc_userSecToken, cookie, null);
            } else {
                conn = pconn.getConnection();
            }
            this.postGetConnectionHandling(conn);
            isConnectionSetupComplete = true;
        }
        catch (SQLException se) {
            FFDCFilter.processException((Throwable)se, (String)((Object)((Object)this)).getClass().getName(), (String)"260", (Object)((Object)this));
            ResourceException x = AdapterUtil.translateSQLException(se, (Object)this, false, ((Object)((Object)this)).getClass());
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getConnection", (Object)se);
            }
            throw x;
        }
        finally {
            if (!isConnectionSetupComplete) {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable x) {}
                }
                if (pconn != null) {
                    try {
                        pconn.close();
                    }
                    catch (Throwable x) {}
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getConnection", (Object)AdapterUtil.toString(conn));
        }
        return conn;
    }

    private ConnectionResults getConnection(final String userName, final String password, final Subject subject, final WSConnectionRequestInfoImpl cri, boolean useKerb, final Object credential) throws ResourceException {
        ConnectionResults results;
        final boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getConnection", (Object[])new Object[]{userName, subject == null ? null : "subject", AdapterUtil.toString((Object)cri), useKerb, credential});
        }
        DSConfig config = this.dsConfig.get();
        if (useKerb && this.internalHelper.supportsSubjectDoAsForKerberos()) {
            try {
                final PrivilegedExceptionAction<ConnectionResults> getConnection = new PrivilegedExceptionAction<ConnectionResults>(){

                    @Override
                    public ConnectionResults run() throws ResourceException {
                        return WSManagedConnectionFactoryImpl.this.getConnection(userName, password, subject, cri, false, credential);
                    }
                };
                results = AccessController.doPrivileged(new PrivilegedExceptionAction<ConnectionResults>(){

                    @Override
                    public ConnectionResults run() throws Exception {
                        Subject copy = new Subject(subject.isReadOnly(), subject.getPrincipals(), subject.getPublicCredentials(), subject.getPrivateCredentials());
                        if (trace && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"running as subject", (Object[])new Object[]{copy});
                        }
                        return (ConnectionResults)Subject.doAs(copy, getConnection);
                    }
                });
            }
            catch (PrivilegedActionException privX) {
                Throwable x = privX.getCause();
                if (x instanceof PrivilegedActionException) {
                    x = x.getCause();
                }
                FFDCFilter.processException((Throwable)x, (String)((Object)((Object)this)).getClass().getName(), (String)"1734", (Object)((Object)this));
                if (trace && tc.isEntryEnabled()) {
                    Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getConnection", (Object)x);
                }
                if (x instanceof ResourceException) {
                    throw (ResourceException)x;
                }
                throw AdapterUtil.createDataStoreAdapterException("GENERAL_EXCEPTION", x.getMessage(), null, ((Object)((Object)this)).getClass());
            }
        }
        if (DataSource.class.equals(config.type) || config.isUCP) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Getting a connection using Datasource. Is UCP? " + config.isUCP), (Object[])new Object[0]);
            }
            Connection conn = this.getConnectionUsingDS(userName, password, cri);
            results = new ConnectionResults(null, null, conn);
        } else {
            try {
                results = this.internalHelper.getPooledConnection(this.dataSource, userName, password, XADataSource.class.equals(config.type), cri, useKerb, credential);
            }
            catch (DataStoreAdapterException dae) {
                throw (ResourceException)((Object)AdapterUtil.mapException((Exception)((Object)dae), null, (Object)this, false));
            }
            results.connection = this.getConnection(results.pooledConnection, results.cookie, cri, userName);
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getConnection", (Object)results);
        }
        return results;
    }

    private final Connection getConnectionUsingDS(String userN, String password, final WSConnectionRequestInfoImpl cri) throws ResourceException {
        final boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getConnectionUsingDS", (Object[])new Object[]{AdapterUtil.toString(this.dataSource), userN});
        }
        final String user = userN == null ? null : userN.trim();
        final String pwd = password == null ? null : password.trim();
        Connection conn = null;
        boolean isConnectionSetupComplete = false;
        try {
            conn = AccessController.doPrivileged(new PrivilegedExceptionAction<Connection>(){

                @Override
                public Connection run() throws Exception {
                    Properties oracleProps = cri.getOracleProperties();
                    if (oracleProps != null) {
                        try {
                            if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"obtain Oracle data source with properties:", (Object[])new Object[]{oracleProps});
                            }
                            Object ods = WSJdbcTracer.getImpl(WSManagedConnectionFactoryImpl.this.dataSource);
                            ClassLoader loader = ods.getClass().getClassLoader();
                            Class<?> dsClass = loader.loadClass("oracle.jdbc.pool.OracleDataSource");
                            Method method = dsClass.getMethod("getConnection", Properties.class);
                            return (Connection)method.invoke(ods, oracleProps.clone());
                        }
                        catch (InvocationTargetException x) {
                            throw x.getCause() instanceof Exception ? (Exception)x.getCause() : x;
                        }
                    }
                    if (WSManagedConnectionFactoryImpl.this.dataSource instanceof XADataSource) {
                        return user == null ? ((XADataSource)WSManagedConnectionFactoryImpl.this.dataSource).getXAConnection().getConnection() : ((XADataSource)WSManagedConnectionFactoryImpl.this.dataSource).getXAConnection(user, pwd).getConnection();
                    }
                    return user == null ? ((DataSource)WSManagedConnectionFactoryImpl.this.dataSource).getConnection() : ((DataSource)WSManagedConnectionFactoryImpl.this.dataSource).getConnection(user, pwd);
                }
            });
            try {
                this.postGetConnectionHandling(conn);
            }
            catch (SQLException se) {
                FFDCFilter.processException((Throwable)se, (String)((Object)((Object)this)).getClass().getName(), (String)"260", (Object)((Object)this));
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getConnectionUsingDS", (Object)se);
                }
                throw AdapterUtil.translateSQLException(se, (Object)this, false, ((Object)((Object)this)).getClass());
            }
            isConnectionSetupComplete = true;
        }
        catch (PrivilegedActionException pae) {
            FFDCFilter.processException((Throwable)pae.getException(), (String)((Object)((Object)this)).getClass().getName(), (String)"1372");
            DataStoreAdapterException resX = AdapterUtil.createDataStoreAdapterException("JAVAX_CONN_ERR", "Connection", pae.getException(), ((Object)((Object)this)).getClass());
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getConnectionUsingDS", (Object)pae.getException());
            }
            throw resX;
        }
        catch (ClassCastException castX) {
            FFDCFilter.processException((Throwable)castX, (String)((Object)((Object)this)).getClass().getName(), (String)"1312");
            DataStoreAdapterException resX = AdapterUtil.createDataStoreAdapterException("NOT_A_1_PHASE_DS", castX.getMessage(), null, ((Object)((Object)this)).getClass());
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getConnectionUsingDS", (Object)castX);
            }
            throw resX;
        }
        finally {
            if (conn != null && !isConnectionSetupComplete) {
                try {
                    conn.close();
                }
                catch (Throwable x) {}
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getConnectionUsingDS", (Object)AdapterUtil.toString(conn));
        }
        return conn;
    }

    public Set<ManagedConnection> getInvalidConnections(Set connectionSet) throws ResourceException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getInvalidConnections", (Object[])new Object[]{connectionSet});
        }
        HashSet<ManagedConnection> badSet = new HashSet<ManagedConnection>();
        WSRdbManagedConnectionImpl mc = null;
        Iterator it = connectionSet.iterator();
        while (it.hasNext()) {
            try {
                mc = (WSRdbManagedConnectionImpl)it.next();
                mc.preTestConnection(false);
            }
            catch (ResourceException resX) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    SQLException sqlX = (SQLException)resX.getCause();
                    Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Found a bad connection.", (Object[])new Object[]{mc, "SQL State:  " + sqlX.getSQLState(), "Error Code: " + sqlX.getErrorCode(), sqlX.getMessage()});
                }
                badSet.add((ManagedConnection)mc);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getInvalidConnections", badSet);
        }
        return badSet;
    }

    public final boolean getRRSTransactional() {
        return this.internalHelper.getRRSTransactional();
    }

    public final String getThreadIdentitySupport() {
        return this.internalHelper.getThreadIdentitySupport();
    }

    public final boolean getThreadSecurity() {
        return this.internalHelper.getThreadSecurity();
    }

    private Object getTraceableDataSource(Object ds) throws ResourceException {
        Class<? extends CommonDataSource> ifc = this.dsConfig.get().type;
        WSJdbcTracer tracer = new WSJdbcTracer(this.internalHelper.getTracer(), this.internalHelper.getPrintWriter(), ds, ifc, null, true);
        HashSet classes = new HashSet();
        for (Class<?> cl = ds.getClass(); cl != null; cl = cl.getSuperclass()) {
            classes.addAll(Arrays.asList(cl.getInterfaces()));
        }
        return Proxy.newProxyInstance(ds.getClass().getClassLoader(), classes.toArray(new Class[classes.size()]), (InvocationHandler)tracer);
    }

    public CommonDataSource getUnderlyingDataSource() throws SQLException {
        return this.dataSource;
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        WSConnectionRequestInfoImpl finalCRI;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"matchManagedConnections", (Object[])new Object[]{connectionSet == null ? null : Integer.valueOf(connectionSet.size()), subject == null ? null : "subject", cxRequestInfo});
        }
        if (connectionSet == null) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"matchManagedConnections", null);
            }
            return null;
        }
        try {
            finalCRI = (WSConnectionRequestInfoImpl)cxRequestInfo;
        }
        catch (ClassCastException castX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"matchManagedConnections", null);
            }
            return null;
        }
        WSRdbManagedConnectionImpl matchedmc = null;
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"the size of the set should be 1, and it is", (Object[])new Object[]{connectionSet.size()});
        }
        Iterator iter = connectionSet.iterator();
        WSRdbManagedConnectionImpl currentmc = (WSRdbManagedConnectionImpl)iter.next();
        if (currentmc._claimedVictim && finalCRI.isReconfigurable(currentmc.cri, true)) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"mc is claimedVictim matched", (Object[])new Object[]{currentmc});
            }
            matchedmc = currentmc;
        } else if (subject == null) {
            if (currentmc.getSubject() == null && finalCRI.isReconfigurable(currentmc.cri, false)) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"mc matched", (Object[])new Object[]{currentmc});
                }
                matchedmc = currentmc;
            }
        } else {
            Subject _sub = currentmc.getSubject();
            if (_sub != null) {
                Equals e = new Equals();
                e.setSubjects(subject, _sub);
                if (AccessController.doPrivileged(e).booleanValue() && finalCRI.isReconfigurable(currentmc.cri, false)) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"mc matched", (Object[])new Object[]{currentmc});
                    }
                    matchedmc = currentmc;
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"matchManagedConnections", (Object)matchedmc);
        }
        return matchedmc;
    }

    private void postGetConnectionHandling(Connection conn) throws SQLException, ResourceException {
        this.dataStoreHelper.doConnectionSetup(conn);
        if (!this.wasUsedToGetAConnection) {
            this.internalHelper.gatherAndDisplayMetaDataInfo(conn, this);
            this.wasUsedToGetAConnection = true;
        }
    }

    public final void setLogWriter(PrintWriter out) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"setLogWriter on the mcf is a no-op when calling this method", (Object[])new Object[0]);
        }
    }

    final void reallySetLogWriter(final PrintWriter out) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"setting the logWriter to:", (Object[])new Object[]{out});
        }
        if (this.dataSource != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws SQLException {
                        WSManagedConnectionFactoryImpl.this.dataSource.setLogWriter(out);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                SQLException se = (SQLException)pae.getCause();
                FFDCFilter.processException((Throwable)se, (String)((Object)((Object)this)).getClass().getName(), (String)"593", (Object)((Object)this));
                throw AdapterUtil.translateSQLException(se, (Object)this, false, ((Object)((Object)this)).getClass());
            }
        }
        this.logWriter = out;
    }

    public String[] introspectSelf() {
        FFDCLogger info = new FFDCLogger((Object)this);
        info.append(this.dsConfig.get().introspectSelf());
        if (this.dsConfig.get().enableMultithreadedAccessDetection) {
            info.append("Multithreaded access was detected?", this.detectedMultithreadedAccess);
        }
        info.append("DataSource Implementation Class:", this.dataSourceImplClass);
        info.append("Underlying DataSource Object: " + AdapterUtil.toString(this.dataSource), this.dataSource);
        info.append("Log Writer:", this.logWriter);
        info.append("Counter of fatal connection errors on ManagedConnections created by this MCF:", this.fatalErrorCount);
        return info.toStringArray();
    }

    public final PrintWriter getLogWriter() throws ResourceException {
        if (this.dataSource == null) {
            return this.logWriter;
        }
        try {
            return this.dataSource.getLogWriter();
        }
        catch (SQLException se) {
            FFDCFilter.processException((Throwable)se, (String)((Object)((Object)this)).getClass().getName(), (String)"1656", (Object)((Object)this));
            throw AdapterUtil.translateSQLException(se, (Object)this, false, ((Object)((Object)this)).getClass());
        }
    }

    public final int getLoginTimeout() throws SQLException {
        try {
            return this.dataSource.getLoginTimeout();
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)((Object)((Object)this)).getClass().getName(), (String)"1670", (Object)((Object)this));
            throw AdapterUtil.mapSQLException(sqlX, (Object)this);
        }
    }

    public final DataStoreHelper getDataStoreHelper() {
        return this.dataStoreHelper;
    }

    public InternalDataStoreHelper getInternalDataStoreHelper() {
        return this.internalHelper;
    }

    public String getCorrelator(WSRdbManagedConnectionImpl mc) throws SQLException {
        return this.internalHelper.getCorrelator(mc);
    }

    public final Class<?> getDataSourceClassName() {
        return this.dataSourceImplClass;
    }

    public final int getDefaultBranchCoupling() {
        return this.internalHelper.getDefaultBranchCoupling();
    }

    public final int getXAStartFlagForBranchCoupling(int couplingType) {
        return this.internalHelper.branchCouplingSupported(couplingType);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        throw new UnsupportedOperationException();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Version getJDBCRuntimeVersion() {
        return this.jdbcRuntime.getVersion();
    }

    class Equals
    implements PrivilegedAction<Boolean> {
        Subject _s1;
        Subject _s2;

        Equals() {
        }

        public final void setSubjects(Subject s1, Subject s2) {
            this._s1 = s1;
            this._s2 = s2;
        }

        @Override
        public Boolean run() {
            String subjectAUniqueID = null;
            String subjectBUniqueID = null;
            if (WSManagedConnectionFactoryImpl.this.perfEnhancementEnabledNotSet) {
                String key = "com.ibm.websphere.security.auth.j2c.cacheReadOnlyAuthDataSubjects";
                WSManagedConnectionFactoryImpl.this.perfEnhancementEnabled = Boolean.parseBoolean(System.getProperty(key));
                WSManagedConnectionFactoryImpl.this.perfEnhancementEnabledNotSet = false;
            }
            if (WSManagedConnectionFactoryImpl.this.perfEnhancementEnabled) {
                Hashtable table = null;
                Iterator<Hashtable> publicCreds = this._s1.getPublicCredentials(Hashtable.class).iterator();
                if (publicCreds != null && publicCreds.hasNext()) {
                    table = publicCreds.next();
                }
                if (table != null) {
                    subjectAUniqueID = (String)table.get("com.ibm.wsspi.security.cred.cacheKey");
                    publicCreds = this._s2.getPublicCredentials(Hashtable.class).iterator();
                    if (publicCreds != null && publicCreds.hasNext()) {
                        table = publicCreds.next();
                    }
                    if (table != null) {
                        subjectBUniqueID = (String)table.get("com.ibm.wsspi.security.cred.cacheKey");
                    }
                }
                if (subjectAUniqueID != null && subjectBUniqueID != null) {
                    return subjectAUniqueID.equals(subjectBUniqueID);
                }
            }
            if (subjectAUniqueID == null || subjectBUniqueID == null) {
                boolean subjestsMatch = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"PK69110 - Using adapter set equals", (Object[])new Object[0]);
                }
                if (this.checkCredentials(this._s1.getPrivateCredentials(), this._s2.getPrivateCredentials())) {
                    subjestsMatch = this.checkCredentials(this._s1.getPublicCredentials(), this._s2.getPublicCredentials());
                }
                return subjestsMatch;
            }
            return false;
        }

        private boolean checkCredentials(Set<Object> s1Credentials, Set<Object> s2Credentials) {
            boolean rVal = false;
            if (s1Credentials != s2Credentials) {
                if (s1Credentials != null && s2Credentials != null) {
                    int it2size;
                    int it1size = s1Credentials.size();
                    if (it1size == (it2size = s2Credentials.size())) {
                        if (it1size == 0) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"Processing credential sets, both are empty, They are equal", (Object[])new Object[0]);
                            }
                            return true;
                        }
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Processing credential sets, sets do not contain the same number of elements. They are not equal", (Object[])new Object[0]);
                        }
                        return false;
                    }
                    if (it1size > 1) {
                        Iterator<Object> it1 = s1Credentials.iterator();
                        int objectsEqual = 0;
                        block0: while (it1.hasNext()) {
                            Object s1Cred = it1.next();
                            for (Object s2Cred : s2Credentials) {
                                if (s1Cred != null ? !s1Cred.equals(s2Cred) : s2Cred != null) continue;
                                ++objectsEqual;
                                continue block0;
                            }
                        }
                        if (objectsEqual == it1size) {
                            rVal = true;
                        }
                    } else {
                        Iterator<Object> it1 = s1Credentials.iterator();
                        Iterator<Object> it2 = s2Credentials.iterator();
                        Object s1Cred = it1.next();
                        Object s2Cred = it2.next();
                        if (s1Cred != null) {
                            if (!s1Cred.equals(s2Cred)) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((Object)this, (TraceComponent)tc, (String)"PK69110 - Objects are not equal", (Object[])new Object[0]);
                                }
                                return false;
                            }
                        } else if (s2Cred != null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"PK69110 - Objects are not equal, one objest is null", (Object[])new Object[0]);
                            }
                            return false;
                        }
                        rVal = true;
                    }
                }
            } else {
                rVal = true;
            }
            return rVal;
        }
    }
}

