/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.spi.StatementCacheKey;

public class PSCacheKey
extends StatementCacheKey {
    public static final int PREPARED_STATEMENT = 1;

    public PSCacheKey(String theSQL, int theType, int theConcurrency, int theHoldability, int theAutoGeneratedKeys, int isoLev, String dbSchema, int timeout) {
        this.type = theType;
        this.concurrency = theConcurrency;
        this.sql = theSQL;
        this.hCode = this.sql.hashCode();
        this.statementType = 1;
        this.holdability = theHoldability;
        this.autoGeneratedKeys = theAutoGeneratedKeys;
        this.statementIsoLevel = isoLev;
        this.schema = dbSchema;
        this.networkTimeout = timeout;
    }

    public final boolean equals(Object keyToCheck) {
        try {
            if (keyToCheck == null) {
                return false;
            }
            StatementCacheKey k = (StatementCacheKey)keyToCheck;
            return (this.sql == k.sql || this.sql.equals(k.sql)) && this.statementType == k.statementType && this.holdability == k.holdability && this.autoGeneratedKeys == k.autoGeneratedKeys && this.type == k.type && this.concurrency == k.concurrency && this.statementIsoLevel == k.statementIsoLevel && AdapterUtil.match(this.schema, k.schema) && this.networkTimeout == k.networkTimeout;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer("PSTMT: ").append(this.sql).append(' ').append(this.type).append(' ');
        sb.append(this.concurrency).append(' ').append(this.holdability).append(' ').append(this.autoGeneratedKeys).append(' ');
        sb.append(this.statementIsoLevel);
        if (this.schema != null) {
            sb.append(' ').append(this.schema);
        }
        sb.append(this.networkTimeout);
        return sb.toString();
    }
}

