/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.dbutils.OracleUtility;
import com.ibm.ws.rsadapter.dbutils.impl.OracleUtilityImpl;
import com.ibm.ws.rsadapter.spi.InternalGenericDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.util.Properties;
import javax.resource.ResourceException;

public class InternalOracleDataStoreHelper
extends InternalGenericDataStoreHelper {
    private static TraceComponent tc = com.ibm.websphere.ras.Tr.register(InternalOracleDataStoreHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private static final String ORACLE9iLOG_TRACELEVEL = "oracle9iLogTraceLevel";
    private OracleUtility UTILITY = null;
    protected static final TraceComponent oraTc = Tr.register((String)"com.ibm.ws.oracle.logwriter", (String)"WAS.database", null);
    private transient PrintWriter oraPw;
    int _logLevel = 2;

    public InternalOracleDataStoreHelper() throws Exception {
        this(null);
    }

    public InternalOracleDataStoreHelper(ClassLoader loader) throws Exception {
        super(loader);
        this.UTILITY = new OracleUtilityImpl(loader);
    }

    @Override
    public boolean alwaysSetAutoCommit() {
        return true;
    }

    @Override
    public void setProperties(Properties props) throws ResourceException {
        String holder;
        super.setProperties(props);
        if (props != null && (holder = props.getProperty(ORACLE9iLOG_TRACELEVEL)) != null && !holder.equals("")) {
            this._logLevel = Integer.parseInt(holder);
            if (oraTc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((TraceComponent)oraTc, (String)"the oracle trace level specified is: ", (Object[])new Object[]{this._logLevel});
            }
            this.UTILITY.setLogVolume(this._logLevel);
        }
    }

    @Override
    public com.ibm.ejs.ras.TraceComponent getTracer() {
        return null;
    }

    @Override
    public Object getUtility() {
        return this.UTILITY;
    }

    @Override
    boolean isAuthException(SQLException x) {
        return x instanceof SQLInvalidAuthorizationSpecException || 1004 == x.getErrorCode() || 1005 == x.getErrorCode() || 1017 == x.getErrorCode();
    }

    @Override
    public boolean shouldTraceBeEnabled(WSManagedConnectionFactoryImpl mcf) {
        return oraTc.isDebugEnabled() && !mcf.loggingEnabled;
    }

    @Override
    public boolean shouldTraceBeEnabled(WSRdbManagedConnectionImpl mc) {
        return this.shouldTraceBeEnabled(mc.mcf);
    }

    @Override
    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl mc) {
        return !oraTc.isDebugEnabled() && mc.mcf.loggingEnabled;
    }

    @Override
    public void disableJdbcLogging(WSRdbManagedConnectionImpl mc) throws ResourceException {
        if (oraTc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((TraceComponent)oraTc, (String)"Disabling logging on Oracle9i or prior", (Object[])new Object[]{mc.sqlConn});
        }
        this.UTILITY.setLogWriter(null);
        mc.mcf.loggingEnabled = false;
    }

    @Override
    public void enableJdbcLogging(WSManagedConnectionFactoryImpl mcf) throws ResourceException {
        PrintWriter pw = this.getPrintWriter();
        if (oraTc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((TraceComponent)oraTc, (String)"Enabling logging on Oralce9i or prior to ", (Object[])new Object[]{pw});
        }
        this.UTILITY.setLogWriter(pw);
        mcf.loggingEnabled = true;
    }

    @Override
    public void enableJdbcLogging(WSRdbManagedConnectionImpl mc) throws ResourceException {
        this.enableJdbcLogging(mc.mcf);
    }

    @Override
    public PrintWriter getPrintWriter() throws ResourceException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (this.oraPw == null) {
            this.oraPw = this.externalHelper.getPrintWriter();
            if (this.oraPw != null) {
                if (trace && oraTc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((TraceComponent)oraTc, (String)"user supplied own printWriter in the datastore helper, will use provided one", (Object[])new Object[]{this.oraPw});
                }
            } else {
                this.oraPw = new PrintWriter((Writer)new TraceWriter(oraTc), true);
            }
        }
        if (trace && oraTc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((TraceComponent)oraTc, (String)"returning", (Object[])new Object[]{this.oraPw});
        }
        return this.oraPw;
    }

    @Override
    public void setReadOnly(WSRdbManagedConnectionImpl managedConn, boolean readOnly, boolean externalCall) throws SQLException {
        if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"setReadOnly", (Object[])new Object[]{managedConn, readOnly, externalCall});
        }
        if (externalCall) {
            if (readOnly) {
                throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", "setReadOnly", Connection.class.getName()));
            }
            com.ibm.websphere.ras.Tr.info((TraceComponent)tc, (String)"ORA_READONLY", (Object[])new Object[0]);
        } else if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"setReadOnly ignored for internal call", (Object[])new Object[0]);
        }
    }

    @Override
    public void psSetBytes(PreparedStatement pstmtImpl, int i, byte[] x) throws SQLException {
        int length;
        int n = length = x == null ? 0 : x.length;
        if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)("psSetBytes: " + length), (Object[])new Object[0]);
        }
        if (x != null && length > 2000) {
            if (tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"ORACLE setBytes byte array length > 2000 workaround.", (Object[])new Object[0]);
            }
            pstmtImpl.setBinaryStream(i, (InputStream)new ByteArrayInputStream(x), length);
        } else {
            pstmtImpl.setBytes(i, x);
        }
    }

    @Override
    public void psSetString(PreparedStatement pstmtImpl, int i, String x) throws SQLException {
        int length;
        int n = length = x == null ? 0 : x.getBytes().length;
        if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)("string length: " + length), (Object[])new Object[0]);
        }
        if (length > 4000) {
            if (tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Oracle setString length > 4000 bytes workaround.", (Object[])new Object[0]);
            }
            pstmtImpl.setCharacterStream(i, (Reader)new StringReader(x), x.length());
        } else {
            pstmtImpl.setString(i, x);
        }
    }

    @Override
    public int getHoldability(Connection conn) throws SQLException {
        int holdability = 0;
        if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"getHoldability", (Object[])new Object[]{AdapterUtil.toString(conn)});
        }
        try {
            if (this.holdabilitySupported) {
                holdability = conn.getHoldability();
                return holdability;
            }
            return 0;
        }
        catch (AbstractMethodError ame) {
            if (tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"getHoldability", (Object[])new Object[]{"getHoldability is not supported in this JDBC driver. Encounter a java.lang.AbstractMethodError"});
            }
            this.holdabilitySupported = false;
            return 0;
        }
        catch (SQLException sqle) {
            if (sqle.getErrorCode() == 17023) {
                if (tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"getHoldability", (Object[])new Object[]{"getHoldability is not supported in this JDBC driver. Encounter a java.sql.SQLException: " + sqle.getMessage()});
                }
                this.holdabilitySupported = false;
                return 0;
            }
            throw sqle;
        }
    }

    @Override
    public void setClientInformation(Properties props, WSRdbManagedConnectionImpl mc, boolean explicitCall) throws SQLException {
        Object sb = null;
        String _clientId = null;
        if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((TraceComponent)tc, (String)"setClientInformation", (Object[])new Object[]{AdapterUtil.hidePassword(props), mc, explicitCall, mc.sqlConn});
        }
        if (explicitCall) {
            _clientId = props.getProperty("CLIENT_ID");
            mc.clientInfoExplicitlySet = true;
        }
        if (_clientId != null) {
            mc.holdCurrentClientInfo(_clientId, null, null, null);
            this.UTILITY.setClientIdentifier(mc.sqlConn, _clientId);
        }
    }

    @Override
    public void setClientInformationArray(String[] clientInfoArray, WSRdbManagedConnectionImpl mc, boolean explicitCall) throws SQLException {
        if (explicitCall) {
            mc.clientInfoExplicitlySet = true;
        } else {
            mc.clientInfoImplicitlySet = true;
        }
        this.UTILITY.setClientIdentifier(mc.sqlConn, clientInfoArray[0]);
    }

    @Override
    public void resetClientInformation(WSRdbManagedConnectionImpl mc) throws SQLException {
        if (mc.clientInfoExplicitlySet || mc.clientInfoImplicitlySet) {
            if (tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"resetClientInformation is called on: ", (Object[])new Object[]{mc});
            }
            this.UTILITY.setClientIdentifier(mc.sqlConn, null);
            mc.clientInfoExplicitlySet = false;
            mc.clientInfoImplicitlySet = false;
        }
    }

    @Override
    public void doConnectionCleanupOnWrapper(WSRdbManagedConnectionImpl mc) throws SQLException {
        if (mc.is2Phase()) {
            if (tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"setting AC to false to workaround Oracle xa problem", (Object[])new Object[0]);
            }
            mc.setAutoCommit(false);
        }
    }
}

