/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.dbutils.OracleUtility;
import com.ibm.ws.rsadapter.dbutils.impl.OracleUtilityImpl;
import com.ibm.ws.rsadapter.spi.InternalOracleDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.XMLFormatter;
import javax.resource.ResourceException;

public class InternalOracle10gDataStoreHelper
extends InternalOracleDataStoreHelper {
    private static TraceComponent tc = Tr.register(InternalOracle10gDataStoreHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private static final String ORACLELOG_FILE_SIZE_LIMIT = "oracleLogFileSizeLimit";
    private static final String ORACLELOG_FILE_COUNT = "oracleLogFileCount";
    private static final String ORACLELOG_FILENAME = "oracleLogFileName";
    private static final String ORACLELOG_TRACELEVEL = "oracleLogTraceLevel";
    private static final String ORACLELOG_FORMAT = "oracleLogFormat";
    private static final String ORACLELOG_PACKAGENAME = "oracleLogPackageName";
    protected OracleUtility UTILITY = null;
    private String[] matrix;

    public InternalOracle10gDataStoreHelper() throws Exception {
        this(null);
    }

    public InternalOracle10gDataStoreHelper(ClassLoader loader) throws Exception {
        super(loader);
        this.UTILITY = new OracleUtilityImpl(loader);
        this.matrix = AccessController.doPrivileged(new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                return new String[InternalOracle10gDataStoreHelper.this.UTILITY.getEndToEndStateIndexMax()];
            }
        });
    }

    @Override
    public boolean alwaysSetAutoCommit() {
        return false;
    }

    @Override
    public void setProperties(Properties props) throws ResourceException {
        super.setProperties(props);
        int limit = 0;
        int count = 1;
        String _oracleLogFileName = null;
        Logger _logger = null;
        Formatter _formatter = null;
        FileHandler _handler = null;
        String _oraclePackageName = "oracle.jdbc.driver";
        String _oracleLogTraceLevel = "INFO";
        String _oracleLogFormat = "SimpleFormat";
        String holder = null;
        if (props != null) {
            holder = props.getProperty(ORACLELOG_PACKAGENAME);
            if (holder != null && !holder.equals("")) {
                _oraclePackageName = holder;
            }
            if ((holder = props.getProperty(ORACLELOG_FILENAME)) != null && !holder.equals("")) {
                _oracleLogFileName = holder;
            }
            if (oraTc.isDebugEnabled()) {
                Tr.debug((TraceComponent)oraTc, (String)"DSConfigHelper.ORACLELOG_PACKAGENAME is: ", (Object[])new Object[]{_oraclePackageName});
                Tr.debug((TraceComponent)oraTc, (String)"DSConfigHelper.ORACLELOG_FILENAME is:  ", (Object[])new Object[]{_oracleLogFileName});
            }
            _logger = Logger.getLogger(_oraclePackageName);
            if (_oracleLogFileName != null && !_oracleLogFileName.equals("")) {
                holder = props.getProperty(ORACLELOG_TRACELEVEL);
                if (holder != null && !holder.equals("")) {
                    _oracleLogTraceLevel = holder;
                }
                if ((holder = props.getProperty(ORACLELOG_FORMAT)) != null && !holder.equals("")) {
                    _oracleLogFormat = holder;
                }
                if (_oracleLogFormat != null && (_oracleLogFormat.charAt(0) == 'S' || _oracleLogFormat.charAt(0) == 's')) {
                    if (oraTc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)oraTc, (String)"SimpleFormatter is used", (Object[])new Object[0]);
                    }
                    _formatter = new SimpleFormatter();
                } else {
                    if (oraTc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)oraTc, (String)"XMLFormatter is used", (Object[])new Object[0]);
                    }
                    _formatter = new XMLFormatter();
                }
                holder = props.getProperty(ORACLELOG_FILE_SIZE_LIMIT);
                if (holder != null && !holder.equals("")) {
                    limit = Integer.parseInt(holder);
                }
                if ((holder = props.getProperty(ORACLELOG_FILE_COUNT)) != null && !holder.equals("")) {
                    count = Integer.parseInt(holder);
                }
                if (oraTc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)oraTc, (String)("DSConfigHelper.ORACLELOG_FILE_COUNT is: " + count), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)oraTc, (String)("DSConfigHelper.ORACLELOG_FILE_SIZE_LIMIT is: " + limit), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)oraTc, (String)"DSConfigHelper.ORACLELOG_FORMAT is: ", (Object[])new Object[]{_oracleLogFormat});
                    Tr.debug((TraceComponent)oraTc, (String)"DSConfigHelper.ORACLELOG_TRACELEVEL is: ", (Object[])new Object[]{_oracleLogTraceLevel});
                }
                try {
                    _handler = new FileHandler(_oracleLogFileName + "%g.%u", limit, count);
                    _handler.setFormatter(_formatter);
                    _handler.setLevel(Level.ALL);
                    _logger.setLevel(AdapterUtil.getLevelBasedOnName(_oracleLogTraceLevel));
                    _logger.setUseParentHandlers(false);
                    _logger.addHandler(_handler);
                }
                catch (IOException iox) {
                    Tr.warning((TraceComponent)tc, (String)"ORACLE_TRACE_WARNING", (Object[])new Object[]{_oracleLogFileName, iox});
                }
            } else if (oraTc.isDebugEnabled()) {
                Tr.debug((TraceComponent)oraTc, (String)"Oracle trace file is not set, Oracle logging/tracing will be mergned with WAS logging based on WAS logging settings", (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void disableJdbcLogging(WSRdbManagedConnectionImpl mc) throws ResourceException {
        block3: {
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Disabling logging on Oracle10g and later", (Object[])new Object[0]);
            }
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        InternalOracle10gDataStoreHelper.this.UTILITY.setTrace(false);
                        return null;
                    }
                });
            }
            catch (Exception x) {
                FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.rsadapter.spi.InternalOracleDataStoreHelper.enableJdbcLogging", (String)"236", (Object)this);
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)oraTc, (String)"InternalOracleDataStoreHelper.enableJdbcLogging failed to enable trace in Oracle, execution will continue", (Object[])new Object[]{x});
            }
        }
        mc.mcf.loggingEnabled = false;
    }

    @Override
    public void enableJdbcLogging(WSManagedConnectionFactoryImpl mcf) throws ResourceException {
        block3: {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)oraTc, (String)"Enabling logging on Oracle10g and later", (Object[])new Object[0]);
            }
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        InternalOracle10gDataStoreHelper.this.UTILITY.setTrace(true);
                        return null;
                    }
                });
            }
            catch (Exception x) {
                FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.rsadapter.spi.InternalOracleDataStoreHelper.enableJdbcLogging", (String)"236", (Object)this);
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)oraTc, (String)"InternalOracleDataStoreHelper.enableJdbcLogging failed to enable trace in Oracle, execution will continue", (Object[])new Object[]{x});
            }
        }
        mcf.loggingEnabled = true;
    }

    @Override
    public void enableJdbcLogging(WSRdbManagedConnectionImpl mc) throws ResourceException {
        this.enableJdbcLogging(mc.mcf);
    }

    @Override
    public PrintWriter getPrintWriter() throws ResourceException {
        return null;
    }

    @Override
    public void doConnectionCleanupOnWrapper(WSRdbManagedConnectionImpl mc) throws SQLException {
    }

    @Override
    public void setClientInformation(Properties props, WSRdbManagedConnectionImpl mc, boolean explicitCall) throws SQLException {
        String _clientId = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setClientInformation", (Object[])new Object[]{AdapterUtil.hidePassword(props), mc, explicitCall, mc.sqlConn});
        }
        if (explicitCall) {
            _clientId = props.getProperty("CLIENT_ID");
            mc.clientInfoExplicitlySet = true;
        }
        if (_clientId != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"The clientInfo string is:", (Object[])new Object[]{_clientId});
            }
            mc.holdCurrentClientInfo(_clientId, null, null, null);
            this.matrix[this.UTILITY.getEndToEndClientIdIndex()] = _clientId;
            this.UTILITY.setEndToEndMetrics(mc.sqlConn, this.matrix, (short)0);
        }
    }

    @Override
    public void setClientInformationArray(String[] clientInfoArray, WSRdbManagedConnectionImpl mc, boolean explicitCall) throws SQLException {
        if (explicitCall) {
            mc.clientInfoExplicitlySet = true;
        } else {
            mc.clientInfoImplicitlySet = true;
        }
        this.matrix[this.UTILITY.getEndToEndClientIdIndex()] = clientInfoArray[0];
        this.UTILITY.setEndToEndMetrics(mc.sqlConn, this.matrix, (short)0);
    }

    @Override
    public void resetClientInformation(WSRdbManagedConnectionImpl mc) throws SQLException {
        if (mc.clientInfoExplicitlySet || mc.clientInfoImplicitlySet) {
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"resetClientInformation is called on: ", (Object[])new Object[]{mc});
            }
            this.matrix[this.UTILITY.getEndToEndClientIdIndex()] = null;
            this.UTILITY.setEndToEndMetrics(mc.sqlConn, this.matrix, (short)0);
            mc.clientInfoExplicitlySet = false;
            mc.clientInfoImplicitlySet = false;
        }
    }
}

