/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.dbutils.DB2UniversalUtility;
import com.ibm.ws.rsadapter.dbutils.impl.DB2UniversalUtilityImpl;
import com.ibm.ws.rsadapter.spi.InternalInformixDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.SQLException;
import javax.resource.ResourceException;

public class InternalInformixJccDataStoreHelper
extends InternalInformixDataStoreHelper {
    private static transient com.ibm.ejs.ras.TraceComponent ifxTc = Tr.register((String)"com.ibm.ws.informix.jcclogwriter", (String)"WAS.database", null);
    private static transient PrintWriter pw = null;
    DB2UniversalUtility db2UniversalUtility = null;
    private transient int configuredTraceLevel = 0;
    private transient Class<?> currClass = InternalInformixJccDataStoreHelper.class;

    public InternalInformixJccDataStoreHelper() throws Exception {
        this(null);
    }

    public InternalInformixJccDataStoreHelper(ClassLoader loader) throws Exception {
        super(loader);
        this.db2UniversalUtility = new DB2UniversalUtilityImpl(loader);
        this.configuredTraceLevel = 0;
    }

    @Override
    public boolean shouldTraceBeEnabled(WSRdbManagedConnectionImpl mc) {
        return TraceComponent.isAnyTracingEnabled() && ifxTc.isDebugEnabled() && !mc.loggingEnabled;
    }

    @Override
    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl mc) {
        return TraceComponent.isAnyTracingEnabled() && !ifxTc.isDebugEnabled() && mc.loggingEnabled;
    }

    @Override
    public void disableJdbcLogging(WSRdbManagedConnectionImpl mc) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && ifxTc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((TraceComponent)ifxTc, (String)"Disabling logging on connection: ", (Object[])new Object[]{mc.sqlConn});
        }
        try {
            this.db2UniversalUtility.setJCCLogWriter(mc.sqlConn, null);
        }
        catch (SQLException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.rsadapter.spi.InternalInformixJccDataStoreHelper.disableJdbcLogging", (String)"86", (Object)this);
            throw AdapterUtil.translateSQLException(e, mc, true, this.currClass);
        }
        mc.loggingEnabled = false;
    }

    @Override
    public void enableJdbcLogging(WSRdbManagedConnectionImpl mc) throws ResourceException {
        PrintWriter pw = this.getPrintWriter();
        if (TraceComponent.isAnyTracingEnabled() && ifxTc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((TraceComponent)ifxTc, (String)"Setting printWriter on connection and with level: ", (Object[])new Object[]{pw, mc.sqlConn, this.configuredTraceLevel});
        }
        try {
            this.db2UniversalUtility.setJCCLogWriter(mc.sqlConn, pw, this.configuredTraceLevel);
        }
        catch (SQLException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.rsadapter.spi.InternalInformixJccDataStoreHelper.enableJdbcLogging", (String)"108", (Object)this);
            throw AdapterUtil.translateSQLException(e, mc, true, this.currClass);
        }
        mc.loggingEnabled = true;
    }

    @Override
    boolean isAuthException(SQLException x) {
        return x.getErrorCode() == -4214 || super.isAuthException(x);
    }

    @Override
    public PrintWriter getPrintWriter() throws ResourceException {
        if (pw == null) {
            pw = this.externalHelper.getPrintWriter();
            if (pw != null) {
                if (TraceComponent.isAnyTracingEnabled() && ifxTc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((TraceComponent)ifxTc, (String)"user supplied own printWriter in the datastore helper, will use provided one", (Object[])new Object[]{pw});
                }
            } else {
                pw = new PrintWriter((Writer)new TraceWriter(ifxTc), true);
            }
        }
        com.ibm.websphere.ras.Tr.debug((TraceComponent)ifxTc, (String)"returning", (Object[])new Object[]{pw});
        return pw;
    }

    @Override
    public com.ibm.ejs.ras.TraceComponent getTracer() {
        return null;
    }
}

