/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rsadapter.AdapterUtil;
import java.text.DecimalFormat;
import java.util.LinkedList;

public class CacheMap {
    private static TraceComponent tc = Tr.register(CacheMap.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private final int maxEntries;
    private int numEntries;
    private final int numBuckets;
    private static final int maxBucketSize = 5;
    private int numDiscards;
    private final Object[][] values;
    private final Object[][] keys;
    private final int[] bucketSizes;
    private final int[] previous;
    private final int[] next;
    private final int BEFORE_LRU;
    private final int AFTER_MRU;

    public CacheMap(int maxSize) {
        this.maxEntries = maxSize;
        this.BEFORE_LRU = this.numBuckets = (this.maxEntries * 4 + 1) / 3;
        this.AFTER_MRU = this.numBuckets + 1;
        int numPointers = this.numBuckets + 2;
        this.previous = new int[numPointers];
        this.next = new int[numPointers];
        this.values = new Object[this.numBuckets][5];
        this.keys = new Object[this.numBuckets][5];
        this.bucketSizes = new int[this.numBuckets];
        for (int i = 0; i < this.numBuckets; ++i) {
            this.next[i] = this.previous[i] = this.BEFORE_LRU;
        }
        this.next[this.BEFORE_LRU] = this.AFTER_MRU;
        this.previous[this.AFTER_MRU] = this.BEFORE_LRU;
    }

    public final Object add(Object key, Object value) {
        int p;
        int bucketIndex;
        int n = bucketIndex = (key.hashCode() & Integer.MAX_VALUE) % this.numBuckets;
        int n2 = this.bucketSizes[n];
        this.bucketSizes[n] = n2 + 1;
        int bucketSize = n2;
        Object discardedObject = bucketSize == 5 ? this.discardFromBucket(bucketIndex, --bucketSize) : null;
        this.values[bucketIndex][bucketSize] = value;
        this.keys[bucketIndex][bucketSize] = key;
        int n3 = this.next[bucketIndex];
        if (n3 != this.BEFORE_LRU) {
            this.previous[n3] = p = this.previous[bucketIndex];
            this.next[p] = n3;
        }
        p = this.previous[this.AFTER_MRU];
        this.previous[this.AFTER_MRU] = this.next[p] = bucketIndex;
        this.next[bucketIndex] = this.AFTER_MRU;
        this.previous[bucketIndex] = p;
        return ++this.numEntries > this.maxEntries ? this.removeLRU() : discardedObject;
    }

    public Object[] addAll(CacheMap c) {
        LinkedList<Object> discards = new LinkedList<Object>();
        int bucketIndex = c.next[c.BEFORE_LRU];
        while (bucketIndex != c.AFTER_MRU) {
            for (int i = 0; i < c.bucketSizes[bucketIndex]; ++i) {
                Object discard = this.add(c.keys[bucketIndex][i], c.values[bucketIndex][i]);
                if (discard == null) continue;
                discards.add(discard);
            }
            bucketIndex = c.next[bucketIndex];
        }
        return discards.toArray();
    }

    private Object discardFromBucket(int bucketIndex, int entryIndex) {
        ++this.numDiscards;
        int n = bucketIndex;
        this.bucketSizes[n] = this.bucketSizes[n] - 1;
        --this.numEntries;
        return this.values[bucketIndex][entryIndex];
    }

    public String display() {
        StringBuffer sb = new StringBuffer();
        DecimalFormat f = new DecimalFormat("'  '000");
        sb.append(AdapterUtil.EOLN).append(this);
        sb.append(AdapterUtil.EOLN).append("Number of entries:   ").append(this.numEntries);
        sb.append(AdapterUtil.EOLN).append("Maximum entries:     ").append(this.maxEntries);
        sb.append(AdapterUtil.EOLN).append("Number of buckets:   ").append(this.numBuckets);
        sb.append(AdapterUtil.EOLN).append("Maximum bucket size: ").append(5);
        sb.append(AdapterUtil.EOLN).append("Number of discards:  ").append(this.numDiscards);
        sb.append(AdapterUtil.EOLN);
        sb.append(AdapterUtil.EOLN).append("BUCKET SIZE PREV NEXT");
        sb.append(AdapterUtil.EOLN);
        for (int i = 0; i < this.numBuckets; ++i) {
            sb.append(f.format(i));
            sb.append(f.format(this.bucketSizes[i]));
            sb.append(f.format(this.previous[i]));
            sb.append(f.format(this.next[i]));
            sb.append(AdapterUtil.EOLN);
            for (int j = 0; j < this.bucketSizes[i]; ++j) {
                sb.append("                      ").append(Integer.toHexString(this.values[i][j].hashCode())).append(' ').append(this.keys[i][j]).append(AdapterUtil.EOLN);
            }
        }
        sb.append(f.format(this.BEFORE_LRU)).append("  LRU     ").append(f.format(this.next[this.BEFORE_LRU])).append(AdapterUtil.EOLN);
        sb.append(f.format(this.AFTER_MRU)).append("  MRU").append(f.format(this.previous[this.AFTER_MRU])).append(AdapterUtil.EOLN);
        return new String(sb);
    }

    public final int getMaxSize() {
        return this.maxEntries;
    }

    public final Object remove(Object key) {
        int bucketIndex = (key.hashCode() & Integer.MAX_VALUE) % this.numBuckets;
        Object[] bucketKeys = this.keys[bucketIndex];
        int bucketSize = this.bucketSizes[bucketIndex];
        for (int i = bucketSize - 1; i >= 0; --i) {
            if (!bucketKeys[i].equals(key)) continue;
            if ((this.bucketSizes[bucketIndex] = --bucketSize) == 0) {
                int n = this.next[bucketIndex];
                int p = this.previous[n] = this.previous[bucketIndex];
                this.next[p] = n;
                this.next[bucketIndex] = this.previous[bucketIndex] = this.BEFORE_LRU;
            }
            --this.numEntries;
            bucketKeys[i] = bucketKeys[bucketSize];
            bucketKeys[bucketSize] = null;
            Object[] bucketValues = this.values[bucketIndex];
            Object value = bucketValues[i];
            bucketValues[i] = bucketValues[bucketSize];
            bucketValues[bucketSize] = null;
            return value;
        }
        return null;
    }

    public final Object[] removeAll() {
        Object[] list = new Object[this.numEntries];
        this.numEntries = 0;
        try {
            int i = this.numBuckets;
            int counter = 0;
            while (i > 0) {
                int j = this.bucketSizes[--i];
                while (j > 0) {
                    Object[] bucketValues = this.values[i];
                    Object[] bucketKeys = this.keys[i];
                    bucketKeys[--j] = null;
                    list[counter++] = bucketValues[j];
                    bucketValues[j] = null;
                }
                this.bucketSizes[i] = 0;
            }
            for (i = 0; i <= this.AFTER_MRU; ++i) {
                this.next[i] = this.previous[i] = this.BEFORE_LRU;
            }
        }
        catch (ArrayIndexOutOfBoundsException ioobX) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"ArrayIndexOutOfBoundsException is caught during removeAll() of the cachMap ", (Object[])new Object[]{this});
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Possible causes:", (Object[])new Object[0]);
                Tr.debug((Object)this, (TraceComponent)tc, (String)"multithreaded access of JDBC objects by the Application", (Object[])new Object[0]);
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Application is closing JDBC objects in a finalize()", (Object[])new Object[0]);
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Exception is: ", (Object[])new Object[]{ioobX});
            }
            throw ioobX;
        }
        return list;
    }

    private final Object removeLRU() {
        int bucketIndex = this.next[this.BEFORE_LRU];
        Object[] bucketValues = this.values[bucketIndex];
        Object[] bucketKeys = this.keys[bucketIndex];
        int n = bucketIndex;
        int n2 = this.bucketSizes[n] - 1;
        this.bucketSizes[n] = n2;
        int bucketSize = n2;
        --this.numEntries;
        int indexToRemove = (this.numDiscards++ & Integer.MAX_VALUE) % (bucketSize + 1);
        Object value = bucketValues[indexToRemove];
        if (bucketSize == 0) {
            int n3 = this.next[bucketIndex];
            int p = this.previous[n3] = this.previous[bucketIndex];
            this.next[p] = n3;
            this.next[bucketIndex] = this.BEFORE_LRU;
            bucketValues[0] = null;
            bucketKeys[0] = null;
        } else {
            bucketValues[indexToRemove] = bucketValues[bucketSize];
            bucketValues[bucketSize] = null;
            bucketKeys[indexToRemove] = bucketKeys[bucketSize];
            bucketKeys[bucketSize] = null;
        }
        return value;
    }

    public final int size() {
        return this.numEntries;
    }
}

