/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jca.adapter.WSConnectionManager;
import com.ibm.ws.jdbc.osgi.JDBCRuntimeVersion;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.ConnectionSharing;
import com.ibm.ws.rsadapter.DSConfig;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement;
import com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData;
import com.ibm.ws.rsadapter.jdbc.WSJdbcObject;
import com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement;
import com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet;
import com.ibm.ws.rsadapter.jdbc.WSJdbcStatement;
import com.ibm.ws.rsadapter.jdbc.WSJdbcTracer;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.jdbc.WSJdbcWrapper;
import com.ibm.ws.rsadapter.spi.CSCacheKey;
import com.ibm.ws.rsadapter.spi.DB2SQLJCSCacheKey;
import com.ibm.ws.rsadapter.spi.DB2SQLJPSCacheKey;
import com.ibm.ws.rsadapter.spi.PSCacheKey;
import com.ibm.ws.rsadapter.spi.StatementCacheKey;
import com.ibm.ws.rsadapter.spi.WSConnectionRequestInfoImpl;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLRecoverableException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Wrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LazyAssociatableConnectionManager;
import javax.resource.spi.LazyEnlistableConnectionManager;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.SharingViolationException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;

public class WSJdbcConnection
extends WSJdbcObject
implements Connection {
    private static final TraceComponent tc = Tr.register(WSJdbcConnection.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private static final Class<?> CASTABLE_CONNECTION_MARKER = Proxy.class;
    private static boolean warnedAboutCatalogMatching;
    private static boolean warnedAboutHoldabilityMatching;
    private static boolean warnedAboutReadOnlyMatching;
    private static boolean warnedAboutTypeMapMatching;
    private static boolean warnedAboutSchemaMatching;
    private static boolean warnedAboutNetworkTimeoutMatching;
    private String[] currentClientInfo;
    private boolean clientInfoSetExplicitly;
    private Properties clientProps;
    protected Connection connImpl;
    DataStoreHelper helper;
    WSRdbManagedConnectionImpl managedConn;
    private WSConnectionManager cm;
    private LazyEnlistableConnectionManager lazyEnlistableCM;
    private LazyAssociatableConnectionManager lazyAssociatableCM;
    private boolean isReserved;
    protected Object managedConnKey;
    private ConnectionRequestInfo connRequestInfo;
    protected boolean autoCommit;
    private boolean rrsTransactional;
    protected Object threadID;
    protected boolean isResultSetClosedAtCommit;
    protected int currentTransactionIsolation = 2;
    protected boolean supportIsolvlSwitching = false;
    private boolean aborted = false;

    protected WSJdbcConnection() {
    }

    public WSJdbcConnection(WSRdbManagedConnectionImpl mc, Connection conn, Object key, Object currentThreadID) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object[])new Object[]{mc, AdapterUtil.toString(conn)});
        }
        this.managedConn = mc;
        this.connImpl = conn;
        this.managedConnKey = key;
        this.threadID = currentThreadID;
        this.mcf = this.managedConn.getManagedConnectionFactory();
        this.helper = this.mcf.getDataStoreHelper();
        this.supportIsolvlSwitching = this.mcf.getInternalDataStoreHelper().isIsolationLevelSwitchingSupport();
        this.dsConfig = this.mcf.dsConfig;
        this.jdbcVersion = this.mcf.jdbcVersion;
        this.rrsTransactional = this.mcf.getRRSTransactional();
        this.freeResourcesOnClose = false;
        this.autoCommit = this.managedConn.getTransactionState() == 1 && !this.managedConn.inGlobalTransaction() ? false : this.managedConn.getDefaultAutoCommit();
        this.childWrappers = new ArrayList(8);
        this.currentTransactionIsolation = this.managedConn.getTransactionIsolation();
        this.init(null);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    protected final Connection initialize(WSConnectionManager connectionManager) throws SQLException {
        this.cm = connectionManager;
        if (this.state != WSJdbcWrapper.State.INACTIVE) {
            this.connImpl.clearWarnings();
        }
        return this;
    }

    public Connection initialize(WSConnectionManager connectionManager, Object key) throws ResourceException, SQLException {
        if (this.managedConnKey == null) {
            throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Connection", null, WSJdbcConnection.class);
        }
        if (key != this.managedConnKey) {
            throw AdapterUtil.createDataStoreAdapterException("NOT_A_JDBC_METHOD", null, null, WSJdbcConnection.class);
        }
        return this.initialize(connectionManager);
    }

    private void beginLocalTransactionIfNecessary() throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (this.managedConn.isMCStale()) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"MC is stale", (Object[])new Object[]{this.managedConn});
            }
            throw AdapterUtil.staleX();
        }
        if (this.autoCommit) {
            return;
        }
        try {
            this.managedConn.processLocalTransactionStartedEvent(this);
        }
        catch (ResourceException ex) {
            FFDCFilter.processException((Throwable)ex, (String)(WSJdbcConnection.class.getName() + ".beginLocalTransactionIfNecessary"), (String)"343", (Object)this);
            throw AdapterUtil.toSQLException(ex);
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Local transaction started for " + this), (Object[])new Object[0]);
        }
    }

    @Override
    protected void beginTransactionIfNecessary() throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"beginTransactionIfNecessary", (Object[])new Object[]{this.managedConn.getTransactionStateAsString()});
        }
        boolean enforceAutoCommit = false;
        if (this.managedConn.isMCStale()) {
            SQLException x = AdapterUtil.staleX();
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"beginTransactionIfNecessary", (Object)("MC is stale: " + this.managedConn));
            }
            throw x;
        }
        if (this.threadID != null) {
            this.detectMultithreadedAccess();
        }
        if (this.supportIsolvlSwitching) {
            this.managedConn.setTransactionIsolation(this.currentTransactionIsolation);
        }
        if (!this.managedConn.isTransactional()) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"beginTransactionIfNecessary", (Object)"no-op enlistment is disabled");
            }
            return;
        }
        switch (this.managedConn.getTransactionState()) {
            case 2: {
                break;
            }
            case 7: {
                this.managedConn.setRrsGlobalTransactionReallyActive(true);
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                if (this.managedConn.isGlobalTransactionActive()) {
                    try {
                        this.managedConn.lazyEnlist(this.lazyEnlistableCM == null ? (this.lazyEnlistableCM = (LazyEnlistableConnectionManager)this.cm) : this.lazyEnlistableCM);
                        break;
                    }
                    catch (ClassCastException castX) {
                        enforceAutoCommit = true;
                        this.beginLocalTransactionIfNecessary();
                        break;
                    }
                    catch (ResourceException resX) {
                        SystemException sysX;
                        FFDCFilter.processException((Throwable)resX, (String)(WSJdbcConnection.class.getName() + ".beginTransactionIfNecessary"), (String)"324", (Object)this);
                        if (resX.getCause() instanceof SystemException && (sysX = (SystemException)resX.getCause()).getCause() != null && sysX.getCause() instanceof XAException) {
                            XAException xaX = (XAException)sysX.getCause();
                            if (xaX.errorCode == -7) {
                                SQLRecoverableException badConnX = new SQLRecoverableException(resX.getMessage());
                                badConnX.initCause(xaX);
                                if (isTraceOn && tc.isEntryEnabled()) {
                                    Tr.exit((Object)this, (TraceComponent)tc, (String)"beginTransactionIfNecessary", (Object)badConnX);
                                }
                                throw badConnX;
                            }
                        }
                        SQLException x = AdapterUtil.toSQLException(resX);
                        if (isTraceOn && tc.isEntryEnabled()) {
                            Tr.exit((Object)this, (TraceComponent)tc, (String)"beginTransactionIfNecessary", (Object)x);
                        }
                        throw x;
                    }
                }
                enforceAutoCommit = true;
                this.beginLocalTransactionIfNecessary();
                break;
            }
            default: {
                SQLException x = new SQLException(AdapterUtil.getNLSMessage("INVALID_TRAN_STATE", this.managedConn.getTransactionStateAsString()));
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"beginTransactionIfNecessary", (Object)x);
                }
                throw x;
            }
        }
        if (enforceAutoCommit) {
            this.managedConn.enforceAutoCommit(this.autoCommit);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"beginTransactionIfNecessary");
        }
    }

    @Override
    public final void clearWarnings() throws SQLException {
        this.activate();
        try {
            this.connImpl.clearWarnings();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.clearWarnings", (String)"395", (Object)this);
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    protected SQLException closeWrapper(boolean closeWrapperOnly) {
        SQLException sqlX;
        block15: {
            block14: {
                boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
                sqlX = null;
                if (this.managedConn != null && this.managedConn.getNumberOfInUseHandles() == 1) {
                    try {
                        boolean dCsPgC = this.mcf.getDataStoreHelper().doConnectionCleanupPerCloseConnection(this.connImpl, false, null);
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionCleanupPerCloseConnection on [helper, mc, sqlCon, returned value]", (Object[])new Object[]{this.mcf.getDataStoreHelper(), this.managedConn, this.connImpl, dCsPgC});
                        }
                        this.managedConn.workNeedsToBeUnDone = false;
                    }
                    catch (Throwable x) {
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionCleanupPerCloseConnection method caught an exception", (Object[])new Object[]{x});
                        }
                        if (x instanceof SQLException) {
                            sqlX = WSJdbcUtil.mapException(this, (SQLException)x);
                            break block14;
                        }
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"initializing a new sqlexception based on the non-sql thrown by doConnectionCleanupPerCloseConnection", (Object[])new Object[]{x});
                        }
                        sqlX = new SQLException(x.getMessage(), null, 999999);
                    }
                } else if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionCleanupPerCloseConnection is not called on mc because number of handles is not 1  or MC is null(i.e. get=>use=>close is not followed", (Object[])new Object[]{this.managedConn, this.managedConn == null ? 0 : this.managedConn.getNumberOfInUseHandles()});
                }
            }
            if (this.managedConn != null) {
                try {
                    this.managedConn.processConnectionClosedEvent(this);
                }
                catch (ResourceException resX) {
                    FFDCFilter.processException((Throwable)resX, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.close", (String)"495", (Object)this);
                    if (sqlX == null) {
                        sqlX = AdapterUtil.toSQLException(resX);
                        break block15;
                    }
                    Tr.warning((TraceComponent)tc, (String)"DSA_INTERNAL_ERR_WARNING", (Object[])new Object[]{"An unexpected error occurred sending a connectionClosed event. ", resX});
                }
            } else {
                ((LazyAssociatableConnectionManager)this.cm).inactiveConnectionClosed((Object)this, (ManagedConnectionFactory)this.mcf);
            }
        }
        this.connImpl = null;
        this.childWrappers = null;
        this.managedConnKey = null;
        this.connRequestInfo = null;
        this.managedConn = null;
        this.cm = null;
        this.helper = null;
        this.threadID = null;
        this.clientProps = null;
        return sqlX;
    }

    @Override
    public void commit() throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"commit", (Object[])new Object[]{this});
        }
        if (this.managedConn != null && this.managedConn.isMCStale()) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"MC is stale", (Object[])new Object[]{this.managedConn});
            }
            throw AdapterUtil.staleX();
        }
        if (this.state == WSJdbcWrapper.State.CLOSED) {
            SQLException closedX = this.createClosedException("Connection");
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)closedX);
            }
            throw closedX;
        }
        if (this.threadID != null) {
            this.detectMultithreadedAccess();
        }
        if (this.state == WSJdbcWrapper.State.INACTIVE) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)"no-op; state is INACTIVE");
            }
            return;
        }
        try {
            if (!this.managedConn.isTransactional()) {
                this.connImpl.commit();
                if (this.isResultSetClosedAtCommit) {
                    for (int i = this.childWrappers.size() - 1; i > -1; --i) {
                        ((WSJdbcStatement)this.childWrappers.get(i)).closeResultSetsIfNecessary();
                    }
                }
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)"Enlistment is disabled");
                }
                return;
            }
            if (this.managedConn.inGlobalTransaction()) {
                SQLException sqlX = new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_GT", "Connection.commit"));
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)sqlX);
                }
                throw sqlX;
            }
            if (this.managedConn.getTransactionState() == 1) {
                this.managedConn.processLocalTransactionCommittedEvent(this);
                if (this.isResultSetClosedAtCommit) {
                    for (int i = this.childWrappers.size() - 1; i > -1; --i) {
                        ((WSJdbcStatement)this.childWrappers.get(i)).closeResultSetsIfNecessary();
                    }
                }
            } else {
                this.connImpl.commit();
            }
        }
        catch (ResourceException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.commit", (String)"776", (Object)this);
            SQLException sqlX = AdapterUtil.toSQLException(ex);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)"Exception");
            }
            throw sqlX;
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".commit"), (String)"587", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)"Exception");
            }
            throw this.proccessSQLException(sqlX);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"commit");
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        Array ra;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"createArrayOf", (Object[])new Object[]{typeName});
        }
        try {
            this.activate();
            ra = this.connImpl.createArrayOf(typeName, elements);
            if (this.freeResourcesOnClose) {
                this.arrays.add(ra);
            }
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".createArrayOf"), (String)"1014", (Object)this);
            throw this.proccessSQLException(sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("Connection.createArrayOf", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".createArrayOf"), (String)"1057", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createArrayOf", (Object)runX);
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".createArrayOf"), (String)"1064", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createArrayOf", (Object)err);
            }
            throw err;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"createArrayOf", (Object)AdapterUtil.toString(ra));
        }
        return ra;
    }

    @Override
    public Blob createBlob() throws SQLException {
        Blob blob;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"createBlob", (Object[])new Object[0]);
        }
        try {
            this.activate();
            blob = this.connImpl.createBlob();
            if (this.freeResourcesOnClose) {
                this.blobs.add(blob);
            }
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".createBlob"), (String)"1040", (Object)this);
            throw this.proccessSQLException(sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("Connection.createBlob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".createBlob"), (String)"1108", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createBlob", (Object)runX);
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".createBlob"), (String)"1115", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createBlob", (Object)err);
            }
            throw err;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"createBlob", (Object)AdapterUtil.toString(blob));
        }
        return blob;
    }

    @Override
    public Clob createClob() throws SQLException {
        Clob clob;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"createClob", (Object[])new Object[0]);
        }
        try {
            this.activate();
            clob = this.connImpl.createClob();
            if (this.freeResourcesOnClose) {
                this.clobs.add(clob);
            }
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".createClob"), (String)"1066", (Object)this);
            throw this.proccessSQLException(sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("Connection.createClob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".createClob"), (String)"1156", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createClob", (Object)runX);
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".createClob"), (String)"1163", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createClob", (Object)err);
            }
            throw err;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"createClob", (Object)AdapterUtil.toString(clob));
        }
        return clob;
    }

    protected CallableStatement createCallableStatementWrapper(CallableStatement cstmtImplObject, int holdability, String sql) throws SQLException {
        this.isResultSetClosedAtCommit = this.isResultSetClosedAtCommit || holdability == 2;
        return new WSJdbcCallableStatement(cstmtImplObject, this, holdability, sql);
    }

    protected CallableStatement createCallableStatementWrapper(CallableStatement cstmtImplObject, int holdability, String sql, StatementCacheKey key) throws SQLException {
        this.isResultSetClosedAtCommit = this.isResultSetClosedAtCommit || holdability == 2;
        return new WSJdbcCallableStatement(cstmtImplObject, this, holdability, sql, key);
    }

    @Override
    public NClob createNClob() throws SQLException {
        NClob clob;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"createNClob", (Object[])new Object[0]);
        }
        try {
            this.activate();
            clob = this.connImpl.createNClob();
            if (this.freeResourcesOnClose) {
                this.clobs.add(clob);
            }
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".createNClob"), (String)"1262", (Object)this);
            throw this.proccessSQLException(sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("Connection.createNClob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".createNClob"), (String)"1280", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createNClob", (Object)runX);
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".createNClob"), (String)"1287", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createNClob", (Object)err);
            }
            throw err;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"createNClob", (Object)AdapterUtil.toString(clob));
        }
        return clob;
    }

    protected PreparedStatement createPreparedStatementWrapper(PreparedStatement pstmtImplObject, int holdability, String sql) throws SQLException {
        this.isResultSetClosedAtCommit = this.isResultSetClosedAtCommit || holdability == 2;
        return new WSJdbcPreparedStatement(pstmtImplObject, this, holdability, sql);
    }

    protected PreparedStatement createPreparedStatementWrapper(PreparedStatement pstmtImplObject, int holdability, String sql, StatementCacheKey key) throws SQLException {
        this.isResultSetClosedAtCommit = this.isResultSetClosedAtCommit || holdability == 2;
        return new WSJdbcPreparedStatement(pstmtImplObject, this, holdability, sql, key);
    }

    protected WSJdbcResultSet createResultSetWrapper(ResultSet rsetImplObject, WSJdbcObject rsetParentWrapper) {
        return new WSJdbcResultSet(rsetImplObject, rsetParentWrapper);
    }

    protected SQLException createSharingException(String methodName) {
        String message = AdapterUtil.getNLSMessage("OP_NOT_SHAREABLE", methodName);
        SQLException sharingX = new SQLException(message);
        sharingX.initCause((Throwable)new SharingViolationException(message));
        return sharingX;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        SQLXML xml;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"createSQLXML", (Object[])new Object[]{this});
        }
        try {
            this.activate();
            xml = this.connImpl.createSQLXML();
            if (this.freeResourcesOnClose) {
                this.xmls.add(xml);
            }
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".createSQLXML"), (String)"1342", (Object)this);
            throw this.proccessSQLException(sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("Connection.createSQLXML", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".createSQLXML"), (String)"1358", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createSQLXML", (Object)runX);
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".createSQLXML"), (String)"1365", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createSQLXML", (Object)err);
            }
            throw err;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"createSQLXML", (Object)AdapterUtil.toString(xml));
        }
        return xml;
    }

    @Override
    public final Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public final Statement createStatement(int type, int concurrency) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createStatement", (Object[])new Object[]{AdapterUtil.getResultSetTypeString(type), AdapterUtil.getConcurrencyModeString(concurrency)});
        }
        Statement stmt = null;
        try {
            if (this.state != WSJdbcWrapper.State.ACTIVE) {
                this.activate();
            }
            this.beginTransactionIfNecessary();
            stmt = this.connImpl.createStatement(type, concurrency);
            Integer queryTimeout = ((DSConfig)this.dsConfig.get()).queryTimeout;
            if (queryTimeout != null) {
                stmt.setQueryTimeout(queryTimeout);
            }
            stmt = this.createStatementWrapper(stmt, this.managedConn.getCurrentHoldability());
            this.childWrappers.add(stmt);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.createStatement", (String)"865", (Object)this);
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable x) {
                    // empty catch block
                }
            }
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createStatement", (Object)"Exception");
            }
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createStatement", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"createStatement", (Object)stmt);
        }
        return stmt;
    }

    protected Statement createStatementWrapper(Statement stmtImplObject, int holdability) throws SQLException {
        this.isResultSetClosedAtCommit = this.isResultSetClosedAtCommit || holdability == 2;
        return new WSJdbcStatement(stmtImplObject, this, holdability);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        Struct struct;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"createStruct", (Object[])new Object[]{typeName});
        }
        try {
            this.activate();
            struct = this.connImpl.createStruct(typeName, attributes);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".createStruct"), (String)"1341", (Object)this);
            throw this.proccessSQLException(sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("Connection.createStruct", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".createStruct"), (String)"1638", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createStruct", (Object)runX);
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".createStruct"), (String)"1645", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createStruct", (Object)err);
            }
            throw err;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"createStruct", (Object)AdapterUtil.toString(struct));
        }
        return struct;
    }

    protected final void detectMultithreadedAccess() {
        if (!((DSConfig)this.dsConfig.get()).enableMultithreadedAccessDetection) {
            return;
        }
        Thread currentThreadID = Thread.currentThread();
        if (currentThreadID != this.threadID) {
            this.mcf.detectedMultithreadedAccess = true;
            StringWriter writer = new StringWriter();
            new Error().printStackTrace(new PrintWriter(writer));
            Tr.warning((TraceComponent)tc, (String)"MULTITHREADED_ACCESS_DETECTED", (Object[])new Object[]{Integer.toHexString(this.threadID.hashCode()) + ' ' + this.threadID, Integer.toHexString(currentThreadID.hashCode()) + ' ' + currentThreadID, writer.getBuffer().delete(0, "java.lang.Error".length())});
        }
    }

    public void dissociate() throws ResourceException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"dissociate", (Object[])new Object[]{this.state, this.isReserved});
        }
        switch (this.state) {
            case ACTIVE: {
                break;
            }
            case INACTIVE: {
                if (this.isReserved) {
                    this.isReserved = false;
                    break;
                }
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"dissociate", (Object)"Already dissociated.");
                }
                return;
            }
            case CLOSED: {
                DataStoreAdapterException x = AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Connection", null, WSJdbcConnection.class);
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"dissociate", (Object)"OBJECT_CLOSED");
                }
                throw x;
            }
        }
        if (this.dynamicWrapperToImpl != null) {
            this.dynamicWrapperToImpl.clear();
        }
        this.closeChildWrappers();
        this.connRequestInfo = this.managedConn.createConnectionRequestInfo();
        if (this.managedConn.clientInfoExplicitlySet || this.managedConn.clientInfoImplicitlySet) {
            if (this.jdbcVersion >= 4) {
                try {
                    this.clientProps = this.connImpl.getClientInfo();
                }
                catch (SQLException sqlX) {
                    FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".dissociate"), (String)"1702", (Object)this);
                    DataStoreAdapterException x = new DataStoreAdapterException("DSA_ERROR", this.proccessSQLException(sqlX), WSJdbcConnection.class);
                    if (isTraceOn && tc.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)tc, (String)"dissociate", (Object)sqlX);
                    }
                    throw x;
                }
            } else {
                this.currentClientInfo = this.managedConn.getCurrentClientInfo();
            }
            this.clientInfoSetExplicitly = this.managedConn.clientInfoExplicitlySet;
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"clientProps saved from mc is:", (Object[])this.currentClientInfo);
            }
        }
        this.managedConn.dissociateHandle(this);
        this.connImpl = null;
        this.managedConn = null;
        this.state = WSJdbcWrapper.State.INACTIVE;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"dissociate", (Object)"state --> INACTIVE");
        }
    }

    public void fireConnectionErrorEvent(Exception ex, boolean logEvent) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        switch (this.state) {
            case ACTIVE: {
                try {
                    this.managedConn.processConnectionErrorOccurredEvent(this, ex, logEvent);
                }
                catch (NullPointerException nullX) {
                    if (!isTraceOn || !tc.isDebugEnabled()) break;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Handle CLOSED or INACTIVE. Not sending CONNECTION_ERROR_OCCURRED.", (Object[])new Object[0]);
                }
                break;
            }
            case INACTIVE: {
                try {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Handle is INACTIVE. Not sending CONNECTION_ERROR_OCCURRED.", (Object[])new Object[0]);
                    }
                    this.close();
                }
                catch (SQLException closeX) {
                    FFDCFilter.processException((Throwable)closeX, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.FireConnectionErrorEvent", (String)"965", (Object)this);
                    if (!isTraceOn || !tc.isDebugEnabled()) break;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Error closing connection:", (Object[])new Object[]{closeX});
                }
                break;
            }
            case CLOSED: {
                if (!isTraceOn || !tc.isDebugEnabled()) break;
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Connection already closed. Not sending CONNECTION_ERROR_OCCURRED.", (Object[])new Object[0]);
            }
        }
    }

    @Override
    public final boolean getAutoCommit() throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (this.state != WSJdbcWrapper.State.ACTIVE) {
            this.activate();
        }
        if (this.rrsTransactional) {
            UOWCurrent uow;
            UOWCoordinator uowCoord;
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"MCF is rrsTransactional - check for Global", (Object[])new Object[0]);
            }
            UOWCoordinator uOWCoordinator = uowCoord = (uow = (UOWCurrent)this.mcf.connectorSvc.getTransactionManager()) == null ? null : uow.getUOWCoord();
            if (uowCoord != null && uowCoord.isGlobal()) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"RRSGlobalTran active - return autoCommit=false", (Object[])new Object[0]);
                }
                return false;
            }
        }
        return this.autoCommit;
    }

    Connection getCastableWrapper(AtomicReference<Class<?>[]> vendorConnectionInterfaces) {
        Object[] interfaceList = vendorConnectionInterfaces.get();
        if (interfaceList == null) {
            LinkedHashSet interfaces = new LinkedHashSet();
            interfaces.add(Connection.class);
            for (Class<?> c = this.connImpl.getClass(); c != null; c = c.getSuperclass()) {
                for (Class<?> i : c.getInterfaces()) {
                    if (Wrapper.class.equals(i) || "java.lang.AutoCloseable".equals(i.getName())) continue;
                    interfaces.add(i);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"initVendorConnectionInterfaceList", (Object[])new Object[]{interfaces});
            }
            interfaceList = interfaces.toArray(new Class[interfaces.size()]);
            vendorConnectionInterfaces.set((Class<?>[])interfaceList);
        }
        if (interfaceList.length <= 1) {
            return this;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Create castable wrapper for", (Object[])new Object[]{Arrays.toString(interfaceList)});
        }
        Connection wrapper = (Connection)Proxy.newProxyInstance(this.connImpl.getClass().getClassLoader(), interfaceList, (InvocationHandler)this);
        this.ifcToDynamicWrapper.put(CASTABLE_CONNECTION_MARKER, wrapper);
        this.dynamicWrapperToImpl.put(wrapper, this.connImpl);
        return wrapper;
    }

    public ManagedConnection getManagedConnection(Object key) throws ResourceException {
        if (this.managedConnKey == null) {
            throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Connection", null, WSJdbcConnection.class);
        }
        if (key != this.managedConnKey) {
            throw AdapterUtil.createDataStoreAdapterException("NOT_A_JDBC_METHOD", null, null, WSJdbcConnection.class);
        }
        return this.managedConn;
    }

    @Override
    public final String getCatalog() throws SQLException {
        this.activate();
        try {
            return this.managedConn.getCatalog();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.getCatalog", (String)"917", (Object)this);
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.activate();
        try {
            return this.connImpl.getClientInfo();
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".getClientInfo"), (String)"1574", (Object)this);
            throw this.proccessSQLException(sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("Connection.getClientInfo", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".getClientInfo"), (String)"1891", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getClientInfo", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".getClientInfo"), (String)"1898", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getClientInfo", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.activate();
        try {
            return this.connImpl.getClientInfo(name);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".getClientInfo"), (String)"1574", (Object)this);
            throw this.proccessSQLException(sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("Connection.getClientInfo", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".getClientInfo"), (String)"1936", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getClientInfo", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".getClientInfo"), (String)"1943", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getClientInfo", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    protected final WSJdbcObject getConnectionWrapper() {
        return this;
    }

    private String getGlobalTranStatusAsString() {
        int status = 6;
        try {
            EmbeddableWebSphereTransactionManager tm = this.mcf.connectorSvc.getTransactionManager();
            if (tm != null) {
                status = tm.getStatus();
            }
        }
        catch (SystemException sysex) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Recieving SystemException from TransactionManager, ignore it and change to STATUS_UNKNOWN", (Object[])new Object[0]);
            }
            status = 5;
        }
        switch (status) {
            case 0: {
                return "STATUS ACTIVE (" + status + ')';
            }
            case 3: {
                return "STATUS COMMITTED (" + status + ')';
            }
            case 8: {
                return "STATUS COMMITTING (" + status + ')';
            }
            case 1: {
                return "STATUS MARKED ROLLBACK (" + status + ')';
            }
            case 6: {
                return "STATUS NO TRANSACTION (" + status + ')';
            }
            case 2: {
                return "STATUS PREPARED (" + status + ')';
            }
            case 7: {
                return "STATUS PREPARING (" + status + ')';
            }
            case 4: {
                return "STATUS ROLLEDBACK (" + status + ')';
            }
            case 9: {
                return "STATUS ROLLING BACK (" + status + ')';
            }
            case 5: {
                return "STATUS UNKNOWN (" + status + ')';
            }
        }
        return "UNKNOWN GLOBAL TRANSACTION STATUS (" + status + ')';
    }

    @Override
    protected final Wrapper getJDBCImplObject() {
        return this.connImpl;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getMetaData", (Object[])new Object[]{this});
        }
        try {
            this.activate();
            this.beginTransactionIfNecessary();
            this.childWrapper = this.childWrapper == null ? new WSJdbcDatabaseMetaData(this.connImpl.getMetaData(), this) : this.childWrapper;
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.getMetaData", (String)"922", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getMetaData", (Object)"Exception");
            }
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getMetaData", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getMetaData", (Object)this.childWrapper);
        }
        return (WSJdbcDatabaseMetaData)this.childWrapper;
    }

    @Override
    protected TraceComponent getTracer() {
        return tc;
    }

    @Override
    public final int getTransactionIsolation() throws SQLException {
        if (this.state != WSJdbcWrapper.State.ACTIVE) {
            this.activate();
        }
        try {
            return this.managedConn.getTransactionIsolation();
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public final Map<String, Class<?>> getTypeMap() throws SQLException {
        this.activate();
        try {
            return this.managedConn.getTypeMap();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.getTypeMap", (String)"927", (Object)this);
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        this.activate();
        try {
            return this.connImpl.getWarnings();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.getWarnings", (String)"991", (Object)this);
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public String[] introspectSelf() {
        FFDCLogger info = new FFDCLogger(this);
        this.introspectAll(info);
        info.eoln();
        info.introspect("ConnectionRequestInfo:", this.connRequestInfo);
        info.introspect("ManagedConnectionFactory:", (Object)this.mcf);
        info.introspect("ManagedConnection:", this.managedConn);
        return info.toStringArray();
    }

    @Override
    protected void introspectWrapperSpecificInfo(FFDCLogger info) {
        info.append("Transaction Manager global transaction status is", this.getGlobalTranStatusAsString());
        info.append("Underlying Connection: " + AdapterUtil.toString(this.connImpl), this.connImpl);
        info.append("Key Object:", this.managedConnKey);
        info.append("DataStoreHelper:", this.helper);
        info.introspect("Connection Manager:", this.cm);
        info.append("ConnectionManager supports lazy association?", this.cm instanceof LazyAssociatableConnectionManager ? Boolean.TRUE : Boolean.FALSE);
        info.append("ConnectionManager supports lazy enlistment?", this.cm instanceof LazyEnlistableConnectionManager ? Boolean.TRUE : Boolean.FALSE);
        info.append("Handle is reserved? " + this.isReserved);
        info.append("AutoCommit value tracked by handle: " + this.autoCommit);
        info.append("Thread id:", this.threadID);
    }

    @Override
    Object invokeOperation(Object implObject, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException {
        int numArgs;
        int n = numArgs = args == null ? 0 : args.length;
        if (numArgs == 0 && method.getName().equals("getConnectionContext")) {
            return this.managedConn.getSQLJConnectionContext(method.getReturnType());
        }
        if (numArgs > 10) {
            String methodName = method.getName();
            if (methodName.equals("prepareSQLJStatement")) {
                return this.prepareSQLJStatement(implObject, method, args);
            }
            if (methodName.equals("prepareSQLJCall")) {
                return this.prepareSQLJCall(implObject, method, args);
            }
        }
        return super.invokeOperation(implObject, method, args);
    }

    @Override
    public final boolean isReadOnly() throws SQLException {
        this.activate();
        try {
            return this.managedConn.isReadOnly();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.isReadOnly", (String)"996", (Object)this);
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    public final boolean isReserved() {
        return this.isReserved;
    }

    public boolean isShareable() throws SQLException {
        try {
            return this.cm.getResourceRefInfo().getSharingScope() == 0;
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        boolean valid;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"isValid", (Object[])new Object[]{timeout});
        }
        if (this.state == WSJdbcWrapper.State.CLOSED) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"isValid", (Object)"FALSE: Connection is CLOSED");
            }
            return false;
        }
        try {
            if (this.state != WSJdbcWrapper.State.ACTIVE) {
                this.activate();
            }
            if (!(valid = this.connImpl.isValid(timeout))) {
                this.fireConnectionErrorEvent(null, true);
            }
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".isValid"), (String)"1852", (Object)this);
            throw this.proccessSQLException(sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("Connection.isValid", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".isValid"), (String)"2244", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"isValid", (Object)runX);
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".isValid"), (String)"2251", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"isValid", (Object)err);
            }
            throw err;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"isValid", (Object)(valid ? Boolean.TRUE : Boolean.FALSE));
        }
        return valid;
    }

    @Override
    public final String nativeSQL(String sql) throws SQLException {
        this.activate();
        try {
            return this.connImpl.nativeSQL(sql);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.nativeSQL", (String)"1079", (Object)this);
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public final CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    @Override
    public final CallableStatement prepareCall(String sql, int type, int concurrency) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"prepareCall", (Object[])new Object[]{sql, AdapterUtil.getResultSetTypeString(type), AdapterUtil.getConcurrencyModeString(concurrency)});
        }
        Statement cstmt = null;
        try {
            if (this.state != WSJdbcWrapper.State.ACTIVE) {
                this.activate();
            }
            if (this.managedConn.isStatementCachingEnabled()) {
                CSCacheKey key = new CSCacheKey(sql, type, concurrency, this.managedConn.getCurrentHoldability(), this.helper.getMetaData().doesStatementCacheIsoLevel() ? this.currentTransactionIsolation : 0, this.managedConn.getCurrentSchema(), this.managedConn.getCurrentNetworkTimeout());
                this.beginTransactionIfNecessary();
                Object s = this.managedConn.getStatement(key);
                if (s == null) {
                    cstmt = this.connImpl.prepareCall(sql, type, concurrency);
                    Integer queryTimeout = ((DSConfig)this.dsConfig.get()).queryTimeout;
                    if (queryTimeout != null) {
                        cstmt.setQueryTimeout(queryTimeout);
                    }
                } else {
                    cstmt = (CallableStatement)s;
                }
                cstmt = this.createCallableStatementWrapper((CallableStatement)cstmt, this.managedConn.getCurrentHoldability(), sql, key);
            } else {
                this.beginTransactionIfNecessary();
                cstmt = this.connImpl.prepareCall(sql, type, concurrency);
                Integer queryTimeout = ((DSConfig)this.dsConfig.get()).queryTimeout;
                if (queryTimeout != null) {
                    cstmt.setQueryTimeout(queryTimeout);
                }
                cstmt = this.createCallableStatementWrapper((CallableStatement)cstmt, this.managedConn.getCurrentHoldability(), sql);
            }
            this.childWrappers.add(cstmt);
        }
        catch (SQLException sqlX) {
            if (cstmt != null) {
                try {
                    cstmt.close();
                }
                catch (Throwable x) {
                    // empty catch block
                }
            }
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"prepareCall", (Object)sqlX);
            }
            throw this.proccessSQLException(sqlX);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"prepareCall", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"prepareCall", (Object)cstmt);
        }
        return cstmt;
    }

    private Object prepareSQLJCall(Object implObject, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException {
        Object sqljWrapper;
        String sql = (String)args[0];
        Object section = args[2];
        int type = (Integer)args[7];
        int concurrency = (Integer)args[8];
        int holdability = (Integer)args[9];
        boolean hasCacheKeySuffix = args.length > 11;
        String cacheKeySuffix = hasCacheKeySuffix ? (String)args[11] : null;
        Object[] additionalArgs = args.length > 12 ? (Object[])args[12] : null;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prepareSQLJCall", (Object[])new Object[]{this, sql, "Statement Role: " + args[1], section, AdapterUtil.toString(args[3]), AdapterUtil.toString(args[4]), "Dynamic Execution? " + args[5], "Needs Describe? " + args[6], AdapterUtil.getResultSetTypeString(type), AdapterUtil.getConcurrencyModeString(concurrency), "ResultSet Holdability: " + AdapterUtil.getCursorHoldabilityString(holdability), "DB2 SQLJ Statement Type: " + args[10], "CacheKeySuffix: " + cacheKeySuffix, "AdditionalArgs: " + Arrays.toString(additionalArgs)});
        }
        try {
            WSJdbcCallableStatement cstmtWrapper;
            if (this.managedConn.isStatementCachingEnabled() && (!hasCacheKeySuffix || cacheKeySuffix != null)) {
                DB2SQLJCSCacheKey key = new DB2SQLJCSCacheKey(sql, type, concurrency, holdability, section, this.helper.getMetaData().doesStatementCacheIsoLevel() ? this.currentTransactionIsolation : 0, this.managedConn.getCurrentSchema(), this.managedConn.getCurrentNetworkTimeout(), cacheKeySuffix);
                Object s = this.managedConn.getStatement(key);
                CallableStatement cstmt = s == null ? (CallableStatement)method.invoke(implObject, args) : (CallableStatement)s;
                cstmtWrapper = new WSJdbcCallableStatement(cstmt, this, holdability, sql, (StatementCacheKey)key);
                cstmtWrapper.sqljSection = section;
            } else {
                CallableStatement cstmt = (CallableStatement)method.invoke(implObject, args);
                cstmtWrapper = new WSJdbcCallableStatement(cstmt, this, holdability, sql);
            }
            sqljWrapper = cstmtWrapper.unwrap(method.getReturnType());
            this.childWrappers.add(cstmtWrapper);
        }
        catch (SQLException sqlX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"prepareSQLJCall", (Object)sqlX);
            }
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"prepareSQLJCall", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prepareSQLJCall", sqljWrapper);
        }
        return sqljWrapper;
    }

    private Object prepareSQLJStatement(Object implObject, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException {
        Object sqljWrapper;
        String sql = (String)args[0];
        Object section = args[2];
        int type = (Integer)args[7];
        int concurrency = (Integer)args[8];
        int holdability = (Integer)args[9];
        boolean hasCacheKeySuffix = args.length > 11;
        String cacheKeySuffix = hasCacheKeySuffix ? (String)args[11] : null;
        Object[] additionalArgs = args.length > 12 ? (Object[])args[12] : null;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prepareSQLJStatement", (Object[])new Object[]{this, sql, "Statement Role: " + args[1], AdapterUtil.toString(section), AdapterUtil.toString(args[3]), AdapterUtil.toString(args[4]), "Dynamic Execution? " + args[5], "Needs Describe? " + args[6], AdapterUtil.getResultSetTypeString(type), AdapterUtil.getConcurrencyModeString(concurrency), "ResultSet Holdability: " + AdapterUtil.getCursorHoldabilityString(holdability), "DB2 SQLJ Statement Type: " + args[10], "CacheKeySuffix: " + cacheKeySuffix, "AdditionalArgs: " + Arrays.toString(additionalArgs)});
        }
        try {
            WSJdbcPreparedStatement pstmtWrapper;
            if (this.managedConn.isStatementCachingEnabled() && (!hasCacheKeySuffix || cacheKeySuffix != null)) {
                DB2SQLJPSCacheKey key = new DB2SQLJPSCacheKey(sql, type, concurrency, holdability, section, this.helper.getMetaData().doesStatementCacheIsoLevel() ? this.currentTransactionIsolation : 0, this.managedConn.getCurrentSchema(), this.managedConn.getCurrentNetworkTimeout(), cacheKeySuffix);
                Object s = this.managedConn.getStatement(key);
                PreparedStatement pstmt = s == null ? (PreparedStatement)method.invoke(implObject, args) : (PreparedStatement)s;
                pstmtWrapper = new WSJdbcPreparedStatement(pstmt, this, holdability, sql, key);
                pstmtWrapper.sqljSection = section;
            } else {
                PreparedStatement pstmt = (PreparedStatement)method.invoke(implObject, args);
                pstmtWrapper = new WSJdbcPreparedStatement(pstmt, this, holdability, sql);
            }
            sqljWrapper = pstmtWrapper.unwrap(method.getReturnType());
            this.childWrappers.add(pstmtWrapper);
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"prepareSQLJStatement", (Object)ex);
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"prepareSQLJStatement", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prepareSQLJStatement", sqljWrapper);
        }
        return sqljWrapper;
    }

    @Override
    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int type, int concurrency) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"prepareStatement", (Object[])new Object[]{sql, AdapterUtil.getResultSetTypeString(type), AdapterUtil.getConcurrencyModeString(concurrency)});
        }
        Statement pstmt = null;
        try {
            if (this.state != WSJdbcWrapper.State.ACTIVE) {
                this.activate();
            }
            if (this.managedConn.isStatementCachingEnabled()) {
                PSCacheKey key = new PSCacheKey(sql, type, concurrency, this.managedConn.getCurrentHoldability(), 0, this.mcf.getDataStoreHelper().getMetaData().doesStatementCacheIsoLevel() ? this.currentTransactionIsolation : 0, this.managedConn.getCurrentSchema(), this.managedConn.getCurrentNetworkTimeout());
                this.beginTransactionIfNecessary();
                Object s = this.managedConn.getStatement(key);
                if (s == null) {
                    pstmt = this.connImpl.prepareStatement(sql, type, concurrency);
                    Integer queryTimeout = ((DSConfig)this.dsConfig.get()).queryTimeout;
                    if (queryTimeout != null) {
                        pstmt.setQueryTimeout(queryTimeout);
                    }
                } else {
                    pstmt = this.resetStatement((PreparedStatement)s);
                }
                pstmt = this.createPreparedStatementWrapper((PreparedStatement)pstmt, this.managedConn.getCurrentHoldability(), sql, key);
            } else {
                this.beginTransactionIfNecessary();
                pstmt = this.connImpl.prepareStatement(sql, type, concurrency);
                Integer queryTimeout = ((DSConfig)this.dsConfig.get()).queryTimeout;
                if (queryTimeout != null) {
                    pstmt.setQueryTimeout(queryTimeout);
                }
                pstmt = this.createPreparedStatementWrapper((PreparedStatement)pstmt, this.managedConn.getCurrentHoldability(), sql);
            }
            this.childWrappers.add(pstmt);
        }
        catch (SQLException ex) {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Throwable x) {
                    // empty catch block
                }
            }
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"prepareStatement", (Object)ex);
            }
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"prepareStatement", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"prepareStatement", (Object)pstmt);
        }
        return pstmt;
    }

    @Override
    final void activate() throws SQLException {
        switch (this.state) {
            case ACTIVE: {
                return;
            }
            case CLOSED: {
                throw this.createClosedException("Connection");
            }
        }
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"activate", (Object[])new Object[0]);
        }
        try {
            this.lazyAssociatableCM = this.lazyAssociatableCM == null ? (LazyAssociatableConnectionManager)this.cm : this.lazyAssociatableCM;
            this.lazyAssociatableCM.associateConnection((Object)this, (ManagedConnectionFactory)this.mcf, this.connRequestInfo);
        }
        catch (ResourceException reassociationX) {
            FFDCFilter.processException((Throwable)reassociationX, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.activate", (String)"1625", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"REASSOCIATION_ERR", (Object[])new Object[]{reassociationX});
            SQLException sqlX = AdapterUtil.toSQLException(reassociationX);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"activate", (Object)((Object)reassociationX));
            }
            throw sqlX;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"activate");
        }
    }

    public void reassociate(ManagedConnection mc, Connection connImplObject, Object key) throws ResourceException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reassociate", (Object[])new Object[]{mc, AdapterUtil.toString(connImplObject)});
        }
        if (this.managedConnKey == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"reassociate", (Object)"Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Connection", null, WSJdbcConnection.class);
        }
        if (key != this.managedConnKey) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"reassociate", (Object)"Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("NOT_A_JDBC_METHOD", null, null, WSJdbcConnection.class);
        }
        if (this.isReserved) {
            if (mc != this.managedConn) {
                String message = "Connection handle is reserved for reassociation with a specific ManagedConnection, which does not match the ManagedConnection provided.";
                DataStoreAdapterException x = AdapterUtil.createDataStoreAdapterException("WS_INTERNAL_ERROR", new Object[]{message, " See trace for more details."}, null, WSJdbcConnection.class);
                if (isTraceOn) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)message, (Object[])new Object[]{this.managedConn, mc});
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)tc, (String)"reassociate", (Object)"WS_INTERNAL_ERROR");
                    }
                }
                throw x;
            }
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Handle is reserved, reassociating back to original ManagedConnection.", (Object[])new Object[0]);
            }
            this.isReserved = false;
            this.state = WSJdbcWrapper.State.ACTIVE;
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"reassociate", (Object)"state --> ACTIVE");
            }
            return;
        }
        if (this.state != WSJdbcWrapper.State.INACTIVE) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"reassociate", (Object)"Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("CANNOT_REASSOCIATE", this.state.name(), null, WSJdbcConnection.class);
        }
        if (this.childWrapper != null || this.childWrappers != null && this.childWrappers.size() > 0) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"reassociate", (Object)"Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("CHILDREN_STILL_OPEN", null, null, WSJdbcConnection.class);
        }
        this.managedConn = (WSRdbManagedConnectionImpl)mc;
        this.connImpl = connImplObject;
        for (Map.Entry entry : this.ifcToDynamicWrapper.entrySet()) {
            try {
                Class ifc = (Class)entry.getKey();
                Connection impl = CASTABLE_CONNECTION_MARKER.equals(ifc) ? this.connImpl : this.getJDBCImplObject(ifc);
                this.dynamicWrapperToImpl.put(entry.getValue(), impl);
            }
            catch (SQLException implX) {
                FFDCFilter.processException((Throwable)implX, (String)(this.getClass().getName() + ".reassociate"), (String)"2763", (Object)this);
                Class ifc = (Class)entry.getKey();
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("New underlying connection doesn't implement " + ifc), (Object[])new Object[]{AdapterUtil.toString(this.ifcToDynamicWrapper.get(ifc))});
                }
                Tr.warning((TraceComponent)tc, (String)"VENDOR_IMPL_NOT_FOUND", (Object[])new Object[]{ifc, implX});
            }
        }
        this.connRequestInfo = null;
        if (this.currentClientInfo != null) {
            try {
                this.mcf.getInternalDataStoreHelper().setClientInformationArray(this.currentClientInfo, this.managedConn, this.clientInfoSetExplicitly);
                this.currentClientInfo = null;
            }
            catch (SQLException sqle) {
                FFDCFilter.processException((Throwable)sqle, (String)(WSJdbcConnection.class.getName() + ".reassociate()"), (String)"1781", (Object)this);
                throw new DataStoreAdapterException("DSA_ERROR", sqle, WSJdbcConnection.class);
            }
        }
        if (this.clientProps != null) {
            try {
                this.connImpl.setClientInfo(this.clientProps);
                this.clientProps = null;
            }
            catch (SQLException sqle) {
                FFDCFilter.processException((Throwable)sqle, (String)(this.getClass().getName() + ".reassociate"), (String)"2833", (Object)this);
                DataStoreAdapterException x = new DataStoreAdapterException("DSA_ERROR", this.proccessSQLException(sqle), WSJdbcConnection.class);
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"reassociate", (Object)sqle);
                }
                throw x;
            }
        }
        this.state = WSJdbcWrapper.State.ACTIVE;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"reassociate", (Object)"state --> ACTIVE");
        }
    }

    public void reserve(Object key) throws ResourceException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (this.managedConnKey == null) {
            throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Connection", null, WSJdbcConnection.class);
        }
        if (key != this.managedConnKey) {
            throw AdapterUtil.createDataStoreAdapterException("NOT_A_JDBC_METHOD", null, null, WSJdbcConnection.class);
        }
        this.isReserved = true;
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Reserving handle", (Object[])new Object[]{"state --> INACTIVE"});
        }
        this.state = WSJdbcWrapper.State.INACTIVE;
    }

    protected final CallableStatement resetStatement(CallableStatement cstmt) throws SQLException {
        if (this.managedConn.resetStmtsInCacheOnRemove) {
            this.helper.doStatementCleanup(cstmt);
        }
        return cstmt;
    }

    protected final PreparedStatement resetStatement(PreparedStatement pstmt) throws SQLException {
        if (this.managedConn.resetStmtsInCacheOnRemove) {
            this.helper.doStatementCleanup(pstmt);
        }
        return pstmt;
    }

    @Override
    public void rollback() throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"rollback", (Object[])new Object[]{this});
        }
        try {
            if (this.managedConn != null && this.managedConn.isMCStale()) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"MC is stale", (Object[])new Object[]{this.managedConn});
                }
                throw AdapterUtil.staleX();
            }
            if (this.state == WSJdbcWrapper.State.CLOSED) {
                SQLException closedX = this.createClosedException("Connection");
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback", (Object)closedX);
                }
                throw closedX;
            }
            if (this.threadID != null) {
                this.detectMultithreadedAccess();
            }
            if (this.state == WSJdbcWrapper.State.INACTIVE) {
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback", (Object)"no-op; state is INACTIVE");
                }
                return;
            }
            if (!this.managedConn.isTransactional()) {
                this.connImpl.rollback();
                for (int i = this.childWrappers.size() - 1; i > -1; --i) {
                    ((WSJdbcStatement)this.childWrappers.get(i)).closeChildWrappers();
                }
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback", (Object)"Enlistment is disabled");
                }
                return;
            }
            if (this.managedConn.inGlobalTransaction()) {
                SQLException sqlX = new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_GT", "Connection.rollback"));
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback", (Object)sqlX);
                }
                throw sqlX;
            }
            if (this.managedConn.getTransactionState() == 1) {
                this.managedConn.processLocalTransactionRolledbackEvent(this);
                for (int i = this.childWrappers.size() - 1; i > -1; --i) {
                    ((WSJdbcStatement)this.childWrappers.get(i)).closeChildWrappers();
                }
            } else {
                this.connImpl.rollback();
            }
        }
        catch (ResourceException resX) {
            FFDCFilter.processException((Throwable)resX, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.rollback", (String)"2001", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback", (Object)"Exception");
            }
            throw AdapterUtil.toSQLException(resX);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".rollback"), (String)"1860", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback", (Object)"Exception");
            }
            throw this.proccessSQLException(sqlX);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
        }
    }

    @Override
    protected final RuntimeException runtimeXIfNotClosed(RuntimeException runtimeX) throws SQLException {
        switch (this.state) {
            case INACTIVE: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Connection dissociated on another thread while performing an operation. Closing the Connection handle.", (Object[])new Object[0]);
                }
                this.close();
                throw this.createClosedException("Connection");
            }
            case CLOSED: {
                throw this.createClosedException("Connection");
            }
        }
        return runtimeX;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setAutoCommit(" + autoCommit + ") requested by application."), (Object[])new Object[0]);
        }
        if (this.state != WSJdbcWrapper.State.ACTIVE) {
            this.activate();
        }
        try {
            if (this.managedConn.getHandleCount() > 1 && autoCommit != this.managedConn.getAutoCommit()) {
                throw this.createSharingException("setAutoCommit");
            }
            if (this.managedConn.getTransactionState() == 0) {
                this.managedConn.setAutoCommit(autoCommit);
                this.autoCommit = autoCommit;
            } else if (this.managedConn.inGlobalTransaction()) {
                if (autoCommit) {
                    throw new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_GT", "setAutoCommit"));
                }
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"setAutoCommit(false) requested during a global transaction.", (Object[])new Object[0]);
                }
                this.managedConn.setAutoCommit(autoCommit);
                this.autoCommit = autoCommit;
            } else {
                if (autoCommit) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"setAutoCommit(true) requested during local transaction; implicitly committing the transaction.", (Object[])new Object[0]);
                    }
                    this.commit();
                }
                this.managedConn.setAutoCommit(autoCommit);
                this.autoCommit = autoCommit;
            }
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setAutoCommit", (String)"2006", (Object)this);
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public final void setCatalog(String cLog) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setCatalog", (Object[])new Object[]{cLog});
        }
        if (!warnedAboutCatalogMatching) {
            Tr.info((TraceComponent)tc, (String)"DEFAULT_MATCH_ORIGINAL", (Object[])new Object[]{"Catalog", "connectionSharing"});
            warnedAboutCatalogMatching = true;
        }
        this.activate();
        try {
            if (this.managedConn.getHandleCount() > 1 && !AdapterUtil.match(cLog, this.managedConn.getCatalog())) {
                throw this.createSharingException("setCatalog");
            }
            this.managedConn.setCatalog(cLog);
            if (ConnectionSharing.MatchCurrentCatalog.isEnabled(this.managedConn.connectionSharing)) {
                WSConnectionRequestInfoImpl cri = (WSConnectionRequestInfoImpl)this.managedConn.getConnectionRequestInfo();
                if (!cri.isCRIChangable()) {
                    cri = WSConnectionRequestInfoImpl.createChangableCRIFromNon(cri);
                    this.managedConn.setCRI(cri);
                }
                cri.setCatalog(cLog);
            }
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setCatalog", (String)"2011", (Object)this);
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    public void setCurrentAutoCommit(boolean autoCommit, Object key) {
        if (key != this.managedConnKey) {
            throw new UnsupportedOperationException(AdapterUtil.getNLSMessage("NOT_A_JDBC_METHOD"));
        }
        this.autoCommit = autoCommit;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cached connection autoCommit is set to " + autoCommit), (Object[])new Object[0]);
        }
    }

    public void setCurrentTransactionIsolation(int isolvl, Object key) {
        if (key != this.managedConnKey) {
            throw new UnsupportedOperationException(AdapterUtil.getNLSMessage("NOT_A_JDBC_METHOD"));
        }
        this.currentTransactionIsolation = isolvl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cached connection isolation level  is set to " + isolvl), (Object[])new Object[0]);
        }
    }

    @Override
    public final void setReadOnly(boolean readOnly) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setReadOnly", (Object[])new Object[]{readOnly});
        }
        if (!warnedAboutReadOnlyMatching) {
            Tr.info((TraceComponent)tc, (String)"DEFAULT_MATCH_ORIGINAL", (Object[])new Object[]{"ReadOnly", "connectionSharing"});
            warnedAboutReadOnlyMatching = true;
        }
        this.activate();
        try {
            if (this.managedConn.getHandleCount() > 1 && readOnly != this.managedConn.isReadOnly()) {
                throw this.createSharingException("setReadOnly");
            }
            this.mcf.getInternalDataStoreHelper().setReadOnly(this.managedConn, readOnly, true);
            if (ConnectionSharing.MatchCurrentReadOnly.isEnabled(this.managedConn.connectionSharing)) {
                WSConnectionRequestInfoImpl cri = (WSConnectionRequestInfoImpl)this.managedConn.getConnectionRequestInfo();
                if (!cri.isCRIChangable()) {
                    cri = WSConnectionRequestInfoImpl.createChangableCRIFromNon(cri);
                    this.managedConn.setCRI(cri);
                }
                cri.setReadOnly(readOnly);
            }
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setReadOnly", (String)"2016", (Object)this);
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public final void setTransactionIsolation(int level) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setTransactionIsolation requested by application.", (Object[])new Object[0]);
        }
        if (this.state != WSJdbcWrapper.State.ACTIVE) {
            this.activate();
        }
        try {
            if (this.managedConn.getHandleCount() > 1 && level != this.managedConn.getTransactionIsolation()) {
                throw this.createSharingException("setTransactionIsolation");
            }
            this.managedConn.setTransactionIsolation(level);
            this.currentTransactionIsolation = level;
            if (!this.supportIsolvlSwitching && ConnectionSharing.MatchCurrentIsolation.isEnabled(this.managedConn.connectionSharing)) {
                WSConnectionRequestInfoImpl cri = (WSConnectionRequestInfoImpl)this.managedConn.getConnectionRequestInfo();
                if (!cri.isCRIChangable()) {
                    cri = WSConnectionRequestInfoImpl.createChangableCRIFromNon(cri);
                    this.managedConn.setCRI(cri);
                }
                cri.setTransactionIsolationLevel(level);
            }
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setTransactionIsolation", (String)"2021", (Object)this);
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public final void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setTypeMap", (Object[])new Object[]{map});
        }
        if (!warnedAboutTypeMapMatching) {
            Tr.info((TraceComponent)tc, (String)"DEFAULT_MATCH_ORIGINAL", (Object[])new Object[]{"TypeMap", "connectionSharing"});
            warnedAboutTypeMapMatching = true;
        }
        this.activate();
        try {
            if (this.managedConn.getHandleCount() > 1) {
                throw this.createSharingException("setTypeMap");
            }
            this.managedConn.setTypeMap(map);
            if (ConnectionSharing.MatchCurrentTypeMap.isEnabled(this.managedConn.connectionSharing)) {
                WSConnectionRequestInfoImpl cri = (WSConnectionRequestInfoImpl)this.managedConn.getConnectionRequestInfo();
                if (!cri.isCRIChangable()) {
                    cri = WSConnectionRequestInfoImpl.createChangableCRIFromNon(cri);
                    this.managedConn.setCRI(cri);
                }
                cri.setTypeMap(map);
            }
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setTypeMap", (String)"2026", (Object)this);
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    public ConnectionRequestInfo getCRI() {
        return this.connRequestInfo;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setHoldability requested by application.", (Object[])new Object[0]);
        }
        if (!warnedAboutHoldabilityMatching) {
            Tr.info((TraceComponent)tc, (String)"DEFAULT_MATCH_ORIGINAL", (Object[])new Object[]{"Holdability", "connectionSharing"});
            warnedAboutHoldabilityMatching = true;
        }
        if (this.state != WSJdbcWrapper.State.ACTIVE) {
            this.activate();
        }
        try {
            if (this.managedConn.getHandleCount() > 1 && holdability != this.managedConn.getHoldability()) {
                throw this.createSharingException("setHoldability");
            }
            this.managedConn.setHoldability(holdability);
            if (ConnectionSharing.MatchCurrentHoldability.isEnabled(this.managedConn.connectionSharing)) {
                WSConnectionRequestInfoImpl cri = (WSConnectionRequestInfoImpl)this.managedConn.getConnectionRequestInfo();
                if (!cri.isCRIChangable()) {
                    cri = WSConnectionRequestInfoImpl.createChangableCRIFromNon(cri);
                    this.managedConn.setCRI(cri);
                }
                cri.setHoldability(holdability);
            }
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setHoldability", (String)"2031", (Object)this);
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        if (this.state != WSJdbcWrapper.State.ACTIVE) {
            this.activate();
        }
        try {
            return this.managedConn.getHoldability();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.getHoldability", (String)"2055", (Object)this);
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"setSavepoint", (Object[])new Object[]{this});
        }
        if (this.state != WSJdbcWrapper.State.ACTIVE) {
            this.activate();
        }
        Savepoint sp = null;
        try {
            if (this.managedConn.inGlobalTransaction()) {
                Tr.error((TraceComponent)tc, (String)"OP_NOT_VALID_IN_GT", (Object[])new Object[]{"setSavepoint"});
                SQLException x = new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_GT", "setSavepoint"));
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"setSavepoint", (Object)"OP_NOT_VALID_IN_GT");
                }
                throw x;
            }
            sp = this.connImpl.setSavepoint();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setSavepoint", (String)"2082", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"setSavepoint", (Object)"Exception");
            }
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"setSavepoint", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"setSavepoint", (Object)sp);
        }
        return sp;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"setSavepoint", (Object[])new Object[]{name});
        }
        if (this.state != WSJdbcWrapper.State.ACTIVE) {
            this.activate();
        }
        Savepoint sp = null;
        try {
            if (this.managedConn.inGlobalTransaction()) {
                Tr.error((TraceComponent)tc, (String)"OP_NOT_VALID_IN_GT", (Object[])new Object[]{"setSavepoint"});
                SQLException x = new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_GT", "setSavepoint"));
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"setSavepoint", (Object)"OP_NOT_VALID_IN_GT");
                }
                throw x;
            }
            sp = this.connImpl.setSavepoint(name);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setSavepoint(String)", (String)"2116", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"setSavepoint", (Object)"Exception");
            }
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"setSavepoint", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"setSavepoint", (Object)sp);
        }
        return sp;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"rollback", (Object[])new Object[]{savepoint});
        }
        if (this.state != WSJdbcWrapper.State.ACTIVE) {
            this.activate();
        }
        try {
            if (this.managedConn.inGlobalTransaction()) {
                Tr.error((TraceComponent)tc, (String)"OP_NOT_VALID_IN_GT", (Object[])new Object[]{"rollback"});
                SQLException x = new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_GT", "rollback"));
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback", (Object)"OP_NOT_VALID_IN_GT");
                }
                throw x;
            }
            this.connImpl.rollback(savepoint);
            for (int i = this.childWrappers.size() - 1; i > -1; --i) {
                ((WSJdbcStatement)this.childWrappers.get(i)).closeChildWrappers();
            }
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.rollback(Savepoint)", (String)"2141", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback", (Object)"Exception");
            }
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"releaseSavepoint", (Object[])new Object[]{savepoint});
        }
        if (this.state != WSJdbcWrapper.State.ACTIVE) {
            this.activate();
        }
        try {
            if (this.managedConn.inGlobalTransaction()) {
                Tr.error((TraceComponent)tc, (String)"OP_NOT_VALID_IN_GT", (Object[])new Object[]{"releaseSavepoint"});
                SQLException x = new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_GT", "releaseSavepoint"));
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"releaseSavepoint", (Object)"OP_NOT_VALID_IN_GT");
                }
                throw x;
            }
            this.connImpl.releaseSavepoint(savepoint);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.releaseSavepoint", (String)"2169", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"releaseSavepoint", (Object)"Exception");
            }
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"releaseSavepoint", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"releaseSavepoint");
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createStatement", (Object[])new Object[]{AdapterUtil.getResultSetTypeString(resultSetType), AdapterUtil.getConcurrencyModeString(resultSetConcurrency), AdapterUtil.getCursorHoldabilityString(resultSetHoldability)});
        }
        Statement stmt = null;
        try {
            if (this.state != WSJdbcWrapper.State.ACTIVE) {
                this.activate();
            }
            this.beginTransactionIfNecessary();
            stmt = this.connImpl.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            Integer queryTimeout = ((DSConfig)this.dsConfig.get()).queryTimeout;
            if (queryTimeout != null) {
                stmt.setQueryTimeout(queryTimeout);
            }
            stmt = this.createStatementWrapper(stmt, resultSetHoldability);
            this.childWrappers.add(stmt);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.createStatement(int, int, int)", (String)"2268", (Object)this);
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable x) {
                    // empty catch block
                }
            }
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createStatement", (Object)"Exception");
            }
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createStatement", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"createStatement", (Object)stmt);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int type, int concurrency, int holdability) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"prepareStatement", (Object[])new Object[]{sql, AdapterUtil.getResultSetTypeString(type), AdapterUtil.getConcurrencyModeString(concurrency), AdapterUtil.getCursorHoldabilityString(holdability)});
        }
        Statement pstmt = null;
        try {
            if (this.state != WSJdbcWrapper.State.ACTIVE) {
                this.activate();
            }
            if (this.managedConn.isStatementCachingEnabled()) {
                PSCacheKey key = new PSCacheKey(sql, type, concurrency, holdability, 0, this.mcf.getDataStoreHelper().getMetaData().doesStatementCacheIsoLevel() ? this.currentTransactionIsolation : 0, this.managedConn.getCurrentSchema(), this.managedConn.getCurrentNetworkTimeout());
                this.beginTransactionIfNecessary();
                Object s = this.managedConn.getStatement(key);
                if (s == null) {
                    pstmt = this.connImpl.prepareStatement(sql, type, concurrency, holdability);
                    Integer queryTimeout = ((DSConfig)this.dsConfig.get()).queryTimeout;
                    if (queryTimeout != null) {
                        pstmt.setQueryTimeout(queryTimeout);
                    }
                } else {
                    pstmt = this.resetStatement((PreparedStatement)s);
                }
                pstmt = this.createPreparedStatementWrapper((PreparedStatement)pstmt, holdability, sql, key);
            } else {
                this.beginTransactionIfNecessary();
                pstmt = this.connImpl.prepareStatement(sql, type, concurrency, holdability);
                Integer queryTimeout = ((DSConfig)this.dsConfig.get()).queryTimeout;
                if (queryTimeout != null) {
                    pstmt.setQueryTimeout(queryTimeout);
                }
                pstmt = this.createPreparedStatementWrapper((PreparedStatement)pstmt, holdability, sql);
            }
            this.childWrappers.add(pstmt);
        }
        catch (SQLException ex) {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Throwable x) {
                    // empty catch block
                }
            }
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"prepareStatement", (Object)ex);
            }
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"prepareStatement", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"prepareStatement", (Object)pstmt);
        }
        return pstmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int type, int concurrency, int holdability) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"prepareCall", (Object[])new Object[]{sql, AdapterUtil.getResultSetTypeString(type), AdapterUtil.getConcurrencyModeString(concurrency), AdapterUtil.getCursorHoldabilityString(holdability)});
        }
        Statement cstmt = null;
        try {
            if (this.state != WSJdbcWrapper.State.ACTIVE) {
                this.activate();
            }
            if (this.managedConn.isStatementCachingEnabled()) {
                CSCacheKey key = new CSCacheKey(sql, type, concurrency, holdability, this.helper.getMetaData().doesStatementCacheIsoLevel() ? this.currentTransactionIsolation : 0, this.managedConn.getCurrentSchema(), this.managedConn.getCurrentNetworkTimeout());
                this.beginTransactionIfNecessary();
                Object s = this.managedConn.getStatement(key);
                if (s == null) {
                    cstmt = this.connImpl.prepareCall(sql, type, concurrency, holdability);
                    Integer queryTimeout = ((DSConfig)this.dsConfig.get()).queryTimeout;
                    if (queryTimeout != null) {
                        cstmt.setQueryTimeout(queryTimeout);
                    }
                } else {
                    cstmt = this.resetStatement((CallableStatement)s);
                }
                cstmt = this.createCallableStatementWrapper((CallableStatement)cstmt, holdability, sql, key);
            } else {
                this.beginTransactionIfNecessary();
                cstmt = this.connImpl.prepareCall(sql, type, concurrency, holdability);
                Integer queryTimeout = ((DSConfig)this.dsConfig.get()).queryTimeout;
                if (queryTimeout != null) {
                    cstmt.setQueryTimeout(queryTimeout);
                }
                cstmt = this.createCallableStatementWrapper((CallableStatement)cstmt, holdability, sql);
            }
            this.childWrappers.add(cstmt);
        }
        catch (SQLException sqlX) {
            if (cstmt != null) {
                try {
                    cstmt.close();
                }
                catch (Throwable x) {
                    // empty catch block
                }
            }
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"prepareCall", (Object)sqlX);
            }
            throw this.proccessSQLException(sqlX);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"prepareCall", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"prepareCall", (Object)cstmt);
        }
        return cstmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"prepareStatement", (Object[])new Object[]{sql, AdapterUtil.getAutoGeneratedKeyString(autoGeneratedKeys)});
        }
        Statement pstmt = null;
        try {
            if (this.state != WSJdbcWrapper.State.ACTIVE) {
                this.activate();
            }
            if (this.managedConn.isStatementCachingEnabled()) {
                PSCacheKey key = new PSCacheKey(sql, 1003, 1007, this.managedConn.getCurrentHoldability(), autoGeneratedKeys, this.mcf.getDataStoreHelper().getMetaData().doesStatementCacheIsoLevel() ? this.currentTransactionIsolation : 0, this.managedConn.getCurrentSchema(), this.managedConn.getCurrentNetworkTimeout());
                this.beginTransactionIfNecessary();
                Object s = this.managedConn.getStatement(key);
                if (s == null) {
                    pstmt = this.connImpl.prepareStatement(sql, autoGeneratedKeys);
                    Integer queryTimeout = ((DSConfig)this.dsConfig.get()).queryTimeout;
                    if (queryTimeout != null) {
                        pstmt.setQueryTimeout(queryTimeout);
                    }
                } else {
                    pstmt = this.resetStatement((PreparedStatement)s);
                }
                pstmt = this.createPreparedStatementWrapper((PreparedStatement)pstmt, this.managedConn.getCurrentHoldability(), sql, key);
            } else {
                this.beginTransactionIfNecessary();
                pstmt = this.connImpl.prepareStatement(sql, autoGeneratedKeys);
                Integer queryTimeout = ((DSConfig)this.dsConfig.get()).queryTimeout;
                if (queryTimeout != null) {
                    pstmt.setQueryTimeout(queryTimeout);
                }
                pstmt = this.createPreparedStatementWrapper((PreparedStatement)pstmt, this.managedConn.getCurrentHoldability(), sql);
            }
            this.childWrappers.add(pstmt);
        }
        catch (SQLException ex) {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Throwable x) {
                    // empty catch block
                }
            }
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"prepareStatement", (Object)ex);
            }
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"prepareStatement", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"prepareStatement", (Object)pstmt);
        }
        return pstmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"prepareStatement", (Object[])new Object[]{sql, Arrays.toString(columnIndexes)});
        }
        Statement pstmt = null;
        try {
            if (this.state != WSJdbcWrapper.State.ACTIVE) {
                this.activate();
            }
            this.beginTransactionIfNecessary();
            pstmt = this.connImpl.prepareStatement(sql, columnIndexes);
            Integer queryTimeout = ((DSConfig)this.dsConfig.get()).queryTimeout;
            if (queryTimeout != null) {
                pstmt.setQueryTimeout(queryTimeout);
            }
            pstmt = this.createPreparedStatementWrapper((PreparedStatement)pstmt, this.managedConn.getCurrentHoldability(), sql);
            this.childWrappers.add(pstmt);
        }
        catch (SQLException ex) {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Throwable x) {
                    // empty catch block
                }
            }
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"prepareStatement", (Object)ex);
            }
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"prepareStatement", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"prepareStatement", (Object)pstmt);
        }
        return pstmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"prepareStatement", (Object[])new Object[]{sql, Arrays.toString(columnNames)});
        }
        Statement pstmt = null;
        try {
            if (this.state != WSJdbcWrapper.State.ACTIVE) {
                this.activate();
            }
            this.beginTransactionIfNecessary();
            pstmt = this.connImpl.prepareStatement(sql, columnNames);
            Integer queryTimeout = ((DSConfig)this.dsConfig.get()).queryTimeout;
            if (queryTimeout != null) {
                pstmt.setQueryTimeout(queryTimeout);
            }
            pstmt = this.createPreparedStatementWrapper((PreparedStatement)pstmt, this.managedConn.getCurrentHoldability(), sql);
            this.childWrappers.add(pstmt);
        }
        catch (SQLException ex) {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Throwable x) {
                    // empty catch block
                }
            }
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"prepareStatement", (Object)ex);
            }
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"prepareStatement", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"prepareStatement", (Object)pstmt);
        }
        return pstmt;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"setClientInfo", (Object[])new Object[]{properties});
        }
        try {
            this.activate();
            try {
                this.connImpl.setClientInfo(properties);
                this.managedConn.clientInfoExplicitlySet = true;
            }
            catch (NullPointerException nullX) {
                throw this.runtimeXIfNotClosed(nullX);
            }
            catch (AbstractMethodError methError) {
                throw AdapterUtil.notSupportedX("Connection.setClientInfo", methError);
            }
            catch (RuntimeException runX) {
                FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".setClientInfo"), (String)"4578", (Object)this);
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"setClientInfo", (Object[])new Object[]{runX});
                }
                throw runX;
            }
            catch (Error err) {
                FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".setClientInfo"), (String)"4585", (Object)this);
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"setClientInfo", (Object[])new Object[]{err});
                }
                throw err;
            }
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".setClientInfo"), (String)"4593", (Object)this);
            this.proccessSQLException(sqlX);
            if (!(sqlX instanceof SQLClientInfoException)) {
                HashMap<String, ClientInfoStatus> failed = new HashMap<String, ClientInfoStatus>();
                for (Object propName : properties.keySet()) {
                    failed.put((String)propName, ClientInfoStatus.REASON_UNKNOWN);
                }
                throw new SQLClientInfoException(sqlX.getMessage(), sqlX.getSQLState(), sqlX.getErrorCode(), failed, sqlX);
            }
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"setClientInfo", (Object)sqlX);
            }
            throw (SQLClientInfoException)sqlX;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"setClientInfo");
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"setClientInfo", (Object[])new Object[]{name, value});
        }
        try {
            this.activate();
            try {
                this.connImpl.setClientInfo(name, value);
                this.managedConn.clientInfoExplicitlySet = true;
            }
            catch (NullPointerException nullX) {
                throw this.runtimeXIfNotClosed(nullX);
            }
            catch (AbstractMethodError methError) {
                throw AdapterUtil.notSupportedX("Connection.setClientInfo", methError);
            }
            catch (RuntimeException runX) {
                FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".setClientInfo"), (String)"4414", (Object)this);
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"setClientInfo", (Object[])new Object[]{runX});
                }
                throw runX;
            }
            catch (Error err) {
                FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".setClientInfo"), (String)"4421", (Object)this);
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"setClientInfo", (Object[])new Object[]{err});
                }
                throw err;
            }
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".setClientInfo"), (String)"4429", (Object)this);
            this.proccessSQLException(sqlX);
            if (!(sqlX instanceof SQLClientInfoException)) {
                HashMap<String, ClientInfoStatus> fProps = new HashMap<String, ClientInfoStatus>();
                fProps.put(name, ClientInfoStatus.REASON_UNKNOWN);
                throw new SQLClientInfoException(sqlX.getMessage(), sqlX.getSQLState(), sqlX.getErrorCode(), fProps, sqlX);
            }
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"setClientInfo", (Object)sqlX);
            }
            throw (SQLClientInfoException)sqlX;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"setClientInfo");
        }
    }

    public void setThreadID(Object threadID, Object key) throws DataStoreAdapterException {
        if (key != this.managedConnKey) {
            throw AdapterUtil.createDataStoreAdapterException("NOT_A_JDBC_METHOD", null, null, WSJdbcConnection.class);
        }
        this.threadID = threadID;
    }

    void markStmtsAsNotPoolable() {
        TraceComponent tc = this.getTracer();
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"markStmtsAsNotPoolable", (Object[])new Object[0]);
            }
            WSJdbcObject wrapper = null;
            int i = this.childWrappers.size();
            while (i > 0) {
                try {
                    if (!((wrapper = (WSJdbcObject)this.childWrappers.get(--i)) instanceof WSJdbcPreparedStatement)) continue;
                    ((WSJdbcPreparedStatement)wrapper).poolabilityHint = false;
                }
                catch (ArrayIndexOutOfBoundsException ioobX) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"ArrayIndexOutOfBoundsException is caught during closeChildWrappers() of the WSJdbcObject", (Object[])new Object[0]);
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Possible causes:", (Object[])new Object[0]);
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"multithreaded access of JDBC objects by the Application", (Object[])new Object[0]);
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Application is closing JDBC objects in a finalize()", (Object[])new Object[0]);
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Exception is: ", (Object[])new Object[]{ioobX});
                    }
                    throw ioobX;
                }
            }
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"markStmtsAsNotPoolable");
            }
        }
    }

    public void setPoolableFlag(PreparedStatement statement, boolean poolable) {
        TraceComponent tc = this.getTracer();
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Marking statement as not poolable.", (Object[])new Object[]{statement, poolable});
        }
        try {
            int size = this.childWrappers != null ? this.childWrappers.size() : 0;
            for (int i = 0; i < size; ++i) {
                Object child = this.childWrappers.get(i);
                if (!(child instanceof WSJdbcPreparedStatement) || statement != WSJdbcTracer.getImpl(((WSJdbcPreparedStatement)child).stmtImpl)) continue;
                ((WSJdbcPreparedStatement)child).poolabilityHint = poolable;
            }
        }
        catch (ArrayIndexOutOfBoundsException ioobX) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"ArrayIndexOutOfBoundsException is caught during closeChildWrappers() of the WSJdbcObject ", (Object[])new Object[]{this});
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Possible causes:", (Object[])new Object[0]);
                Tr.debug((Object)this, (TraceComponent)tc, (String)"multithreaded access of JDBC objects by the Application", (Object[])new Object[0]);
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Application is closing JDBC objects in a finalize()", (Object[])new Object[0]);
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Exception is: ", (Object[])new Object[]{ioobX});
            }
            throw ioobX;
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (this.managedConn != null) {
            if (!this.managedConn.haveVendorConnectionPropertiesChanged && WSRdbManagedConnectionImpl.VENDOR_PROPERTY_SETTERS.contains(methodName)) {
                if (this.managedConn.CONNECTION_VENDOR_DEFAULT_PROPERTIES == null) {
                    this.managedConn.CONNECTION_VENDOR_DEFAULT_PROPERTIES = this.mcf.getInternalDataStoreHelper().cacheVendorConnectionProps(this.connImpl);
                }
                this.managedConn.haveVendorConnectionPropertiesChanged = true;
            }
            if (this.managedConn.isStatementCachingEnabled() && !this.managedConn.resetStmtsInCacheOnRemove && WSRdbManagedConnectionImpl.VENDOR_STM_AND_CONNECTION_PROPERTY_SETTERS.contains(methodName)) {
                this.managedConn.resetStmtsInCacheOnRemove = true;
            }
        }
        return super.invoke(proxy, method, args);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (this.mcf.beforeJDBCVersion(JDBCRuntimeVersion.VERSION_4_1)) {
            throw new SQLFeatureNotSupportedException();
        }
        this.setAborted(true);
        this.managedConn.setAborted(true);
        this.mcf.jdbcRuntime.doAbort(this.connImpl, executor);
        this.fireConnectionErrorEvent(null, false);
    }

    public boolean isAborted() throws SQLFeatureNotSupportedException {
        if (this.mcf.beforeJDBCVersion(JDBCRuntimeVersion.VERSION_4_1)) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.aborted;
    }

    public void setAborted(boolean aborted) throws SQLFeatureNotSupportedException {
        if (this.mcf.beforeJDBCVersion(JDBCRuntimeVersion.VERSION_4_1)) {
            throw new SQLFeatureNotSupportedException();
        }
        this.aborted = aborted;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        if (this.mcf.beforeJDBCVersion(JDBCRuntimeVersion.VERSION_4_1)) {
            throw new SQLFeatureNotSupportedException();
        }
        this.activate();
        try {
            return this.managedConn.getNetworkTimeout();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.getSchema", (String)"4200", (Object)this);
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        if (this.mcf.beforeJDBCVersion(JDBCRuntimeVersion.VERSION_4_1)) {
            throw new SQLFeatureNotSupportedException();
        }
        if (!warnedAboutNetworkTimeoutMatching) {
            Tr.info((TraceComponent)tc, (String)"DEFAULT_MATCH_ORIGINAL", (Object[])new Object[]{"NetworkTimeout", "connectionSharing"});
            warnedAboutNetworkTimeoutMatching = true;
        }
        this.activate();
        try {
            if (this.managedConn.getHandleCount() > 1 && milliseconds != this.managedConn.getCurrentNetworkTimeout()) {
                throw this.createSharingException("setNetworkTimeout");
            }
            this.managedConn.setNetworkTimeout(executor, milliseconds);
            if (ConnectionSharing.MatchCurrentNetworkTimeout.isEnabled(this.managedConn.connectionSharing)) {
                WSConnectionRequestInfoImpl cri = (WSConnectionRequestInfoImpl)this.managedConn.getConnectionRequestInfo();
                if (!cri.isCRIChangable()) {
                    cri = WSConnectionRequestInfoImpl.createChangableCRIFromNon(cri);
                    this.managedConn.setCRI(cri);
                }
                cri.setNetworkTimeout(milliseconds);
            }
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setNetworkTimeout", (String)"4234", (Object)this);
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        if (this.mcf.beforeJDBCVersion(JDBCRuntimeVersion.VERSION_4_1)) {
            throw new SQLFeatureNotSupportedException();
        }
        this.activate();
        try {
            return this.managedConn.getSchema();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.getSchema", (String)"4200", (Object)this);
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        if (this.mcf.beforeJDBCVersion(JDBCRuntimeVersion.VERSION_4_1)) {
            throw new SQLFeatureNotSupportedException();
        }
        if (!warnedAboutSchemaMatching) {
            Tr.info((TraceComponent)tc, (String)"DEFAULT_MATCH_ORIGINAL", (Object[])new Object[]{"Schema", "connectionSharing"});
            warnedAboutSchemaMatching = true;
        }
        this.activate();
        try {
            if (this.managedConn.getHandleCount() > 1 && !AdapterUtil.match(schema, this.managedConn.getCurrentSchema())) {
                throw this.createSharingException("setSchema");
            }
            this.managedConn.setSchema(schema);
            if (ConnectionSharing.MatchCurrentSchema.isEnabled(this.managedConn.connectionSharing)) {
                WSConnectionRequestInfoImpl cri = (WSConnectionRequestInfoImpl)this.managedConn.getConnectionRequestInfo();
                if (!cri.isCRIChangable()) {
                    cri = WSConnectionRequestInfoImpl.createChangableCRIFromNon(cri);
                    this.managedConn.setCRI(cri);
                }
                cri.setSchema(schema);
            }
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setSchema", (String)"4214", (Object)this);
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    private SQLException proccessSQLException(SQLException ex) {
        block5: {
            if (this.mcf.atLeastJDBCVersion(JDBCRuntimeVersion.VERSION_4_1) && this.managedConn != null && this.managedConn.currentNetworkTimeout != 0) {
                try {
                    if (!this.isClosed() && this.connImpl != null && this.connImpl.isClosed()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Network timeout detected, closing wrapper objects.", (Object[])new Object[0]);
                        }
                        this.close(true);
                    }
                }
                catch (SQLException e) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)"Exception ocurred while processing SQLException: ", (Object[])new Object[]{e});
                }
            }
        }
        return WSJdbcUtil.mapException(this, ex);
    }
}

