/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.exceptions;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.resource.spi.ResourceAdapterInternalException;

public class DataStoreAdapterInternalException
extends ResourceAdapterInternalException {
    private static final long serialVersionUID = 3811185660727364876L;
    private static final String resBundle = "com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS";
    private static final TraceComponent tc = Tr.register(DataStoreAdapterInternalException.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private static final boolean debug = false;
    private String defaultText = null;
    private String resourceKey = null;
    private Object[] formatArguments = null;

    public DataStoreAdapterInternalException(String message) {
        super(message);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"DataStoreAdapterInternalException.constructor(String)", (Object[])new Object[0]);
        }
    }

    public DataStoreAdapterInternalException(String resourceKey, String defaultText) {
        this(resourceKey, null, defaultText);
    }

    public DataStoreAdapterInternalException(String resourceKey, Object[] formatArguments, String defaultText) {
        super(defaultText);
        Tr.error((TraceComponent)tc, (String)resourceKey, (Object[])formatArguments);
        this.resourceKey = resourceKey;
        this.formatArguments = new Object[formatArguments.length];
        System.arraycopy(formatArguments, 0, this.formatArguments, 0, formatArguments.length);
        this.defaultText = defaultText;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("DataStoreAdapterInternalException.ctor(resourceKey=" + resourceKey + " formatArguments=" + Arrays.toString(formatArguments) + " defaultText=" + defaultText + ")"), (Object[])new Object[0]);
        }
    }

    public String getMessage(String resourceKey, Object[] formatArguments, String message) {
        if (resBundle != null && resourceKey != null) {
            String EOLN;
            String key;
            String retrievedMessage = null;
            String internalMessage = null;
            String defaultEnglishMessage = null;
            ResourceBundle bundle = null;
            try {
                bundle = ResourceBundle.getBundle(resBundle);
            }
            catch (MissingResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.rsadapter.exceptions.DataStoreAdapterInternalException.getMessage", (String)"154", (Object)((Object)this));
                key = null;
                EOLN = AdapterUtil.EOLN;
                if (message == null) {
                    key = "missingResourceBundleNoDft";
                    defaultEnglishMessage = "There was an error retrieving resource bundle {0}. " + EOLN + "There is no default message.";
                } else {
                    key = "missingResourceBundleWithDft";
                    defaultEnglishMessage = "There was an error retrieving resource bundle {0}. " + EOLN + "The default exception message is: {2}.";
                }
                internalMessage = this.getErrorMsg("com.ibm.websphere.exception.DistributedExceptionResource", key, defaultEnglishMessage);
            }
            if (bundle != null) {
                try {
                    retrievedMessage = bundle.getString(resourceKey);
                }
                catch (MissingResourceException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.rsadapter.exceptions.DataStoreAdapterInternalException.getMessage", (String)"173", (Object)((Object)this));
                    key = null;
                    EOLN = AdapterUtil.EOLN;
                    if (message == null) {
                        key = "missingResourceKeyNoDft";
                        defaultEnglishMessage = "There was an error retrieving resource key {1} in resource bundle {0}. " + EOLN + "There is no default message.";
                    } else {
                        key = "missingResourceKeyWithDft";
                        defaultEnglishMessage = "There was an error retrieving resource key {1} in resource bundle {0}. " + EOLN + "The default exception message is: {2}.";
                    }
                    internalMessage = this.getErrorMsg("com.ibm.websphere.exception.DistributedExceptionResource", key, defaultEnglishMessage);
                }
            }
            String formattedMessage = null;
            if (retrievedMessage != null) {
                formattedMessage = formatArguments != null ? MessageFormat.format(retrievedMessage, formatArguments) : retrievedMessage;
            } else if (internalMessage != null) {
                Object[] intFormatArguments = new Object[]{resBundle, resourceKey, message};
                formattedMessage = MessageFormat.format(internalMessage, intFormatArguments);
            } else {
                return message;
            }
            return formattedMessage;
        }
        return message;
    }

    private String getErrorMsg(String resourceBundle, String resourceKey, String defaultEnglishMessage) {
        ResourceBundle bundle = null;
        String errorMsg = null;
        try {
            bundle = ResourceBundle.getBundle(resourceBundle);
        }
        catch (MissingResourceException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.rsadapter.exceptions.DataStoreAdapterInternalException.getErrorMsg", (String)"234", (Object)((Object)this));
            errorMsg = defaultEnglishMessage;
        }
        if (bundle != null) {
            try {
                errorMsg = bundle.getString(resourceKey);
            }
            catch (MissingResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.rsadapter.exceptions.DataStoreAdapterInternalException.getErrorMsg", (String)"242", (Object)((Object)this));
                errorMsg = defaultEnglishMessage;
            }
        }
        return errorMsg;
    }

    public String getMessage() {
        String message = null;
        if (this.resourceKey == null) {
            message = super.getMessage();
        } else {
            try {
                message = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws Exception {
                        return DataStoreAdapterInternalException.this.getMessage(DataStoreAdapterInternalException.this.resourceKey, DataStoreAdapterInternalException.this.formatArguments, DataStoreAdapterInternalException.this.defaultText);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                FFDCFilter.processException((Throwable)pae.getException(), (String)"com.ibm.ws.rsadapter.exceptions.DataStoreAdapterInternalException.getErrorMsg", (String)"287", (Object)((Object)this));
                Tr.error((TraceComponent)tc, (String)"WS_INTERNAL_WARNING", (Object[])new Object[]{"Unable to retrieve message for resource key=" + this.resourceKey, pae.getException()});
            }
        }
        return message;
    }
}

