/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.dbutils.impl;

import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.dbutils.DB2UniversalUtility;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.PooledConnection;
import org.ietf.jgss.GSSCredential;

public class DB2UniversalUtilityImpl
implements DB2UniversalUtility {
    private final ClassLoader loader;
    private final AtomicReference<Method> getDB2Correlator = new AtomicReference();
    private final AtomicReference<Method> isDBValid = new AtomicReference();
    private final AtomicReference<Method> isInDB2UnitOfWork = new AtomicReference();
    private final AtomicReference<Method> isMonitoring = new AtomicReference();
    private final AtomicReference<Method> pushData = new AtomicReference();
    private final AtomicReference<Method> reuseDB2Connection = new AtomicReference();
    private final AtomicReference<Method> setDB2ClientUser = new AtomicReference();
    private final AtomicReference<Method> setDB2ClientWorkstation = new AtomicReference();
    private final AtomicReference<Method> setDB2ClientApplicationInformation = new AtomicReference();
    private final AtomicReference<Method> setDB2ClientAccountingInformation = new AtomicReference();
    private final AtomicReference<Method> setJCCLogWriter = new AtomicReference();
    private final AtomicReference<Method> setJCCLogWriter2 = new AtomicReference();
    private static final Class<?>[] TYPES_boolean_int = new Class[]{Boolean.TYPE, Integer.TYPE};
    private static final Class<?>[] TYPES_PrintWriter = new Class[]{PrintWriter.class};
    private static final Class<?>[] TYPES_PrintWriter_int = new Class[]{PrintWriter.class, Integer.TYPE};
    private static final Class<?>[] TYPES_GSSCredential_Properties = new Class[]{GSSCredential.class, Properties.class};
    private static final Class<?>[] TYPES_Properties = new Class[]{Properties.class};
    private static final Class<?>[] TYPES_String = new Class[]{String.class};

    public DB2UniversalUtilityImpl(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public String getDB2Correlator(Connection sqlConn) throws SQLException {
        return (String)this.invokeOnDB2Connection(sqlConn, this.getDB2Correlator, "getDB2Correlator", null, new Object[0]);
    }

    @Override
    public Object getDB2Object(Connection con) {
        try {
            Class<?> DB2Wrapper = this.loader.loadClass("com.ibm.db2.jcc.DB2Wrapper");
            return DB2Wrapper.getMethod("getDB2Object", new Class[0]).invoke((Object)con, new Object[0]);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x instanceof InvocationTargetException ? x.getCause() : x);
        }
    }

    private final Object invokeOnDB2Connection(Connection con, AtomicReference<Method> methRef, String methName, Class<?>[] paramTypes, Object ... params) throws SQLException {
        try {
            Method m = methRef.get();
            if (m == null) {
                Class<?> c = this.loader.loadClass("com.ibm.db2.jcc.DB2Connection");
                m = c.getMethod(methName, paramTypes);
                methRef.set(m);
            }
            return m.invoke((Object)con, params);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (NoSuchMethodException x) {
            throw (Error)new NoSuchMethodError(methName).initCause(x);
        }
        catch (InvocationTargetException e) {
            throw AdapterUtil.toSQLException(e.getCause());
        }
        catch (Exception x) {
            throw AdapterUtil.toSQLException(x);
        }
    }

    @Override
    public void setJCCLogWriter(Connection sqlConn, PrintWriter writer) throws SQLException {
        this.invokeOnDB2Connection(sqlConn, this.setJCCLogWriter, "setJCCLogWriter", TYPES_PrintWriter, writer);
    }

    @Override
    public void setJCCLogWriter(Connection sqlConn, PrintWriter pw, int configuredTraceLevel) throws SQLException {
        this.invokeOnDB2Connection(sqlConn, this.setJCCLogWriter2, "setJCCLogWriter", TYPES_PrintWriter_int, pw, configuredTraceLevel);
    }

    @Override
    public void setDB2ClientInfo(Connection sqlConn, String userId, String workstation, String applicationInfo, String accountInfo) throws SQLException {
        this.invokeOnDB2Connection(sqlConn, this.setDB2ClientUser, "setDB2ClientUser", TYPES_String, userId);
        this.invokeOnDB2Connection(sqlConn, this.setDB2ClientWorkstation, "setDB2ClientWorkstation", TYPES_String, workstation);
        this.invokeOnDB2Connection(sqlConn, this.setDB2ClientApplicationInformation, "setDB2ClientApplicationInformation", TYPES_String, applicationInfo);
        this.invokeOnDB2Connection(sqlConn, this.setDB2ClientAccountingInformation, "setDB2ClientAccountingInformation", TYPES_String, accountInfo);
    }

    @Override
    public PooledConnection getPooledConnection(Object dataSource, Object gssCredential, boolean is2Phase) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isInDB2UnitOfWork(Connection conn) throws SQLException {
        return (Boolean)this.invokeOnDB2Connection(conn, this.isInDB2UnitOfWork, "isInDB2UnitOfWork", null, new Object[0]);
    }

    @Override
    public Object[] getDB2TrustedXAConnection(Object ds, String user, String password) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Object[] getDB2TrustedPooledConnection(Object ds, String user, String password) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Object[] getDB2TrustedXAConnection(Object ds, boolean useKerberos, Object gssCredential) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Object[] getDB2TrustedPooledConnection(Object ds, boolean useKerberos, Object gssCredential) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Connection getDB2Connection(PooledConnection pcon, String originalUser, String identityName, String password, String realm, byte[] userSecToken, byte[] cookie, Properties props) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void reuseDB2Connection(Connection conn, byte[] cookie, String user, String password, String userRegistry, byte[] userSecToken, String originalUser, Properties properties) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void reuseDB2Connection(Connection conn, Properties properties) throws SQLException {
        this.invokeOnDB2Connection(conn, this.reuseDB2Connection, "reuseDB2Connection", TYPES_Properties, properties);
    }

    @Override
    public void reuseDB2Connection(Connection sqlConn, GSSCredential gssCred, Properties props) throws SQLException {
        this.invokeOnDB2Connection(sqlConn, this.reuseDB2Connection, "reuseDB2Connection", TYPES_GSSCredential_Properties, gssCred, props);
    }

    @Override
    public boolean isDBValid(Connection conn, boolean allowExceptions, int timeout) throws SQLException {
        return (Boolean)this.invokeOnDB2Connection(conn, this.isDBValid, "isDBValid", TYPES_boolean_int, allowExceptions, timeout);
    }

    @Override
    public void pushDataToCMX(int cmxMessageType, Object[] cmxArgs, Object DBObject, boolean sendEvent) {
        try {
            Method m = this.pushData.get();
            if (m == null) {
                Class<?> c = this.loader.loadClass("com.ibm.pdq.cmx.client.ManageableProxy");
                m = c.getMethod("pushData", Integer.TYPE, Object[].class, Boolean.TYPE);
                this.pushData.set(m);
            }
            m.invoke(DBObject, cmxMessageType, cmxArgs, sendEvent);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x instanceof InvocationTargetException ? x.getCause() : x);
        }
    }

    @Override
    public boolean isCMXMonitoringEnabled(Object dsProxy) {
        try {
            Method m = this.isMonitoring.get();
            if (m == null) {
                Class<?> c = this.loader.loadClass("com.ibm.pdq.cmx.client.DataSourceProxy");
                m = c.getMethod("isMonitoring", new Class[0]);
                this.isMonitoring.set(m);
            }
            return (Boolean)m.invoke(dsProxy, new Object[0]);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x instanceof InvocationTargetException ? x.getCause() : x);
        }
    }
}

