/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.spi.InternalDB2AS400NativeDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalDB2AS400ToolboxDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalDataDirectDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalDerbyDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalDerbyNetworkServerDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalGenericDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalInformixDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalInformixJccDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalMicrosoftSQLServerDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalOracle11gDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalSybaseDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;

public class DSConfigHelper {
    private static final TraceComponent tc = Tr.register(DSConfigHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    public static final String DATABASE_NAME = "databaseName";
    public static final String PASSWORD = "password";
    public static final String URL = "URL";
    public static final String USER = "user";
    public static final String DATA_SOURCE_CLASS = "dataSourceClass";
    public static final String DATA_STORE_HELPER_CLASS = "dataStoreHelperClass";
    public static final String INFORMIX_LOCK_MODE_WAIT = "informixLockModeWait";
    public static final String INFORMIX_ALLOW_NEWLINE = "informixAllowNewLine";
    public static final String USE_RRA_SET_EQUALS = "useRRASetEquals";
    public static final String ISOLATION_SWITCHING_SUPPORT = "isolationLevelSwitchingSupport";
    public static final String VALIDATE_NEW_CONNECTION = "validateNewConnection";
    public static final String VALIDATE_NEW_CONNECTION_TIMEOUT = "validateNewConnectionTimeout";
    public static final String DATASOURCE_CLIENT_ACCOUNTING_INFO = "clientAccountingInformation";
    public static final String DATASOURCE_CLIENT_LOCATION = "clientWorkstation";
    public static final String DATASOURCE_CLIENT_ID = "clientUser";
    public static final String DATASOURCE_CLIENT_APPLICATION_NAME = "clientApplicationInformation";
    public static final String DERBY_HELPER_NAME = "com.ibm.websphere.rsadapter.DerbyDataStoreHelper";
    public static final String DERBY_NS_U_HELPER_NAME = "com.ibm.websphere.rsadapter.DerbyNetworkServerDataStoreHelper";
    public static final String CONNECTJDBC_HELPER_NAME = "com.ibm.websphere.rsadapter.ConnectJDBCDataStoreHelper";
    public static final String DB2AS400_HELPER_NAME = "com.ibm.websphere.rsadapter.DB2AS400DataStoreHelper";
    public static final String DB2_HELPER_NAME = "com.ibm.websphere.rsadapter.DB2DataStoreHelper";
    public static final String DB2UNIVERSAL_HELPER_NAME = "com.ibm.websphere.rsadapter.DB2UniversalDataStoreHelper";
    public static final String INFORMIX_HELPER_NAME = "com.ibm.websphere.rsadapter.InformixDataStoreHelper";
    public static final String INFORMIX_JCC_HELPER_NAME = "com.ibm.websphere.rsadapter.InformixJccDataStoreHelper";
    public static final String MICROSOFT_SQL_SERVER_HELPER_NAME = "com.ibm.websphere.rsadapter.MicrosoftSQLServerDataStoreHelper";
    public static final String ORACLE_HELPER_NAME = "com.ibm.websphere.rsadapter.OracleDataStoreHelper";
    public static final String ORACLE_10G_HELPER_NAME = "com.ibm.websphere.rsadapter.Oracle10gDataStoreHelper";
    public static final String ORACLE_11G_HELPER_NAME = "com.ibm.websphere.rsadapter.Oracle11gDataStoreHelper";
    public static final String SYBASE_HELPER_NAME = "com.ibm.websphere.rsadapter.SybaseDataStoreHelper";
    public static final String GENERIC_HELPER_NAME = "com.ibm.websphere.rsadapter.GenericDataStoreHelper";
    private static final Map<String, String> dsHelpersByPackage = new LinkedHashMap<String, String>();
    static final HashMap<String, String> helperMap;
    public static final boolean _disablePK54589;
    public static final boolean _allowOraUpdateableConcurrency;
    public static final boolean _skipInternalClearWarnings;
    public static final boolean _allowSetReadOnlyForSybase;
    public static final boolean _enableSpecialOracleTypeMapMatching;
    public static final boolean _enableReplacementOfErrorMessages;
    public static final boolean _disableCheckingForAuthorizationException;
    public static final boolean _useContextClassLoaderForLoadClass;
    public static final boolean _disablePoolPurgeIfAffinityEnabled;

    public static DataStoreHelper createDataStoreHelper(WSManagedConnectionFactoryImpl mcf, String helperClassName, Properties helperProps, ClassLoader loader) throws ResourceException {
        DataStoreHelper helper;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createDataStoreHelper", (Object[])new Object[]{helperClassName, helperProps});
        }
        try {
            Class<?> helperClass = loader.loadClass(helperClassName);
            if (helperClass.getName().equals(GENERIC_HELPER_NAME)) {
                Tr.warning((TraceComponent)tc, (String)"DSH_GEN_USED", (Object[])new Object[0]);
            }
            helper = (DataStoreHelper)helperClass.getConstructor(WSManagedConnectionFactoryImpl.class, Properties.class).newInstance(new Object[]{mcf, helperProps});
        }
        catch (ClassNotFoundException classX) {
            FFDCFilter.processException((Throwable)classX, (String)"com.ibm.ws.rsadapter.DSConfigHelper.createDataStoreHelper", (String)"469");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createDataStoreHelper", (Object)classX);
            }
            throw AdapterUtil.createDataStoreAdapterException("HELPER_NOT_FOUND", helperClassName, classX, DSConfigHelper.class);
        }
        catch (InstantiationException instanceX) {
            FFDCFilter.processException((Throwable)instanceX, (String)"com.ibm.ws.rsadapter.DSConfigHelper.createDataStoreHelper", (String)"475");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createDataStoreHelper", (Object)instanceX);
            }
            throw AdapterUtil.createDataStoreAdapterException("HELPER_IMPL_ERR", helperClassName, instanceX, DSConfigHelper.class);
        }
        catch (NoSuchMethodException methodX) {
            FFDCFilter.processException((Throwable)methodX, (String)"com.ibm.ws.rsadapter.DSConfigHelper.createDataStoreHelper", (String)"481");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createDataStoreHelper", (Object)methodX);
            }
            throw AdapterUtil.createDataStoreAdapterException("HELPER_NEW_UP_ERR", helperClassName, methodX, DSConfigHelper.class);
        }
        catch (IllegalAccessException accessX) {
            FFDCFilter.processException((Throwable)accessX, (String)"com.ibm.ws.rsadapter.DSConfigHelper.createDataStoreHelper", (String)"487");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createDataStoreHelper", (Object)accessX);
            }
            throw AdapterUtil.createDataStoreAdapterException("HELPER_ACCESS_ERR", helperClassName, accessX, DSConfigHelper.class);
        }
        catch (ClassCastException castX) {
            FFDCFilter.processException((Throwable)castX, (String)"com.ibm.ws.rsadapter.DSConfigHelper.createDataStoreHelper", (String)"493");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createDataStoreHelper", (Object)castX);
            }
            throw AdapterUtil.createDataStoreAdapterException("HELPER_CAST_ERR", helperClassName, castX, DSConfigHelper.class);
        }
        catch (InvocationTargetException invocationX) {
            FFDCFilter.processException((Throwable)invocationX, (String)"com.ibm.ws.rsadapter.DSConfigHelper.createDataStoreHelper", (String)"499");
            DataStoreAdapterException x = AdapterUtil.createDataStoreAdapterException("HELPER_CTOR_ERR", new Object[]{helperClassName, invocationX.getTargetException()}, invocationX.getTargetException(), DSConfigHelper.class);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createDataStoreHelper", (Object)invocationX.getCause());
            }
            throw x;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createDataStoreHelper", (Object)AdapterUtil.toString(helper));
        }
        return helper;
    }

    public static InternalDataStoreHelper createInternalDataStoreHelper(String externalHelperName, DataStoreHelper dataStoreHelper, String dataSourceImplClass, ClassLoader dataSourceLoader) throws ResourceException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        String internalHelperName = helperMap.get(externalHelperName);
        try {
            block29: {
                if (internalHelperName == null) {
                    internalHelperName = helperMap.get(dataSourceImplClass);
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"searching on the dataSourceImplClass returned: ", (Object[])new Object[]{internalHelperName});
                    }
                    if (internalHelperName == null) {
                        int helperType = dataStoreHelper.getMetaData().getHelperType();
                        switch (helperType) {
                            case 1: 
                            case 3: 
                            case 15: {
                                return new InternalDB2DataStoreHelper(dataSourceLoader);
                            }
                            case 4: {
                                return new InternalDB2UniversalDataStoreHelper(dataSourceLoader);
                            }
                            case 19: {
                                return new InternalDerbyDataStoreHelper(dataSourceLoader);
                            }
                            case 11: 
                            case 12: {
                                return new InternalSybaseDataStoreHelper(dataSourceLoader);
                            }
                            case 14: {
                                return new InternalInformixDataStoreHelper(dataSourceLoader);
                            }
                            case 21: {
                                return new InternalInformixJccDataStoreHelper(dataSourceLoader);
                            }
                            case 10: {
                                return new InternalMicrosoftSQLServerDataStoreHelper(dataSourceLoader);
                            }
                            case 5: {
                                return new InternalGenericDataStoreHelper(dataSourceLoader);
                            }
                            case 7: {
                                return new InternalDataDirectDataStoreHelper(dataSourceLoader);
                            }
                            case 22: {
                                return new InternalOracle11gDataStoreHelper(dataSourceLoader);
                            }
                            case 18: {
                                return new InternalDerbyNetworkServerDataStoreHelper(dataSourceLoader);
                            }
                            case 2: {
                                if (AdapterUtil.isAssignableFromNamed("com.ibm.as400.access.AS400JDBCDataSource", dataSourceImplClass, dataSourceLoader)) {
                                    return new InternalDB2AS400ToolboxDataStoreHelper(dataSourceLoader);
                                }
                                if (AdapterUtil.isAssignableFromNamed("com.ibm.db2.jdbc.app.UDBConnectionPoolDataSource", dataSourceImplClass, dataSourceLoader)) {
                                    return new InternalDB2AS400NativeDataStoreHelper(dataSourceLoader);
                                }
                                if (AdapterUtil.isAssignableFromNamed("com.ibm.db2.jdbc.app.UDBXADataSource", dataSourceImplClass, dataSourceLoader)) {
                                    return new InternalDB2AS400NativeDataStoreHelper(dataSourceLoader);
                                }
                                if (!AdapterUtil.isAssignableFromNamed("com.ibm.db2.jdbc.app.DB2GenericDataSource", dataSourceImplClass, dataSourceLoader)) break;
                                return new InternalDB2AS400NativeDataStoreHelper(dataSourceLoader);
                            }
                        }
                        return new InternalGenericDataStoreHelper(dataSourceLoader);
                    }
                }
                if (internalHelperName.equals("com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper")) {
                    try {
                        Class.forName("com.ibm.db2.jcc.SQLJContext", false, dataSourceLoader);
                        internalHelperName = "com.ibm.ws.rsadapter.spi.InternalDB2V8SQLJDataStoreHelper";
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"SQLJContext is implemented by DB2, change to InternalDB2V8SQLJDataStoreHelper  ", (Object[])new Object[]{internalHelperName});
                        }
                    }
                    catch (ClassNotFoundException exp) {
                        try {
                            Class.forName("com.ibm.db2.jcc.SQLJConnection", false, dataSourceLoader);
                            internalHelperName = "com.ibm.ws.rsadapter.spi.InternalDB2V8DataStoreHelper";
                            if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"SQLJConnection is implemented by DB2, change to InternalDB2V8DataStoreHelper  ", (Object[])new Object[]{internalHelperName});
                            }
                        }
                        catch (ClassNotFoundException exp2) {
                            if (!isTraceOn || !tc.isDebugEnabled()) break block29;
                            Tr.debug((TraceComponent)tc, (String)"SQLJConnection or SQLJContext is not implemented by DB2", (Object[])new Object[0]);
                        }
                    }
                }
            }
            Class<?> internalHelperClass = Class.forName(internalHelperName);
            return (InternalDataStoreHelper)internalHelperClass.getConstructor(ClassLoader.class).newInstance(dataSourceLoader);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)(DSConfigHelper.class.getName() + ".createInternalDataStoreHelper"), (String)"276");
            throw AdapterUtil.createDataStoreAdapterException("DSA_INTERNAL_ERROR", new Object[]{"Unable to locate Internal Data Store Helper for " + externalHelperName, ".  Exception is: ", ex}, ex, DSConfigHelper.class);
        }
    }

    public static String getDataStoreHelperClassName(String dsClassName) {
        for (Map.Entry<String, String> entry : dsHelpersByPackage.entrySet()) {
            if (!dsClassName.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return GENERIC_HELPER_NAME;
    }

    public static void setProperty(Object obj, PropertyDescriptor pd, String value, boolean doTraceValue) throws Exception {
        Method setter;
        Object param = null;
        String propName = pd.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("set " + propName + " = " + (doTraceValue ? value : "******")), (Object[])new Object[0]);
        }
        if ((setter = pd.getWriteMethod()) == null) {
            throw new NoSuchMethodException(AdapterUtil.getNLSMessage("NO_SETTER_METHOD", propName));
        }
        Class<?> paramType = setter.getParameterTypes()[0];
        if (!paramType.isPrimitive()) {
            param = paramType.equals(String.class) ? value : (paramType.equals(Properties.class) ? AdapterUtil.toProperties(value) : (paramType.equals(Character.class) ? Character.valueOf(value.charAt(0)) : paramType.getConstructor(String.class).newInstance(value)));
        } else if (paramType.equals(Integer.TYPE)) {
            param = Integer.valueOf(value);
        } else if (paramType.equals(Long.TYPE)) {
            param = Long.valueOf(value);
        } else if (paramType.equals(Boolean.TYPE)) {
            param = Boolean.valueOf(value);
        } else if (paramType.equals(Double.TYPE)) {
            param = Double.valueOf(value);
        } else if (paramType.equals(Float.TYPE)) {
            param = Float.valueOf(value);
        } else if (paramType.equals(Short.TYPE)) {
            param = Short.valueOf(value);
        } else if (paramType.equals(Byte.TYPE)) {
            param = Byte.valueOf(value);
        } else if (paramType.equals(Character.TYPE)) {
            param = Character.valueOf(value.charAt(0));
        }
        setter.invoke(obj, param);
    }

    static {
        dsHelpersByPackage.put("com.ibm.db2.jcc.", DB2UNIVERSAL_HELPER_NAME);
        dsHelpersByPackage.put("com.ibm.as400.", DB2AS400_HELPER_NAME);
        dsHelpersByPackage.put("com.ibm.db2.jdbc.app.", DB2AS400_HELPER_NAME);
        dsHelpersByPackage.put("oracle.", ORACLE_11G_HELPER_NAME);
        dsHelpersByPackage.put("com.microsoft.", MICROSOFT_SQL_SERVER_HELPER_NAME);
        dsHelpersByPackage.put("com.ddtek.jdbcx.sqlserver.", CONNECTJDBC_HELPER_NAME);
        dsHelpersByPackage.put("com.informix.", INFORMIX_HELPER_NAME);
        dsHelpersByPackage.put("com.sybase.", SYBASE_HELPER_NAME);
        dsHelpersByPackage.put("org.apache.derby.jdbc.Client", DERBY_NS_U_HELPER_NAME);
        dsHelpersByPackage.put("org.apache.derby.jdbc.Embedded", DERBY_HELPER_NAME);
        helperMap = new HashMap(47);
        helperMap.put(DB2UNIVERSAL_HELPER_NAME, "com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper");
        helperMap.put(DB2_HELPER_NAME, "com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.DB2390DataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.DB2390LocalDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.DataDirectDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDataDirectDataStoreHelper");
        helperMap.put(DERBY_HELPER_NAME, "com.ibm.ws.rsadapter.spi.InternalDerbyDataStoreHelper");
        helperMap.put(DERBY_NS_U_HELPER_NAME, "com.ibm.ws.rsadapter.spi.InternalDerbyNetworkServerDataStoreHelper");
        helperMap.put(INFORMIX_HELPER_NAME, "com.ibm.ws.rsadapter.spi.InternalInformixDataStoreHelper");
        helperMap.put(INFORMIX_JCC_HELPER_NAME, "com.ibm.ws.rsadapter.spi.InternalInformixJccDataStoreHelper");
        helperMap.put(SYBASE_HELPER_NAME, "com.ibm.ws.rsadapter.spi.InternalSybaseDataStoreHelper");
        helperMap.put(ORACLE_HELPER_NAME, "com.ibm.ws.rsadapter.spi.InternalOracleDataStoreHelper");
        helperMap.put(ORACLE_10G_HELPER_NAME, "com.ibm.ws.rsadapter.spi.InternalOracle10gDataStoreHelper");
        helperMap.put(ORACLE_11G_HELPER_NAME, "com.ibm.ws.rsadapter.spi.InternalOracle11gDataStoreHelper");
        helperMap.put(CONNECTJDBC_HELPER_NAME, "com.ibm.ws.rsadapter.spi.InternalDataDirectDataStoreHelper");
        helperMap.put(MICROSOFT_SQL_SERVER_HELPER_NAME, "com.ibm.ws.rsadapter.spi.InternalMicrosoftSQLServerDataStoreHelper");
        helperMap.put("com.ibm.db2.jdbc.app.DB2StdConnectionPoolDataSource", "com.ibm.ws.rsadapter.spi.InternalDB2AS400NativeDataStoreHelper");
        helperMap.put("com.ibm.db2.jdbc.app.DB2StdXADataSource", "com.ibm.ws.rsadapter.spi.InternalDB2AS400NativeDataStoreHelper");
        helperMap.put("com.ibm.db2.jdbc.app.UDBConnectionPoolDataSource", "com.ibm.ws.rsadapter.spi.InternalDB2AS400NativeDataStoreHelper");
        helperMap.put("com.ibm.db2.jdbc.app.UDBXADataSource", "com.ibm.ws.rsadapter.spi.InternalDB2AS400NativeDataStoreHelper");
        helperMap.put("com.ibm.as400.access.AS400JDBCConnectionPoolDataSource", "com.ibm.ws.rsadapter.spi.InternalDB2AS400ToolboxDataStoreHelper");
        helperMap.put("com.ibm.as400.access.AS400JDBCXADataSource", "com.ibm.ws.rsadapter.spi.InternalDB2AS400ToolboxDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.ProxyDataSource", "com.ibm.ws.rsadapter.spi.InternalGenericDataStoreHelper");
        boolean[] systemProps = AccessController.doPrivileged(new PrivilegedAction<boolean[]>(){

            @Override
            public boolean[] run() {
                boolean trace = TraceComponent.isAnyTracingEnabled();
                boolean[] props = new boolean[9];
                props[0] = Boolean.valueOf(System.getProperty("disablePK54589"));
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Property disablePK54589 (PK54589 fixes CRI matching problem): " + _disablePK54589), (Object[])new Object[0]);
                }
                props[1] = Boolean.valueOf(System.getProperty("com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.disableCheckingForAuthorizationException"));
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Property com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.disableCheckingForAuthorizationException: " + _disableCheckingForAuthorizationException), (Object[])new Object[0]);
                }
                props[2] = Boolean.valueOf(System.getProperty("com.ibm.websphere.rsadapter.OracleDataStoreHelper.allowOraUpdateableConcurrency"));
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Property com.ibm.websphere.rsadapter.OracleDataStoreHelper.allowOraUpdateableConcurrency: " + _allowOraUpdateableConcurrency), (Object[])new Object[0]);
                }
                props[3] = Boolean.valueOf(System.getProperty("com.ibm.ws.rsadapter.spi.InternalDataStoreHelper.skipInternalClearWarnings"));
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Property com.ibm.ws.rsadapter.spi.InternalDataStoreHelper.skipInternalClearWarnings: " + _skipInternalClearWarnings), (Object[])new Object[0]);
                }
                props[4] = Boolean.valueOf(System.getProperty("com.ibm.ws.rsadapter.spi.InternalSybaseDataStoreHelper.allowSetReadOnlyForSybase"));
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Property com.ibm.ws.rsadapter.spi.InternalSybaseDataStoreHelper.allowSetReadOnlyForSybase: " + _allowSetReadOnlyForSybase), (Object[])new Object[0]);
                }
                boolean bl = props[5] = Boolean.valueOf(System.getProperty("com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException.disableReplacementOfErrorMessages")) == false;
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Property com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException.disableReplacementOfErrorMessages: " + !_enableReplacementOfErrorMessages), (Object[])new Object[0]);
                }
                props[6] = Boolean.valueOf(System.getProperty("com.ibm.ws.rsadapter.spi.WSConnectionRequestInfoImpl.enableSpecialOracleTypeMapMatching"));
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Property com.ibm.ws.rsadapter.spi.WSConnectionRequestInfoImpl.enableSpecialOracleTypeMapMatching: " + _enableSpecialOracleTypeMapMatching), (Object[])new Object[0]);
                }
                props[7] = Boolean.valueOf(System.getProperty("com.ibm.ws.rsadapter.DSConfigurationHelper.useContextClassLoaderForLoadClass"));
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Property com.ibm.ws.rsadapter.DSConfigurationHelper.useContextClassLoaderForLoadClass: " + _useContextClassLoaderForLoadClass), (Object[])new Object[0]);
                }
                props[8] = Boolean.getBoolean("com.ibm.ws.rsadapter.spi.WSRdbDataSource.disablePoolPurgeIfAffinityEnabled");
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Property com.ibm.ws.rsadapter.spi.WSRdbDataSource.disablePoolPurgeIfAffinityEnabled: " + _disablePoolPurgeIfAffinityEnabled), (Object[])new Object[0]);
                }
                return props;
            }
        });
        _disablePK54589 = systemProps[0];
        _disableCheckingForAuthorizationException = systemProps[1];
        _allowOraUpdateableConcurrency = systemProps[2];
        _skipInternalClearWarnings = systemProps[3];
        _allowSetReadOnlyForSybase = systemProps[4];
        _enableReplacementOfErrorMessages = systemProps[5];
        _enableSpecialOracleTypeMapMatching = systemProps[6];
        _useContextClassLoaderForLoadClass = systemProps[7];
        _disablePoolPurgeIfAffinityEnabled = systemProps[8];
    }
}

