/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jdbc.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.jca.cm.ConnectorService;
import com.ibm.ws.jdbc.internal.DataSourceDef;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class PropertyService
extends Properties {
    private static final long serialVersionUID = -6017388542378621407L;
    private static final TraceComponent tc = Tr.register(PropertyService.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    public static final List<String> DURATION_MIXED_PROPS = Arrays.asList("lockTimeout");
    private static final List<String> DURATION_MS_LONG_PROPS = Arrays.asList("ifxCPMServiceInterval");
    public static final List<String> DURATION_MS_INT_PROPS = Arrays.asList("ifxIFX_SOC_TIMEOUT", "soTimeout");
    public static final List<String> DURATION_S_INT_PROPS = Arrays.asList("abandonedConnectionTimeout", "blockingReadConnectionTimeout", "connectionRetryDelay", "connectionWaitTimeout", "currentLockTimeout", "ifxIFX_LOCK_MODE_WAIT", "ifxINFORMIXCONTIME", "inactiveConnectionTimeout", "keepAliveTimeOut", "loginTimeout", "maxConnectionReuseTime", "maxIdleTime", "queryTimeout", "retryIntervalForClientReroute", "soLinger", "timeoutCheckInterval", "timeToLiveConnectionTimeout");
    public static final String FACTORY_PID = "com.ibm.ws.jdbc.dataSource.properties";
    public static final String FACTORY_PID_INFORMIX_JCC = "com.ibm.ws.jdbc.dataSource.properties.informix.jcc";
    static final String ID = "id";
    private static final String[] PASSWORD_PROPS = new String[]{DataSourceDef.password.name(), "trustStorePassword", "connectionProperties"};
    public static final String PROPERTIES = "properties";
    private String factoryPID;

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String getFactoryPID() {
        return this.factoryPID;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public static void parseDurationProperties(Map<String, Object> vendorProps, String className, ConnectorService connectorSvc) throws Exception {
        block15: {
            Object propValue;
            for (String propName : DURATION_MS_LONG_PROPS) {
                propValue = vendorProps.remove(propName);
                if (propValue == null) continue;
                try {
                    vendorProps.put(propName, MetatypeUtils.evaluateDuration((String)((String)propValue), (TimeUnit)TimeUnit.MILLISECONDS));
                }
                catch (Exception x) {
                    x = (Exception)connectorSvc.ignoreWarnOrFail(tc, (Throwable)x, x.getClass(), "UNSUPPORTED_VALUE_J2CA8011", new Object[]{propValue, propName, className});
                    if (x == null) continue;
                    throw x;
                }
            }
            for (String propName : DURATION_MS_INT_PROPS) {
                propValue = vendorProps.remove(propName);
                if (propValue == null) continue;
                try {
                    vendorProps.put(propName, MetatypeUtils.evaluateDuration((String)((String)propValue), (TimeUnit)TimeUnit.MILLISECONDS).intValue());
                }
                catch (Exception x) {
                    x = (Exception)connectorSvc.ignoreWarnOrFail(tc, (Throwable)x, x.getClass(), "UNSUPPORTED_VALUE_J2CA8011", new Object[]{propValue, propName, className});
                    if (x == null) continue;
                    throw x;
                }
            }
            for (String propName : DURATION_S_INT_PROPS) {
                propValue = vendorProps.remove(propName);
                if (propValue == null) continue;
                if (propValue instanceof String) {
                    try {
                        vendorProps.put(propName, MetatypeUtils.evaluateDuration((String)((String)propValue), (TimeUnit)TimeUnit.SECONDS).intValue());
                        continue;
                    }
                    catch (Exception x) {
                        x = (Exception)connectorSvc.ignoreWarnOrFail(tc, (Throwable)x, x.getClass(), "UNSUPPORTED_VALUE_J2CA8011", new Object[]{propValue, propName, className});
                        if (x == null) continue;
                        throw x;
                    }
                }
                vendorProps.put(propName, propValue);
            }
            Object lockTimeout = vendorProps.remove("lockTimeout");
            if (lockTimeout != null) {
                try {
                    if (className.startsWith("com.microsoft")) {
                        vendorProps.put("lockTimeout", MetatypeUtils.evaluateDuration((String)((String)lockTimeout), (TimeUnit)TimeUnit.MILLISECONDS));
                    } else {
                        vendorProps.put("lockTimeout", MetatypeUtils.evaluateDuration((String)((String)lockTimeout), (TimeUnit)TimeUnit.SECONDS).intValue());
                    }
                }
                catch (Exception x) {
                    x = (Exception)connectorSvc.ignoreWarnOrFail(tc, (Throwable)x, x.getClass(), "UNSUPPORTED_VALUE_J2CA8011", new Object[]{lockTimeout, "lockTimeout", className});
                    if (x == null) break block15;
                    throw x;
                }
            }
        }
    }

    public static final void parsePasswordProperties(Map<String, Object> vendorProps) {
        for (String propName : PASSWORD_PROPS) {
            String propValue = (String)vendorProps.remove(propName);
            if (propValue == null) continue;
            vendorProps.put(propName, new SerializableProtectedString(propValue.toCharArray()));
        }
    }

    public void setFactoryPID(String factoryPID) {
        this.factoryPID = factoryPID;
    }

    @Override
    public synchronized String toString() {
        StringBuilder sb = new StringBuilder(40 + this.size() * 40);
        sb.append(this.getClass().getSimpleName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append(":{");
        for (Map.Entry<Object, Object> prop : this.entrySet()) {
            boolean isPassword = ((String)prop.getKey()).toLowerCase().indexOf("password") >= 0;
            sb.append(prop.getKey()).append('=').append(isPassword ? "******" : prop.getValue()).append(", ");
        }
        if (this.size() > 0) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append("}");
        return sb.toString();
    }
}

