/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jdbc.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class JDBCDrivers {
    private static final Map<String, String[]> classNamesByKey = new LinkedHashMap<String, String[]>();
    private static final Map<String, String[]> classNamesByPID = new HashMap<String, String[]>();

    private static final boolean contains(Collection<String> list, String value) {
        for (String item : list) {
            if (!item.contains(value)) continue;
            return true;
        }
        return false;
    }

    static String getConnectionPoolDataSourceClassName(Collection<String> fileNames) {
        for (Map.Entry<String, String[]> entry : classNamesByKey.entrySet()) {
            if (!JDBCDrivers.contains(fileNames, entry.getKey())) continue;
            String[] classNames = entry.getValue();
            return classNames == null ? null : classNames[1];
        }
        return null;
    }

    static String getConnectionPoolDataSourceClassName(String vendorPropertiesPID) {
        String[] classNames = classNamesByPID.get(vendorPropertiesPID);
        return classNames == null ? null : classNames[1];
    }

    static String getDataSourceClassName(Collection<String> fileNames) {
        for (Map.Entry<String, String[]> entry : classNamesByKey.entrySet()) {
            if (!JDBCDrivers.contains(fileNames, entry.getKey())) continue;
            String[] classNames = entry.getValue();
            return classNames == null ? null : classNames[0];
        }
        return null;
    }

    static String getDataSourceClassName(String vendorPropertiesPID) {
        String[] classNames = classNamesByPID.get(vendorPropertiesPID);
        return classNames == null ? null : classNames[0];
    }

    static String getXADataSourceClassName(Collection<String> fileNames) {
        for (Map.Entry<String, String[]> entry : classNamesByKey.entrySet()) {
            if (!JDBCDrivers.contains(fileNames, entry.getKey())) continue;
            String[] classNames = entry.getValue();
            return classNames == null ? null : classNames[2];
        }
        return null;
    }

    static String getXADataSourceClassName(String vendorPropertiesPID) {
        String[] classNames = classNamesByPID.get(vendorPropertiesPID);
        return classNames == null ? null : classNames[2];
    }

    static {
        String[] classes = new String[]{"com.ibm.db2.jcc.DB2DataSource", "com.ibm.db2.jcc.DB2ConnectionPoolDataSource", "com.ibm.db2.jcc.DB2XADataSource"};
        classNamesByPID.put("com.ibm.ws.jdbc.dataSource.properties.db2.jcc", classes);
        classNamesByPID.put("com.ibm.ws.jdbc.dataSource.properties.informix.jcc", classes);
        classNamesByKey.put("DB2JCC", classes);
        classes = new String[]{"oracle.ucp.jdbc.PoolDataSourceImpl", null, "oracle.ucp.jdbc.PoolXADataSourceImpl"};
        classNamesByPID.put("com.ibm.ws.jdbc.dataSource.properties.oracle.ucp", classes);
        classNamesByKey.put("UCP.JAR", classes);
        classes = new String[]{"oracle.jdbc.pool.OracleDataSource", "oracle.jdbc.pool.OracleConnectionPoolDataSource", "oracle.jdbc.xa.client.OracleXADataSource"};
        classNamesByPID.put("com.ibm.ws.jdbc.dataSource.properties.oracle", classes);
        classNamesByKey.put("OJDBC", classes);
        classes = new String[]{"com.microsoft.sqlserver.jdbc.SQLServerDataSource", "com.microsoft.sqlserver.jdbc.SQLServerConnectionPoolDataSource", "com.microsoft.sqlserver.jdbc.SQLServerXADataSource"};
        classNamesByPID.put("com.ibm.ws.jdbc.dataSource.properties.microsoft.sqlserver", classes);
        classNamesByKey.put("SQLJDBC4.JAR", classes);
        classNamesByKey.put("SQLJDBC.JAR", classes);
        classes = new String[]{"com.informix.jdbcx.IfxDataSource", "com.informix.jdbcx.IfxConnectionPoolDataSource", "com.informix.jdbcx.IfxXADataSource"};
        classNamesByPID.put("com.ibm.ws.jdbc.dataSource.properties.informix", classes);
        classNamesByKey.put("IFXJDBC", classes);
        classes = new String[]{"org.apache.derby.jdbc.ClientDataSource40", "org.apache.derby.jdbc.ClientConnectionPoolDataSource40", "org.apache.derby.jdbc.ClientXADataSource40"};
        classNamesByPID.put("com.ibm.ws.jdbc.dataSource.properties.derby.client", classes);
        classNamesByKey.put("DERBYCLIENT.JAR", classes);
        classes = new String[]{"org.apache.derby.jdbc.EmbeddedDataSource40", "org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource40", "org.apache.derby.jdbc.EmbeddedXADataSource40"};
        classNamesByPID.put("com.ibm.ws.jdbc.dataSource.properties.derby.embedded", classes);
        classNamesByKey.put("DERBY", classes);
        classes = new String[]{"com.ibm.as400.access.AS400JDBCDataSource", "com.ibm.as400.access.AS400JDBCConnectionPoolDataSource", "com.ibm.as400.access.AS400JDBCXADataSource"};
        classNamesByPID.put("com.ibm.ws.jdbc.dataSource.properties.db2.i.toolbox", classes);
        classNamesByKey.put("JT400.JAR", classes);
        classes = new String[]{"com.ibm.db2.jdbc.app.UDBDataSource", "com.ibm.db2.jdbc.app.UDBConnectionPoolDataSource", "com.ibm.db2.jdbc.app.UDBXADataSource"};
        classNamesByPID.put("com.ibm.ws.jdbc.dataSource.properties.db2.i.native", classes);
        classNamesByKey.put("DB2_CLASSES", classes);
        classes = new String[]{"com.mysql.jdbc.jdbc2.optional.MysqlXADataSource", "com.mysql.jdbc.jdbc2.optional.MysqlConnectionPoolDataSource", "com.mysql.jdbc.jdbc2.optional.MysqlDataSource"};
        classNamesByKey.put("MYSQL-CONNECTOR-JAVA", classes);
        classes = new String[]{"com.sybase.jdbc4.jdbc.SybDataSource", "com.sybase.jdbc4.jdbc.SybConnectionPoolDataSource", "com.sybase.jdbc4.jdbc.SybXADataSource"};
        classNamesByKey.put("JCONN4", classes);
        classes = new String[]{"com.sybase.jdbc3.jdbc.SybDataSource", "com.sybase.jdbc3.jdbc.SybConnectionPoolDataSource", "com.sybase.jdbc3.jdbc.SybXADataSource"};
        classNamesByKey.put("JCONN3", classes);
        classes = new String[]{"com.sybase.jdbc2.jdbc.SybDataSource", "com.sybase.jdbc2.jdbc.SybConnectionPoolDataSource", "com.sybase.jdbc2.jdbc.SybXADataSource"};
        classNamesByKey.put("JCONN2", classes);
        classes = new String[]{"solid.jdbc.SolidDataSource", "solid.jdbc.SolidConnectionPoolDataSource", "solid.jdbc.xa.SolidXADataSource"};
        classNamesByKey.put("SOLIDDRIVER", classes);
        String className = "com.ddtek.jdbcx.sqlserver.SQLServerDataSource";
        classes = new String[]{className, className, className};
        classNamesByPID.put("com.ibm.ws.jdbc.dataSource.properties.datadirect.sqlserver", classes);
        classNamesByKey.put("SQLSERVER.JAR", classes);
        className = "com.ddtek.jdbcx.oracle.OracleDataSource";
        classes = new String[]{className, className, className};
        classNamesByKey.put("ORACLE.JAR", classes);
        className = "com.ddtek.jdbcx.sequelink.SequeLinkDataSource";
        classes = new String[]{className, className, className};
        classNamesByKey.put("SLJC.JAR", classes);
    }
}

