/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jdbc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jca.cm.ConnectionManagerService;
import com.ibm.ws.jca.cm.ConnectorService;
import com.ibm.ws.jdbc.DataSourceService;
import com.ibm.ws.jdbc.internal.AppDefinedResourceFactory;
import com.ibm.ws.jdbc.internal.DataSourceDef;
import com.ibm.ws.jdbc.internal.PropertyService;
import com.ibm.ws.resource.ResourceFactory;
import com.ibm.ws.resource.ResourceFactoryBuilder;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfig;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.library.Library;
import java.sql.SQLNonTransientException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;

public class DataSourceResourceFactoryBuilder
implements ResourceFactoryBuilder {
    private static final TraceComponent tc = Tr.register(DataSourceResourceFactoryBuilder.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private static final String CONFIG_DISPLAY_ID = "config.displayId";
    private static final String CONFIG_SOURCE = "config.source";
    private static final String FILE = "file";
    private static final String ID = "id";
    private final AtomicServiceReference<ConfigurationAdmin> configAdminRef = new AtomicServiceReference("configAdmin");
    private ConnectorService connectorSvc;

    protected void activate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"activate", (Object[])new Object[]{context});
        }
        this.configAdminRef.activate(context);
    }

    public ResourceFactory createResourceFactory(Map<String, Object> props) throws Exception {
        Object value;
        String recoveryAuthDataRef;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createResourceFactory", (Object[])new Object[]{AdapterUtil.hidePasswords(props, 1)});
        }
        Hashtable<String, String> cmSvcProps = new Hashtable<String, String>();
        Hashtable<String, Object> dsSvcProps = new Hashtable<String, Object>();
        Hashtable<String, Object> driverProps = new Hashtable<String, Object>();
        HashMap<String, Object> vendorProps = new HashMap<String, Object>();
        VariableRegistry variableRegistry = this.connectorSvc.getVariableRegistry();
        for (Map.Entry<String, Object> prop : props.entrySet()) {
            Object value2 = prop.getValue();
            if (value2 instanceof String) {
                value2 = variableRegistry.resolveString((String)value2);
            }
            vendorProps.put(prop.getKey(), value2);
        }
        String application = (String)vendorProps.remove("application");
        String declaringApplication = (String)vendorProps.remove("declaringApplication");
        String module = (String)vendorProps.remove("module");
        String component = (String)vendorProps.remove("component");
        String jndiName = (String)vendorProps.remove("jndiName");
        String dataSourceID = DataSourceResourceFactoryBuilder.getDataSourceID(application, module, component, jndiName);
        String conManagerID = dataSourceID + '/' + "connectionManager";
        String jdbcDriverID = dataSourceID + '/' + "jdbcDriver";
        String conManagerFilter = FilterUtils.createPropertyFilter((String)ID, (String)conManagerID);
        String jdbcDriverFilter = FilterUtils.createPropertyFilter((String)ID, (String)jdbcDriverID);
        StringBuilder filter = new StringBuilder(FilterUtils.createPropertyFilter((String)ID, (String)dataSourceID));
        filter.insert(filter.length() - 1, '*');
        if (!this.removeExistingConfigurations(filter.toString())) {
            throw new IllegalArgumentException(dataSourceID);
        }
        cmSvcProps.put(ID, conManagerID);
        cmSvcProps.put(CONFIG_DISPLAY_ID, conManagerID);
        driverProps.put(ID, jdbcDriverID);
        driverProps.put(CONFIG_DISPLAY_ID, jdbcDriverID);
        dsSvcProps.put(ID, dataSourceID);
        dsSvcProps.put(CONFIG_DISPLAY_ID, dataSourceID);
        dsSvcProps.put("jndiName", jndiName);
        dsSvcProps.put("jndiName.unique", dataSourceID);
        dsSvcProps.put("connectionManager.target", conManagerFilter);
        dsSvcProps.put("driver.target", jdbcDriverFilter);
        String containerAuthDataRef = (String)vendorProps.remove("containerAuthDataRef");
        if (containerAuthDataRef != null) {
            String authDataFilter = FilterUtils.createPropertyFilter((String)ID, (String)containerAuthDataRef);
            dsSvcProps.put("containerAuthData.target", authDataFilter);
        }
        if ((recoveryAuthDataRef = (String)vendorProps.remove("recoveryAuthDataRef")) != null) {
            String authDataFilter = FilterUtils.createPropertyFilter((String)ID, (String)recoveryAuthDataRef);
            dsSvcProps.put("recoveryAuthData.target", authDataFilter);
        }
        if (application != null) {
            dsSvcProps.put("application", application);
            if (module != null) {
                dsSvcProps.put("module", module);
                if (component != null) {
                    dsSvcProps.put("component", component);
                }
            }
        }
        for (String name : ConnectionManagerService.CONNECTION_MANAGER_PROPS) {
            value = vendorProps.remove(name);
            if (value == null) continue;
            cmSvcProps.put(name, (String)value);
        }
        for (String name : DSConfig.DATA_SOURCE_PROPS) {
            value = vendorProps.remove(name);
            if (value == null) continue;
            dsSvcProps.put(name, value);
        }
        BundleContext bundleContext = FrameworkUtil.getBundle(DataSourceResourceFactoryBuilder.class).getBundleContext();
        String className = (String)vendorProps.remove(DataSourceDef.className.name());
        this.updateWithLibraries(bundleContext, application, declaringApplication, className, driverProps, dsSvcProps);
        value = vendorProps.remove(DataSourceDef.initialPoolSize.name());
        if (value != null && (Integer)value > 0) {
            ConnectorService.logMessage((Level)Level.INFO, (String)"IGNORE_FEATURE_J2CA0240", (Object[])new Object[]{DataSourceDef.initialPoolSize.name(), jndiName});
        }
        if ((value = vendorProps.remove(DataSourceDef.maxStatements.name())) != null) {
            Integer maxPoolSize = (Integer)cmSvcProps.get(DataSourceDef.maxPoolSize.name());
            int stmtCacheSize = maxPoolSize == null || maxPoolSize <= 0 ? 0 : (Integer)value / maxPoolSize;
            dsSvcProps.put("statementCacheSize", stmtCacheSize);
        }
        String url = (String)vendorProps.remove(DataSourceDef.url.name());
        if (vendorProps.containsKey(DataSourceDef.databaseName.name()) || vendorProps.containsKey(DataSourceDef.portNumber.name())) {
            url = null;
        }
        if (!vendorProps.containsKey(DataSourceDef.serverName.name())) {
            if (url != null) {
                vendorProps.put("URL", url);
            } else if (!className.startsWith("org.apache.derby.jdbc.Embedded")) {
                vendorProps.put(DataSourceDef.serverName.name(), "localhost");
            }
        }
        PropertyService.parseDurationProperties(vendorProps, className, this.connectorSvc);
        PropertyService.parsePasswordProperties(vendorProps);
        for (Map.Entry entry : vendorProps.entrySet()) {
            dsSvcProps.put("propertiesRef.0." + (String)entry.getKey(), entry.getValue());
        }
        StringBuilder dsFilter = new StringBuilder(200);
        dsFilter.append("(&").append(FilterUtils.createPropertyFilter((String)ID, (String)dataSourceID));
        dsFilter.append(FilterUtils.createPropertyFilter((String)"objectClass", (String)DataSourceService.class.getName())).append(")");
        AppDefinedResourceFactory factory = new AppDefinedResourceFactory(this, bundleContext, dataSourceID, dsFilter.toString(), declaringApplication);
        try {
            String bundleLocation = bundleContext.getBundle().getLocation();
            String jcaBundleLocation = FrameworkUtil.getBundle(ConnectorService.class).getBundleContext().getBundle().getLocation();
            ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getService();
            Configuration conMgrConfig = configAdmin.createFactoryConfiguration("com.ibm.ws.jca.connectionManager", jcaBundleLocation);
            conMgrConfig.update(cmSvcProps);
            dsSvcProps.put("connectionManagerRef", new String[]{conMgrConfig.getPid()});
            Configuration driverConfig = configAdmin.createFactoryConfiguration("com.ibm.ws.jdbc.jdbcDriver", bundleLocation);
            driverConfig.update(driverProps);
            dsSvcProps.put("jdbcDriverRef", new String[]{driverConfig.getPid()});
            Configuration dsSvcConfig = configAdmin.createFactoryConfiguration("com.ibm.ws.jdbc.dataSource", bundleLocation);
            dsSvcConfig.update(dsSvcProps);
        }
        catch (Exception x) {
            factory.destroy();
            throw x;
        }
        catch (Error x) {
            factory.destroy();
            throw x;
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createResourceFactory", (Object)factory);
        }
        return factory;
    }

    protected void deactivate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"deactivate", (Object[])new Object[]{context});
        }
        this.configAdminRef.deactivate(context);
    }

    private static final String getDataSourceID(String application, String module, String component, String jndiName) {
        StringBuilder sb = new StringBuilder(jndiName.length() + 80);
        if (application != null) {
            sb.append("application").append('[').append(application).append(']').append('/');
            if (module != null) {
                sb.append("module").append('[').append(module).append(']').append('/');
                if (component != null) {
                    sb.append("component").append('[').append(component).append(']').append('/');
                }
            }
        }
        return sb.append("dataSource").append('[').append(jndiName).append(']').toString();
    }

    public final boolean removeExistingConfigurations(String filter) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getService();
        Configuration[] existingConfigurations = configAdmin.listConfigurations(filter);
        if (existingConfigurations != null) {
            for (Configuration config : existingConfigurations) {
                Dictionary cfgProps = config.getProperties();
                if (cfgProps != null && FILE.equals(cfgProps.get(CONFIG_SOURCE))) {
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"configuration found in server.xml: ", (Object[])new Object[]{config.getPid()});
                    }
                    return false;
                }
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"removing", (Object[])new Object[]{config.getPid()});
                }
                config.delete();
            }
        }
        return true;
    }

    protected void setConfigAdmin(ServiceReference<ConfigurationAdmin> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setConfigAdmin", (Object[])new Object[]{ref});
        }
        this.configAdminRef.setReference(ref);
    }

    protected void setConnectorService(ConnectorService svc) {
        this.connectorSvc = svc;
    }

    protected void unsetConfigAdmin(ServiceReference<ConfigurationAdmin> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsetConfigAdmin", (Object[])new Object[]{ref});
        }
        this.configAdminRef.unsetReference(ref);
    }

    protected void unsetConnectorService(ConnectorService svc) {
        this.connectorSvc = null;
    }

    private final void updateWithLibraries(BundleContext bundleContext, String applicationName, String declaringApplication, String className, Hashtable<String, Object> driverProps, Hashtable<String, Object> dsSvcProps) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateWithLibraries", (Object[])new Object[]{applicationName, className});
        }
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getServiceWithException();
        Configuration[] classloaderConfigs = null;
        ServiceReference[] refs = bundleContext.getServiceReferences("com.ibm.wsspi.application.Application", FilterUtils.createPropertyFilter((String)"name", (String)declaringApplication));
        if (refs != null && refs.length > 0) {
            ServiceReference appRef = refs[0];
            String parentPid = (String)appRef.getProperty("service.pid");
            String sourcePid = (String)appRef.getProperty("ibm.extends.source.pid");
            if (sourcePid != null) {
                parentPid = sourcePid;
            }
            StringBuilder classloaderFilter = new StringBuilder(200);
            classloaderFilter.append("(&");
            classloaderFilter.append(FilterUtils.createPropertyFilter((String)"service.factoryPid", (String)"com.ibm.ws.classloading.classloader"));
            classloaderFilter.append(FilterUtils.createPropertyFilter((String)"config.parentPID", (String)parentPid));
            classloaderFilter.append(')');
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"filter for classloaders", (Object[])new Object[]{classloaderFilter});
            }
            if (classloaderFilter.length() > 3) {
                classloaderConfigs = configAdmin.listConfigurations(classloaderFilter.toString());
            }
        }
        StringBuilder commonLibraryFilter = new StringBuilder(500);
        StringBuilder libraryFilter = new StringBuilder(500);
        commonLibraryFilter.append("(|");
        libraryFilter.append("(|");
        if (classloaderConfigs != null) {
            for (void var16_18 : classloaderConfigs) {
                Object commonLibraryRef;
                Object privateLibraryRef;
                Dictionary classloaderProps = var16_18.getProperties();
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"classloader", (Object[])new Object[]{classloaderProps});
                }
                if (applicationName != null && (privateLibraryRef = classloaderProps.get("privateLibraryRef")) != null && privateLibraryRef instanceof String[]) {
                    for (String pid : (String[])privateLibraryRef) {
                        libraryFilter.append(FilterUtils.createPropertyFilter((String)"service.pid", (String)pid));
                    }
                }
                if ((commonLibraryRef = classloaderProps.get("commonLibraryRef")) == null || !(commonLibraryRef instanceof String[])) continue;
                for (String pid : (String[])commonLibraryRef) {
                    commonLibraryFilter.append(FilterUtils.createPropertyFilter((String)"service.pid", (String)pid));
                }
            }
        }
        commonLibraryFilter.append(')');
        libraryFilter.append(')');
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"filters for libraries", (Object[])new Object[]{commonLibraryFilter, libraryFilter});
        }
        LinkedList libraryRefs = new LinkedList();
        if (commonLibraryFilter.length() > 3) {
            libraryRefs.addAll(bundleContext.getServiceReferences(Library.class, commonLibraryFilter.toString()));
        }
        if (libraryFilter.length() > 3) {
            libraryRefs.addAll(bundleContext.getServiceReferences(Library.class, libraryFilter.toString()));
        }
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"libraries", (Object[])libraryRefs.toArray());
        }
        for (ServiceReference libraryRef : libraryRefs) {
            Library library = (Library)bundleContext.getService(libraryRef);
            String libraryPid = (String)libraryRef.getProperty("service.pid");
            if (library == null) {
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"library not found", (Object[])new Object[]{libraryPid});
                continue;
            }
            try {
                ClassLoader loader = library.getClassLoader();
                Class<?> cl = loader.loadClass(className);
                String type = XADataSource.class.isAssignableFrom(cl) ? XADataSource.class.getName() : (ConnectionPoolDataSource.class.isAssignableFrom(cl) ? ConnectionPoolDataSource.class.getName() : DataSource.class.getName());
                driverProps.put("libraryRef", new String[]{libraryPid});
                driverProps.put("sharedLib.target", FilterUtils.createPropertyFilter((String)"service.pid", (String)libraryPid));
                driverProps.put(type, className);
                dsSvcProps.put("type", type);
                if (trace && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"updateWithLibraries", driverProps);
                }
                return;
            }
            catch (ClassNotFoundException x) {
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)(className + " not found in"), (Object[])new Object[]{libraryPid});
            }
            catch (Exception x) {
                FFDCFilter.processException((Throwable)x, (String)DataSourceResourceFactoryBuilder.class.getName(), (String)"444", (Object[])new Object[]{libraryRef});
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)libraryRef.toString(), (Object[])new Object[]{x});
            }
        }
        SQLNonTransientException x = new SQLNonTransientException(ConnectorService.getMessage((String)"MISSING_LIBRARY_J2CA8022", (Object[])new Object[]{declaringApplication, className, "dataSource", dsSvcProps.get("jndiName")}));
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateWithLibraries", (Object)x);
        }
        throw x;
    }
}

