/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.rsadapter.GenericDataStoreHelper;
import com.ibm.ws.rsadapter.DSConfigHelper;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SybaseDataStoreHelper
extends GenericDataStoreHelper {
    private static final TraceComponent tc = com.ibm.websphere.ras.Tr.register(SybaseDataStoreHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private static final com.ibm.ejs.ras.TraceComponent sybaseTc = Tr.register((String)"com.ibm.ws.sybase.logwriter", (String)"WAS.database", null);
    private HashMap<Object, Class<?>> userNewMap = null;
    private HashMap<Object, Class<?>> sybaseErrorMap = new HashMap(5);
    private static final int HASHSIZE = 5;
    private boolean isXADataSource = false;
    private static final String sybaseXADataSourceClassName = "SybXADataSource";

    public SybaseDataStoreHelper(WSManagedConnectionFactoryImpl mcf, Properties props) {
        super(mcf, props);
        this.addInitialMaps();
        this.dshMd.setGetTypeMapSupport(false);
        this.dshMd.setHelperType(11);
        this.dshMd.setDatabaseDefaultIsolationLevel(4);
        String dataSourceImplClass = (String)props.get("dataSourceClass");
        if (dataSourceImplClass != null && dataSourceImplClass.endsWith(sybaseXADataSourceClassName)) {
            this.isXADataSource = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"the metadata for the Sybase helper is", (Object[])new Object[]{this.dshMd});
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"done constructing Sybase helper:", (Object[])new Object[]{this});
        }
    }

    private void addInitialMaps() {
        this.sybaseErrorMap.put("JZ0C0", StaleConnectionException.class);
        this.sybaseErrorMap.put("JZ0C1", StaleConnectionException.class);
    }

    @Override
    public void doStatementCleanup(PreparedStatement stmt) throws SQLException {
        Integer queryTimeout;
        stmt.setFetchDirection(1000);
        if (stmt.getMaxFieldSize() != 0) {
            stmt.setMaxFieldSize(0);
        }
        if (stmt.getMaxRows() != 0) {
            stmt.setMaxRows(0);
        }
        if ((queryTimeout = this.mcf.dsConfig.get().queryTimeout) == null) {
            queryTimeout = this.defaultQueryTimeout;
        }
        stmt.setQueryTimeout(queryTimeout);
    }

    @Override
    public final Class<?> findMappingClass(SQLException e) {
        String methodName = "findMappingClass";
        Class<?> eClass = null;
        String sqlState = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.entry((Object)this, (TraceComponent)tc, (String)"findMappingClass", (Object[])new Object[]{e});
        }
        if (e != null) {
            if (this.userNewMap != null) {
                eClass = this.userNewMap.get(e.getErrorCode());
                if (eClass != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"findMappingClass", eClass);
                    }
                    return eClass;
                }
                sqlState = e.getSQLState();
                if (sqlState != null && (eClass = this.userNewMap.get(sqlState)) != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"findMappingClass", eClass);
                    }
                    return eClass;
                }
            }
            if ((eClass = this.sybaseErrorMap.get(e.getErrorCode())) != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"findMappingClass", eClass);
                }
                return eClass;
            }
            sqlState = e.getSQLState();
            if (sqlState != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"The sqlState is: ", (Object[])new Object[]{sqlState});
                }
                eClass = this.sybaseErrorMap.get(sqlState);
            }
            if (eClass == null) {
                SQLException nextException = e.getNextException();
                if (nextException != null && nextException != e) {
                    eClass = this.findMappingClass(nextException);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"findMappingClass", eClass);
                    }
                    return eClass;
                }
                eClass = super.findMappingClass(e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"findMappingClass", eClass);
                }
                return eClass;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"findMappingClass", eClass);
        }
        return eClass;
    }

    @Override
    public final void setUserDefinedMap(Map newmap) {
        this.userNewMap = new HashMap(newmap);
    }

    @Override
    public PrintWriter getPrintWriter() {
        if (TraceComponent.isAnyTracingEnabled() && sybaseTc.isDebugEnabled()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Sybase logging is enabled", (Object[])new Object[0]);
            }
            return new PrintWriter(new TraceWriter(sybaseTc));
        }
        return null;
    }

    @Override
    public void doConnectionSetup(Connection conn) throws SQLException {
        SQLWarning warn = conn.getWarnings();
        if (warn != null) {
            SQLException sqlex = null;
            String sqlstate = warn.getSQLState();
            if (sqlstate.equals("010UF")) {
                SQLException sqlex2 = sqlex = new SQLException(warn.getMessage(), sqlstate);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)(sqlstate + warn.getMessage()), (Object[])new Object[0]);
                }
                for (warn = warn.getNextWarning(); warn != null; warn = warn.getNextWarning()) {
                    sqlex2 = new SQLException(warn.getMessage(), warn.getSQLState());
                    sqlex.setNextException(sqlex2);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)(warn.getSQLState() + warn.getMessage()), (Object[])new Object[0]);
                }
                throw sqlex;
            }
        }
    }

    @Override
    public boolean doConnectionCleanup(Connection conn) throws SQLException {
        boolean standardPropModified = false;
        if (this.isXADataSource) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup(): calling setAutoCommit(true) and returning true from this method", (Object[])new Object[0]);
            }
            conn.setAutoCommit(true);
            standardPropModified = true;
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup(): doing nothing and returning false from this method", (Object[])new Object[0]);
        }
        if (!DSConfigHelper._skipInternalClearWarnings) {
            conn.clearWarnings();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"clearWarnings: cleanup of warnings done", (Object[])new Object[0]);
            }
        }
        return standardPropModified;
    }
}

