/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.rsadapter.Oracle10gDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;

public class Oracle11gDataStoreHelper
extends Oracle10gDataStoreHelper {
    private static final TraceComponent tc = Tr.register(Oracle11gDataStoreHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private static final int NOT_CACHED = -99;
    private int driverMajorVersion = -99;
    private int driverMinorVersion = -99;

    public Oracle11gDataStoreHelper(WSManagedConnectionFactoryImpl mcf, Properties props) {
        super(mcf, props);
        this.dshMd.setHelperType(22);
    }

    @Override
    public void doStatementCleanup(PreparedStatement stmt) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"doStatementCleanup", (Object[])new Object[0]);
        }
        super.doStatementCleanup(stmt);
        this.utility.clearDefines(stmt);
        this.utility.setDefaultRowPrefetch(stmt);
        if (this.driverMajorVersion == -99) {
            this.driverMajorVersion = stmt.getConnection().getMetaData().getDriverMajorVersion();
            this.driverMinorVersion = stmt.getConnection().getMetaData().getDriverMinorVersion();
        }
        if (this.driverMajorVersion > 11 || this.driverMajorVersion == 11 && this.driverMinorVersion >= 2) {
            this.utility.setLobPrefetchSize(stmt, 4000);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"doStatementCleanup");
        }
    }
}

