/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.websphere.ce.cm.PortableSQLException;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.websphere.rsadapter.DataStoreHelperMetaData;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLRecoverableException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;

public class GenericDataStoreHelper
implements DataStoreHelper {
    protected static final String resBundle = "com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS";
    private static final TraceComponent tc = Tr.register(GenericDataStoreHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    WSManagedConnectionFactoryImpl mcf;
    final DataStoreHelperMetaData dshMd;
    protected HashMap<Object, Class<?>> genErrorMap = null;
    private static final int HASHSIZE = 17;
    private HashMap<Object, Class<?>> userNewMap = null;
    protected int defaultQueryTimeout;
    private boolean setCursorNameSupported = true;

    public GenericDataStoreHelper(WSManagedConnectionFactoryImpl mcf, Properties props) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        this.mcf = mcf;
        this.dshMd = new DataStoreHelperMetaData(mcf);
        this.genErrorMap = new HashMap(17);
        this.addInitialMaps();
        if (props != null) {
            String holder = props.getProperty("queryTimeout");
            if (props.containsKey("queryTimeout") && holder != null && !holder.equals("")) {
                this.defaultQueryTimeout = Integer.parseInt(holder);
            }
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"init ", (Object[])new Object[]{this, "Default query timeout=" + this.defaultQueryTimeout});
        }
    }

    public void init() {
    }

    @Override
    public DataStoreHelperMetaData getMetaData() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"returning: ", (Object[])new Object[]{this.dshMd});
        }
        return this.dshMd;
    }

    private void addInitialMaps() {
        this.genErrorMap.put("55032", StaleConnectionException.class);
        this.genErrorMap.put("08001", StaleConnectionException.class);
        this.genErrorMap.put("08003", StaleConnectionException.class);
        this.genErrorMap.put("40003", StaleConnectionException.class);
        this.genErrorMap.put("S1000", StaleConnectionException.class);
        this.genErrorMap.put("08006", StaleConnectionException.class);
        this.genErrorMap.put("08S01", StaleConnectionException.class);
    }

    @Override
    public int getIsolationLevel() {
        int isoLevel = this.dshMd.getDatabaseDefaultIsolationLevel();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"getIsolationLevel", (Object[])new Object[]{AdapterUtil.getIsolationLevelString(isoLevel)});
        }
        return isoLevel;
    }

    @Override
    public boolean isConnectionError(SQLException ex) {
        Class<?> clss;
        boolean eqFlag;
        String methodName = "isConnectionError";
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"isConnectionError", (Object[])new Object[]{ex});
        }
        boolean bl = eqFlag = ex instanceof SQLRecoverableException || ex instanceof SQLNonTransientConnectionException || ex instanceof StaleConnectionException;
        if (ex != null && !eqFlag && (clss = this.findMappingClass(ex)) != null) {
            eqFlag = StaleConnectionException.class.isAssignableFrom(clss);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"isConnectionError", (Object)eqFlag);
        }
        return eqFlag;
    }

    public Class<?> findMappingClass(SQLException e) {
        String methodName = "findMappingClass";
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        Class<?> eClass = null;
        String sqlState = null;
        if (isTraceOn) {
            if (tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"findMappingClass", (Object[])new Object[]{e});
            }
            if (tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"the DataStoreHelper is: ", (Object[])new Object[]{this});
            }
        }
        if (e != null) {
            if (this.userNewMap != null) {
                eClass = this.userNewMap.get(e.getErrorCode());
                if (eClass != null) {
                    if (isTraceOn && tc.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)tc, (String)"findMappingClass", eClass);
                    }
                    return eClass;
                }
                sqlState = e.getSQLState();
                if (sqlState != null && (eClass = this.userNewMap.get(sqlState)) != null) {
                    if (isTraceOn && tc.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)tc, (String)"findMappingClass", eClass);
                    }
                    return eClass;
                }
            }
            if ((eClass = this.genErrorMap.get(e.getErrorCode())) == null && (sqlState = e.getSQLState()) != null) {
                eClass = this.genErrorMap.get(sqlState);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"findMappingClass", eClass);
        }
        return eClass;
    }

    private SQLException mapExceptionHelper(SQLException e) {
        Class<?> eClass;
        String methodName = "mapExceptionHelper";
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"mapExceptionHelper", (Object[])new Object[0]);
        }
        if ((eClass = this.findMappingClass(e)) != null && !eClass.equals(Void.class)) {
            try {
                final Class[] params = new Class[]{SQLException.class};
                Constructor ctor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return eClass.getDeclaredConstructor(params);
                    }
                });
                PortableSQLException mapping = (PortableSQLException)ctor.newInstance(e);
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"mapExceptionHelper", (Object)mapping);
                }
                return mapping;
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.websphere.rsadapter.GenericDataStoreHelper.mapExceptionHelper", (String)"313", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"NO_EXCPT_MAP", (Object[])new Object[]{ex});
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"mapExceptionHelper", (Object)e);
                }
                return e;
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"mapExceptionHelper");
        }
        return e;
    }

    @Override
    public SQLException mapException(SQLException e) {
        if (e instanceof PortableSQLException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Exception does not need to be mapped, returning the same exception", (Object[])new Object[]{e});
            }
            return e;
        }
        return this.mapExceptionHelper(e);
    }

    @Override
    public void doConnectionSetup(Connection conn) throws SQLException {
    }

    @Override
    public boolean doConnectionCleanup(Connection conn) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup(): no cleanup is done return false", (Object[])new Object[0]);
        }
        return false;
    }

    @Override
    public void doStatementCleanup(PreparedStatement stmt) throws SQLException {
        block4: {
            boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (this.setCursorNameSupported) {
                try {
                    stmt.setCursorName(null);
                }
                catch (SQLFeatureNotSupportedException supportX) {
                    this.setCursorNameSupported = false;
                    if (!isTraceOn || !tc.isDebugEnabled()) break block4;
                    Tr.debug((TraceComponent)tc, (String)"Statement.setCursorName() is not supported.", (Object[])new Object[]{supportX});
                }
            }
        }
        stmt.setFetchDirection(1000);
        stmt.setMaxFieldSize(0);
        stmt.setMaxRows(0);
        Integer queryTimeout = this.mcf.dsConfig.get().queryTimeout;
        if (queryTimeout == null) {
            queryTimeout = this.defaultQueryTimeout;
        }
        stmt.setQueryTimeout(queryTimeout);
    }

    @Override
    public void setUserDefinedMap(Map newmap) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setUserDefinedMap: ", (Object[])new Object[]{newmap});
        }
        this.userNewMap = new HashMap(newmap);
    }

    @Override
    public PrintWriter getPrintWriter() {
        return null;
    }

    @Override
    public String getXAExceptionContents(XAException x) {
        StringBuffer xsb = new StringBuffer(200);
        xsb.append("The cause is               : ").append(x.getCause());
        return xsb.toString();
    }

    @Override
    public void doConnectionSetupPerTransaction(Subject sub, String user, Connection conn, boolean reauthRequired, Object properties) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionSetupPerTxn: is not implemented", (Object[])new Object[]{properties});
        }
    }

    @Override
    public boolean doConnectionSetupPerGetConnection(Connection conn, boolean isCMP, Object props) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionSetupPerGetConnection is not implemented", (Object[])new Object[]{conn, isCMP, props});
        }
        return false;
    }

    @Override
    public boolean doConnectionCleanupPerCloseConnection(Connection conn, boolean isCMP, Object props) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionCleanupPerCloseConnection is not implemented", (Object[])new Object[]{conn, isCMP, props});
        }
        return false;
    }
}

