/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.jdbc.osgi.JDBCRuntimeVersion;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;

public class DataStoreHelperMetaData {
    private static final TraceComponent tc = Tr.register(DataStoreHelperMetaData.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private int defaultTransactionIsolation = 2;
    private final WSManagedConnectionFactoryImpl mcf;
    private boolean supportsGetCatalog = true;
    private boolean supportsGetTypeMap = true;
    private boolean supportsIsReadOnly = true;
    private boolean supportsGetSchema;
    private boolean supportsGetNetworkTimeout;
    private int helperType = 5;
    private boolean statementCachesIsoLevel = false;
    private boolean supportsUOWDetection = false;

    public DataStoreHelperMetaData(WSManagedConnectionFactoryImpl mcf) {
        this.mcf = mcf;
        this.supportsGetSchema = mcf.atLeastJDBCVersion(JDBCRuntimeVersion.VERSION_4_1);
        this.supportsGetNetworkTimeout = mcf.atLeastJDBCVersion(JDBCRuntimeVersion.VERSION_4_1);
    }

    public final int getHelperType() {
        return this.helperType;
    }

    public final void setHelperType(int hType) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setHelperType: " + hType), (Object[])new Object[0]);
        }
        this.helperType = hType;
    }

    public final int getDatabaseDefaultIsolationLevel() {
        int isolation = this.mcf.dsConfig.get().isolationLevel;
        if (isolation == -1) {
            isolation = this.defaultTransactionIsolation;
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"override default isolation", (Object[])new Object[]{isolation});
        }
        return isolation;
    }

    public final void setDatabaseDefaultIsolationLevel(int helperDefaultLevel) {
        this.defaultTransactionIsolation = helperDefaultLevel;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setDatabaseDefaultIsolationLevel: " + AdapterUtil.getIsolationLevelString(this.defaultTransactionIsolation)), (Object[])new Object[0]);
        }
    }

    public final void setGetCatalogSupport(boolean flag) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setGetCatalogSupport: " + flag), (Object[])new Object[0]);
        }
        this.supportsGetCatalog = flag;
    }

    public final boolean supportsGetCatalog() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"supportsGetCatalog: ", (Object[])new Object[0]);
        }
        return this.supportsGetCatalog;
    }

    public final void setGetTypeMapSupport(boolean flag) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setGetTypeMapSupport: " + flag), (Object[])new Object[0]);
        }
        this.supportsGetTypeMap = flag;
    }

    public final boolean supportsGetTypeMap() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("supportsGetTypeMap(): returning " + this.supportsGetTypeMap), (Object[])new Object[0]);
        }
        return this.supportsGetTypeMap;
    }

    public final void setReadOnlySupport(boolean flag) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setReadOnlySupport: " + flag), (Object[])new Object[0]);
        }
        this.supportsIsReadOnly = flag;
    }

    public final boolean supportsIsReadOnly() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("supportsIsReadOnly: " + this.supportsIsReadOnly), (Object[])new Object[0]);
        }
        return this.supportsIsReadOnly;
    }

    public final void setSchemaSupport(boolean flag) {
        if (flag && this.mcf.beforeJDBCVersion(JDBCRuntimeVersion.VERSION_4_1)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setSchemaSupport: Unable to enable schemaSupport because the current JDBC version is before 4.1", (Object[])new Object[0]);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("setSchemaSupport: " + flag), (Object[])new Object[0]);
            }
            this.supportsGetSchema = flag;
        }
    }

    public final boolean supportsGetSchema() {
        return this.supportsGetSchema && this.mcf.atLeastJDBCVersion(JDBCRuntimeVersion.VERSION_4_1);
    }

    public final void setNetworkTimeoutSupport(boolean flag) {
        if (flag && this.mcf.beforeJDBCVersion(JDBCRuntimeVersion.VERSION_4_1)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setNetworkTimeoutSupport: Unable to enable networkTimeoutSupport because the current JDBC version is before 4.1", (Object[])new Object[0]);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("setNetworkTimeoutSupport: " + flag), (Object[])new Object[0]);
            }
            this.supportsGetNetworkTimeout = flag;
        }
    }

    public final boolean supportsGetNetworkTimeout() {
        return this.supportsGetNetworkTimeout && this.mcf.atLeastJDBCVersion(JDBCRuntimeVersion.VERSION_4_1);
    }

    public final boolean doesStatementCacheIsoLevel() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("statementCachesIsoLevel: " + this.statementCachesIsoLevel), (Object[])new Object[0]);
        }
        return this.statementCachesIsoLevel;
    }

    public final void setStatementCacheIsoLevel(boolean flag) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setStatementCacheIsoLevel: " + flag), (Object[])new Object[0]);
        }
        this.statementCachesIsoLevel = flag;
    }

    public final void setSupportsUOWDetection(boolean flag) {
        this.supportsUOWDetection = flag;
    }

    public final boolean supportsUOWDetection() {
        return this.supportsUOWDetection;
    }

    public String toString() {
        String EOLN = AdapterUtil.EOLN;
        StringBuilder sb = new StringBuilder(128);
        sb.append(EOLN);
        sb.append("The defaultTransactionIsolation is: ").append(this.defaultTransactionIsolation).append(EOLN);
        sb.append("The supportsGetCatalog          is: ").append(this.supportsGetCatalog).append(EOLN);
        sb.append("The supportsGetTypeMap          is: ").append(this.supportsGetTypeMap).append(EOLN);
        sb.append("The supportsGetSchema           is: ").append(this.supportsGetSchema).append(EOLN);
        sb.append("The supportsGetNetworkTimeout   is: ").append(this.supportsGetNetworkTimeout).append(EOLN);
        sb.append("The supportsUOWDetection        is: ").append(this.supportsUOWDetection).append(EOLN);
        sb.append("The supportsIsReadOnly          is: ").append(this.supportsIsReadOnly).append(EOLN);
        sb.append("The helpertype                  is: ").append(AdapterUtil.getHelperTypeAsString(this.helperType)).append(EOLN);
        sb.append("The statementCachesIsoLevel     is: ").append(this.statementCachesIsoLevel).append(EOLN);
        return new String(sb);
    }
}

