/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.rsadapter.DataDirectDataStoreHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.jdbc.WSJdbcTracer;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class ConnectJDBCDataStoreHelper
extends DataDirectDataStoreHelper {
    private static final TraceComponent tc = Tr.register(ConnectJDBCDataStoreHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private static final String LONG_DATA_CACHE_SIZE = "longDataCacheSize";
    private int longDataCacheSize = 2048;
    private final AtomicReference<Method> getNetworkTimeout = new AtomicReference();
    private final AtomicReference<Method> setLongDataCacheSize = new AtomicReference();
    private final AtomicReference<Method> setNetworkTimeout = new AtomicReference();
    private final AtomicBoolean supportsSetLongDataCacheSize = new AtomicBoolean(true);
    private final AtomicBoolean supportsNetworkTimeout = new AtomicBoolean(true);

    public ConnectJDBCDataStoreHelper(WSManagedConnectionFactoryImpl mcf, Properties props) {
        super(mcf, props);
        if (props != null && props.containsKey(LONG_DATA_CACHE_SIZE)) {
            try {
                this.longDataCacheSize = Integer.parseInt(props.getProperty(LONG_DATA_CACHE_SIZE));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Default longDataCacheSize = " + this.longDataCacheSize), (Object[])new Object[0]);
        }
        this.dshMd.setHelperType(7);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Done constructing ConnectJDBCDataStoreHelper", (Object[])new Object[0]);
        }
    }

    @Override
    public boolean doConnectionCleanup(Connection conn) throws SQLException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup", (Object[])new Object[]{AdapterUtil.toString(conn)});
        }
        boolean updated = false;
        Method method = this.getNetworkTimeout.get();
        if (method == null && this.supportsNetworkTimeout.get()) {
            try {
                method = conn.getClass().getMethod("getNetworkTimeout", new Class[0]);
                this.getNetworkTimeout.set(method);
            }
            catch (NoSuchMethodException x) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"getNetworkTimeout not supported.", (Object[])new Object[0]);
                }
                this.supportsNetworkTimeout.set(false);
            }
        }
        if (method != null) {
            try {
                int networkTimeout = (Integer)method.invoke((Object)conn, new Object[0]);
                if (networkTimeout != 0) {
                    method = this.setNetworkTimeout.get();
                    if (method == null) {
                        method = conn.getClass().getMethod("setNetworkTimeout", Integer.TYPE);
                        this.setNetworkTimeout.set(method);
                    }
                    method.invoke((Object)conn, 0);
                    updated = true;
                }
            }
            catch (InvocationTargetException x) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup", (Object[])new Object[]{x.getCause()});
                }
                this.supportsNetworkTimeout.set(false);
                this.getNetworkTimeout.set(null);
                this.setNetworkTimeout.set(null);
            }
            catch (IllegalAccessException x) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"NetworkTimeout not supported.", (Object[])new Object[0]);
                }
                this.supportsNetworkTimeout.set(false);
                this.getNetworkTimeout.set(null);
                this.setNetworkTimeout.set(null);
            }
            catch (NoSuchMethodException x) {
                FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"237", (Object)this);
                throw new SQLFeatureNotSupportedException(x);
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup");
        }
        return updated;
    }

    @Override
    public void doStatementCleanup(PreparedStatement stmt) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"doStatementCleanup", (Object[])new Object[]{AdapterUtil.toString(stmt)});
        }
        stmt.setFetchDirection(1000);
        stmt.setMaxFieldSize(0);
        stmt.setMaxRows(0);
        Integer queryTimeout = this.mcf.dsConfig.get().queryTimeout;
        if (queryTimeout == null) {
            queryTimeout = this.defaultQueryTimeout;
        }
        stmt.setQueryTimeout(queryTimeout);
        stmt = (PreparedStatement)WSJdbcTracer.getImpl(stmt);
        Method method = this.setLongDataCacheSize.get();
        if (method == null && this.supportsSetLongDataCacheSize.get()) {
            try {
                method = stmt.getClass().getMethod("setLongDataCacheSize", Integer.TYPE);
                this.setLongDataCacheSize.set(method);
            }
            catch (NoSuchMethodException x) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"LongDataCacheSize not supported.", (Object[])new Object[0]);
                }
                this.supportsSetLongDataCacheSize.set(false);
            }
        }
        if (method != null) {
            try {
                method.invoke((Object)stmt, this.longDataCacheSize);
            }
            catch (InvocationTargetException x) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"doStatementCleanup", (Object)x.getCause());
                }
                throw (SQLException)x.getCause();
            }
            catch (IllegalAccessException x) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"LongDataCacheSize not supported.", (Object[])new Object[0]);
                }
                this.supportsSetLongDataCacheSize.set(false);
                this.setLongDataCacheSize.set(null);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"doStatementCleanup");
        }
    }
}

